/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.SurroundWithAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public abstract class SurroundWith {
    private final CompilationUnit fRootNode;
    private final Statement[] fSelectedStatements;
    private boolean fIsNewContext;
    private ITrackedNodePosition fFirstInsertedPosition;
    private ITrackedNodePosition fLastInsertedPosition;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SurroundWith(CompilationUnit compilationUnit, Statement[] statementArray) {
        this.fRootNode = compilationUnit;
        this.fSelectedStatements = statementArray;
    }

    public static boolean isApplicable(IInvocationContext iInvocationContext) throws JavaModelException {
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        CompilationUnit compilationUnit = ASTProvider.getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_NO, null);
        if (compilationUnit == null) {
            return true;
        }
        Selection selection = Selection.createFromStartLength(iInvocationContext.getSelectionOffset(), iInvocationContext.getSelectionLength());
        SurroundWithAnalyzer surroundWithAnalyzer = new SurroundWithAnalyzer(iCompilationUnit, selection);
        iInvocationContext.getASTRoot().accept((ASTVisitor)surroundWithAnalyzer);
        return surroundWithAnalyzer.getStatus().isOK() && surroundWithAnalyzer.hasSelectedNodes();
    }

    public static Statement[] getSelectedStatements(IInvocationContext iInvocationContext) throws JavaModelException {
        Selection selection = Selection.createFromStartLength(iInvocationContext.getSelectionOffset(), iInvocationContext.getSelectionLength());
        SurroundWithAnalyzer surroundWithAnalyzer = new SurroundWithAnalyzer(iInvocationContext.getCompilationUnit(), selection);
        iInvocationContext.getASTRoot().accept((ASTVisitor)surroundWithAnalyzer);
        if (!surroundWithAnalyzer.getStatus().isOK() || !surroundWithAnalyzer.hasSelectedNodes()) {
            return null;
        }
        return surroundWithAnalyzer.getSelectedStatements();
    }

    public int getBodyStart() {
        return this.fFirstInsertedPosition.getStartPosition();
    }

    public int getBodyLength() {
        return this.fLastInsertedPosition.getStartPosition() + this.fLastInsertedPosition.getLength() - this.getBodyStart();
    }

    public ASTRewrite getRewrite() throws CoreException {
        ImportRewrite importRewrite;
        Statement[] statementArray = this.fSelectedStatements;
        AST aST = this.getAst();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        Statement statement = statementArray[0];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BodyDeclaration bodyDeclaration = (BodyDeclaration)ASTNodes.getParent((ASTNode)statement, clazz);
        int n = LocalVariableIndex.perform(bodyDeclaration) + 1;
        this.fIsNewContext = this.isNewContext();
        List list = this.getVariableDeclarationsAccessedAfter((ASTNode)statementArray[statementArray.length - 1], n);
        List list2 = this.getVariableDeclarationReadsInside(statementArray, n);
        ArrayList arrayList = new ArrayList();
        this.moveToBlock(statementArray, arrayList, list, list2, aSTRewrite);
        if (this.fIsNewContext) {
            importRewrite = StubUtility.createImportRewrite((CompilationUnit)statementArray[0].getRoot(), false);
            int n2 = 0;
            while (n2 < statementArray.length) {
                this.qualifyThisExpressions((ASTNode)statementArray[n2], aSTRewrite, importRewrite);
                ++n2;
            }
        }
        if (statementArray.length == 1 && ASTNodes.isControlStatementBody(statementArray[0].getLocationInParent())) {
            importRewrite = aST.newBlock();
            aSTRewrite.replace((ASTNode)statementArray[0], (ASTNode)importRewrite, null);
            ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)importRewrite, Block.STATEMENTS_PROPERTY);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ASTNode aSTNode = (ASTNode)iterator.next();
                listRewrite.insertLast(aSTNode, null);
            }
        } else {
            importRewrite = this.getListRewrite((ASTNode)statementArray[0], aSTRewrite);
            Statement statement2 = statementArray[statementArray.length - 1];
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ASTNode aSTNode = (ASTNode)iterator.next();
                importRewrite.insertAfter(aSTNode, (ASTNode)statement2, null);
                statement2 = aSTNode;
            }
        }
        this.fFirstInsertedPosition = aSTRewrite.track((ASTNode)arrayList.get(0));
        this.fLastInsertedPosition = aSTRewrite.track((ASTNode)arrayList.get(arrayList.size() - 1));
        return aSTRewrite;
    }

    protected abstract boolean isNewContext();

    protected List getVariableDeclarationReadsInside(Statement[] statementArray, int n) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        if (!this.fIsNewContext) {
            return arrayList;
        }
        IVariableBinding[] iVariableBindingArray = this.getReads((ASTNode[])statementArray, n);
        int n2 = 0;
        while (n2 < iVariableBindingArray.length) {
            ASTNode aSTNode;
            IVariableBinding iVariableBinding = iVariableBindingArray[n2];
            if (!iVariableBinding.isField() && (aSTNode = this.getRootNode().findDeclaringNode((IBinding)iVariableBinding)) instanceof VariableDeclaration) {
                arrayList.add(aSTNode);
            }
            ++n2;
        }
        return arrayList;
    }

    protected List getVariableDeclarationsAccessedAfter(ASTNode aSTNode, int n) {
        List list;
        Object object;
        if (aSTNode.getLocationInParent() == SwitchStatement.STATEMENTS_PROPERTY) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.SwitchStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = (SwitchStatement)ASTNodes.getParent(aSTNode, clazz);
            list = object.statements();
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.Block");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = (Block)ASTNodes.getParent(aSTNode, clazz);
            list = object.statements();
        }
        object = list.subList(list.indexOf(aSTNode) + 1, list.size());
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        if (!object.isEmpty()) {
            IVariableBinding[] iVariableBindingArray = this.getAccesses(object.toArray(new ASTNode[object.size()]), n);
            int n2 = 0;
            while (n2 < iVariableBindingArray.length) {
                ASTNode aSTNode2;
                IVariableBinding iVariableBinding = iVariableBindingArray[n2];
                if (!iVariableBinding.isField() && (aSTNode2 = ASTNodes.findDeclaration((IBinding)iVariableBinding, (ASTNode)this.getRootNode())) instanceof VariableDeclarationFragment) {
                    arrayList.add(aSTNode2);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    private IVariableBinding[] getReads(ASTNode[] aSTNodeArray, int n) {
        FlowContext flowContext = new FlowContext(0, n);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo flowInfo = new InOutFlowAnalyzer(flowContext).perform(aSTNodeArray);
        IVariableBinding[] iVariableBindingArray = flowInfo.get(flowContext, 38);
        return iVariableBindingArray;
    }

    private IVariableBinding[] getAccesses(ASTNode[] aSTNodeArray, int n) {
        FlowContext flowContext = new FlowContext(0, n);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo flowInfo = new InOutFlowAnalyzer(flowContext).perform(aSTNodeArray);
        IVariableBinding[] iVariableBindingArray = flowInfo.get(flowContext, 62);
        return iVariableBindingArray;
    }

    private final void moveToBlock(Statement[] statementArray, List list, List list2, List list3, ASTRewrite aSTRewrite) {
        VariableDeclarationFragment variableDeclarationFragment;
        Object object;
        Object object2;
        Statement statement;
        int n = 0;
        while (n < statementArray.length) {
            statement = statementArray[n];
            if (statement instanceof VariableDeclarationStatement) {
                object2 = (VariableDeclarationStatement)statement;
                object = this.getListRewrite((ASTNode)object2, aSTRewrite);
                this.splitVariableDeclarationStatement((VariableDeclarationStatement)object2, this.createSplitSelectedOperator(list2, list3, aSTRewrite, list, (ListRewrite)object), aSTRewrite);
                variableDeclarationFragment = object2.fragments().iterator();
                while (variableDeclarationFragment.hasNext()) {
                    list3.remove(variableDeclarationFragment.next());
                }
            } else {
                this.insertNodeAtEnd(aSTRewrite, list, (ASTNode)statement);
            }
            ++n;
        }
        while (!list3.isEmpty()) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)list3.get(0);
            if (variableDeclaration instanceof SingleVariableDeclaration) {
                if (ASTNodes.findModifierNode(16, ASTNodes.getModifiers(variableDeclaration)) == null) {
                    ModifierRewrite.create(aSTRewrite, (ASTNode)variableDeclaration).setModifiers(16, 0, null);
                }
                list3.remove(0);
                continue;
            }
            if (variableDeclaration.getParent() instanceof VariableDeclarationStatement) {
                statement = (VariableDeclarationStatement)variableDeclaration.getParent();
                object2 = this.getListRewrite((ASTNode)statement, aSTRewrite);
                this.splitVariableDeclarationStatement((VariableDeclarationStatement)statement, this.createSplitUnselectedOperator(list3, aSTRewrite, (ListRewrite)object2), aSTRewrite);
                object = statement.fragments().iterator();
                while (object.hasNext()) {
                    variableDeclarationFragment = (VariableDeclarationFragment)object.next();
                    list3.remove(variableDeclarationFragment);
                }
                continue;
            }
            if (!(variableDeclaration.getParent() instanceof VariableDeclarationExpression)) continue;
            statement = (VariableDeclarationExpression)variableDeclaration.getParent();
            VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationExpression)statement, 16, 0, aSTRewrite, null);
            object2 = statement.fragments().iterator();
            while (object2.hasNext()) {
                object = (VariableDeclarationFragment)object2.next();
                list3.remove(object);
            }
        }
    }

    private void insertNodeAtEnd(ASTRewrite aSTRewrite, List list, ASTNode aSTNode) {
        list.add(aSTRewrite.createMoveTarget(aSTNode));
    }

    protected ISplitOperation createSplitUnselectedOperator(List list, ASTRewrite aSTRewrite, ListRewrite listRewrite) {
        return new SplitUnselectedOperator(list, listRewrite, aSTRewrite);
    }

    protected ISplitOperation createSplitSelectedOperator(List list, List list2, ASTRewrite aSTRewrite, List list3, ListRewrite listRewrite) {
        return new SplitSelectedOperator(list2, list, listRewrite, aSTRewrite, list3);
    }

    private void splitVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement, ISplitOperation iSplitOperation, ASTRewrite aSTRewrite) {
        List list = variableDeclarationStatement.fragments();
        Iterator iterator = list.iterator();
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
        VariableDeclarationStatement variableDeclarationStatement2 = variableDeclarationStatement;
        iSplitOperation.initializeStatement(variableDeclarationStatement2, variableDeclarationFragment);
        ListRewrite listRewrite = null;
        while (iterator.hasNext()) {
            ASTNode aSTNode;
            VariableDeclarationFragment variableDeclarationFragment2 = (VariableDeclarationFragment)iterator.next();
            if (iSplitOperation.needsSplit(variableDeclarationFragment, variableDeclarationFragment2)) {
                aSTNode = this.getAst().newVariableDeclarationStatement((VariableDeclarationFragment)aSTRewrite.createMoveTarget((ASTNode)variableDeclarationFragment2));
                ListRewrite listRewrite2 = aSTRewrite.getListRewrite(aSTNode, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                Iterator iterator2 = variableDeclarationStatement.modifiers().iterator();
                while (iterator2.hasNext()) {
                    listRewrite2.insertLast(aSTRewrite.createCopyTarget((ASTNode)iterator2.next()), null);
                }
                aSTNode.setType((Type)aSTRewrite.createCopyTarget((ASTNode)variableDeclarationStatement.getType()));
                iSplitOperation.initializeStatement((VariableDeclarationStatement)aSTNode, variableDeclarationFragment2);
                listRewrite = aSTRewrite.getListRewrite(aSTNode, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                variableDeclarationStatement2 = aSTNode;
            } else if (listRewrite != null) {
                aSTNode = aSTRewrite.createMoveTarget((ASTNode)variableDeclarationFragment2);
                listRewrite.insertLast(aSTNode, null);
            }
            variableDeclarationFragment = variableDeclarationFragment2;
        }
    }

    protected static void makeFinal(VariableDeclarationStatement variableDeclarationStatement, ASTRewrite aSTRewrite) {
        VariableDeclaration variableDeclaration = (VariableDeclaration)variableDeclarationStatement.fragments().get(0);
        if (ASTNodes.findModifierNode(16, ASTNodes.getModifiers(variableDeclaration)) == null) {
            ModifierRewrite.create(aSTRewrite, (ASTNode)variableDeclarationStatement).setModifiers(16, 0, null);
        }
    }

    private void qualifyThisExpressions(ASTNode aSTNode, final ASTRewrite aSTRewrite, ImportRewrite importRewrite) {
        aSTNode.accept((ASTVisitor)new GenericVisitor(){

            public boolean visit(ThisExpression thisExpression) {
                IJavaElement iJavaElement;
                ITypeBinding iTypeBinding;
                if (thisExpression.getQualifier() == null && (iTypeBinding = thisExpression.resolveTypeBinding()) != null && (iJavaElement = iTypeBinding.getJavaElement()) instanceof IType) {
                    String string = ((IType)iJavaElement).getElementName();
                    SimpleName simpleName = thisExpression.getAST().newSimpleName(string);
                    aSTRewrite.set((ASTNode)thisExpression, (StructuralPropertyDescriptor)ThisExpression.QUALIFIER_PROPERTY, (Object)simpleName, null);
                }
                return super.visit(thisExpression);
            }
        });
    }

    protected static void splitOffInitializer(List list, VariableDeclarationFragment variableDeclarationFragment, ASTRewrite aSTRewrite) {
        Expression expression = variableDeclarationFragment.getInitializer();
        if (expression != null) {
            AST aST = aSTRewrite.getAST();
            Assignment assignment = aST.newAssignment();
            assignment.setLeftHandSide((Expression)aSTRewrite.createCopyTarget((ASTNode)variableDeclarationFragment.getName()));
            assignment.setRightHandSide((Expression)aSTRewrite.createMoveTarget((ASTNode)expression));
            list.add(aST.newExpressionStatement((Expression)assignment));
        }
    }

    private ListRewrite getListRewrite(ASTNode aSTNode, ASTRewrite aSTRewrite) {
        if (aSTNode.getLocationInParent() == SwitchStatement.STATEMENTS_PROPERTY) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.SwitchStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ASTNode aSTNode2 = ASTNodes.getParent(aSTNode, clazz);
            return aSTRewrite.getListRewrite(aSTNode2, SwitchStatement.STATEMENTS_PROPERTY);
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.Block");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ASTNode aSTNode3 = ASTNodes.getParent(aSTNode, clazz);
        return aSTRewrite.getListRewrite(aSTNode3, Block.STATEMENTS_PROPERTY);
    }

    protected final AST getAst() {
        return this.getRootNode().getAST();
    }

    protected final Statement[] getSelectedStatements() {
        return this.fSelectedStatements;
    }

    private CompilationUnit getRootNode() {
        if (this.fSelectedStatements.length > 0) {
            return (CompilationUnit)this.fSelectedStatements[0].getRoot();
        }
        return this.fRootNode;
    }

    protected static interface ISplitOperation {
        public boolean needsSplit(VariableDeclarationFragment var1, VariableDeclarationFragment var2);

        public void initializeStatement(VariableDeclarationStatement var1, VariableDeclarationFragment var2);
    }

    private static final class SplitSelectedOperator
    implements ISplitOperation {
        private List fAccessedInside;
        private List fStatements;
        private List fAccessedAfter;
        private ASTRewrite fRewrite;
        private ListRewrite fBlockRewrite;
        private VariableDeclarationStatement fLastStatement = null;

        public SplitSelectedOperator(List list, List list2, ListRewrite listRewrite, ASTRewrite aSTRewrite, List list3) {
            this.fAccessedInside = list;
            this.fStatements = list3;
            this.fAccessedAfter = list2;
            this.fRewrite = aSTRewrite;
            this.fBlockRewrite = listRewrite;
        }

        public boolean needsSplit(VariableDeclarationFragment variableDeclarationFragment, VariableDeclarationFragment variableDeclarationFragment2) {
            return this.fAccessedInside.contains(variableDeclarationFragment) != this.fAccessedInside.contains(variableDeclarationFragment2) || this.fAccessedAfter.contains(variableDeclarationFragment) != this.fAccessedAfter.contains(variableDeclarationFragment2);
        }

        public void initializeStatement(VariableDeclarationStatement variableDeclarationStatement, VariableDeclarationFragment variableDeclarationFragment) {
            if (this.fAccessedAfter.contains(variableDeclarationFragment)) {
                if (this.fAccessedInside.contains(variableDeclarationFragment)) {
                    SurroundWith.makeFinal(variableDeclarationStatement, this.fRewrite);
                }
                this.handleInitializer(variableDeclarationFragment);
                if (this.fLastStatement != null) {
                    this.fBlockRewrite.insertAfter((ASTNode)variableDeclarationStatement, (ASTNode)this.fLastStatement, null);
                }
                this.fLastStatement = variableDeclarationStatement;
            } else if (this.fLastStatement != null) {
                this.handleNewStatement((Statement)variableDeclarationStatement);
            } else {
                this.handleStatement((Statement)variableDeclarationStatement);
                this.fLastStatement = variableDeclarationStatement;
            }
        }

        protected void handleStatement(Statement statement) {
            this.fStatements.add(this.fRewrite.createMoveTarget((ASTNode)statement));
        }

        protected void handleNewStatement(Statement statement) {
            this.fStatements.add(statement);
        }

        protected void handleInitializer(VariableDeclarationFragment variableDeclarationFragment) {
            SurroundWith.splitOffInitializer(this.fStatements, variableDeclarationFragment, this.fRewrite);
        }
    }

    private static final class SplitUnselectedOperator
    implements ISplitOperation {
        private List fAccessedInside;
        private ListRewrite fBlockRewrite;
        private ASTRewrite fRewrite;
        private VariableDeclarationStatement fLastStatement;

        private SplitUnselectedOperator(List list, ListRewrite listRewrite, ASTRewrite aSTRewrite) {
            this.fAccessedInside = list;
            this.fBlockRewrite = listRewrite;
            this.fRewrite = aSTRewrite;
            this.fLastStatement = null;
        }

        public boolean needsSplit(VariableDeclarationFragment variableDeclarationFragment, VariableDeclarationFragment variableDeclarationFragment2) {
            return this.fAccessedInside.contains(variableDeclarationFragment) ^ this.fAccessedInside.contains(variableDeclarationFragment2);
        }

        public void initializeStatement(VariableDeclarationStatement variableDeclarationStatement, VariableDeclarationFragment variableDeclarationFragment) {
            if (this.fAccessedInside.contains(variableDeclarationFragment)) {
                SurroundWith.makeFinal(variableDeclarationStatement, this.fRewrite);
            }
            if (this.fLastStatement != null) {
                this.fBlockRewrite.insertAfter((ASTNode)variableDeclarationStatement, (ASTNode)this.fLastStatement, null);
            }
            this.fLastStatement = variableDeclarationStatement;
        }
    }
}

