/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CastCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ChangeMethodSignatureProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ImplementInterfaceProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.TypeChangeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class TypeMismatchSubProcessor {
    private TypeMismatchSubProcessor() {
    }

    public static void addTypeMismatchProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) throws CoreException {
        BodyDeclaration bodyDeclaration;
        boolean bl;
        Assignment assignment;
        String[] stringArray = iProblemLocation.getProblemArguments();
        if (stringArray.length != 2) {
            return;
        }
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        CompilationUnit compilationUnit = iInvocationContext.getASTRoot();
        AST aST = compilationUnit.getAST();
        ASTNode aSTNode = iProblemLocation.getCoveredNode(compilationUnit);
        if (!(aSTNode instanceof Expression)) {
            return;
        }
        Expression expression = (Expression)aSTNode;
        SimpleName simpleName = null;
        ITypeBinding iTypeBinding = null;
        int n = aSTNode.getParent().getNodeType();
        if (n == 7) {
            assignment = (Assignment)aSTNode.getParent();
            Expression expression2 = assignment.getLeftHandSide();
            if (aSTNode.equals((Object)expression2)) {
                expression = assignment.getRightHandSide();
            }
            iTypeBinding = assignment.getLeftHandSide().resolveTypeBinding();
            if (expression2 instanceof Name) {
                simpleName = (Name)expression2;
            } else if (expression2 instanceof FieldAccess) {
                simpleName = ((FieldAccess)expression2).getName();
            }
        } else if (n == 59) {
            assignment = (VariableDeclarationFragment)aSTNode.getParent();
            if (aSTNode.equals((Object)assignment.getName()) || aSTNode.equals((Object)assignment.getInitializer())) {
                expression = assignment.getInitializer();
                iTypeBinding = ASTNodes.getType((VariableDeclaration)assignment).resolveBinding();
                simpleName = assignment.getName();
            }
        } else if (n == 80) {
            simpleName = ((MemberValuePair)aSTNode.getParent()).getName();
            iTypeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
        } else if (n == 79) {
            simpleName = ((SingleMemberAnnotation)aSTNode.getParent()).getTypeName();
            iTypeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
        } else {
            iTypeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
        }
        if (iTypeBinding == null) {
            return;
        }
        if (!(expression instanceof ArrayInitializer) && ((assignment = expression.resolveTypeBinding()) == null || assignment.isCastCompatible(iTypeBinding) || expression instanceof CastExpression)) {
            collection.add(TypeMismatchSubProcessor.createCastProposal(iInvocationContext, iTypeBinding, expression, 7));
        }
        boolean bl2 = bl = (assignment = expression.resolveTypeBinding()) == null || "void".equals(assignment.getName());
        if (!bl && n == 41 && (bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode)) instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            if ((assignment = Bindings.normalizeTypeBinding((ITypeBinding)assignment)) == null) {
                assignment = aST.resolveWellKnownType("java.lang.Object");
            }
            if (assignment.isWildcardType()) {
                assignment = ASTResolving.normalizeWildcardType((ITypeBinding)assignment, true, aST);
            }
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            String string = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturntype_description, assignment.getName());
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            LinkedCorrectionProposal linkedCorrectionProposal = new LinkedCorrectionProposal(string, iCompilationUnit, aSTRewrite, 6, image);
            ImportRewrite importRewrite = linkedCorrectionProposal.createImportRewrite(compilationUnit);
            Type type = importRewrite.addImport((ITypeBinding)assignment, aST);
            aSTRewrite.replace((ASTNode)methodDeclaration.getReturnType2(), (ASTNode)type, null);
            String string2 = "return";
            linkedCorrectionProposal.addLinkedPosition(aSTRewrite.track((ASTNode)type), true, string2);
            ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(aST, (ITypeBinding)assignment);
            int n2 = 0;
            while (n2 < iTypeBindingArray.length) {
                linkedCorrectionProposal.addLinkedPositionProposal(string2, iTypeBindingArray[n2]);
                ++n2;
            }
            collection.add(linkedCorrectionProposal);
        }
        if (!bl && simpleName != null) {
            if ((assignment = Bindings.normalizeTypeBinding((ITypeBinding)assignment)) == null) {
                assignment = aST.resolveWellKnownType("java.lang.Object");
            }
            if (assignment.isWildcardType()) {
                assignment = ASTResolving.normalizeWildcardType((ITypeBinding)assignment, true, aST);
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(iInvocationContext, (Expression)simpleName, (ITypeBinding)assignment, true, 6, collection);
        }
        TypeMismatchSubProcessor.addChangeSenderTypeProposals(iInvocationContext, expression, iTypeBinding, false, 5, collection);
    }

    public static void addChangeSenderTypeProposals(IInvocationContext iInvocationContext, Expression expression, ITypeBinding iTypeBinding, boolean bl, int n, Collection collection) throws JavaModelException {
        ITypeBinding iTypeBinding2;
        IVariableBinding iVariableBinding;
        IMethodBinding iMethodBinding = null;
        switch (expression.getNodeType()) {
            case 32: {
                iMethodBinding = ((MethodInvocation)expression).resolveMethodBinding();
                break;
            }
            case 48: {
                iMethodBinding = ((SuperMethodInvocation)expression).resolveMethodBinding();
                break;
            }
            case 22: {
                iMethodBinding = ((FieldAccess)expression).resolveFieldBinding();
                break;
            }
            case 47: {
                iMethodBinding = ((SuperFieldAccess)expression).resolveFieldBinding();
                break;
            }
            case 40: 
            case 42: {
                iMethodBinding = ((Name)expression).resolveBinding();
            }
        }
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        CompilationUnit compilationUnit = iInvocationContext.getASTRoot();
        ICompilationUnit iCompilationUnit2 = null;
        ITypeBinding iTypeBinding3 = null;
        IMethodBinding iMethodBinding2 = iMethodBinding;
        if (iMethodBinding instanceof IVariableBinding) {
            iVariableBinding = (IVariableBinding)iMethodBinding;
            if (iVariableBinding.isEnumConstant()) {
                return;
            }
            if (!iVariableBinding.isField()) {
                iCompilationUnit2 = iCompilationUnit;
            } else {
                iMethodBinding2 = iVariableBinding.getVariableDeclaration();
                iTypeBinding2 = iVariableBinding.getDeclaringClass();
                if (iTypeBinding2 == null) {
                    return;
                }
                iTypeBinding3 = iTypeBinding2.getTypeDeclaration();
            }
        } else if (iMethodBinding instanceof IMethodBinding) {
            iVariableBinding = iMethodBinding;
            if (!iVariableBinding.isConstructor()) {
                iTypeBinding3 = iVariableBinding.getDeclaringClass().getTypeDeclaration();
                iMethodBinding2 = iVariableBinding.getMethodDeclaration();
            }
        } else if (iMethodBinding instanceof ITypeBinding && expression.getLocationInParent() == SingleMemberAnnotation.TYPE_NAME_PROPERTY && (iMethodBinding2 = Bindings.findMethodInType(iTypeBinding3 = (ITypeBinding)iMethodBinding, "value", null)) == null) {
            return;
        }
        if (iTypeBinding3 != null && iTypeBinding3.isFromSource()) {
            iCompilationUnit2 = ASTResolving.findCompilationUnitForBinding(iCompilationUnit, compilationUnit, iTypeBinding3);
        }
        if (iCompilationUnit2 != null && ASTResolving.isUseableTypeInContext(iTypeBinding, (IBinding)iMethodBinding2, false)) {
            collection.add(new TypeChangeCompletionProposal(iCompilationUnit2, (IBinding)iMethodBinding2, compilationUnit, iTypeBinding, bl, n));
        }
        if (!bl) {
            ICompilationUnit iCompilationUnit3;
            iVariableBinding = expression.resolveTypeBinding();
            if (iTypeBinding.isInterface() && iVariableBinding != null && iVariableBinding.isClass() && !iVariableBinding.isAnonymous() && iVariableBinding.isFromSource() && (iCompilationUnit3 = ASTResolving.findCompilationUnitForBinding(iCompilationUnit, compilationUnit, iTypeBinding2 = iVariableBinding.getTypeDeclaration())) != null && ASTResolving.isUseableTypeInContext(iTypeBinding, (IBinding)iTypeBinding2, true)) {
                collection.add(new ImplementInterfaceProposal(iCompilationUnit3, iTypeBinding2, compilationUnit, iTypeBinding, n - 1));
            }
        }
    }

    public static ASTRewriteCorrectionProposal createCastProposal(IInvocationContext iInvocationContext, ITypeBinding iTypeBinding, Expression expression, int n) {
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        String string = BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_DEFAULT);
        String string2 = expression.getNodeType() == 11 ? Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changecast_description, string) : Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addcast_description, string);
        return new CastCompletionProposal(string2, iCompilationUnit, expression, iTypeBinding, n);
    }

    public static void addIncompatibleReturnTypeProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) throws JavaModelException {
        CompilationUnit compilationUnit = iInvocationContext.getASTRoot();
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        if (aSTNode == null) {
            return;
        }
        MethodDeclaration methodDeclaration = ASTResolving.findParentMethodDeclaration(aSTNode);
        if (methodDeclaration == null) {
            return;
        }
        IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
        if (iMethodBinding == null) {
            return;
        }
        IMethodBinding iMethodBinding2 = Bindings.findOverriddenMethod(iMethodBinding, false);
        if (iMethodBinding2 == null || iMethodBinding2.getReturnType() == iMethodBinding.getReturnType()) {
            return;
        }
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        IMethodBinding iMethodBinding3 = iMethodBinding.getMethodDeclaration();
        collection.add(new TypeChangeCompletionProposal(iCompilationUnit, (IBinding)iMethodBinding3, compilationUnit, iMethodBinding2.getReturnType(), false, 8));
        ICompilationUnit iCompilationUnit2 = iCompilationUnit;
        IMethodBinding iMethodBinding4 = iMethodBinding2.getMethodDeclaration();
        ITypeBinding iTypeBinding = iMethodBinding4.getDeclaringClass();
        ITypeBinding iTypeBinding2 = iMethodBinding.getReturnType();
        if (iTypeBinding.isFromSource()) {
            iCompilationUnit2 = ASTResolving.findCompilationUnitForBinding(iCompilationUnit, compilationUnit, iTypeBinding);
        }
        if (iCompilationUnit2 != null && ASTResolving.isUseableTypeInContext(iTypeBinding2, (IBinding)iMethodBinding4, false)) {
            TypeChangeCompletionProposal typeChangeCompletionProposal = new TypeChangeCompletionProposal(iCompilationUnit2, (IBinding)iMethodBinding4, compilationUnit, iTypeBinding2, false, 7);
            if (iTypeBinding.isInterface()) {
                typeChangeCompletionProposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofimplemented_description, iMethodBinding4.getName()));
            } else {
                typeChangeCompletionProposal.setDisplayName(Messages.format(CorrectionMessages.TypeMismatchSubProcessor_changereturnofoverridden_description, iMethodBinding4.getName()));
            }
            collection.add(typeChangeCompletionProposal);
        }
    }

    public static void addIncompatibleThrowsProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) throws JavaModelException {
        CompilationUnit compilationUnit = iInvocationContext.getASTRoot();
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        if (!(aSTNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
        IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
        if (iMethodBinding == null) {
            return;
        }
        IMethodBinding iMethodBinding2 = Bindings.findOverriddenMethod(iMethodBinding, false);
        if (iMethodBinding2 == null) {
            return;
        }
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getExceptionTypes();
        ITypeBinding[] iTypeBindingArray2 = iMethodBinding2.getExceptionTypes();
        ArrayList<ITypeBinding> arrayList = new ArrayList<ITypeBinding>();
        ITypeBinding iTypeBinding = new ChangeMethodSignatureProposal.ChangeDescription[iTypeBindingArray.length];
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (!TypeMismatchSubProcessor.isDeclaredException(iTypeBindingArray[n], iTypeBindingArray2)) {
                iTypeBinding[n] = new ChangeMethodSignatureProposal.RemoveDescription();
                arrayList.add(iTypeBindingArray[n]);
            }
            ++n;
        }
        String string = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_removeexceptions_description, iMethodBinding.getName());
        ChangeMethodSignatureProposal.ChangeDescription[] changeDescriptionArray = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.remove_correction.gif");
        collection.add(new ChangeMethodSignatureProposal(string, iCompilationUnit, (ASTNode)compilationUnit, iMethodBinding, null, (ChangeMethodSignatureProposal.ChangeDescription[])iTypeBinding, 8, (Image)changeDescriptionArray));
        iTypeBinding = iMethodBinding2.getDeclaringClass();
        string = iCompilationUnit;
        if (iTypeBinding.isFromSource()) {
            string = ASTResolving.findCompilationUnitForBinding(iCompilationUnit, compilationUnit, iTypeBinding);
        }
        if (string != null) {
            changeDescriptionArray = new ChangeMethodSignatureProposal.ChangeDescription[iTypeBindingArray2.length + arrayList.size()];
            int n2 = 0;
            while (n2 < arrayList.size()) {
                changeDescriptionArray[n2 + iTypeBindingArray2.length] = new ChangeMethodSignatureProposal.InsertDescription((ITypeBinding)arrayList.get(n2), "");
                ++n2;
            }
            IMethodBinding iMethodBinding3 = iMethodBinding2.getMethodDeclaration();
            Object[] objectArray = new String[]{iTypeBinding.getName(), iMethodBinding2.getName()};
            String string2 = Messages.format(CorrectionMessages.TypeMismatchSubProcessor_addexceptions_description, objectArray);
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.add_correction.gif");
            collection.add(new ChangeMethodSignatureProposal(string2, (ICompilationUnit)string, (ASTNode)compilationUnit, iMethodBinding3, null, changeDescriptionArray, 7, image));
        }
    }

    private static boolean isDeclaredException(ITypeBinding iTypeBinding, ITypeBinding[] iTypeBindingArray) {
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (Bindings.isSuperType(iTypeBindingArray[n], iTypeBinding)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

