/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;
import org.osgi.framework.Bundle;

final class CompletionProposalComputerDescriptor {
    private static final String DEFAULT_CATEGORY_ID = "org.eclipse.wst.jsdt.ui.defaultProposalCategory";
    private static final String CATEGORY_ID = "categoryId";
    private static final String TYPE = "type";
    private static final String CLASS = "class";
    private static final String ACTIVATE = "activate";
    private static final String PARTITION = "partition";
    private static final Set PARTITION_SET;
    private static final String PERFORMANCE_EVENT;
    private static final boolean MEASURE_PERFORMANCE;
    private static final long MAX_DELAY = 5000L;
    private static final String COMPUTE_COMPLETION_PROPOSALS = "computeCompletionProposals()";
    private static final String COMPUTE_CONTEXT_INFORMATION = "computeContextInformation()";
    private static final String SESSION_STARTED = "sessionStarted()";
    private static final String SESSION_ENDED = "sessionEnded()";
    private final String fId;
    private final String fName;
    private final String fClass;
    private final boolean fActivate;
    private final Set fPartitions;
    private final IConfigurationElement fElement;
    private final CompletionProposalComputerRegistry fRegistry;
    private IJavaCompletionProposalComputer fComputer;
    private final CompletionProposalCategory fCategory;
    private String fLastError;
    private boolean fIsReportingDelay = false;
    private long fStart;

    static {
        PERFORMANCE_EVENT = String.valueOf(JavaPlugin.getPluginId()) + "/perf/content_assist/extensions";
        MEASURE_PERFORMANCE = PerformanceStats.isEnabled((String)PERFORMANCE_EVENT);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("__dftl_partition_content_type");
        hashSet.add("__java_javadoc");
        hashSet.add("__java_multiline_comment");
        hashSet.add("__java_singleline_comment");
        hashSet.add("__java_string");
        hashSet.add("__java_character");
        PARTITION_SET = Collections.unmodifiableSet(hashSet);
    }

    CompletionProposalComputerDescriptor(IConfigurationElement iConfigurationElement, CompletionProposalComputerRegistry completionProposalComputerRegistry, List list) throws InvalidRegistryObjectException {
        String string;
        Assert.isLegal((completionProposalComputerRegistry != null ? 1 : 0) != 0);
        Assert.isLegal((iConfigurationElement != null ? 1 : 0) != 0);
        this.fRegistry = completionProposalComputerRegistry;
        this.fElement = iConfigurationElement;
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        this.fId = iExtension.getUniqueIdentifier();
        this.checkNotNull(this.fId, "id");
        String string2 = iExtension.getLabel();
        this.fName = string2.length() == 0 ? this.fId : string2;
        HashSet<String> hashSet = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(PARTITION);
        if (iConfigurationElementArray.length == 0) {
            this.fPartitions = PARTITION_SET;
        } else {
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                string = iConfigurationElementArray[n].getAttribute(TYPE);
                this.checkNotNull(string, TYPE);
                hashSet.add(string);
                ++n;
            }
            this.fPartitions = Collections.unmodifiableSet(hashSet);
        }
        String string3 = iConfigurationElement.getAttribute(ACTIVATE);
        this.fActivate = Boolean.valueOf(string3);
        this.fClass = iConfigurationElement.getAttribute(CLASS);
        this.checkNotNull(this.fClass, CLASS);
        string = iConfigurationElement.getAttribute(CATEGORY_ID);
        if (string == null) {
            string = DEFAULT_CATEGORY_ID;
        }
        CompletionProposalCategory completionProposalCategory = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CompletionProposalCategory completionProposalCategory2 = (CompletionProposalCategory)iterator.next();
            if (!completionProposalCategory2.getId().equals(string)) continue;
            completionProposalCategory = completionProposalCategory2;
            break;
        }
        if (completionProposalCategory == null) {
            this.fCategory = new CompletionProposalCategory(string, this.fName, completionProposalComputerRegistry);
            list.add(this.fCategory);
        } else {
            this.fCategory = completionProposalCategory;
        }
    }

    private void checkNotNull(Object object, String string) throws InvalidRegistryObjectException {
        if (object == null) {
            Object[] objectArray = new Object[]{this.getId(), this.fElement.getContributor().getName(), string};
            String string2 = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, objectArray);
            Status status = new Status(2, JavaPlugin.getPluginId(), 0, string2, null);
            JavaPlugin.log((IStatus)status);
            throw new InvalidRegistryObjectException();
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public Set getPartitions() {
        return this.fPartitions;
    }

    private synchronized IJavaCompletionProposalComputer getComputer() throws CoreException, InvalidRegistryObjectException {
        if (this.fComputer == null && (this.fActivate || this.isPluginLoaded())) {
            this.fComputer = this.createComputer();
        }
        return this.fComputer;
    }

    private boolean isPluginLoaded() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    private Bundle getBundle() {
        String string = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)string);
        return bundle;
    }

    public IJavaCompletionProposalComputer createComputer() throws CoreException, InvalidRegistryObjectException {
        return (IJavaCompletionProposalComputer)this.fElement.createExecutableExtension(CLASS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List computeCompletionProposals(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        IStatus iStatus;
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        try {
            try {
                block12: {
                    List list;
                    IJavaCompletionProposalComputer iJavaCompletionProposalComputer = this.getComputer();
                    if (iJavaCompletionProposalComputer == null) {
                        List list2 = Collections.EMPTY_LIST;
                        Object var10_8 = null;
                        iProgressMonitor.done();
                        return list2;
                    }
                    try {
                        PerformanceStats performanceStats = this.startMeter(contentAssistInvocationContext, iJavaCompletionProposalComputer);
                        List list3 = iJavaCompletionProposalComputer.computeCompletionProposals(contentAssistInvocationContext, iProgressMonitor);
                        this.stopMeter(performanceStats, COMPUTE_COMPLETION_PROPOSALS);
                        if (list3 == null) break block12;
                        this.fLastError = iJavaCompletionProposalComputer.getErrorMessage();
                        list = list3;
                        Object var7_15 = null;
                        this.fIsReportingDelay = true;
                    }
                    catch (Throwable throwable) {
                        Object var7_16 = null;
                        this.fIsReportingDelay = true;
                        throw throwable;
                    }
                    Object var10_9 = null;
                    iProgressMonitor.done();
                    return list;
                }
                Object var7_17 = null;
                this.fIsReportingDelay = true;
                iStatus = this.createAPIViolationStatus(COMPUTE_COMPLETION_PROPOSALS);
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                iStatus = this.createExceptionStatus(invalidRegistryObjectException);
            }
            catch (CoreException coreException) {
                iStatus = this.createExceptionStatus(coreException);
            }
            catch (RuntimeException runtimeException) {
                iStatus = this.createExceptionStatus(runtimeException);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        this.fRegistry.informUser(this, iStatus);
        return Collections.EMPTY_LIST;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List computeContextInformation(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        IStatus iStatus;
        block12: {
            List list;
            block11: {
                List list2;
                block10: {
                    if (!this.isEnabled()) {
                        return Collections.EMPTY_LIST;
                    }
                    try {
                        try {
                            IJavaCompletionProposalComputer iJavaCompletionProposalComputer = this.getComputer();
                            if (iJavaCompletionProposalComputer == null) {
                                list2 = Collections.EMPTY_LIST;
                                Object var7_9 = null;
                                break block10;
                            }
                            PerformanceStats performanceStats = this.startMeter(contentAssistInvocationContext, iJavaCompletionProposalComputer);
                            List list3 = iJavaCompletionProposalComputer.computeContextInformation(contentAssistInvocationContext, iProgressMonitor);
                            this.stopMeter(performanceStats, COMPUTE_CONTEXT_INFORMATION);
                            if (list3 != null) {
                                this.fLastError = iJavaCompletionProposalComputer.getErrorMessage();
                                list = list3;
                                break block11;
                            }
                            iStatus = this.createAPIViolationStatus(COMPUTE_CONTEXT_INFORMATION);
                        }
                        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                            iStatus = this.createExceptionStatus(invalidRegistryObjectException);
                        }
                        catch (CoreException coreException) {
                            iStatus = this.createExceptionStatus(coreException);
                        }
                        catch (RuntimeException runtimeException) {
                            iStatus = this.createExceptionStatus(runtimeException);
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                }
                iProgressMonitor.done();
                return list2;
            }
            Object var7_10 = null;
            iProgressMonitor.done();
            return list;
        }
        Object var7_12 = null;
        iProgressMonitor.done();
        this.fRegistry.informUser(this, iStatus);
        return Collections.EMPTY_LIST;
    }

    public void sessionStarted() {
        IStatus iStatus;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IJavaCompletionProposalComputer iJavaCompletionProposalComputer = this.getComputer();
            if (iJavaCompletionProposalComputer == null) {
                return;
            }
            PerformanceStats performanceStats = this.startMeter(SESSION_STARTED, iJavaCompletionProposalComputer);
            iJavaCompletionProposalComputer.sessionStarted();
            this.stopMeter(performanceStats, SESSION_ENDED);
            return;
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            iStatus = this.createExceptionStatus(invalidRegistryObjectException);
        }
        catch (CoreException coreException) {
            iStatus = this.createExceptionStatus(coreException);
        }
        catch (RuntimeException runtimeException) {
            iStatus = this.createExceptionStatus(runtimeException);
        }
        this.fRegistry.informUser(this, iStatus);
    }

    public void sessionEnded() {
        IStatus iStatus;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IJavaCompletionProposalComputer iJavaCompletionProposalComputer = this.getComputer();
            if (iJavaCompletionProposalComputer == null) {
                return;
            }
            PerformanceStats performanceStats = this.startMeter(SESSION_ENDED, iJavaCompletionProposalComputer);
            iJavaCompletionProposalComputer.sessionEnded();
            this.stopMeter(performanceStats, SESSION_ENDED);
            return;
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            iStatus = this.createExceptionStatus(invalidRegistryObjectException);
        }
        catch (CoreException coreException) {
            iStatus = this.createExceptionStatus(coreException);
        }
        catch (RuntimeException runtimeException) {
            iStatus = this.createExceptionStatus(runtimeException);
        }
        this.fRegistry.informUser(this, iStatus);
    }

    private PerformanceStats startMeter(Object object, IJavaCompletionProposalComputer iJavaCompletionProposalComputer) {
        PerformanceStats performanceStats;
        if (MEASURE_PERFORMANCE) {
            performanceStats = PerformanceStats.getStats((String)PERFORMANCE_EVENT, (Object)iJavaCompletionProposalComputer);
            performanceStats.startRun(object.toString());
        } else {
            performanceStats = null;
        }
        if (this.fIsReportingDelay) {
            this.fStart = System.currentTimeMillis();
        }
        return performanceStats;
    }

    private void stopMeter(PerformanceStats performanceStats, String string) {
        long l;
        if (MEASURE_PERFORMANCE) {
            performanceStats.endRun();
            if (performanceStats.isFailure()) {
                IStatus iStatus = this.createPerformanceStatus(string);
                this.fRegistry.informUser(this, iStatus);
                return;
            }
        }
        if (this.fIsReportingDelay && (l = System.currentTimeMillis()) - this.fStart > 5000L) {
            IStatus iStatus = this.createPerformanceStatus(string);
            this.fRegistry.informUser(this, iStatus);
        }
    }

    private IStatus createExceptionStatus(InvalidRegistryObjectException invalidRegistryObjectException) {
        String string = this.createBlameMessage();
        String string2 = JavaTextMessages.CompletionProposalComputerDescriptor_reason_invalid;
        return new Status(1, JavaPlugin.getPluginId(), 0, String.valueOf(string) + " " + string2, (Throwable)invalidRegistryObjectException);
    }

    private IStatus createExceptionStatus(CoreException coreException) {
        String string = this.createBlameMessage();
        String string2 = JavaTextMessages.CompletionProposalComputerDescriptor_reason_instantiation;
        return new Status(4, JavaPlugin.getPluginId(), 0, String.valueOf(string) + " " + string2, (Throwable)coreException);
    }

    private IStatus createExceptionStatus(RuntimeException runtimeException) {
        String string = this.createBlameMessage();
        String string2 = JavaTextMessages.CompletionProposalComputerDescriptor_reason_runtime_ex;
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(string) + " " + string2, (Throwable)runtimeException);
    }

    private IStatus createAPIViolationStatus(String string) {
        String string2 = this.createBlameMessage();
        Object[] objectArray = new Object[]{string};
        String string3 = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_API, objectArray);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(string2) + " " + string3, null);
    }

    private IStatus createPerformanceStatus(String string) {
        String string2 = this.createBlameMessage();
        Object[] objectArray = new Object[]{string};
        String string3 = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_performance, objectArray);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(string2) + " " + string3, null);
    }

    private String createBlameMessage() {
        Object[] objectArray = new Object[]{this.getName(), this.fElement.getDeclaringExtension().getContributor().getName()};
        String string = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_blame_message, objectArray);
        return string;
    }

    private boolean isEnabled() {
        return this.fCategory.isEnabled();
    }

    CompletionProposalCategory getCategory() {
        return this.fCategory;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    IContributor getContributor() {
        try {
            return this.fElement.getContributor();
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return null;
        }
    }
}

