/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;

public class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/ResultCollector"));
    private static final String PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY = "EmptyDefaultAssistCategory";
    private static final Comparator ORDER_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            CompletionProposalCategory completionProposalCategory = (CompletionProposalCategory)object;
            CompletionProposalCategory completionProposalCategory2 = (CompletionProposalCategory)object2;
            return completionProposalCategory.getSortOrder() - completionProposalCategory2.getSortOrder();
        }
    };
    private final List fCategories;
    private final String fPartition;
    private final ContentAssistant fAssistant;
    private char[] fCompletionAutoActivationCharacters;
    private int fRepetition = -1;
    private List fCategoryIteration = null;
    private String fIterationGesture = null;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;
    static /* synthetic */ Class class$0;

    public ContentAssistProcessor(ContentAssistant contentAssistant, String string) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)contentAssistant);
        this.fPartition = string;
        this.fCategories = CompletionProposalComputerRegistry.getDefault().getProposalCategories();
        this.fAssistant = contentAssistant;
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent contentAssistEvent) {
                CompletionProposalCategory completionProposalCategory;
                if (contentAssistEvent.processor != ContentAssistProcessor.this) {
                    return;
                }
                ContentAssistProcessor.this.fIterationGesture = ContentAssistProcessor.this.getIterationGesture();
                KeySequence keySequence = ContentAssistProcessor.this.getIterationBinding();
                ContentAssistProcessor.this.fCategoryIteration = ContentAssistProcessor.this.getCategoryIteration();
                IContentAssistantExtension2 iContentAssistantExtension2 = ContentAssistProcessor.this.fCategories.iterator();
                while (iContentAssistantExtension2.hasNext()) {
                    completionProposalCategory = (CompletionProposalCategory)iContentAssistantExtension2.next();
                    completionProposalCategory.sessionStarted();
                }
                ContentAssistProcessor.this.fRepetition = 0;
                if (contentAssistEvent.assistant instanceof IContentAssistantExtension2) {
                    iContentAssistantExtension2 = (IContentAssistantExtension2)contentAssistEvent.assistant;
                    if (ContentAssistProcessor.this.fCategoryIteration.size() == 1) {
                        iContentAssistantExtension2.setRepeatedInvocationMode(false);
                        iContentAssistantExtension2.setShowEmptyList(false);
                    } else {
                        iContentAssistantExtension2.setRepeatedInvocationMode(true);
                        iContentAssistantExtension2.setStatusLineVisible(true);
                        iContentAssistantExtension2.setStatusMessage(ContentAssistProcessor.this.createIterationMessage());
                        iContentAssistantExtension2.setShowEmptyList(true);
                        if (iContentAssistantExtension2 instanceof IContentAssistantExtension3) {
                            completionProposalCategory = (IContentAssistantExtension3)iContentAssistantExtension2;
                            ((ContentAssistant)completionProposalCategory).setRepeatedInvocationTrigger(keySequence);
                        }
                    }
                }
            }

            public void assistSessionEnded(ContentAssistEvent contentAssistEvent) {
                CompletionProposalCategory completionProposalCategory;
                if (contentAssistEvent.processor != ContentAssistProcessor.this) {
                    return;
                }
                IContentAssistantExtension2 iContentAssistantExtension2 = ContentAssistProcessor.this.fCategories.iterator();
                while (iContentAssistantExtension2.hasNext()) {
                    completionProposalCategory = (CompletionProposalCategory)iContentAssistantExtension2.next();
                    completionProposalCategory.sessionEnded();
                }
                ContentAssistProcessor.this.fCategoryIteration = null;
                ContentAssistProcessor.this.fRepetition = -1;
                ContentAssistProcessor.this.fIterationGesture = null;
                if (contentAssistEvent.assistant instanceof IContentAssistantExtension2) {
                    iContentAssistantExtension2 = (IContentAssistantExtension2)contentAssistEvent.assistant;
                    iContentAssistantExtension2.setShowEmptyList(false);
                    iContentAssistantExtension2.setRepeatedInvocationMode(false);
                    iContentAssistantExtension2.setStatusLineVisible(false);
                    if (iContentAssistantExtension2 instanceof IContentAssistantExtension3) {
                        completionProposalCategory = (IContentAssistantExtension3)iContentAssistantExtension2;
                        ((ContentAssistant)completionProposalCategory).setRepeatedInvocationTrigger(null);
                    }
                }
            }

            public void selectionChanged(ICompletionProposal iCompletionProposal, boolean bl) {
            }
        });
    }

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        long l = DEBUG ? System.currentTimeMillis() : 0L;
        this.clearState();
        IProgressMonitor iProgressMonitor = this.createProgressMonitor();
        iProgressMonitor.beginTask(JavaTextMessages.ContentAssistProcessor_computing_proposals, this.fCategories.size() + 1);
        ContentAssistInvocationContext contentAssistInvocationContext = this.createContext(iTextViewer, n);
        long l2 = DEBUG ? System.currentTimeMillis() : 0L;
        iProgressMonitor.subTask(JavaTextMessages.ContentAssistProcessor_collecting_proposals);
        List list = this.collectProposals(iTextViewer, n, iProgressMonitor, contentAssistInvocationContext);
        long l3 = DEBUG ? System.currentTimeMillis() : 0L;
        iProgressMonitor.subTask(JavaTextMessages.ContentAssistProcessor_sorting_proposals);
        List list2 = this.filterAndSortProposals(list, iProgressMonitor, contentAssistInvocationContext);
        this.fNumberOfComputedResults = list2.size();
        long l4 = DEBUG ? System.currentTimeMillis() : 0L;
        ICompletionProposal[] iCompletionProposalArray = list2.toArray(new ICompletionProposal[list2.size()]);
        iProgressMonitor.done();
        if (DEBUG) {
            System.err.println("Code Assist Stats (" + iCompletionProposalArray.length + " proposals)");
            System.err.println("Code Assist (setup):\t" + (l2 - l));
            System.err.println("Code Assist (collect):\t" + (l3 - l2));
            System.err.println("Code Assist (sort):\t" + (l4 - l3));
        }
        return iCompletionProposalArray;
    }

    private void clearState() {
        this.fErrorMessage = null;
        this.fNumberOfComputedResults = 0;
    }

    private List collectProposals(ITextViewer iTextViewer, int n, IProgressMonitor iProgressMonitor, ContentAssistInvocationContext contentAssistInvocationContext) {
        ArrayList arrayList = new ArrayList();
        List list = this.getCategories();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CompletionProposalCategory completionProposalCategory = (CompletionProposalCategory)iterator.next();
            List list2 = completionProposalCategory.computeCompletionProposals(contentAssistInvocationContext, this.fPartition, new SubProgressMonitor(iProgressMonitor, 1));
            arrayList.addAll(list2);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = completionProposalCategory.getErrorMessage();
        }
        return arrayList;
    }

    protected List filterAndSortProposals(List list, IProgressMonitor iProgressMonitor, ContentAssistInvocationContext contentAssistInvocationContext) {
        return list;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        this.clearState();
        IProgressMonitor iProgressMonitor = this.createProgressMonitor();
        iProgressMonitor.beginTask(JavaTextMessages.ContentAssistProcessor_computing_contexts, this.fCategories.size() + 1);
        iProgressMonitor.subTask(JavaTextMessages.ContentAssistProcessor_collecting_contexts);
        List list = this.collectContextInformation(iTextViewer, n, iProgressMonitor);
        iProgressMonitor.subTask(JavaTextMessages.ContentAssistProcessor_sorting_contexts);
        List list2 = this.filterAndSortContextInformation(list, iProgressMonitor);
        this.fNumberOfComputedResults = list2.size();
        IContextInformation[] iContextInformationArray = list2.toArray(new IContextInformation[list2.size()]);
        iProgressMonitor.done();
        return iContextInformationArray;
    }

    private List collectContextInformation(ITextViewer iTextViewer, int n, IProgressMonitor iProgressMonitor) {
        ArrayList arrayList = new ArrayList();
        ContentAssistInvocationContext contentAssistInvocationContext = this.createContext(iTextViewer, n);
        List list = this.getCategories();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CompletionProposalCategory completionProposalCategory = (CompletionProposalCategory)iterator.next();
            List list2 = completionProposalCategory.computeContextInformation(contentAssistInvocationContext, this.fPartition, new SubProgressMonitor(iProgressMonitor, 1));
            arrayList.addAll(list2);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = completionProposalCategory.getErrorMessage();
        }
        return arrayList;
    }

    protected List filterAndSortContextInformation(List list, IProgressMonitor iProgressMonitor) {
        return list;
    }

    public final void setCompletionProposalAutoActivationCharacters(char[] cArray) {
        this.fCompletionAutoActivationCharacters = cArray;
    }

    public final char[] getCompletionProposalAutoActivationCharacters() {
        return this.fCompletionAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults > 0) {
            return null;
        }
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        return JavaUIMessages.JavaEditor_codeassist_noCompletions;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected ContentAssistInvocationContext createContext(ITextViewer iTextViewer, int n) {
        return new ContentAssistInvocationContext(iTextViewer, n);
    }

    private List getCategories() {
        if (this.fCategoryIteration == null) {
            return this.fCategories;
        }
        int n = this.fRepetition % this.fCategoryIteration.size();
        this.fAssistant.setStatusMessage(this.createIterationMessage());
        this.fAssistant.setEmptyMessage(this.createEmptyMessage());
        ++this.fRepetition;
        return (List)this.fCategoryIteration.get(n);
    }

    private List getCategoryIteration() {
        ArrayList<List<CompletionProposalCategory>> arrayList = new ArrayList<List<CompletionProposalCategory>>();
        arrayList.add(this.getDefaultCategories());
        Iterator iterator = this.getSeparateCategories().iterator();
        while (iterator.hasNext()) {
            CompletionProposalCategory completionProposalCategory = (CompletionProposalCategory)iterator.next();
            arrayList.add(Collections.singletonList(completionProposalCategory));
        }
        return arrayList;
    }

    private List getDefaultCategories() {
        List list = this.getDefaultCategoriesUnchecked();
        if (("__java_javadoc".equals(this.fPartition) || "__dftl_partition_content_type".equals(this.fPartition)) && list.isEmpty() && !this.fCategories.isEmpty() && this.informUserAboutEmptyDefaultCategory()) {
            list = this.getDefaultCategoriesUnchecked();
        }
        return list;
    }

    private List getDefaultCategoriesUnchecked() {
        ArrayList<CompletionProposalCategory> arrayList = new ArrayList<CompletionProposalCategory>();
        Iterator iterator = this.fCategories.iterator();
        while (iterator.hasNext()) {
            CompletionProposalCategory completionProposalCategory = (CompletionProposalCategory)iterator.next();
            if (!completionProposalCategory.isIncluded() || !completionProposalCategory.hasComputers(this.fPartition)) continue;
            arrayList.add(completionProposalCategory);
        }
        return arrayList;
    }

    private boolean informUserAboutEmptyDefaultCategory() {
        String string;
        String string2;
        String string3;
        String string4;
        Shell shell;
        OptionalMessageDialog optionalMessageDialog;
        int n;
        if (OptionalMessageDialog.isDialogEnabled(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY) && (1034 == (n = (optionalMessageDialog = new OptionalMessageDialog(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY, shell = JavaPlugin.getActiveWorkbenchShell(), string4 = JavaTextMessages.ContentAssistProcessor_all_disabled_title, null, string3 = JavaTextMessages.ContentAssistProcessor_all_disabled_message, 4, new String[]{string2 = JFaceResources.getString((String)"defaults"), IDialogConstants.CLOSE_LABEL}, 1, string = Messages.format(JavaTextMessages.ContentAssistProcessor_all_disabled_preference_link, LegacyActionTools.removeMnemonics((String)string2)), string2){
            private final /* synthetic */ String val$linkMessage;
            private final /* synthetic */ String val$restoreButtonLabel;
            {
                this.val$linkMessage = string4;
                this.val$restoreButtonLabel = string5;
            }

            protected Control createCustomArea(Composite composite) {
                Composite composite2 = new Composite(composite, 0);
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                gridLayout.verticalSpacing = 0;
                composite2.setLayout((Layout)gridLayout);
                Composite composite3 = new Composite(composite2, 0);
                gridLayout = new GridLayout();
                gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
                gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                composite3.setLayout((Layout)gridLayout);
                Link link = new Link(composite3, 0);
                link.setText(this.val$linkMessage);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        3.access$0(this.this$1, 1035);
                        this.this$1.close();
                    }
                });
                GridData gridData = new GridData(4, 1, true, false);
                gridData.widthHint = this.getMinimumMessageWidth();
                link.setLayoutData((Object)gridData);
                super.createCustomArea(composite2);
                return composite2;
            }

            protected void createButtonsForButtonBar(Composite composite) {
                Button[] buttonArray = new Button[]{this.createButton(composite, 1034, this.val$restoreButtonLabel, false), this.createButton(composite, 12, IDialogConstants.CLOSE_LABEL, true)};
                this.setButtons(buttonArray);
            }

            static /* synthetic */ void access$0(3 var0, int n) {
                var0.setReturnCode(n);
            }
        }).open()) || 1035 == n)) {
            Object object;
            if (1034 == n) {
                object = JavaPlugin.getDefault().getPreferenceStore();
                object.setToDefault("content_assist_category_order");
                object.setToDefault("content_assist_disabled_computers");
            }
            if (1035 == n) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.wst.jsdt.ui.preferences.CodeAssistPreferenceAdvanced", null, null).open();
            }
            object = CompletionProposalComputerRegistry.getDefault();
            ((CompletionProposalComputerRegistry)object).reload();
            return true;
        }
        return false;
    }

    private List getSeparateCategories() {
        ArrayList<CompletionProposalCategory> arrayList = new ArrayList<CompletionProposalCategory>();
        Iterator iterator = this.fCategories.iterator();
        while (iterator.hasNext()) {
            CompletionProposalCategory completionProposalCategory = (CompletionProposalCategory)iterator.next();
            if (!completionProposalCategory.isSeparateCommand() || !completionProposalCategory.hasComputers(this.fPartition)) continue;
            arrayList.add(completionProposalCategory);
        }
        Collections.sort(arrayList, ORDER_COMPARATOR);
        return arrayList;
    }

    private String createEmptyMessage() {
        return Messages.format(JavaTextMessages.ContentAssistProcessor_empty_message, new String[]{this.getCategoryLabel(this.fRepetition)});
    }

    private String createIterationMessage() {
        return Messages.format(JavaTextMessages.ContentAssistProcessor_toggle_affordance_update_message, new String[]{this.getCategoryLabel(this.fRepetition), this.fIterationGesture, this.getCategoryLabel(this.fRepetition + 1)});
    }

    private String getCategoryLabel(int n) {
        int n2 = n % this.fCategoryIteration.size();
        if (n2 == 0) {
            return JavaTextMessages.ContentAssistProcessor_defaultProposalCategory;
        }
        return this.toString((CompletionProposalCategory)((List)this.fCategoryIteration.get(n2)).get(0));
    }

    private String toString(CompletionProposalCategory completionProposalCategory) {
        return completionProposalCategory.getDisplayName();
    }

    private String getIterationGesture() {
        KeySequence keySequence = this.getIterationBinding();
        return keySequence != null ? Messages.format(JavaTextMessages.ContentAssistProcessor_toggle_affordance_press_gesture, new Object[]{keySequence.format()}) : JavaTextMessages.ContentAssistProcessor_toggle_affordance_click_gesture;
    }

    private KeySequence getIterationBinding() {
        IBindingService iBindingService;
        TriggerSequence triggerSequence;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((triggerSequence = (iBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)).getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals")) instanceof KeySequence) {
            return (KeySequence)triggerSequence;
        }
        return null;
    }
}

