/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.FilledArgumentNamesMethodProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public final class FillArgumentNamesCompletionProposalCollector
extends CompletionProposalCollector {
    private final boolean fIsGuessArguments;

    public FillArgumentNamesCompletionProposalCollector(JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        super(javaContentAssistInvocationContext.getCompilationUnit());
        this.setInvocationContext(javaContentAssistInvocationContext);
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        this.fIsGuessArguments = iPreferenceStore.getBoolean("content_assist_guess_method_arguments");
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal completionProposal) {
        switch (completionProposal.getKind()) {
            case 6: {
                return this.createMethodReferenceProposal(completionProposal);
            }
            case 9: {
                return this.createTypeProposal(completionProposal);
            }
        }
        return super.createJavaCompletionProposal(completionProposal);
    }

    private IJavaCompletionProposal createMethodReferenceProposal(CompletionProposal completionProposal) {
        String string = String.valueOf(completionProposal.getCompletion());
        if (string.length() == 0 || string.length() == 1 && string.charAt(0) == ')' || Signature.getParameterCount((char[])completionProposal.getSignature()) == 0 || this.getContext().isInJavadoc()) {
            return super.createJavaCompletionProposal(completionProposal);
        }
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        JavaMethodCompletionProposal javaMethodCompletionProposal = iCompilationUnit != null && this.fIsGuessArguments ? new ParameterGuessingProposal(completionProposal, this.getInvocationContext()) : new FilledArgumentNamesMethodProposal(completionProposal, this.getInvocationContext());
        return javaMethodCompletionProposal;
    }

    private IJavaCompletionProposal createTypeProposal(CompletionProposal completionProposal) {
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        if (iCompilationUnit == null || this.getContext().isInJavadoc()) {
            return super.createJavaCompletionProposal(completionProposal);
        }
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        if (!this.shouldProposeGenerics(iJavaProject)) {
            return super.createJavaCompletionProposal(completionProposal);
        }
        char[] cArray = completionProposal.getCompletion();
        if (cArray.length > 0 && (cArray[cArray.length - 1] == ';' || cArray[cArray.length - 1] == '.')) {
            return super.createJavaCompletionProposal(completionProposal);
        }
        LazyGenericTypeProposal lazyGenericTypeProposal = new LazyGenericTypeProposal(completionProposal, this.getInvocationContext());
        return lazyGenericTypeProposal;
    }

    private final boolean shouldProposeGenerics(IJavaProject iJavaProject) {
        String string = iJavaProject != null ? iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.source");
        return string != null && "1.5".compareTo(string) <= 0;
    }
}

