/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public final class FilledArgumentNamesMethodProposal
extends JavaMethodCompletionProposal {
    private IRegion fSelectedRegion;
    private int[] fArgumentOffsets;
    private int[] fArgumentLengths;

    public FilledArgumentNamesMethodProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        super(completionProposal, javaContentAssistInvocationContext);
    }

    public void apply(IDocument iDocument, char c, int n) {
        super.apply(iDocument, c, n);
        int n2 = this.getReplacementOffset();
        String string = this.getReplacementString();
        if (this.fArgumentOffsets != null && this.getTextViewer() != null) {
            try {
                LinkedPositionGroup linkedPositionGroup;
                LinkedModeModel linkedModeModel = new LinkedModeModel();
                int n3 = 0;
                while (n3 != this.fArgumentOffsets.length) {
                    linkedPositionGroup = new LinkedPositionGroup();
                    linkedPositionGroup.addPosition(new LinkedPosition(iDocument, n2 + this.fArgumentOffsets[n3], this.fArgumentLengths[n3], -1));
                    linkedModeModel.addGroup(linkedPositionGroup);
                    ++n3;
                }
                linkedModeModel.forceInstall();
                JavaEditor javaEditor = this.getJavaEditor();
                if (javaEditor != null) {
                    linkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(javaEditor));
                }
                linkedPositionGroup = new EditorLinkedModeUI(linkedModeModel, this.getTextViewer());
                linkedPositionGroup.setExitPosition(this.getTextViewer(), n2 + string.length(), 0, Integer.MAX_VALUE);
                linkedPositionGroup.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(')', iDocument));
                linkedPositionGroup.setDoContextInfo(true);
                linkedPositionGroup.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                linkedPositionGroup.enter();
                this.fSelectedRegion = linkedPositionGroup.getSelectedRegion();
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
                this.openErrorDialog(badLocationException);
            }
        } else {
            this.fSelectedRegion = new Region(n2 + string.length(), 0);
        }
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    protected String computeReplacementString() {
        if (!this.hasParameters() || !this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        char[][] cArray = this.fProposal.findParameterNames(null);
        int n = cArray.length;
        this.fArgumentOffsets = new int[n];
        this.fArgumentLengths = new int[n];
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.fProposal.getName()));
        LazyJavaCompletionProposal.FormatterPrefs formatterPrefs = this.getFormatterPrefs();
        if (formatterPrefs.beforeOpeningParen) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("(");
        this.setCursorPosition(stringBuffer.length());
        if (formatterPrefs.afterOpeningParen) {
            stringBuffer.append(" ");
        }
        int n2 = 0;
        while (n2 != n) {
            if (n2 != 0) {
                if (formatterPrefs.beforeComma) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(",");
                if (formatterPrefs.afterComma) {
                    stringBuffer.append(" ");
                }
            }
            this.fArgumentOffsets[n2] = stringBuffer.length();
            stringBuffer.append(cArray[n2]);
            this.fArgumentLengths[n2] = cArray[n2].length;
            ++n2;
        }
        if (formatterPrefs.beforeClosingParen) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private JavaEditor getJavaEditor() {
        IEditorPart iEditorPart = JavaPlugin.getActivePage().getActiveEditor();
        if (iEditorPart instanceof JavaEditor) {
            return (JavaEditor)iEditorPart;
        }
        return null;
    }

    public Point getSelection(IDocument iDocument) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException badLocationException) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.FilledArgumentNamesMethodProposal_error_msg, (String)badLocationException.getMessage());
    }
}

