/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaTypeHover;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;

public class JavaInformationProvider
implements IInformationProvider,
IInformationProviderExtension2 {
    protected IEditorPart fEditor;
    protected IPartListener fPartListener;
    protected String fCurrentPerspective;
    protected IJavaEditorTextHover fImplementation;
    private IInformationControlCreator fPresenterControlCreator;

    public JavaInformationProvider(IEditorPart iEditorPart) {
        this.fEditor = iEditorPart;
        if (this.fEditor != null) {
            this.fPartListener = new EditorWatcher();
            IWorkbenchWindow iWorkbenchWindow = this.fEditor.getSite().getWorkbenchWindow();
            iWorkbenchWindow.getPartService().addPartListener(this.fPartListener);
            this.update();
        }
    }

    protected void update() {
        IPerspectiveDescriptor iPerspectiveDescriptor;
        IWorkbenchWindow iWorkbenchWindow = this.fEditor.getSite().getWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null && (iPerspectiveDescriptor = iWorkbenchPage.getPerspective()) != null) {
            String string = iPerspectiveDescriptor.getId();
            if (this.fCurrentPerspective == null || this.fCurrentPerspective != string) {
                this.fCurrentPerspective = string;
                this.fImplementation = new JavaTypeHover();
                this.fImplementation.setEditor(this.fEditor);
            }
        }
    }

    public IRegion getSubject(ITextViewer iTextViewer, int n) {
        if (iTextViewer != null) {
            return JavaWordFinder.findWord(iTextViewer.getDocument(), n);
        }
        return null;
    }

    public String getInformation(ITextViewer iTextViewer, IRegion iRegion) {
        String string;
        if (this.fImplementation != null && (string = this.fImplementation.getHoverInfo(iTextViewer, iRegion)) != null && string.trim().length() > 0) {
            return string;
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new ControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    private static final class ControlCreator
    extends AbstractReusableInformationControlCreator {
        private ControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            int n = 20;
            int n2 = 768;
            if (BrowserInformationControl.isAvailable((Composite)shell)) {
                return new BrowserInformationControl(shell, n, n2);
            }
            return new DefaultInformationControl(shell, n, n2, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
        }
    }

    class EditorWatcher
    implements IPartListener {
        EditorWatcher() {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart == JavaInformationProvider.this.fEditor) {
                JavaInformationProvider.this.fEditor.getSite().getWorkbenchWindow().getPartService().removePartListener(JavaInformationProvider.this.fPartListener);
                JavaInformationProvider.this.fPartListener = null;
            }
        }

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            JavaInformationProvider.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            JavaInformationProvider.this.update();
        }
    }
}

