/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.util.Properties;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaHoverMessages;

public class NLSStringHover
extends AbstractJavaEditorTextHover {
    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        if (!(this.getEditor() instanceof JavaEditor)) {
            return null;
        }
        IJavaElement iJavaElement = this.getEditorInputJavaElement();
        if (iJavaElement == null) {
            return null;
        }
        CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST(iJavaElement, ASTProvider.WAIT_NO, null);
        if (compilationUnit == null) {
            return null;
        }
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, n, 1);
        if (aSTNode instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)aSTNode;
            return new Region(stringLiteral.getStartPosition(), stringLiteral.getLength());
        }
        if (aSTNode instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)aSTNode;
            return new Region(simpleName.getStartPosition(), simpleName.getLength());
        }
        return null;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        IStorage iStorage;
        if (!(this.getEditor() instanceof JavaEditor)) {
            return null;
        }
        IJavaElement iJavaElement = this.getEditorInputJavaElement();
        if (iJavaElement == null) {
            return null;
        }
        CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST(iJavaElement, ASTProvider.WAIT_ACTIVE_ONLY, null);
        if (compilationUnit == null) {
            return null;
        }
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, iRegion.getOffset(), iRegion.getLength());
        if (!(aSTNode instanceof StringLiteral) && !(aSTNode instanceof SimpleName)) {
            return null;
        }
        if (aSTNode.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        AccessorClassReference accessorClassReference = NLSHintHelper.getAccessorClassReference(compilationUnit, iRegion);
        if (accessorClassReference == null) {
            return null;
        }
        try {
            iStorage = NLSHintHelper.getResourceBundle(iJavaElement.getJavaProject(), accessorClassReference);
            if (iStorage == null) {
                return this.toHtml(JavaHoverMessages.NLSStringHover_NLSStringHover_PropertiesFileNotDetectedWarning, "");
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        String string = iStorage.getName();
        Properties properties = NLSHintHelper.getProperties(iStorage);
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return this.toHtml(string, JavaHoverMessages.NLSStringHover_NLSStringHover_missingKeyWarning);
        }
        String string2 = null;
        string2 = aSTNode instanceof StringLiteral ? ((StringLiteral)aSTNode).getLiteralValue() : ((SimpleName)aSTNode).getIdentifier();
        if (string2 == null) {
            return null;
        }
        String string3 = properties.getProperty(string2, null);
        string3 = string3 != null ? HTMLPrinter.convertToHTMLContent((String)string3) : JavaHoverMessages.NLSStringHover_NLSStringHover_missingKeyWarning;
        return this.toHtml(string, string3);
    }

    private String toHtml(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addSmallHeader((StringBuffer)stringBuffer, (String)string);
        HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (String)string2);
        HTMLPrinter.insertPageProlog((StringBuffer)stringBuffer, (int)0);
        HTMLPrinter.addPageEpilog((StringBuffer)stringBuffer);
        return stringBuffer.toString();
    }

    private IJavaElement getEditorInputJavaElement() {
        IEditorInput iEditorInput;
        if (this.getEditor() instanceof CompilationUnitEditor) {
            return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditor().getEditorInput());
        }
        if (this.getEditor() instanceof ClassFileEditor && (iEditorInput = this.getEditor().getEditorInput()) instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)iEditorInput).getClassFile();
        }
        return null;
    }
}

