/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.javadoc;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class JavaDocAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private final String fPartitioning;

    public JavaDocAutoIndentStrategy(String string) {
        this.fPartitioning = string;
    }

    private void indentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        int n = documentCommand.offset;
        if (n == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            int n2 = n == iDocument.getLength() ? n - 1 : n;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n2);
            int n3 = iRegion.getOffset();
            int n4 = this.findEndOfWhiteSpace(iDocument, n3, n);
            Assert.isTrue((n4 >= n3 ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            IRegion iRegion2 = this.findPrefixRange(iDocument, iRegion);
            String string = iDocument.get(iRegion2.getOffset(), iRegion2.getLength());
            int n5 = Math.min(n - iRegion2.getOffset(), iRegion2.getLength());
            stringBuffer.append(string.substring(0, n5));
            if (n4 < n && iDocument.getChar(n4) == '/' && iDocument.getChar(n4 + 1) != '/') {
                stringBuffer.append(" * ");
                if (this.isPreferenceTrue("closeJavaDocs") && this.isNewComment(iDocument, n)) {
                    documentCommand.shiftsCaret = false;
                    documentCommand.caretOffset = documentCommand.offset + stringBuffer.length();
                    String string2 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
                    String string3 = String.valueOf(string2) + string + " */";
                    if (this.isPreferenceTrue("addJavaDocTags")) {
                        iDocument.replace(n, 0, string3);
                        ICompilationUnit iCompilationUnit = JavaDocAutoIndentStrategy.getCompilationUnit();
                        if (iCompilationUnit != null) {
                            try {
                                JavaModelUtil.reconcile(iCompilationUnit);
                                String string4 = this.createJavaDocTags(iDocument, documentCommand, string, string2, iCompilationUnit);
                                if (string4 != null && !string4.trim().equals("*")) {
                                    stringBuffer.append(string4);
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                    } else {
                        stringBuffer.append(string3);
                    }
                }
            }
            if (n5 < iRegion2.getLength()) {
                documentCommand.caretOffset = n + iRegion2.getLength() - n5;
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isPreferenceTrue(String string) {
        return JavaPlugin.getDefault().getPreferenceStore().getBoolean(string);
    }

    private IRegion findPrefixRange(IDocument iDocument, IRegion iRegion) throws BadLocationException {
        int n;
        int n2 = iRegion.getOffset();
        int n3 = this.findEndOfWhiteSpace(iDocument, n2, n = n2 + iRegion.getLength());
        if (n3 < n && iDocument.getChar(n3) == '*') {
            ++n3;
            while (n3 < n && iDocument.getChar(n3) == ' ') {
                ++n3;
            }
        }
        return new Region(n2, n3 - n2);
    }

    private String createJavaDocTags(IDocument iDocument, DocumentCommand documentCommand, String string, String string2, ICompilationUnit iCompilationUnit) throws CoreException, BadLocationException {
        IJavaElement iJavaElement = iCompilationUnit.getElementAt(documentCommand.offset);
        if (iJavaElement == null) {
            return null;
        }
        switch (iJavaElement.getElementType()) {
            case 7: {
                return this.createTypeTags(iDocument, documentCommand, string, string2, (IType)iJavaElement);
            }
            case 9: {
                return this.createMethodTags(iDocument, documentCommand, string, string2, (IMethod)iJavaElement);
            }
        }
        return null;
    }

    private String prepareTemplateComment(String string, String string2, IJavaProject iJavaProject, String string3) {
        if (string.endsWith("*/")) {
            string = string.substring(0, string.length() - 2);
        }
        if ((string = string.trim()).startsWith("/*")) {
            string = string.length() > 2 && string.charAt(2) == '*' ? string.substring(3) : string.substring(2);
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2 && Character.getType(string.charAt(n)) == 12) {
            ++n;
        }
        string = string.substring(n);
        return Strings.changeIndent(string, 0, iJavaProject, string2, string3);
    }

    private String createTypeTags(IDocument iDocument, DocumentCommand documentCommand, String string, String string2, IType iType) throws CoreException, BadLocationException {
        String[] stringArray = StubUtility.getTypeParameterNames(iType.getTypeParameters());
        String string3 = CodeGeneration.getTypeComment(iType.getCompilationUnit(), iType.getTypeQualifiedName('.'), stringArray, string2);
        if (string3 != null) {
            boolean bl = string3.startsWith("/**");
            if (!this.isFirstComment(iDocument, documentCommand, (IMember)iType, bl)) {
                return null;
            }
            return this.prepareTemplateComment(string3.trim(), string, iType.getJavaProject(), string2);
        }
        return null;
    }

    private String createMethodTags(IDocument iDocument, DocumentCommand documentCommand, String string, String string2, IMethod iMethod) throws CoreException, BadLocationException {
        ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)documentCommand.offset, (boolean)false);
        IMethod iMethod2 = JavaDocAutoIndentStrategy.getInheritedMethod(iMethod);
        String string3 = CodeGeneration.getMethodComment(iMethod, iMethod2, string2);
        if (string3 != null) {
            boolean bl;
            boolean bl2 = (string3 = string3.trim()).startsWith("/**");
            if (!this.isFirstComment(iDocument, documentCommand, (IMember)iMethod, bl2)) {
                return null;
            }
            boolean bl3 = bl = iTypedRegion.getLength() >= 3 && iDocument.get(iTypedRegion.getOffset(), 3).equals("/**");
            if (bl2 == bl) {
                return this.prepareTemplateComment(string3, string, iMethod.getJavaProject(), string2);
            }
        }
        return null;
    }

    private boolean isFirstComment(IDocument iDocument, DocumentCommand documentCommand, IMember iMember, boolean bl) throws BadLocationException, JavaModelException {
        String string;
        ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)documentCommand.offset, (boolean)false);
        ISourceRange iSourceRange = iMember.getSourceRange();
        if (iSourceRange == null || iSourceRange.getOffset() != iTypedRegion.getOffset()) {
            return false;
        }
        int n = iSourceRange.getOffset();
        int n2 = iSourceRange.getLength();
        int n3 = iMember.getNameRange().getOffset() - n;
        int n4 = iTypedRegion.getOffset() - n;
        String string2 = string = bl ? "/**" : "/*";
        return iDocument.get(n, n2).lastIndexOf(string, n3) == n4;
    }

    private void indentAfterCommentEnd(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset < 2 || iDocument.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(iDocument.get(documentCommand.offset - 2, 2))) {
                ++documentCommand.length;
                --documentCommand.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isNewComment(IDocument iDocument, int n) {
        ITypedRegion iTypedRegion;
        block7: {
            int n2;
            block6: {
                int n3;
                block5: {
                    try {
                        n3 = iDocument.getLineOfOffset(n) + 1;
                        if (n3 < iDocument.getNumberOfLines()) break block5;
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                        return false;
                    }
                }
                IRegion iRegion = iDocument.getLineInformation(n3);
                iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)n, (boolean)false);
                n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                if (iRegion.getOffset() < n2) break block6;
                return false;
            }
            if (iDocument.getLength() != n2) break block7;
            return true;
        }
        String string = iDocument.get(iTypedRegion.getOffset(), iTypedRegion.getLength());
        return string.indexOf("/*", 2) != -1;
    }

    private boolean isSmartMode() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 iTextEditorExtension3 = (ITextEditorExtension3)iEditorPart;
            return iTextEditorExtension3.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (!this.isSmartMode()) {
            return;
        }
        if (documentCommand.text != null) {
            String[] stringArray;
            int n;
            if (documentCommand.length == 0 && (n = TextUtilities.endsWith((String[])(stringArray = iDocument.getLegalLineDelimiters()), (String)documentCommand.text)) > -1) {
                if (stringArray[n].equals(documentCommand.text)) {
                    this.indentAfterNewLine(iDocument, documentCommand);
                }
                return;
            }
            if (documentCommand.text.equals("/")) {
                this.indentAfterCommentEnd(iDocument, documentCommand);
                return;
            }
        }
    }

    private static IMethod getInheritedMethod(IMethod iMethod) throws JavaModelException {
        IType iType = iMethod.getDeclaringType();
        if (iType == null) {
            return null;
        }
        MethodOverrideTester methodOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(iType);
        return methodOverrideTester.findOverriddenMethod(iMethod, true);
    }

    private static ICompilationUnit getCompilationUnit() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null) {
            return null;
        }
        WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit iCompilationUnit = workingCopyManager.getWorkingCopy(iEditorPart.getEditorInput());
        if (iCompilationUnit == null) {
            return null;
        }
        return iCompilationUnit;
    }
}

