/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewer;

public class TraditionalHierarchyViewer
extends TypeHierarchyViewer {
    public TraditionalHierarchyViewer(Composite composite, TypeHierarchyLifeCycle typeHierarchyLifeCycle, IWorkbenchPart iWorkbenchPart) {
        super(composite, (IContentProvider)new TraditionalHierarchyContentProvider(typeHierarchyLifeCycle), typeHierarchyLifeCycle, iWorkbenchPart);
    }

    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.TraditionalHierarchyViewer_filtered_title;
        }
        return TypeHierarchyMessages.TraditionalHierarchyViewer_title;
    }

    public void updateContent(boolean bl) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (bl) {
            TraditionalHierarchyContentProvider traditionalHierarchyContentProvider = (TraditionalHierarchyContentProvider)this.getContentProvider();
            int n = traditionalHierarchyContentProvider.getExpandLevel();
            if (this.isMethodFiltering()) {
                ++n;
            }
            this.expandToLevel(n);
        }
        this.getTree().setRedraw(true);
    }

    public static class TraditionalHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public TraditionalHierarchyContentProvider(TypeHierarchyLifeCycle typeHierarchyLifeCycle) {
            super(typeHierarchyLifeCycle);
        }

        public int getExpandLevel() {
            ITypeHierarchy iTypeHierarchy = this.getHierarchy();
            if (iTypeHierarchy != null) {
                IType iType = iTypeHierarchy.getType();
                if (iType != null) {
                    return this.getDepth(iTypeHierarchy, iType) + 2;
                }
                return 5;
            }
            return 2;
        }

        private int getDepth(ITypeHierarchy iTypeHierarchy, IType iType) {
            int n = 0;
            IType iType2 = iTypeHierarchy.getSuperclass(iType);
            while (iType2 != null) {
                ++n;
                iType2 = iTypeHierarchy.getSuperclass(iType2);
            }
            return n;
        }

        protected final void getRootTypes(List list) {
            ITypeHierarchy iTypeHierarchy = this.getHierarchy();
            if (iTypeHierarchy != null) {
                IType iType = iTypeHierarchy.getType();
                if (iType == null) {
                    IType[] iTypeArray = iTypeHierarchy.getRootClasses();
                    int n = 0;
                    while (n < iTypeArray.length) {
                        list.add(iTypeArray[n]);
                        ++n;
                    }
                    IType[] iTypeArray2 = iTypeHierarchy.getRootInterfaces();
                    int n2 = 0;
                    while (n2 < iTypeArray2.length) {
                        list.add(iTypeArray2[n2]);
                        ++n2;
                    }
                } else if (Flags.isInterface((int)iTypeHierarchy.getCachedFlags(iType))) {
                    list.add(iType);
                } else if (this.isAnonymousFromInterface(iType)) {
                    list.add(iTypeHierarchy.getSuperInterfaces(iType)[0]);
                } else {
                    IType[] iTypeArray = iTypeHierarchy.getRootClasses();
                    int n = 0;
                    while (n < iTypeArray.length) {
                        if (this.isObject(iTypeArray[n])) {
                            list.add(iTypeArray[n]);
                            return;
                        }
                        ++n;
                    }
                    list.addAll(Arrays.asList(iTypeArray));
                }
            }
        }

        protected final void getTypesInHierarchy(IType iType, List list) {
            block9: {
                ITypeHierarchy iTypeHierarchy = this.getHierarchy();
                if (iTypeHierarchy == null) break block9;
                IType[] iTypeArray = iTypeHierarchy.getSubtypes(iType);
                if (this.isObject(iType)) {
                    int n = 0;
                    while (n < iTypeArray.length) {
                        IType iType2 = iTypeArray[n];
                        if (!this.isAnonymousFromInterface(iType2)) {
                            list.add(iType2);
                        }
                        ++n;
                    }
                } else {
                    boolean bl;
                    boolean bl2 = iTypeHierarchy.getType() != null;
                    boolean bl3 = bl = !Flags.isInterface((int)iTypeHierarchy.getCachedFlags(iType));
                    if (bl || bl2) {
                        int n = 0;
                        while (n < iTypeArray.length) {
                            list.add(iTypeArray[n]);
                            ++n;
                        }
                    } else {
                        int n = 0;
                        while (n < iTypeArray.length) {
                            IType iType3 = iTypeArray[n];
                            if (Flags.isInterface((int)iTypeHierarchy.getCachedFlags(iType3)) || this.isAnonymous(iType3)) {
                                list.add(iType3);
                            }
                            ++n;
                        }
                    }
                }
            }
        }

        protected IType getParentType(IType iType) {
            ITypeHierarchy iTypeHierarchy = this.getHierarchy();
            if (iTypeHierarchy != null) {
                return iTypeHierarchy.getSuperclass(iType);
            }
            return null;
        }
    }
}

