/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ISelectionListenerWithAST;

public class SelectionListenerWithASTManager {
    private static SelectionListenerWithASTManager fgDefault;
    private Map fListenerGroups = new HashMap();

    public static SelectionListenerWithASTManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithASTManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithASTManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ITextEditor iTextEditor, ISelectionListenerWithAST iSelectionListenerWithAST) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListenerGroup = (PartListenerGroup)this.fListenerGroups.get(iTextEditor);
            if (partListenerGroup == null) {
                partListenerGroup = new PartListenerGroup(iTextEditor);
                this.fListenerGroups.put(iTextEditor, partListenerGroup);
            }
            partListenerGroup.install(iSelectionListenerWithAST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ITextEditor iTextEditor, ISelectionListenerWithAST iSelectionListenerWithAST) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListenerGroup = (PartListenerGroup)this.fListenerGroups.get(iTextEditor);
            if (partListenerGroup != null) {
                partListenerGroup.uninstall(iSelectionListenerWithAST);
                if (partListenerGroup.isEmpty()) {
                    this.fListenerGroups.remove(iTextEditor);
                }
            }
        }
    }

    private static final class PartListenerGroup {
        private ITextEditor fPart;
        private ISelectionListener fPostSelectionListener;
        private ISelectionChangedListener fSelectionListener;
        private Job fCurrentJob;
        private ListenerList fAstListeners;
        private final Object fJobLock = new Object();

        public PartListenerGroup(ITextEditor iTextEditor) {
            this.fPart = iTextEditor;
            this.fCurrentJob = null;
            this.fAstListeners = new ListenerList(1);
            this.fSelectionListener = new ISelectionChangedListener(this){
                final /* synthetic */ PartListenerGroup this$1;
                {
                    this.this$1 = partListenerGroup;
                }

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    ISelection iSelection = selectionChangedEvent.getSelection();
                    if (iSelection instanceof ITextSelection) {
                        this.this$1.fireSelectionChanged((ITextSelection)iSelection);
                    }
                }
            };
            this.fPostSelectionListener = new ISelectionListener(this){
                final /* synthetic */ PartListenerGroup this$1;
                {
                    this.this$1 = partListenerGroup;
                }

                public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
                    if (iWorkbenchPart == PartListenerGroup.access$0(this.this$1) && iSelection instanceof ITextSelection) {
                        this.this$1.firePostSelectionChanged((ITextSelection)iSelection);
                    }
                }
            };
        }

        public boolean isEmpty() {
            return this.fAstListeners.isEmpty();
        }

        public void install(ISelectionListenerWithAST iSelectionListenerWithAST) {
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().addPostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider iSelectionProvider = this.fPart.getSelectionProvider();
                if (iSelectionProvider != null) {
                    iSelectionProvider.addSelectionChangedListener(this.fSelectionListener);
                }
            }
            this.fAstListeners.add((Object)iSelectionListenerWithAST);
        }

        public void uninstall(ISelectionListenerWithAST iSelectionListenerWithAST) {
            this.fAstListeners.remove((Object)iSelectionListenerWithAST);
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().removePostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider iSelectionProvider = this.fPart.getSelectionProvider();
                if (iSelectionProvider != null) {
                    iSelectionProvider.removeSelectionChangedListener(this.fSelectionListener);
                }
            }
        }

        public void fireSelectionChanged(ITextSelection iTextSelection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
        }

        public void firePostSelectionChanged(ITextSelection iTextSelection) {
            IJavaElement iJavaElement;
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
            if ((iJavaElement = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fPart, false)) == null) {
                return;
            }
            this.fCurrentJob = new Job(this, JavaUIMessages.SelectionListenerWithASTManager_job_title, iJavaElement, iTextSelection){
                final /* synthetic */ PartListenerGroup this$1;
                private final /* synthetic */ IJavaElement val$input;
                private final /* synthetic */ ITextSelection val$selection;
                {
                    this.this$1 = partListenerGroup;
                    this.val$input = iJavaElement;
                    this.val$selection = iTextSelection;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus run(IProgressMonitor iProgressMonitor) {
                    if (iProgressMonitor == null) {
                        iProgressMonitor = new NullProgressMonitor();
                    }
                    Object object = PartListenerGroup.access$1(this.this$1);
                    synchronized (object) {
                        return this.this$1.calculateASTandInform(this.val$input, this.val$selection, iProgressMonitor);
                    }
                }
            };
            this.fCurrentJob.setPriority(50);
            this.fCurrentJob.setSystem(true);
            this.fCurrentJob.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus calculateASTandInform(IJavaElement iJavaElement, ITextSelection iTextSelection, IProgressMonitor iProgressMonitor) {
            block8: {
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    Object[] objectArray;
                    CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST(iJavaElement, ASTProvider.WAIT_ACTIVE_ONLY, iProgressMonitor);
                    if (compilationUnit == null || iProgressMonitor.isCanceled()) break block8;
                    PartListenerGroup partListenerGroup = this;
                    synchronized (partListenerGroup) {
                        objectArray = this.fAstListeners.getListeners();
                    }
                    int n = 0;
                    while (n < objectArray.length) {
                        ((ISelectionListenerWithAST)objectArray[n]).selectionChanged((IEditorPart)this.fPart, iTextSelection, compilationUnit);
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++n;
                    }
                    return Status.OK_STATUS;
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
            return Status.CANCEL_STATUS;
        }

        static /* synthetic */ ITextEditor access$0(PartListenerGroup partListenerGroup) {
            return partListenerGroup.fPart;
        }

        static /* synthetic */ Object access$1(PartListenerGroup partListenerGroup) {
            return partListenerGroup.fJobLock;
        }
    }
}

