/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class AccessRuleEntryDialog
extends StatusDialog {
    private StringDialogField fPatternDialog;
    private StatusInfo fPatternStatus;
    private String fPattern;
    private ComboDialogField fRuleKindCombo;
    private int[] fRuleKinds;

    public AccessRuleEntryDialog(Shell shell, IAccessRule iAccessRule, CPListElement cPListElement) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        String string = iAccessRule == null ? NewWizardMessages.TypeRestrictionEntryDialog_add_title : NewWizardMessages.TypeRestrictionEntryDialog_edit_title;
        String string2 = Messages.format(NewWizardMessages.TypeRestrictionEntryDialog_pattern_label, cPListElement.getPath().makeRelative().toString());
        this.setTitle(string);
        this.fPatternStatus = new StatusInfo();
        TypeRulesAdapter typeRulesAdapter = new TypeRulesAdapter();
        this.fPatternDialog = new StringDialogField();
        this.fPatternDialog.setLabelText(string2);
        this.fPatternDialog.setDialogFieldListener(typeRulesAdapter);
        this.fRuleKindCombo = new ComboDialogField(8);
        this.fRuleKindCombo.setLabelText(NewWizardMessages.TypeRestrictionEntryDialog_kind_label);
        this.fRuleKindCombo.setDialogFieldListener(typeRulesAdapter);
        String[] stringArray = new String[]{NewWizardMessages.TypeRestrictionEntryDialog_kind_non_accessible, NewWizardMessages.TypeRestrictionEntryDialog_kind_discourraged, NewWizardMessages.TypeRestrictionEntryDialog_kind_accessible};
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        this.fRuleKinds = nArray;
        this.fRuleKindCombo.setItems(stringArray);
        if (iAccessRule == null) {
            this.fPatternDialog.setText("");
            this.fRuleKindCombo.selectItem(0);
        } else {
            this.fPatternDialog.setText(iAccessRule.getPattern().toString());
            int n = 0;
            while (n < this.fRuleKinds.length) {
                if (this.fRuleKinds[n] == iAccessRule.getKind()) {
                    this.fRuleKindCombo.selectItem(n);
                    break;
                }
                ++n;
            }
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 2, true, false));
        Label label = new Label(composite3, 64);
        label.setText(NewWizardMessages.TypeRestrictionEntryDialog_description);
        GridData gridData = new GridData(4, 2, true, false, 2, 1);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        label.setLayoutData((Object)gridData);
        this.fRuleKindCombo.doFillIntoGrid(composite3, 2);
        this.fPatternDialog.doFillIntoGrid(composite3, 2);
        Label label2 = new Label(composite3, 64);
        label2.setText(NewWizardMessages.TypeRestrictionEntryDialog_description2);
        gridData = new GridData(4, 2, true, false, 2, 1);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        label2.setLayoutData((Object)gridData);
        this.fPatternDialog.postSetFocusOnDialogField(composite.getDisplay());
        AccessRuleEntryDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doStatusLineUpdate() {
        this.checkIfPatternValid();
        this.updateStatus(this.fPatternStatus);
    }

    protected void checkIfPatternValid() {
        String string = this.fPatternDialog.getText().trim();
        if (string.length() == 0) {
            this.fPatternStatus.setError(NewWizardMessages.TypeRestrictionEntryDialog_error_empty);
            return;
        }
        Path path = new Path(string);
        if (path.isAbsolute() || path.getDevice() != null) {
            this.fPatternStatus.setError(NewWizardMessages.TypeRestrictionEntryDialog_error_notrelative);
            return;
        }
        this.fPattern = string;
        this.fPatternStatus.setOK();
    }

    public IAccessRule getRule() {
        Path path = new Path(this.fPattern);
        int n = this.fRuleKinds[this.fRuleKindCombo.getSelectionIndex()];
        return JavaCore.newAccessRule((IPath)path, (int)n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.access_rules_dialog_context");
    }

    private class TypeRulesAdapter
    implements IDialogFieldListener {
        private TypeRulesAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            AccessRuleEntryDialog.this.doStatusLineUpdate();
        }
    }
}

