/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPageExtension2;
import org.eclipse.wst.jsdt.ui.wizards.NewElementWizardPage;

public class UserLibraryWizardPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension,
IClasspathContainerPageExtension2 {
    private CheckedListDialogField fLibrarySelector;
    private CPUserLibraryElement fEditResult;
    private Set fUsedPaths;
    private boolean fIsEditMode;
    private IJavaProject fProject;
    private boolean fIsExported;

    public UserLibraryWizardPage() {
        super("UserLibraryWizardPage");
        this.setTitle(NewWizardMessages.UserLibraryWizardPage_title);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.updateDescription(null);
        this.fUsedPaths = new HashSet();
        this.fProject = UserLibraryWizardPage.createPlaceholderProject();
        LibraryListAdapter libraryListAdapter = new LibraryListAdapter();
        String[] stringArray = new String[]{NewWizardMessages.UserLibraryWizardPage_list_config_button};
        this.fLibrarySelector = new CheckedListDialogField(libraryListAdapter, stringArray, (ILabelProvider)new CPListLabelProvider());
        this.fLibrarySelector.setDialogFieldListener(libraryListAdapter);
        this.fLibrarySelector.setLabelText(NewWizardMessages.UserLibraryWizardPage_list_label);
        this.fEditResult = null;
        this.updateStatus(this.validateSetting(Collections.EMPTY_LIST));
    }

    private static IJavaProject createPlaceholderProject() {
        String string = "####internal";
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject;
        while ((iProject = iWorkspaceRoot.getProject(string)).exists()) {
            string = String.valueOf(string) + '1';
        }
        return JavaCore.create((IProject)iProject);
    }

    private void updateDescription(IClasspathEntry iClasspathEntry) {
        if (iClasspathEntry == null || iClasspathEntry.getPath().segmentCount() != 2) {
            this.setDescription(NewWizardMessages.UserLibraryWizardPage_description_new);
        } else {
            this.setDescription(Messages.format(NewWizardMessages.UserLibraryWizardPage_description_edit, iClasspathEntry.getPath().segment(1)));
        }
    }

    private List updateLibraryList() {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        List list = this.fLibrarySelector.getElements();
        int n = 0;
        while (n < list.size()) {
            stringArray = (String[])list.get(n);
            hashSet.add(stringArray.getName());
            if (this.fLibrarySelector.isChecked(stringArray)) {
                hashSet2.add(stringArray.getName());
            }
            ++n;
        }
        ArrayList<CPUserLibraryElement> arrayList = new ArrayList<CPUserLibraryElement>();
        stringArray = JavaCore.getUserLibraryNames();
        Arrays.sort(stringArray, Collator.getInstance());
        ArrayList<CPUserLibraryElement> arrayList2 = new ArrayList<CPUserLibraryElement>(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            IPath iPath = new Path("org.eclipse.wst.jsdt.USER_LIBRARY").append(string);
            try {
                IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)this.fProject);
                CPUserLibraryElement cPUserLibraryElement = new CPUserLibraryElement(string, iClasspathContainer, this.fProject);
                arrayList2.add(cPUserLibraryElement);
                if (!hashSet2.isEmpty()) {
                    if (hashSet2.contains(string)) {
                        arrayList.add(cPUserLibraryElement);
                    }
                } else if (!hashSet.contains(string)) {
                    arrayList.add(cPUserLibraryElement);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            ++n2;
        }
        this.fLibrarySelector.setElements(arrayList2);
        return arrayList;
    }

    private void doDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fLibrarySelector) {
            List list = this.fLibrarySelector.getCheckedElements();
            if (this.fIsEditMode) {
                if (list.size() > 1) {
                    if (this.fEditResult != null && list.remove(this.fEditResult)) {
                        this.fLibrarySelector.setCheckedWithoutUpdate(this.fEditResult, false);
                    }
                    this.fEditResult = (CPUserLibraryElement)list.get(0);
                    int n = 1;
                    while (n < list.size()) {
                        this.fLibrarySelector.setCheckedWithoutUpdate(list.get(n), false);
                        ++n;
                    }
                } else if (list.size() == 1) {
                    this.fEditResult = (CPUserLibraryElement)list.get(0);
                }
            }
            this.updateStatus(this.validateSetting(list));
        }
    }

    private IStatus validateSetting(List list) {
        int n = list.size();
        if (n == 0) {
            return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_selectentry);
        }
        if (this.fIsEditMode && n > 1) {
            return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_selectonlyone);
        }
        int n2 = 0;
        while (n2 < list.size()) {
            CPUserLibraryElement cPUserLibraryElement = (CPUserLibraryElement)list.get(n2);
            if (this.fUsedPaths.contains(cPUserLibraryElement.getPath())) {
                return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_alreadyoncp);
            }
            ++n2;
        }
        return new StatusInfo();
    }

    private void doButtonPressed(int n) {
        if (n == 0) {
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            if (this.fEditResult != null) {
                hashMap.put("select_library", this.fEditResult.getName());
            }
            String string = "org.eclipse.wst.jsdt.ui.preferences.UserLibraryPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)string, (String[])new String[]{string}, hashMap).open();
            List list = this.updateLibraryList();
            if (list.size() > 0) {
                if (this.fIsEditMode) {
                    this.fLibrarySelector.setChecked(list.get(0), true);
                } else {
                    this.fLibrarySelector.setCheckedElements(list);
                }
            }
        } else {
            this.fLibrarySelector.setCheckedElements(this.fLibrarySelector.getSelectedElements());
        }
    }

    private void doDoubleClicked(ListDialogField listDialogField) {
        Object e;
        boolean bl;
        List list = this.fLibrarySelector.getSelectedElements();
        if (!(list.size() != 1 || (bl = this.fLibrarySelector.isChecked(e = list.get(0))) && this.fIsEditMode)) {
            this.fLibrarySelector.setChecked(e, !bl);
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fLibrarySelector}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrarySelector.getListControl(null));
        Dialog.applyDialogFont((Control)composite2);
        this.setControl((Control)composite2);
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        if (this.fEditResult != null) {
            return JavaCore.newContainerEntry((IPath)this.fEditResult.getPath(), (boolean)this.fIsExported);
        }
        return null;
    }

    public IClasspathEntry[] getNewContainers() {
        List list = this.fLibrarySelector.getCheckedElements();
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[list.size()];
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            CPUserLibraryElement cPUserLibraryElement = (CPUserLibraryElement)list.get(n);
            iClasspathEntryArray[n] = JavaCore.newContainerEntry((IPath)cPUserLibraryElement.getPath(), (boolean)this.fIsExported);
            ++n;
        }
        return iClasspathEntryArray;
    }

    public void setSelection(IClasspathEntry iClasspathEntry) {
        this.fIsExported = iClasspathEntry != null && iClasspathEntry.isExported();
        this.updateDescription(iClasspathEntry);
        boolean bl = this.fIsEditMode = iClasspathEntry != null;
        if (iClasspathEntry != null) {
            this.fUsedPaths.remove(iClasspathEntry.getPath());
        }
        String string = null;
        if (iClasspathEntry != null && iClasspathEntry.getPath().segmentCount() == 2) {
            string = iClasspathEntry.getPath().segment(1);
        }
        this.updateLibraryList();
        if (string != null) {
            List list = this.fLibrarySelector.getElements();
            int n = 0;
            while (n < list.size()) {
                CPUserLibraryElement cPUserLibraryElement = (CPUserLibraryElement)list.get(n);
                if (cPUserLibraryElement.getName().equals(string)) {
                    this.fLibrarySelector.setChecked(cPUserLibraryElement, true);
                    return;
                }
                ++n;
            }
        }
    }

    public void initialize(IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray) {
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            if (iClasspathEntry.getEntryKind() == 5) {
                this.fUsedPaths.add(iClasspathEntry.getPath());
            }
            ++n;
        }
    }

    private class LibraryListAdapter
    implements IListAdapter,
    IDialogFieldListener {
        public void dialogFieldChanged(DialogField dialogField) {
            UserLibraryWizardPage.this.doDialogFieldChanged(dialogField);
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            UserLibraryWizardPage.this.doButtonPressed(n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
        }

        public void doubleClicked(ListDialogField listDialogField) {
            UserLibraryWizardPage.this.doDoubleClicked(listDialogField);
        }
    }
}

