/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class AddArchiveToBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public AddArchiveToBuildpathAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public AddArchiveToBuildpathAction(IRunnableContext iRunnableContext, ISetSelectionTarget iSetSelectionTarget) {
        this(null, iSetSelectionTarget, iRunnableContext);
    }

    private AddArchiveToBuildpathAction(IWorkbenchSite iWorkbenchSite, ISetSelectionTarget iSetSelectionTarget, IRunnableContext iRunnableContext) {
        super(iWorkbenchSite, iSetSelectionTarget, 14);
        this.fContext = iRunnableContext;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_label);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_EXTJAR);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_tooltip);
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath_archives;
    }

    public void run() {
        Shell shell = this.getShell();
        final IPath[] iPathArray = BuildPathDialogAccess.chooseExternalJAREntries(shell);
        if (iPathArray == null) {
            return;
        }
        try {
            final IJavaProject iJavaProject = (IJavaProject)this.getSelectedElements().get(0);
            IStatus iStatus = ClasspathModifier.checkAddExternalJarsPrecondition(iPathArray, CPJavaProject.createFromExisting(iJavaProject));
            if (iStatus.getSeverity() == 4) {
                MessageDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.AddArchiveToBuildpathAction_InfoTitle, (String)iStatus.getMessage());
                return;
            }
            if (iStatus.getSeverity() == 1) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)NewWizardMessages.AddArchiveToBuildpathAction_InfoTitle, (String)iStatus.getMessage());
            } else if (iStatus.getSeverity() == 2) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)NewWizardMessages.AddArchiveToBuildpathAction_InfoTitle, (String)iStatus.getMessage());
            }
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List list = AddArchiveToBuildpathAction.this.addExternalJars(iPathArray, iJavaProject, iProgressMonitor);
                        if (list.size() > 0) {
                            AddArchiveToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(list));
                        }
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            };
            this.fContext.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)invocationTargetException.getCause(), NewWizardMessages.AddArchiveToBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(invocationTargetException);
            }
        }
        catch (CoreException coreException) {
            this.showExceptionDialog(coreException, NewWizardMessages.AddArchiveToBuildpathAction_ErrorTitle);
            JavaPlugin.log(coreException);
        }
        catch (InterruptedException interruptedException) {}
    }

    private List addExternalJars(IPath[] iPathArray, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList<IPackageFragmentRoot> arrayList;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            CPJavaProject cPJavaProject = CPJavaProject.createFromExisting(iJavaProject);
            BuildpathDelta buildpathDelta = ClasspathModifier.addExternalJars(iPathArray, cPJavaProject);
            ClasspathModifier.commitClassPath(cPJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
            this.informListeners(buildpathDelta);
            List list = buildpathDelta.getAddedEntries();
            ArrayList<IPackageFragmentRoot> arrayList2 = new ArrayList<IPackageFragmentRoot>(list.size());
            int n = 0;
            while (n < list.size()) {
                IClasspathEntry iClasspathEntry = ((CPListElement)list.get(n)).getClasspathEntry();
                IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.findPackageFragmentRoot(iClasspathEntry.getPath());
                if (iPackageFragmentRoot != null) {
                    arrayList2.add(iPackageFragmentRoot);
                }
                ++n;
            }
            iProgressMonitor.worked(1);
            arrayList = arrayList2;
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return arrayList;
    }

    protected boolean canHandle(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        return object instanceof IJavaProject;
    }
}

