/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RemoveWorkingSetElementAction
extends SelectionDispatchAction {
    public RemoveWorkingSetElementAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(WorkingSetMessages.RemoveWorkingSetElementAction_label);
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        IWorkingSet iWorkingSet = this.getWorkingSet(iStructuredSelection);
        this.setEnabled(iWorkingSet != null && !"org.eclipse.wst.jsdt.internal.ui.OthersWorkingSet".equals(iWorkingSet.getId()));
    }

    private IWorkingSet getWorkingSet(IStructuredSelection iStructuredSelection) {
        if (!(iStructuredSelection instanceof ITreeSelection)) {
            return null;
        }
        ITreeSelection iTreeSelection = (ITreeSelection)iStructuredSelection;
        List list = iTreeSelection.toList();
        IWorkingSet iWorkingSet = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            TreePath[] treePathArray = iTreeSelection.getPathsFor(e);
            if (treePathArray.length != 1) {
                return null;
            }
            TreePath treePath = treePathArray[0];
            if (treePath.getSegmentCount() != 2) {
                return null;
            }
            Object object = treePath.getSegment(0);
            if (!(object instanceof IWorkingSet)) {
                return null;
            }
            if (iWorkingSet == null) {
                iWorkingSet = (IWorkingSet)object;
                continue;
            }
            if (iWorkingSet == object) continue;
            return null;
        }
        return iWorkingSet;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IWorkingSet iWorkingSet = this.getWorkingSet(iStructuredSelection);
        if (iWorkingSet == null) {
            return;
        }
        HashSet<IAdaptable> hashSet = new HashSet<IAdaptable>(Arrays.asList(iWorkingSet.getElements()));
        List list = iStructuredSelection.toList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IAdaptable[] iAdaptableArray;
            Object e = iterator.next();
            if (!(e instanceof IAdaptable) || (iAdaptableArray = iWorkingSet.adaptElements(new IAdaptable[]{(IAdaptable)e})).length != 1) continue;
            hashSet.remove(iAdaptableArray[0]);
        }
        iWorkingSet.setElements(hashSet.toArray(new IAdaptable[hashSet.size()]));
    }
}

