/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaViewerFilter;

public class WorkingSetFilter
extends JavaViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private WorkingSetCompareEntry[] fCachedCompareEntries = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        if (this.fWorkingSet != iWorkingSet) {
            this.fWorkingSet = iWorkingSet;
            this.notifyWorkingSetContentChange();
        }
    }

    protected void initFilter() {
        this.notifyWorkingSetContentChange();
    }

    public final void notifyWorkingSetContentChange() {
        if (this.fWorkingSet != null) {
            IAdaptable[] iAdaptableArray = this.fWorkingSet.getElements();
            this.fCachedCompareEntries = new WorkingSetCompareEntry[iAdaptableArray.length];
            int n = 0;
            while (n < iAdaptableArray.length) {
                this.fCachedCompareEntries[n] = new WorkingSetCompareEntry(iAdaptableArray[n]);
                ++n;
            }
        } else {
            this.fCachedCompareEntries = null;
        }
    }

    protected void freeFilter() {
        this.fCachedCompareEntries = null;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        if (this.fWorkingSet == null || this.fWorkingSet.isAggregateWorkingSet() && this.fWorkingSet.isEmpty()) {
            return true;
        }
        if (object2 instanceof PackageFragmentRootContainer) {
            return this.isEnclosing((PackageFragmentRootContainer)object2);
        }
        if (object2 instanceof IAdaptable) {
            return this.isEnclosing((IAdaptable)object2);
        }
        return true;
    }

    public boolean isEnclosing(IAdaptable iAdaptable) {
        WorkingSetCompareEntry workingSetCompareEntry = new WorkingSetCompareEntry(iAdaptable);
        if (this.fCachedCompareEntries != null) {
            int n = 0;
            while (n < this.fCachedCompareEntries.length) {
                if (this.fCachedCompareEntries[n].contains(workingSetCompareEntry)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (this.fWorkingSet != null) {
            IAdaptable[] iAdaptableArray = this.fWorkingSet.getElements();
            int n = 0;
            while (n < iAdaptableArray.length) {
                if (new WorkingSetCompareEntry(iAdaptableArray[n]).contains(workingSetCompareEntry)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean isEnclosing(PackageFragmentRootContainer packageFragmentRootContainer) {
        IAdaptable[] iAdaptableArray = packageFragmentRootContainer.getChildren();
        int n = 0;
        while (n < iAdaptableArray.length) {
            if (this.isEnclosing(iAdaptableArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static class WorkingSetCompareEntry {
        private IPath fResourcePath;
        private IJavaElement fJavaElement;

        public WorkingSetCompareEntry(IAdaptable iAdaptable) {
            if (iAdaptable instanceof IJavaElement) {
                this.init((IJavaElement)iAdaptable);
            } else if (iAdaptable instanceof IResource) {
                this.init((IResource)iAdaptable);
            } else if (iAdaptable instanceof ClassPathContainer.RequiredProjectWrapper) {
                ClassPathContainer.RequiredProjectWrapper requiredProjectWrapper = (ClassPathContainer.RequiredProjectWrapper)iAdaptable;
                IJavaProject iJavaProject = requiredProjectWrapper.getParentClassPathContainer().getJavaProject();
                IFile iFile = iJavaProject.getProject().getFile(String.valueOf(requiredProjectWrapper.getProject().getElementName()) + "-fake-jar.jar");
                this.init((IJavaElement)iJavaProject.getPackageFragmentRoot((IResource)iFile));
            } else {
                IJavaElement iJavaElement;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.init(iJavaElement);
                } else {
                    IResource iResource;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz2)) != null) {
                        this.init(iResource);
                    } else {
                        this.fResourcePath = null;
                        this.fJavaElement = null;
                    }
                }
            }
        }

        private void init(IResource iResource) {
            this.fJavaElement = JavaCore.create((IResource)iResource);
            this.fResourcePath = iResource.getFullPath();
        }

        private void init(IJavaElement iJavaElement) {
            this.fJavaElement = iJavaElement;
            this.fResourcePath = iJavaElement.getPath();
        }

        public boolean contains(WorkingSetCompareEntry workingSetCompareEntry) {
            IPath iPath;
            if (this.fJavaElement != null && workingSetCompareEntry.fJavaElement != null) {
                IPackageFragmentRoot iPackageFragmentRoot;
                IJavaElement iJavaElement = workingSetCompareEntry.fJavaElement;
                if (this.fJavaElement.getElementType() == 2 && (iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3)) != null && iPackageFragmentRoot.isExternal() && iPackageFragmentRoot.isArchive() && ((IJavaProject)this.fJavaElement).isOnClasspath(iJavaElement)) {
                    return true;
                }
                return this.isAncestor(iJavaElement, this.fJavaElement) || this.isAncestor(this.fJavaElement, iJavaElement);
            }
            return this.fResourcePath != null && workingSetCompareEntry.fResourcePath != null && ((iPath = workingSetCompareEntry.fResourcePath).isPrefixOf(this.fResourcePath) || this.fResourcePath.isPrefixOf(iPath));
        }

        /*
         * Unable to fully structure code
         */
        private boolean isAncestor(IJavaElement var1_1, IJavaElement var2_2) {
            var3_3 = var1_1.getAncestor(var2_2.getElementType());
            if (!var2_2.equals(var3_3)) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                if (!var2_2.equals(var3_3 = var3_3.getParent().getAncestor(var2_2.getElementType()))) continue;
                return true;
lbl6:
                // 2 sources

                ** while (var3_3 instanceof IMember)
            }
lbl7:
            // 1 sources

            return false;
        }
    }
}

