/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindDeclarationsAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindDeclarationsInWorkingSetAction
extends FindDeclarationsAction {
    private IWorkingSet[] fWorkingSet;

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, (IWorkingSet[])null);
    }

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite iWorkbenchSite, IWorkingSet[] iWorkingSetArray) {
        super(iWorkbenchSite);
        this.fWorkingSet = iWorkingSetArray;
    }

    public FindDeclarationsInWorkingSetAction(JavaEditor javaEditor) {
        this(javaEditor, null);
    }

    public FindDeclarationsInWorkingSetAction(JavaEditor javaEditor, IWorkingSet[] iWorkingSetArray) {
        super(javaEditor);
        this.fWorkingSet = iWorkingSetArray;
    }

    void init() {
        this.setText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_declarations_in_working_set_action");
    }

    QuerySpecification createQuery(IJavaElement iJavaElement) throws JavaModelException, InterruptedException {
        JavaSearchScopeFactory javaSearchScopeFactory = JavaSearchScopeFactory.getInstance();
        IWorkingSet[] iWorkingSetArray = this.fWorkingSet;
        if (this.fWorkingSet == null && (iWorkingSetArray = javaSearchScopeFactory.queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(iWorkingSetArray);
        IJavaSearchScope iJavaSearchScope = javaSearchScopeFactory.createJavaSearchScope(iWorkingSetArray, true);
        String string = javaSearchScopeFactory.getWorkingSetScopeDescription(iWorkingSetArray, true);
        return new ElementQuerySpecification(iJavaElement, this.getLimitTo(), iJavaSearchScope, string);
    }
}

