/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.FindOccurrencesEngine;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FindOccurrencesInFileAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    static /* synthetic */ Class class$0;

    public FindOccurrencesInFileAction(IViewPart iViewPart) {
        this((IWorkbenchSite)iViewPart.getSite());
    }

    public FindOccurrencesInFileAction(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public FindOccurrencesInFileAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(FindOccurrencesInFileAction.getEditorInput(javaEditor) != null);
    }

    public FindOccurrencesInFileAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        if (iWorkbenchSite instanceof IViewSite) {
            this.fActionBars = ((IViewSite)iWorkbenchSite).getActionBars();
        } else if (iWorkbenchSite instanceof IEditorSite) {
            this.fActionBars = ((IEditorSite)iWorkbenchSite).getActionBars();
        } else if (iWorkbenchSite instanceof IPageSite) {
            this.fActionBars = ((IPageSite)iWorkbenchSite).getActionBars();
        }
        this.setText(SearchMessages.Search_FindOccurrencesInFile_label);
        this.setToolTipText(SearchMessages.Search_FindOccurrencesInFile_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_occurrences_in_file_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.getMember(iStructuredSelection) != null);
    }

    private IMember getMember(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IMember) {
            IMember iMember = (IMember)object;
            try {
                if (iMember.getNameRange() == null) {
                    return null;
                }
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
            IClassFile iClassFile = iMember.getClassFile();
            if (iClassFile != null) {
                try {
                    if (iClassFile.getSourceRange() != null) {
                        return iMember;
                    }
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            return iMember;
        }
        return null;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IMember iMember = this.getMember(iStructuredSelection);
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaElement)iMember)) {
            return;
        }
        FindOccurrencesEngine findOccurrencesEngine = FindOccurrencesEngine.create((IJavaElement)iMember, new OccurrencesFinder());
        try {
            ISourceRange iSourceRange = iMember.getNameRange();
            String string = findOccurrencesEngine.run(iSourceRange.getOffset(), iSourceRange.getLength());
            if (string != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fActionBars, string);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    private static void showMessage(Shell shell, IActionBars iActionBars, String string) {
        IStatusLineManager iStatusLineManager;
        if (iActionBars != null && (iStatusLineManager = iActionBars.getStatusLineManager()) != null) {
            iStatusLineManager.setMessage(string);
        }
        shell.getDisplay().beep();
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public final void run(ITextSelection iTextSelection) {
        IJavaElement iJavaElement = FindOccurrencesInFileAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
            return;
        }
        FindOccurrencesEngine findOccurrencesEngine = FindOccurrencesEngine.create(iJavaElement, new OccurrencesFinder());
        try {
            String string = findOccurrencesEngine.run(iTextSelection.getOffset(), iTextSelection.getLength());
            if (string != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fEditor, string);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    private static IJavaElement getEditorInput(JavaEditor javaEditor) {
        IEditorInput iEditorInput = javaEditor.getEditorInput();
        if (iEditorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)iEditorInput).getClassFile();
        }
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput);
    }

    private static void showMessage(Shell shell, JavaEditor javaEditor, String string) {
        IEditorStatusLine iEditorStatusLine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)javaEditor.getAdapter(clazz)) != null) {
            iEditorStatusLine.setMessage(true, string, null);
        }
        shell.getDisplay().beep();
    }
}

