/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class InferTypeArgumentsAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public InferTypeArgumentsAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InferTypeArgumentsAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.InferTypeArgumentsAction_label);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        if (javaTextSelection.getLength() != 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IJavaElement[] iJavaElementArray = InferTypeArgumentsAction.getSelectedElements(iStructuredSelection);
        try {
            if (!ActionUtil.areProcessable(this.getShell(), iJavaElementArray)) {
                return;
            }
            if (RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(iJavaElementArray)) {
                RefactoringExecutionStarter.startInferTypeArgumentsRefactoring(iJavaElementArray, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.InferTypeArgumentsAction_unavailable);
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
        IJavaElement[] iJavaElementArray = new IJavaElement[]{iJavaElement};
        try {
            if (iJavaElement != null && RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(iJavaElementArray)) {
                RefactoringExecutionStarter.startInferTypeArgumentsRefactoring(iJavaElementArray, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.InferTypeArgumentsAction_unavailable);
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IJavaElement[] getSelectedElements(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        IJavaElement[] iJavaElementArray = new IJavaElement[list.size()];
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (!(e instanceof IJavaElement)) {
                return new IJavaElement[0];
            }
            iJavaElementArray[n] = (IJavaElement)e;
            ++n;
        }
        return iJavaElementArray;
    }
}

