/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindAction;
import org.eclipse.wst.jsdt.ui.actions.FindReadReferencesAction;
import org.eclipse.wst.jsdt.ui.actions.FindReadReferencesInHierarchyAction;
import org.eclipse.wst.jsdt.ui.actions.FindReadReferencesInProjectAction;
import org.eclipse.wst.jsdt.ui.actions.FindReadReferencesInWorkingSetAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.actions.WorkingSetFindAction;

public class ReadReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_readReferences;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindReadReferencesAction fFindReadReferencesAction;
    private FindReadReferencesInProjectAction fFindReadReferencesInProjectAction;
    private FindReadReferencesInHierarchyAction fFindReadReferencesInHierarchyAction;
    private FindReadReferencesInWorkingSetAction fFindReadReferencesInWorkingSetAction;

    public ReadReferencesSearchGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        this.fGroupId = "group.search";
        this.fFindReadReferencesAction = new FindReadReferencesAction(iWorkbenchSite);
        this.fFindReadReferencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.workspace");
        this.fFindReadReferencesInProjectAction = new FindReadReferencesInProjectAction(iWorkbenchSite);
        this.fFindReadReferencesInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.read.access.in.project");
        this.fFindReadReferencesInHierarchyAction = new FindReadReferencesInHierarchyAction(iWorkbenchSite);
        this.fFindReadReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.hierarchy");
        this.fFindReadReferencesInWorkingSetAction = new FindReadReferencesInWorkingSetAction(iWorkbenchSite);
        this.fFindReadReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.working.set");
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.registerAction(this.fFindReadReferencesAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindReadReferencesInProjectAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindReadReferencesInHierarchyAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindReadReferencesInWorkingSetAction, iSelectionProvider, iSelection);
    }

    public ReadReferencesSearchGroup(JavaEditor javaEditor) {
        this.fEditor = javaEditor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindReadReferencesAction = new FindReadReferencesAction(this.fEditor);
        this.fFindReadReferencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.workspace");
        this.fEditor.setAction("SearchReadAccessInWorkspace", (IAction)this.fFindReadReferencesAction);
        this.fFindReadReferencesInProjectAction = new FindReadReferencesInProjectAction(this.fEditor);
        this.fFindReadReferencesInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.read.access.in.project");
        this.fEditor.setAction("SearchReadAccessInProject", (IAction)this.fFindReadReferencesInProjectAction);
        this.fFindReadReferencesInHierarchyAction = new FindReadReferencesInHierarchyAction(this.fEditor);
        this.fFindReadReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.hierarchy");
        this.fEditor.setAction("SearchReadAccessInHierarchy", (IAction)this.fFindReadReferencesInHierarchyAction);
        this.fFindReadReferencesInWorkingSetAction = new FindReadReferencesInWorkingSetAction(this.fEditor);
        this.fFindReadReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.working.set");
        this.fEditor.setAction("SearchReadAccessInWorkingSet", (IAction)this.fFindReadReferencesInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        selectionDispatchAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
    }

    private void addAction(IAction iAction, IMenuManager iMenuManager) {
        if (iAction.isEnabled()) {
            iMenuManager.add(iAction);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] iWorkingSetArray, IMenuManager iMenuManager) {
        WorkingSetFindAction workingSetFindAction = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindReadReferencesInWorkingSetAction(this.fEditor, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindReadReferencesInWorkingSetAction(this.fSite, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray));
        workingSetFindAction.update(this.getContext().getSelection());
        this.addAction((IAction)workingSetFindAction, iMenuManager);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindReadReferencesAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindReadReferencesInProjectAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindReadReferencesInHierarchyAction, (IMenuManager)menuManager);
        menuManager.add((IContributionItem)new Separator());
        Iterator iterator = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iterator.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iterator.next(), (IMenuManager)menuManager);
        }
        this.addAction((IAction)this.fFindReadReferencesInWorkingSetAction, (IMenuManager)menuManager);
        if (!menuManager.isEmpty()) {
            iMenuManager.appendToGroup(this.fGroupId, (IContributionItem)menuManager);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        Assert.isNotNull((Object)iActionBars);
        super.fillActionBars(iActionBars);
        this.fActionBars = iActionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.disposeAction(this.fFindReadReferencesAction, iSelectionProvider);
            this.disposeAction(this.fFindReadReferencesInProjectAction, iSelectionProvider);
            this.disposeAction(this.fFindReadReferencesInHierarchyAction, iSelectionProvider);
            this.disposeAction(this.fFindReadReferencesInWorkingSetAction, iSelectionProvider);
        }
        this.fFindReadReferencesAction = null;
        this.fFindReadReferencesInProjectAction = null;
        this.fFindReadReferencesInHierarchyAction = null;
        this.fFindReadReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ReadAccessInWorkspace", (IAction)this.fFindReadReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ReadAccessInProject", (IAction)this.fFindReadReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ReadAccessInHierarchy", (IAction)this.fFindReadReferencesInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ReadAccessInWorkingSet", (IAction)this.fFindReadReferencesInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        if (iSelectionChangedListener != null) {
            iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }
}

