/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RefreshAction
extends SelectionDispatchAction {
    static /* synthetic */ Class class$0;

    public RefreshAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.RefreshAction_label);
        this.setToolTipText(ActionMessages.RefreshAction_toolTip);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "refresh_nav.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.refresh_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return true;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IWorkingSet) continue;
            if (e instanceof IAdaptable) {
                IResource iResource;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                    return false;
                }
                if (iResource.getType() != 4 || ((IProject)iResource).isOpen()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        final IResource[] iResourceArray = this.getResources(iStructuredSelection);
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask(ActionMessages.RefreshAction_progressMessage, iResourceArray.length * 2);
                iProgressMonitor.subTask("");
                ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(5);
                int n = 0;
                while (n < iResourceArray.length) {
                    IJavaElement iJavaElement;
                    IResource iResource = iResourceArray[n];
                    if (iResource.getType() == 4) {
                        RefreshAction.this.checkLocationDeleted((IProject)iResource);
                    } else if (iResource.getType() == 8) {
                        iJavaElement = ((IWorkspaceRoot)iResource).getProjects();
                        int n2 = 0;
                        while (n2 < ((IProject[])iJavaElement).length) {
                            RefreshAction.this.checkLocationDeleted((IProject)iJavaElement[n2]);
                            ++n2;
                        }
                    }
                    iResource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    iJavaElement = JavaCore.create((IResource)iResource);
                    if (iJavaElement != null && iJavaElement.exists()) {
                        arrayList.add(iJavaElement);
                    }
                    ++n;
                }
                IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                iJavaModel.refreshExternalArchives(arrayList.toArray(new IJavaElement[arrayList.size()]), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, iResourceArray.length));
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), ActionMessages.RefreshAction_error_title, ActionMessages.RefreshAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IResource[] getResources(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        ArrayList arrayList = new ArrayList(iStructuredSelection.size());
        this.getResources(arrayList, iStructuredSelection.toArray());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!this.isDescendent(arrayList, iResource)) continue;
            iterator.remove();
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private void getResources(List list, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IWorkingSet) {
                this.getResources(list, ((IWorkingSet)object).getElements());
            } else if (object instanceof IAdaptable) {
                IResource iResource;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && (iResource.getType() != 4 || iResource.getType() == 4 && ((IProject)iResource).isOpen())) {
                    list.add(iResource);
                }
            }
            ++n;
        }
    }

    private boolean isDescendent(List list, IResource iResource) {
        IContainer iContainer = iResource.getParent();
        while (iContainer != null) {
            if (list.contains(iContainer)) {
                return true;
            }
            iContainer = iContainer.getParent();
        }
        return false;
    }

    private void checkLocationDeleted(IProject iProject) throws CoreException {
        if (!iProject.exists()) {
            return;
        }
        URI uRI = iProject.getLocationURI();
        if (uRI == null) {
            return;
        }
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        if (!iFileStore.fetchInfo().exists()) {
            final String string = Messages.format(ActionMessages.RefreshAction_locationDeleted_message, new Object[]{iProject.getName(), Resources.getLocationString((IResource)iProject)});
            final boolean[] blArray = new boolean[1];
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    blArray[0] = MessageDialog.openQuestion((Shell)RefreshAction.this.getShell(), (String)ActionMessages.RefreshAction_locationDeleted_title, (String)string);
                }
            });
            if (blArray[0]) {
                iProject.delete(true, true, null);
            }
        }
    }
}

