/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.style.java;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.wst.jsdt.web.core.internal.java.JsDataTypes;
import org.eclipse.wst.jsdt.web.ui.internal.style.java.JavaWordDetector;

class JSDTCodeScanner
extends RuleBasedScanner {
    private static String[] fgConstants = JsDataTypes.CONSTANTS;
    private static String[] fgKeywords = JsDataTypes.KEYWORDS;
    private static String[] fgTypes = JsDataTypes.TYPES;
    private IToken fDefaultToken;
    private IToken fKeywordToken;
    private IToken fSingleLineCommentToken;
    private IToken fStringToken;
    private IToken fTypeToken;

    public void initializeRules() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new MultiLineRule("/*", "*/", this.fSingleLineCommentToken));
        arrayList.add(new EndOfLineRule("//", this.fSingleLineCommentToken));
        arrayList.add(new SingleLineRule("\"", "\"", this.fStringToken, '\\'));
        arrayList.add(new SingleLineRule("'", "'", this.fStringToken, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), this.fDefaultToken);
        int n = 0;
        while (n < fgKeywords.length) {
            wordRule.addWord(fgKeywords[n], this.fKeywordToken);
            ++n;
        }
        n = 0;
        while (n < fgTypes.length) {
            wordRule.addWord(fgTypes[n], this.fTypeToken);
            ++n;
        }
        n = 0;
        while (n < fgConstants.length) {
            wordRule.addWord(fgConstants[n], this.fTypeToken);
            ++n;
        }
        arrayList.add(wordRule);
        IRule[] iRuleArray = new IRule[arrayList.size()];
        arrayList.toArray(iRuleArray);
        this.setRules(iRuleArray);
    }

    public void setTokenData(String string, Object object) {
        if (string == "keyword") {
            this.fKeywordToken = new Token(object);
            this.fTypeToken = new Token(object);
        } else if (string == "string") {
            this.fStringToken = new Token(object);
        } else if (string == "single_line_comment") {
            this.fSingleLineCommentToken = new Token(object);
        } else if (string == "default") {
            this.fDefaultToken = new Token(object);
        }
    }
}

