/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.view;

import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.internet.monitor.core.internal.IContentFilter;
import org.eclipse.wst.internet.monitor.core.internal.MonitorPlugin;
import org.eclipse.wst.internet.monitor.core.internal.http.ResendHTTPRequest;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IRequestListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.Trace;
import org.eclipse.wst.internet.monitor.ui.internal.view.FilterAction;
import org.eclipse.wst.internet.monitor.ui.internal.view.MonitorTreeContentProvider;
import org.eclipse.wst.internet.monitor.ui.internal.view.TreeLabelProvider;
import org.eclipse.wst.internet.monitor.ui.internal.view.Viewer;
import org.eclipse.wst.internet.monitor.ui.internal.view.ViewerManager;

public class MonitorView
extends ViewPart {
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected MonitorTreeContentProvider contentProvider;
    protected IRequestListener listener;
    protected ViewerManager vm;
    protected List requestViewers;
    protected List responseViewers;
    protected static SimpleDateFormat format;
    protected static final String VIEW_ID = "org.eclipse.wst.internet.monitor.view";
    protected static final String DEFAULT_VIEWER = "org.eclipse.wst.internet.monitor.viewers.byte";
    protected IAction httpHeaderAction;
    protected IAction preferenceAction;
    public static MonitorView view;
    protected Request currentRequest = null;
    protected StructuredSelection currentSelection = null;

    public MonitorView() {
        view = this;
        try {
            format = new SimpleDateFormat(Messages.viewDateFormat);
        }
        catch (Exception exception) {
            format = new SimpleDateFormat("h:mm.s.S a");
        }
    }

    public void doRequestAdded(final Request rr) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!(rr instanceof ResendHTTPRequest)) {
                    Integer in = new Integer(rr.getLocalPort());
                    MonitorView.this.treeViewer.add((Object)"root", (Object)in);
                    MonitorView.this.treeViewer.add((Object)in, (Object)rr);
                    MonitorView.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)rr), true);
                }
            }
        });
    }

    public void doRequestChanged(final Request rr) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (MonitorView.this.treeViewer == null) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)MonitorView.this.treeViewer.getSelection();
                MonitorView.this.treeViewer.refresh((Object)rr);
                if (!sel.isEmpty()) {
                    MonitorView.this.treeViewer.setSelection((ISelection)sel);
                }
            }
        });
    }

    protected void clear() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MonitorView.this.treeViewer.setSelection(null);
                MonitorView.this.treeViewer.setInput((Object)"root");
            }
        });
    }

    protected void setSelection(Request request) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)request));
        }
    }

    public void createPartControl(Composite parent) {
        Viewer viewer;
        SashForm sashFparent = new SashForm(parent, 512);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        sashFparent.setLayout((Layout)layout);
        sashFparent.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sashFparent, "org.eclipse.wst.internet.monitor.ui.tmvw0000");
        Composite treePanel = new Composite((Composite)sashFparent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        treePanel.setLayout((Layout)layout);
        GridData data = new GridData(770);
        data.heightHint = 110;
        data.horizontalSpan = 2;
        treePanel.setLayoutData((Object)data);
        this.tree = new Tree(treePanel, 2820);
        data = new GridData(1808);
        this.tree.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer(this.tree);
        this.contentProvider = new MonitorTreeContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tree, "org.eclipse.wst.internet.monitor.ui.tmvw0002");
        Composite detailsPanel = new Composite(treePanel, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        detailsPanel.setLayout((Layout)layout);
        data = new GridData(272);
        data.widthHint = 200;
        detailsPanel.setLayoutData((Object)data);
        final Label label = new Label(detailsPanel, 0);
        label.setText(NLS.bind((String)Messages.viewTime, (Object)""));
        label.setLayoutData((Object)new GridData(770));
        final Label label2 = new Label(detailsPanel, 0);
        label2.setText(NLS.bind((String)Messages.viewResponseTime, (Object)""));
        label2.setLayoutData((Object)new GridData(770));
        final Label label3 = new Label(detailsPanel, 0);
        label3.setText(NLS.bind((String)Messages.viewType, (Object)""));
        label3.setLayoutData((Object)new GridData(770));
        SashForm sashFchild = new SashForm((Composite)sashFparent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 4;
        sashFchild.setLayout((Layout)layout);
        sashFparent.setWeights(new int[]{30, 70});
        Composite request = new Composite((Composite)sashFchild, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 3;
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        request.setLayout((Layout)layout);
        request.setLayoutData((Object)new GridData(1808));
        Composite requestHeader = new Composite(request, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 1;
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        data = new GridData(770);
        requestHeader.setLayout((Layout)layout);
        requestHeader.setLayoutData((Object)data);
        final Label requestLabel = new Label(requestHeader, 0);
        requestLabel.setText(NLS.bind((String)Messages.viewRequest, (Object)""));
        requestLabel.setLayoutData((Object)new GridData(768));
        final Combo requestViewerCombo = new Combo(requestHeader, 12);
        data = new GridData(128);
        data.verticalSpan = 2;
        requestViewerCombo.setLayoutData((Object)data);
        final Label requestSizeLabel = new Label(requestHeader, 0);
        requestSizeLabel.setText(NLS.bind((String)Messages.viewSize, (Object)""));
        requestSizeLabel.setLayoutData((Object)new GridData(768));
        Composite response = new Composite((Composite)sashFchild, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 3;
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        response.setLayout((Layout)layout);
        response.setLayoutData((Object)new GridData(1808));
        Composite responseHeader = new Composite(response, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 1;
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        data = new GridData(770);
        responseHeader.setLayout((Layout)layout);
        responseHeader.setLayoutData((Object)data);
        final Label responseLabel = new Label(responseHeader, 0);
        responseLabel.setText(NLS.bind((String)Messages.viewResponse, (Object)""));
        responseLabel.setLayoutData((Object)new GridData(768));
        final Combo responseViewerCombo = new Combo(responseHeader, 12);
        data = new GridData(128);
        data.verticalSpan = 2;
        responseViewerCombo.setLayoutData((Object)data);
        final Label responseSizeLabel = new Label(responseHeader, 0);
        responseSizeLabel.setText(NLS.bind((String)Messages.viewSize, (Object)""));
        responseSizeLabel.setLayoutData((Object)new GridData(768));
        this.vm = new ViewerManager(request, request, response, response);
        this.requestViewers = this.vm.getRequestViewers();
        this.responseViewers = this.vm.getResponseViewers();
        Iterator iterator = this.requestViewers.iterator();
        int ctr = 0;
        while (iterator.hasNext()) {
            viewer = (Viewer)iterator.next();
            requestViewerCombo.add(viewer.getLabel(), ctr);
            if (viewer.getId().equals(DEFAULT_VIEWER)) {
                requestViewerCombo.select(ctr);
                this.vm.setRequestViewer(viewer);
            }
            ++ctr;
        }
        requestViewerCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Viewer viewer = (Viewer)MonitorView.this.requestViewers.get(requestViewerCombo.getSelectionIndex());
                if (MonitorView.this.currentRequest != null && viewer != null) {
                    MonitorView.this.currentRequest.setProperty("request-viewer", (Object)viewer.getId());
                }
                MonitorView.this.vm.setRequestViewer(viewer);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        requestHeader.layout(true);
        iterator = this.responseViewers.iterator();
        ctr = 0;
        while (iterator.hasNext()) {
            viewer = (Viewer)iterator.next();
            responseViewerCombo.add(viewer.getLabel(), ctr);
            if (viewer.getId().equals(DEFAULT_VIEWER)) {
                responseViewerCombo.select(ctr);
                this.vm.setResponseViewer(viewer);
            }
            ++ctr;
        }
        responseViewerCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Viewer viewer = (Viewer)MonitorView.this.responseViewers.get(responseViewerCombo.getSelectionIndex());
                if (MonitorView.this.currentRequest != null && viewer != null) {
                    MonitorView.this.currentRequest.setProperty("response-viewer", (Object)viewer.getId());
                }
                MonitorView.this.vm.setResponseViewer(viewer);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        responseHeader.layout(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                MonitorView.this.currentRequest = null;
                if (selection != null && !selection.isEmpty()) {
                    StructuredSelection sel;
                    MonitorView.this.currentSelection = sel = (StructuredSelection)selection;
                    Object obj = sel.iterator().next();
                    if (obj instanceof Request) {
                        MonitorView.this.currentRequest = (Request)obj;
                    }
                }
                if (MonitorView.this.currentRequest != null) {
                    label.setText(NLS.bind((String)Messages.viewTime, (Object)format.format(MonitorView.this.currentRequest.getDate())));
                    if (MonitorView.this.currentRequest.getResponseTime() == -1L) {
                        label2.setText(NLS.bind((String)Messages.viewResponseTime, (Object)""));
                    } else {
                        String time = NLS.bind((String)Messages.viewResponseTimeFormat, (Object)String.valueOf(MonitorView.this.currentRequest.getResponseTime()));
                        label2.setText(NLS.bind((String)Messages.viewResponseTime, (Object)time));
                    }
                    label3.setText(NLS.bind((String)Messages.viewType, (Object)MonitorView.this.currentRequest.getProtocol()));
                    requestLabel.setText(NLS.bind((String)Messages.viewRequest, (Object)("localhost:" + MonitorView.this.currentRequest.getLocalPort())));
                    requestSizeLabel.setText(MonitorView.this.getSizeString(MonitorView.this.currentRequest.getRequest(2), MonitorView.this.currentRequest.getRequest(3)));
                    responseLabel.setText(NLS.bind((String)Messages.viewResponse, (Object)(String.valueOf(MonitorView.this.currentRequest.getRemoteHost()) + ":" + MonitorView.this.currentRequest.getRemotePort())));
                    responseSizeLabel.setText(MonitorView.this.getSizeString(MonitorView.this.currentRequest.getResponse(2), MonitorView.this.currentRequest.getResponse(3)));
                    MonitorView.this.vm.setRequest(MonitorView.this.currentRequest);
                    Viewer viewer = MonitorView.this.vm.findViewer((String)MonitorView.this.currentRequest.getProperty("request-viewer"));
                    if (viewer == null) {
                        viewer = MonitorView.this.vm.findViewer(MonitorView.DEFAULT_VIEWER);
                    }
                    if (viewer != null) {
                        MonitorView.this.vm.setRequestViewer(viewer);
                        requestViewerCombo.select(MonitorView.this.requestViewers.indexOf(viewer));
                    }
                    if ((viewer = MonitorView.this.vm.findViewer((String)MonitorView.this.currentRequest.getProperty("response-viewer"))) == null && MonitorView.this.currentRequest.getName() != null) {
                        viewer = MonitorView.this.vm.getDefaultViewer(MonitorView.this.currentRequest.getName());
                    }
                    if (viewer != null) {
                        MonitorView.this.vm.setResponseViewer(viewer);
                        responseViewerCombo.select(MonitorView.this.responseViewers.indexOf(viewer));
                    }
                } else {
                    label.setText(NLS.bind((String)Messages.viewTime, (Object)""));
                    label2.setText(NLS.bind((String)Messages.viewResponseTime, (Object)""));
                    requestLabel.setText(NLS.bind((String)Messages.viewRequest, (Object)""));
                    requestSizeLabel.setText(NLS.bind((String)Messages.viewSize, (Object)""));
                    responseLabel.setText(NLS.bind((String)Messages.viewResponse, (Object)""));
                    responseSizeLabel.setText(NLS.bind((String)Messages.viewSize, (Object)""));
                    MonitorView.this.vm.setRequest(MonitorView.this.currentRequest);
                }
            }
        });
        this.treeViewer.expandToLevel(2);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                menu.add((IContributionItem)new GroupMarker("additions"));
                menu.add(MonitorView.this.preferenceAction);
            }
        });
        Menu menu = menuManager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
        this.initializeActions();
    }

    protected String getSizeString(byte[] a, byte[] b) {
        String aa = "0";
        String bb = "0";
        if (a != null) {
            aa = String.valueOf(a.length);
        }
        if (b != null) {
            bb = String.valueOf(b.length);
        }
        String size = NLS.bind((String)Messages.viewSizeFormat, (Object[])new Object[]{aa, bb});
        return NLS.bind((String)Messages.viewSize, (Object)size);
    }

    public void dispose() {
        super.dispose();
        this.treeViewer = null;
        view = null;
    }

    public void initializeActions() {
        Action sortByResponseTimeAction = new Action(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        boolean b = 8.access$0(this.this$1).contentProvider.getSortByResponseTime();
                        8.access$0(this.this$1).contentProvider.setSortByResponseTime(!b);
                        8.access$0(this.this$1).treeViewer.refresh();
                        this.this$1.setChecked(!b);
                    }
                });
            }

            static /* synthetic */ MonitorView access$0(8 var0) {
                return var0.MonitorView.this;
            }
        };
        sortByResponseTimeAction.setChecked(false);
        sortByResponseTimeAction.setToolTipText(Messages.actionSortByResponseTime);
        sortByResponseTimeAction.setImageDescriptor(MonitorUIPlugin.getImageDescriptor("IMG_ELCL_SORT_RESPONSE_TIME"));
        sortByResponseTimeAction.setHoverImageDescriptor(MonitorUIPlugin.getImageDescriptor("IMG_CLCL_SORT_RESPONSE_TIME"));
        sortByResponseTimeAction.setDisabledImageDescriptor(MonitorUIPlugin.getImageDescriptor("IMG_DLCL_SORT_RESPONSE_TIME"));
        Action clearAction = new Action(){

            public void run() {
                MonitorUIPlugin.getInstance().clearRequests();
                MonitorView.this.clear();
            }
        };
        clearAction.setToolTipText(Messages.actionClearToolTip);
        clearAction.setImageDescriptor(MonitorUIPlugin.getImageDescriptor("IMG_ELCL_CLEAR"));
        clearAction.setHoverImageDescriptor(MonitorUIPlugin.getImageDescriptor("IMG_CLCL_CLEAR"));
        clearAction.setDisabledImageDescriptor(MonitorUIPlugin.getImageDescriptor("IMG_DLCL_CLEAR"));
        this.httpHeaderAction = new Action(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        boolean b = 11.access$0(this.this$1).vm.getDisplayHeaderInfo();
                        11.access$0(this.this$1).vm.setDisplayHeaderInfo(!b);
                        this.this$1.setChecked(!b);
                    }
                });
            }

            static /* synthetic */ MonitorView access$0(11 var0) {
                return var0.MonitorView.this;
            }
        };
        this.httpHeaderAction.setChecked(this.vm.getDisplayHeaderInfo());
        this.httpHeaderAction.setText(Messages.actionShowHeader);
        this.preferenceAction = new Action(){

            public void run() {
                MonitorView.this.showPreferencePage();
            }
        };
        this.preferenceAction.setText(Messages.actionProperties);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)sortByResponseTimeAction);
        tbm.add((IAction)clearAction);
        IContentFilter[] filters = MonitorPlugin.getInstance().getContentFilters();
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add(this.httpHeaderAction);
        int size = filters.length;
        int i = 0;
        while (i < size) {
            FilterAction action = new FilterAction(this.vm, filters[i]);
            menuManager.add((IAction)action);
            ++i;
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.preferenceAction);
    }

    protected boolean showPreferencePage() {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.debug.ui.DebugPreferencePage").findSubNode("org.eclipse.wst.internet.monitor.preferencePage");
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        final PreferenceDialog dialog = new PreferenceDialog(this.getSite().getShell(), manager2);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    public static void open(final Request request) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbench workbench = MonitorUIPlugin.getInstance().getWorkbench();
                    IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                    IWorkbenchPage page = workbenchWindow.getActivePage();
                    IViewPart view2 = page.findView(MonitorView.VIEW_ID);
                    if (view2 != null) {
                        page.bringToTop((IWorkbenchPart)view2);
                    } else {
                        page.showView(MonitorView.VIEW_ID);
                    }
                    if (view != null) {
                        view.setSelection(request);
                    }
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Error opening TCP/IP view", e);
                }
            }
        });
    }

    public void setFocus() {
        if (this.tree != null) {
            this.tree.setFocus();
        }
    }
}

