/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class CommitCommentArea
extends DialogArea {
    private static final String EMPTY_MESSAGE = CVSUIMessages.CommitCommentArea_0;
    private static final String COMBO_MESSAGE = CVSUIMessages.CommitCommentArea_1;
    private static final String CONFIGURE_TEMPLATES_MESSAGE = CVSUIMessages.CommitCommentArea_5;
    public static final String OK_REQUESTED = "OkRequested";
    public static final String COMMENT_MODIFIED = "CommentModified";
    private TextBox fTextBox;
    private ComboBox fComboBox;
    private IProject fMainProject;
    private String fProposedComment;
    private Composite fComposite;

    public void createArea(Composite parent) {
        Dialog.applyDialogFont((Control)parent);
        this.initializeDialogUnits((Control)parent);
        this.fComposite = this.createGrabbingComposite(parent, 1);
        this.initializeDialogUnits((Control)this.fComposite);
        this.fTextBox = new TextBox(this.fComposite, EMPTY_MESSAGE, this.getInitialComment());
        String[] comments = CVSUIPlugin.getPlugin().getRepositoryManager().getPreviousComments();
        String[] commentTemplates = CVSUIPlugin.getPlugin().getRepositoryManager().getCommentTemplates();
        this.fComboBox = new ComboBox(this.fComposite, COMBO_MESSAGE, comments, commentTemplates);
        Link templatesPrefsLink = new Link(this.fComposite, 0);
        templatesPrefsLink.setText("<a href=\"configureTemplates\">" + CONFIGURE_TEMPLATES_MESSAGE + "</a>");
        templatesPrefsLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CommitCommentArea.this.openCommentTemplatesPreferencePage();
            }

            public void widgetSelected(SelectionEvent e) {
                CommitCommentArea.this.openCommentTemplatesPreferencePage();
            }
        });
        this.fComboBox.addObserver(this.fTextBox);
    }

    void openCommentTemplatesPreferencePage() {
        PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.team.cvs.ui.CommentTemplatesPreferences", (String[])new String[]{"org.eclipse.team.cvs.ui.CommentTemplatesPreferences"}, null).open();
        this.fComboBox.setCommentTemplates(CVSUIPlugin.getPlugin().getRepositoryManager().getCommentTemplates());
    }

    public String getComment(boolean save) {
        String comment = this.fTextBox.getText();
        if (comment == null) {
            return "";
        }
        String stripped = this.strip(comment);
        if (save && comment.length() > 0) {
            CVSUIPlugin.getPlugin().getRepositoryManager().addComment(comment);
        }
        return stripped;
    }

    public String getCommentWithPrompt(Shell shell) {
        String comment = this.getComment(false);
        if (comment.length() == 0) {
            String toggleMessage;
            String message;
            String title;
            MessageDialogWithToggle dialog;
            IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
            String value = store.getString("pref_allow_empty_commit_comment");
            if ("never".equals(value)) {
                return null;
            }
            if ("prompt".equals(value) && (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)(title = CVSUIMessages.CommitCommentArea_2), (String)(message = CVSUIMessages.CommitCommentArea_3), (String)(toggleMessage = CVSUIMessages.CommitCommentArea_4), (boolean)false, (IPreferenceStore)store, (String)"pref_allow_empty_commit_comment")).getReturnCode() != 2) {
                this.fTextBox.setFocus();
                return null;
            }
        }
        return this.getComment(true);
    }

    public void setProject(IProject iProject) {
        this.fMainProject = iProject;
    }

    public void setFocus() {
        if (this.fTextBox != null) {
            this.fTextBox.setFocus();
        }
    }

    public void setProposedComment(String proposedComment) {
        this.fProposedComment = proposedComment == null || proposedComment.length() == 0 ? null : proposedComment;
    }

    public boolean hasCommitTemplate() {
        try {
            String commitTemplate = this.getCommitTemplate();
            return commitTemplate != null && commitTemplate.length() > 0;
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    public void setEnabled(boolean enabled) {
        this.fTextBox.setEnabled(enabled);
        this.fComboBox.setEnabled(enabled);
    }

    public Composite getComposite() {
        return this.fComposite;
    }

    protected void firePropertyChangeChange(String property, Object oldValue, Object newValue) {
        super.firePropertyChangeChange(property, oldValue, newValue);
    }

    private String getInitialComment() {
        if (this.fProposedComment != null) {
            return this.fProposedComment;
        }
        try {
            return this.getCommitTemplate();
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return "";
        }
    }

    private String strip(String comment) {
        try {
            String commitTemplate = this.getCommitTemplate();
            if (comment.startsWith(commitTemplate)) {
                return comment.substring(commitTemplate.length());
            }
            if (comment.endsWith(commitTemplate)) {
                return comment.substring(0, comment.length() - commitTemplate.length());
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        return comment;
    }

    private CVSTeamProvider getProvider() {
        if (this.fMainProject == null) {
            return null;
        }
        return (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.fMainProject, (String)CVSProviderPlugin.getTypeId());
    }

    private String getCommitTemplate() throws CVSException {
        CVSTeamProvider provider = this.getProvider();
        if (provider == null) {
            return "";
        }
        String template = provider.getCommitTemplate();
        return template != null ? template : "";
    }

    private static class ComboBox
    extends Observable
    implements SelectionListener,
    FocusListener {
        private final String fMessage;
        private final String[] fComments;
        private String[] fCommentTemplates;
        private final Combo fCombo;

        public ComboBox(Composite composite, String message, String[] options, String[] commentTemplates) {
            this.fMessage = message;
            this.fComments = options;
            this.fCommentTemplates = commentTemplates;
            this.fCombo = new Combo(composite, 8);
            this.fCombo.setLayoutData((Object)SWTUtils.createHFillGridData());
            this.fCombo.setVisibleItemCount(20);
            this.populateList();
            this.fCombo.addFocusListener((FocusListener)this);
            this.fCombo.addSelectionListener((SelectionListener)this);
        }

        private void populateList() {
            this.fCombo.removeAll();
            this.fCombo.add(this.fMessage);
            int i = 0;
            while (i < this.fCommentTemplates.length) {
                this.fCombo.add(String.valueOf(CVSUIMessages.CommitCommentArea_6) + ": " + Util.flattenText((String)this.fCommentTemplates[i]));
                ++i;
            }
            i = 0;
            while (i < this.fComments.length) {
                this.fCombo.add(Util.flattenText((String)this.fComments[i]));
                ++i;
            }
            this.fCombo.setText(this.fMessage);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.fCombo.getSelectionIndex();
            if (index > 0) {
                this.setChanged();
                String message = --index < this.fCommentTemplates.length ? this.fCommentTemplates[index] : this.fComments[index - this.fCommentTemplates.length];
                this.notifyObservers(message);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.fCombo.removeSelectionListener((SelectionListener)this);
            try {
                this.fCombo.setText(this.fMessage);
            }
            finally {
                this.fCombo.addSelectionListener((SelectionListener)this);
            }
        }

        public void setEnabled(boolean enabled) {
            this.fCombo.setEnabled(enabled);
        }

        void setCommentTemplates(String[] templates) {
            this.fCommentTemplates = templates;
            this.populateList();
        }
    }

    private class TextBox
    implements ModifyListener,
    TraverseListener,
    FocusListener,
    Observer {
        private final StyledText fTextField;
        private final String fMessage;
        private String fText;

        public TextBox(Composite composite, String message, String initialText) {
            this.fMessage = message;
            this.fText = initialText;
            AnnotationModel annotationModel = new AnnotationModel();
            DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
            Composite cc = new Composite(composite, 2048);
            cc.setLayout((Layout)new FillLayout());
            cc.setLayoutData((Object)new GridData(1808));
            SourceViewer sourceViewer = new SourceViewer(cc, null, null, true, 578);
            sourceViewer.getTextWidget().setIndent(2);
            SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)sourceViewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
            Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
            while (e.hasNext()) {
                support.setAnnotationPreference((AnnotationPreference)e.next());
            }
            support.install(EditorsUI.getPreferenceStore());
            sourceViewer.getTextWidget().addDisposeListener(new DisposeListener(this, support){
                final /* synthetic */ TextBox this$1;
                private final /* synthetic */ SourceViewerDecorationSupport val$support;
                {
                    this.this$1 = textBox;
                    this.val$support = sourceViewerDecorationSupport;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.val$support.uninstall();
                }
            });
            Document document = new Document(initialText);
            sourceViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
            sourceViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
            this.fTextField = sourceViewer.getTextWidget();
            this.fTextField.addTraverseListener((TraverseListener)this);
            this.fTextField.addModifyListener((ModifyListener)this);
            this.fTextField.addFocusListener((FocusListener)this);
        }

        public void modifyText(ModifyEvent e) {
            String old = this.fText;
            this.fText = this.fTextField.getText();
            CommitCommentArea.this.firePropertyChangeChange(CommitCommentArea.COMMENT_MODIFIED, old, this.fText);
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4 && (e.stateMask & 0x40000) != 0) {
                e.doit = false;
                CommitCommentArea.this.firePropertyChangeChange(CommitCommentArea.OK_REQUESTED, null, null);
            }
        }

        public void focusGained(FocusEvent e) {
            if (this.fText.length() > 0) {
                return;
            }
            this.fTextField.removeModifyListener((ModifyListener)this);
            try {
                this.fTextField.setText(this.fText);
            }
            finally {
                this.fTextField.addModifyListener((ModifyListener)this);
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.fText.length() > 0) {
                return;
            }
            this.fTextField.removeModifyListener((ModifyListener)this);
            try {
                this.fTextField.setText(this.fMessage);
                this.fTextField.selectAll();
            }
            finally {
                this.fTextField.addModifyListener((ModifyListener)this);
            }
        }

        public void setEnabled(boolean enabled) {
            this.fTextField.setEnabled(enabled);
        }

        public void update(Observable o, Object arg) {
            if (arg instanceof String) {
                this.setText((String)arg);
            }
        }

        public String getText() {
            return this.fText;
        }

        private void setText(String text) {
            if (text.length() == 0) {
                this.fTextField.setText(this.fMessage);
                this.fTextField.selectAll();
            } else {
                this.fTextField.setText(text);
            }
        }

        public void setFocus() {
            this.fTextField.setFocus();
        }
    }
}

