/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public abstract class JavaRefactoringDescriptor
extends RefactoringDescriptor {
    protected static final String ATTRIBUTE_ELEMENT = "element";
    protected static final String ATTRIBUTE_INPUT = "input";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_REFERENCES = "references";
    protected static final String ATTRIBUTE_SELECTION = "selection";
    protected static final String ATTRIBUTE_VERSION = "version";
    public static final int JAR_MIGRATION = 65536;
    public static final int JAR_REFACTORING = 524288;
    public static final int JAR_SOURCE_ATTACHMENT = 262144;
    protected static final String VALUE_VERSION_1_0 = "1.0";
    protected final Map fArguments;

    protected static String elementToHandle(String string, IJavaElement iJavaElement) {
        String string2 = iJavaElement.getHandleIdentifier();
        if (string != null && !(iJavaElement instanceof IJavaProject)) {
            String string3 = iJavaElement.getJavaProject().getHandleIdentifier();
            return string2.substring(string3.length());
        }
        return string2;
    }

    protected static IJavaElement handleToElement(String string, String string2) {
        return JavaRefactoringDescriptor.handleToElement(string, string2, true);
    }

    protected static IJavaElement handleToElement(String string, String string2, boolean bl) {
        return JavaRefactoringDescriptor.handleToElement(null, string, string2, bl);
    }

    protected static IJavaElement handleToElement(WorkingCopyOwner workingCopyOwner, String string, String string2, boolean bl) {
        IMethod[] iMethodArray;
        IJavaProject iJavaProject;
        IJavaElement iJavaElement = null;
        iJavaElement = workingCopyOwner != null ? JavaCore.create((String)string2, (WorkingCopyOwner)workingCopyOwner) : JavaCore.create((String)string2);
        if (iJavaElement == null && string != null) {
            iJavaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(string);
            iMethodArray = iJavaProject.getHandleIdentifier();
            iJavaElement = workingCopyOwner != null ? JavaCore.create((String)(String.valueOf(iMethodArray) + string2), (WorkingCopyOwner)workingCopyOwner) : JavaCore.create((String)(String.valueOf(iMethodArray) + string2));
        }
        if (bl && iJavaElement instanceof IMethod) {
            IMethod[] iMethodArray2;
            iJavaProject = (IMethod)iJavaElement;
            if (iJavaProject.getDeclaringType() != null) {
                iMethodArray2 = iJavaProject.getDeclaringType().findMethods((IMethod)iJavaProject);
            } else {
                IMethod[] iMethodArray3 = new IMethod[1];
                iMethodArray2 = iMethodArray3;
                iMethodArray3[0] = iJavaProject.getCompilationUnit().getMethod(iJavaProject.getElementName(), iJavaProject.getParameterTypes());
            }
            iMethodArray = iMethodArray2;
            if (iMethodArray != null && iMethodArray.length > 0) {
                iJavaElement = iMethodArray[0];
            }
        }
        if (iJavaElement != null && (!bl || iJavaElement.exists())) {
            return iJavaElement;
        }
        return null;
    }

    protected static IResource handleToResource(String string, String string2) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(string2)) {
            return null;
        }
        IPath iPath = Path.fromPortableString((String)string2);
        if (iPath == null) {
            return null;
        }
        if (string != null && !"".equals(string)) {
            return iWorkspaceRoot.getProject(string).findMember(iPath);
        }
        return iWorkspaceRoot.findMember(iPath);
    }

    protected static String resourceToHandle(String string, IResource iResource) {
        if (string != null && !"".equals(string)) {
            return iResource.getProjectRelativePath().toPortableString();
        }
        return iResource.getFullPath().toPortableString();
    }

    protected JavaRefactoringDescriptor(String string) {
        this(string, new HashMap());
    }

    protected JavaRefactoringDescriptor(String string, Map map) {
        super(string, null, DescriptorMessages.JavaRefactoringDescriptor_not_available, null, 6);
        this.fArguments = map;
        this.fArguments.put(ATTRIBUTE_VERSION, VALUE_VERSION_1_0);
    }

    public Refactoring createRefactoring(RefactoringStatus refactoringStatus) throws CoreException {
        this.populateArgumentMap();
        Refactoring refactoring = null;
        String string = this.getID();
        RefactoringContribution refactoringContribution = RefactoringCore.getRefactoringContribution((String)string);
        if (refactoringContribution != null) {
            RefactoringDescriptor refactoringDescriptor = refactoringContribution.createDescriptor(string, this.getProject(), this.getDescription(), this.getComment(), this.fArguments, this.getFlags());
            if (refactoringDescriptor != null) {
                refactoring = refactoringDescriptor.createRefactoring(refactoringStatus);
            } else {
                JavaManipulationPlugin.log((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 0, MessageFormat.format(DescriptorMessages.JavaRefactoringDescriptor_no_resulting_descriptor, string), null));
            }
        }
        return refactoring;
    }

    protected Map getArguments() {
        this.populateArgumentMap();
        return new HashMap(this.fArguments);
    }

    protected void populateArgumentMap() {
        Assert.isTrue((!this.validateDescriptor().hasFatalError() ? 1 : 0) != 0, (String)"Validation returns a fatal error status.");
    }

    public void setComment(String string) {
        super.setComment(string);
    }

    public void setDescription(String string) {
        super.setDescription(string);
    }

    public void setFlags(int n) {
        super.setFlags(n);
    }

    public void setProject(String string) {
        super.setProject(string);
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        String string = this.getDescription();
        if (string == null || "".equals(string)) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.JavaRefactoringDescriptor_no_description));
        }
        return refactoringStatus;
    }
}

