/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class MoveDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_FILES = "files";
    private static final String ATTRIBUTE_FOLDERS = "folders";
    private static final String ATTRIBUTE_FRAGMENTS = "fragments";
    private static final String ATTRIBUTE_MEMBERS = "members";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_POLICY = "policy";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_ROOTS = "roots";
    private static final String ATTRIBUTE_TARGET = "target";
    private static final String ATTRIBUTE_UNITS = "units";
    private static final String POLICY_MOVE_MEMBERS = "org.eclipse.wst.jsdt.ui.moveMembers";
    private static final String POLICY_MOVE_PACKAGES = "org.eclipse.wst.jsdt.ui.movePackages";
    private static final String POLICY_MOVE_RESOURCES = "org.eclipse.wst.jsdt.ui.moveResources";
    private static final String POLICY_MOVE_ROOTS = "org.eclipse.wst.jsdt.ui.moveRoots";
    private Object fDestination;
    private IFile[] fFiles;
    private IFolder[] fFolders;
    private IPackageFragment[] fFragments;
    private IMember[] fMembers;
    private String fMovePolicy = null;
    private String fPatterns = null;
    private boolean fQualified = false;
    private boolean fReferences = false;
    private IPackageFragmentRoot[] fRoots;
    private ICompilationUnit[] fUnits;

    public MoveDescriptor() {
        super("org.eclipse.wst.jsdt.ui.move");
    }

    protected void populateArgumentMap() {
        block11: {
            String string;
            block13: {
                block12: {
                    block10: {
                        super.populateArgumentMap();
                        this.fArguments.put(ATTRIBUTE_POLICY, this.fMovePolicy);
                        string = this.getProject();
                        if (this.fDestination instanceof IJavaElement) {
                            this.fArguments.put(ATTRIBUTE_DESTINATION, JavaRefactoringDescriptor.elementToHandle(string, (IJavaElement)this.fDestination));
                        } else if (this.fDestination instanceof IResource) {
                            this.fArguments.put(ATTRIBUTE_TARGET, JavaRefactoringDescriptor.resourceToHandle(null, (IResource)this.fDestination));
                        }
                        if (!POLICY_MOVE_RESOURCES.equals(this.fMovePolicy)) break block10;
                        this.fArguments.put("references", Boolean.toString(this.fReferences));
                        this.fArguments.put(ATTRIBUTE_QUALIFIED, Boolean.toString(this.fQualified));
                        if (this.fPatterns != null && !"".equals(this.fPatterns)) {
                            this.fArguments.put(ATTRIBUTE_PATTERNS, this.fPatterns);
                        }
                        this.fArguments.put(ATTRIBUTE_FILES, new Integer(this.fFiles.length).toString());
                        int n = 0;
                        while (n < this.fFiles.length) {
                            this.fArguments.put("element" + (n + 1), JavaRefactoringDescriptor.resourceToHandle(string, (IResource)this.fFiles[n]));
                            ++n;
                        }
                        this.fArguments.put(ATTRIBUTE_FOLDERS, new Integer(this.fFolders.length).toString());
                        n = 0;
                        while (n < this.fFolders.length) {
                            this.fArguments.put("element" + (n + this.fFiles.length + 1), JavaRefactoringDescriptor.resourceToHandle(string, (IResource)this.fFolders[n]));
                            ++n;
                        }
                        this.fArguments.put(ATTRIBUTE_UNITS, new Integer(this.fUnits.length).toString());
                        n = 0;
                        while (n < this.fUnits.length) {
                            this.fArguments.put("element" + (n + this.fFolders.length + this.fFiles.length + 1), JavaRefactoringDescriptor.elementToHandle(string, (IJavaElement)this.fUnits[n]));
                            ++n;
                        }
                        break block11;
                    }
                    if (!POLICY_MOVE_ROOTS.equals(this.fMovePolicy)) break block12;
                    this.fArguments.put(ATTRIBUTE_ROOTS, new Integer(this.fRoots.length).toString());
                    int n = 0;
                    while (n < this.fRoots.length) {
                        this.fArguments.put("element" + (n + 1), JavaRefactoringDescriptor.elementToHandle(string, (IJavaElement)this.fRoots[n]));
                        ++n;
                    }
                    break block11;
                }
                if (!POLICY_MOVE_PACKAGES.equals(this.fMovePolicy)) break block13;
                this.fArguments.put(ATTRIBUTE_FRAGMENTS, new Integer(this.fFragments.length).toString());
                int n = 0;
                while (n < this.fFragments.length) {
                    this.fArguments.put("element" + (n + 1), JavaRefactoringDescriptor.elementToHandle(string, (IJavaElement)this.fFragments[n]));
                    ++n;
                }
                break block11;
            }
            if (!POLICY_MOVE_MEMBERS.equals(this.fMovePolicy)) break block11;
            this.fArguments.put(ATTRIBUTE_MEMBERS, new Integer(this.fMembers.length).toString());
            int n = 0;
            while (n < this.fMembers.length) {
                this.fArguments.put("element" + (n + 1), JavaRefactoringDescriptor.elementToHandle(string, (IJavaElement)this.fMembers[n]));
                ++n;
            }
        }
    }

    public void setDestination(IJavaElement iJavaElement) {
        Assert.isNotNull((Object)iJavaElement);
        this.fDestination = iJavaElement;
    }

    public void setDestination(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.fDestination = iResource;
    }

    public void setFileNamePatterns(String string) {
        Assert.isNotNull((Object)string);
        Assert.isLegal((!"".equals(string) ? 1 : 0) != 0, (String)"Pattern must not be empty");
        this.fPatterns = string;
    }

    public void setMoveMembers(IMember[] iMemberArray) {
        Assert.isNotNull((Object)iMemberArray);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fMembers = iMemberArray;
        this.fMovePolicy = POLICY_MOVE_MEMBERS;
    }

    public void setMovePackageFragmentRoots(IPackageFragmentRoot[] iPackageFragmentRootArray) {
        Assert.isNotNull((Object)iPackageFragmentRootArray);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fRoots = iPackageFragmentRootArray;
        this.fMovePolicy = POLICY_MOVE_ROOTS;
    }

    public void setMovePackages(IPackageFragment[] iPackageFragmentArray) {
        Assert.isNotNull((Object)iPackageFragmentArray);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fFragments = iPackageFragmentArray;
        this.fMovePolicy = POLICY_MOVE_PACKAGES;
    }

    public void setMoveResources(IFile[] iFileArray, IFolder[] iFolderArray, ICompilationUnit[] iCompilationUnitArray) {
        Assert.isNotNull((Object)iFileArray);
        Assert.isNotNull((Object)iFolderArray);
        Assert.isNotNull((Object)iCompilationUnitArray);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fFiles = iFileArray;
        this.fFolders = iFolderArray;
        this.fUnits = iCompilationUnitArray;
        this.fMovePolicy = POLICY_MOVE_RESOURCES;
    }

    public void setUpdateQualifiedNames(boolean bl) {
        this.fQualified = bl;
    }

    public void setUpdateReferences(boolean bl) {
        this.fReferences = bl;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus refactoringStatus = super.validateDescriptor();
        if (!refactoringStatus.hasFatalError()) {
            if (this.fMovePolicy == null) {
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveDescriptor_no_elements_set));
            }
            if (this.fDestination == null) {
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveDescriptor_no_destination_set));
            }
        }
        return refactoringStatus;
    }
}

