/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public abstract class ExternalToolsMainTab
extends AbstractLaunchConfigurationTab {
    public static final String FIRST_EDIT = "editedByExternalToolsMainTab";
    protected Text locationField;
    protected Text workDirectoryField;
    protected Button fileLocationButton;
    protected Button workspaceLocationButton;
    protected Button variablesLocationButton;
    protected Button fileWorkingDirectoryButton;
    protected Button workspaceWorkingDirectoryButton;
    protected Button variablesWorkingDirectoryButton;
    protected Text argumentField;
    protected Button argumentVariablesButton;
    protected SelectionAdapter selectionAdapter;
    protected boolean fInitializing = false;
    private boolean userEdited = false;
    protected WidgetListener fListener = new WidgetListener();

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createLocationComponent(mainComposite);
        this.createWorkDirectoryComponent(mainComposite);
        this.createArgumentComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createLocationComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String locationLabel = this.getLocationLabel();
        group.setText(locationLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.locationField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.locationField.setLayoutData((Object)gridData);
        this.locationField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.locationField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.workspaceLocationButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab__Browse_Workspace____3, null);
        this.workspaceLocationButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.workspaceLocationButton, String.valueOf(group.getText()) + " " + this.workspaceLocationButton.getText());
        this.fileLocationButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Brows_e_File_System____4, null);
        this.fileLocationButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fileLocationButton, String.valueOf(group.getText()) + " " + this.fileLocationButton.getText());
        this.variablesLocationButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_31, null);
        this.variablesLocationButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.variablesLocationButton, String.valueOf(group.getText()) + " " + this.variablesLocationButton.getText());
    }

    protected String getLocationLabel() {
        return ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab__Location___2;
    }

    protected void createWorkDirectoryComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = this.getWorkingDirectoryLabel();
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.workDirectoryField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.workDirectoryField.setLayoutData((Object)data);
        this.workDirectoryField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.workDirectoryField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.workspaceWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Browse_Wor_kspace____6, null);
        this.workspaceWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.workspaceWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.workspaceWorkingDirectoryButton.getText());
        this.fileWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Browse_F_ile_System____7, null);
        this.fileWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fileWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.fileLocationButton.getText());
        this.variablesWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_32, null);
        this.variablesWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.variablesWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.variablesWorkingDirectoryButton.getText());
    }

    protected String getWorkingDirectoryLabel() {
        return ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Working__Directory__5;
    }

    protected void createArgumentComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab__Arguments___1;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        group.setFont(parent.getFont());
        this.argumentField = new Text((Composite)group, 2626);
        gridData = new GridData(1808);
        gridData.widthHint = 200;
        gridData.heightHint = 30;
        this.argumentField.setLayoutData((Object)gridData);
        this.argumentField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentField, group.getText());
        Composite composite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        gridData = new GridData(128);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        composite.setFont(parent.getFont());
        this.argumentVariablesButton = this.createPushButton(composite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Varia_bles____2, null);
        this.argumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentVariablesButton, this.argumentVariablesButton.getText());
        Label instruction = new Label((Composite)group, 0);
        instruction.setText(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_3);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        instruction.setLayoutData((Object)gridData);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(FIRST_EDIT, true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        this.updateLocation(configuration);
        this.updateWorkingDirectory(configuration);
        this.updateArgument(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    protected void updateWorkingDirectory(ILaunchConfiguration configuration) {
        String workingDir = "";
        try {
            workingDir = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", "");
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Error_reading_configuration_10, ce);
        }
        this.workDirectoryField.setText(workingDir);
    }

    protected void updateLocation(ILaunchConfiguration configuration) {
        String location = "";
        try {
            location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Error_reading_configuration_10, ce);
        }
        this.locationField.setText(location);
    }

    protected void updateArgument(ILaunchConfiguration configuration) {
        String arguments = "";
        try {
            arguments = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "");
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Error_reading_configuration_7, ce);
        }
        this.argumentField.setText(arguments);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String location = this.locationField.getText().trim();
        if (location.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
        }
        String workingDirectory = this.workDirectoryField.getText().trim();
        if (workingDirectory.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDirectory);
        }
        String arguments = this.argumentField.getText().trim();
        if (arguments.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
        }
        if (this.userEdited) {
            configuration.setAttribute(FIRST_EDIT, null);
        }
    }

    public String getName() {
        return ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab__Main_17;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean newConfig = false;
        try {
            newConfig = launchConfig.getAttribute(FIRST_EDIT, false);
        }
        catch (CoreException coreException) {}
        return this.validateLocation(newConfig) && this.validateWorkDirectory();
    }

    protected boolean validateLocation(boolean newConfig) {
        String location = this.locationField.getText().trim();
        if (location.length() < 1) {
            if (newConfig) {
                this.setErrorMessage(null);
                this.setMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_30);
            } else {
                this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_External_tool_location_cannot_be_empty_18);
                this.setMessage(null);
            }
            return false;
        }
        String expandedLocation = null;
        try {
            expandedLocation = this.resolveValue(location);
            if (expandedLocation == null) {
                return true;
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
        File file = new File(expandedLocation);
        if (!file.exists()) {
            if (!newConfig) {
                this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_External_tool_location_does_not_exist_19);
            }
            return false;
        }
        if (!file.isFile()) {
            if (!newConfig) {
                this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_External_tool_location_specified_is_not_a_file_20);
            }
            return false;
        }
        return true;
    }

    private void validateVaribles(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        manager.validateStringVariables(expression);
    }

    private String resolveValue(String expression) throws CoreException {
        String expanded = null;
        try {
            expanded = this.getValue(expression);
        }
        catch (CoreException coreException) {
            this.validateVaribles(expression);
            return null;
        }
        return expanded;
    }

    private String getValue(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(expression);
    }

    protected boolean validateWorkDirectory() {
        String dir = this.workDirectoryField.getText().trim();
        if (dir.length() <= 0) {
            return true;
        }
        String expandedDir = null;
        try {
            expandedDir = this.resolveValue(dir);
            if (expandedDir == null) {
                return true;
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
        File file = new File(expandedDir);
        if (!file.exists()) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_External_tool_working_directory_does_not_exist_or_is_invalid_21);
            return false;
        }
        if (!file.isDirectory()) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Not_a_directory);
            return false;
        }
        return true;
    }

    protected void handleFileLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String text = fileDialog.open();
        if (text != null) {
            this.locationField.setText(text);
        }
    }

    protected void handleWorkspaceLocationButtonSelected() {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Select_a_resource_22);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IResource resource = (IResource)results[0];
        this.locationField.setText(this.newVariableExpression("workspace_loc", resource.getFullPath().toString()));
    }

    protected void handleWorkspaceWorkingDirectoryButtonSelected() {
        ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_23);
        containerDialog.open();
        Object[] resource = containerDialog.getResult();
        String text = null;
        if (resource != null && resource.length > 0) {
            text = this.newVariableExpression("workspace_loc", ((IPath)resource[0]).toString());
        }
        if (text != null) {
            this.workDirectoryField.setText(text);
        }
    }

    protected String newVariableExpression(String varName, String arg) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(varName, arg);
    }

    protected void handleFileWorkingDirectoryButtonSelected() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_23);
        dialog.setFilterPath(this.workDirectoryField.getText());
        String text = dialog.open();
        if (text != null) {
            this.workDirectoryField.setText(text);
        }
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    public Image getImage() {
        return ExternalToolsImages.getImage("org.eclipse.ui.externaltools.IMG_TAB_MAIN");
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuffer stripped = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!ExternalToolsMainTab.this.fInitializing) {
                ExternalToolsMainTab.this.setDirty(true);
                ExternalToolsMainTab.this.userEdited = true;
                ExternalToolsMainTab.this.updateLaunchConfigurationDialog();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            ExternalToolsMainTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == ExternalToolsMainTab.this.workspaceLocationButton) {
                ExternalToolsMainTab.this.handleWorkspaceLocationButtonSelected();
            } else if (source == ExternalToolsMainTab.this.fileLocationButton) {
                ExternalToolsMainTab.this.handleFileLocationButtonSelected();
            } else if (source == ExternalToolsMainTab.this.workspaceWorkingDirectoryButton) {
                ExternalToolsMainTab.this.handleWorkspaceWorkingDirectoryButtonSelected();
            } else if (source == ExternalToolsMainTab.this.fileWorkingDirectoryButton) {
                ExternalToolsMainTab.this.handleFileWorkingDirectoryButtonSelected();
            } else if (source == ExternalToolsMainTab.this.argumentVariablesButton) {
                ExternalToolsMainTab.this.handleVariablesButtonSelected(ExternalToolsMainTab.this.argumentField);
            } else if (source == ExternalToolsMainTab.this.variablesLocationButton) {
                ExternalToolsMainTab.this.handleVariablesButtonSelected(ExternalToolsMainTab.this.locationField);
            } else if (source == ExternalToolsMainTab.this.variablesWorkingDirectoryButton) {
                ExternalToolsMainTab.this.handleVariablesButtonSelected(ExternalToolsMainTab.this.workDirectoryField);
            }
        }
    }
}

