/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.internal.databinding.observable.tree.IUnorderedTreeProvider;
import org.eclipse.jface.internal.databinding.provisional.viewers.IParentProvider;
import org.eclipse.jface.internal.databinding.provisional.viewers.TreeNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class UnorderedTreeContentProvider
implements ITreeContentProvider,
ITreePathContentProvider {
    private HashMap mapElementToTreeNode = new HashMap();
    private LinkedList enqueuedPrefetches = new LinkedList();
    private IParentProvider rootParentProvider = null;
    private boolean useTreePaths = false;
    KnownElementsSet elements = new KnownElementsSet();
    private ITreeViewerListener expandListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }
    };
    private IUnorderedTreeProvider provider;
    private Object pendingNode;
    private int avoidViewerUpdates;
    private TreeViewer treeViewer;
    private int staleCount = 0;
    private boolean useRefresh;
    private int maxPrefetches = 0;

    public UnorderedTreeContentProvider(IUnorderedTreeProvider provider, Object pendingNode, boolean useRefresh) {
        this.provider = provider;
        this.pendingNode = pendingNode;
        this.useRefresh = useRefresh;
    }

    public void useTreePaths(boolean usePaths) {
        this.useTreePaths = usePaths;
    }

    public void setRootPath(IParentProvider rootParentProvider) {
        this.rootParentProvider = rootParentProvider;
    }

    public void setMaxPrefetches(int maxPrefetches) {
        this.maxPrefetches = maxPrefetches;
    }

    IObservableSet createChildSet(Object element) {
        return this.provider.createChildSet(element);
    }

    void remove(Object element, Set removals, boolean lastElement) {
        if (removals.isEmpty()) {
            return;
        }
        if (this.avoidViewerUpdates == 0) {
            if (lastElement || this.useRefresh) {
                this.doRefresh(element);
            } else if (this.useTreePaths) {
                ArrayList<TreePath> toRemove = new ArrayList<TreePath>();
                TreePath[] parents = this.getParents(element);
                int i = 0;
                while (i < parents.length) {
                    TreePath parent = parents[i];
                    Iterator iter = removals.iterator();
                    while (iter.hasNext()) {
                        Object elementToRemove = iter.next();
                        toRemove.add(parent.createChildPath(element).createChildPath(elementToRemove));
                    }
                    ++i;
                }
                this.treeViewer.remove((Object[])toRemove.toArray(new TreePath[toRemove.size()]));
            } else {
                this.treeViewer.remove(element, removals.toArray());
            }
            Iterator iter = removals.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                TreeNode nextNode = (TreeNode)this.mapElementToTreeNode.get(next);
                if (nextNode == null) continue;
                nextNode.removeParent(element);
                this.removeIfUnused(nextNode);
            }
        }
    }

    void add(Object element, Set additions) {
        if (additions.isEmpty()) {
            return;
        }
        if (this.avoidViewerUpdates == 0) {
            this.addParent(element, additions);
            if (this.useRefresh) {
                this.doRefresh(element);
            } else if (this.useTreePaths) {
                TreePath[] parents = this.getParents(element);
                int i = 0;
                while (i < parents.length) {
                    TreePath parent = parents[i];
                    this.treeViewer.add((Object)parent.createChildPath(element), additions.toArray());
                    ++i;
                }
            } else {
                this.treeViewer.add(element, additions.toArray());
            }
        }
    }

    private void doRefresh(Object element) {
        this.treeViewer.refresh(element);
    }

    private void addParent(Object parent, Set children) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            TreeNode nextNode = this.getNode(next);
            nextNode.addParent(parent);
        }
    }

    public final Object getPendingNode() {
        return this.pendingNode;
    }

    public IObservableSet getChildrenSet(Object parent) {
        IObservableSet result = this.getNode(parent).getChildrenSet();
        return result;
    }

    public void dispose() {
        if (this.treeViewer != null) {
            try {
                ++this.avoidViewerUpdates;
                this.enqueuedPrefetches.clear();
                Object[] keys = this.mapElementToTreeNode.keySet().toArray();
                int i = 0;
                while (i < keys.length) {
                    Object key = keys[i];
                    TreeNode result = (TreeNode)this.mapElementToTreeNode.get(key);
                    if (result != null) {
                        result.dispose();
                    }
                    ++i;
                }
                this.setViewer(null);
            }
            finally {
                --this.avoidViewerUpdates;
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.setViewer(viewer);
        if (oldInput != null && newInput != null && oldInput.equals(newInput)) {
            return;
        }
        try {
            ++this.avoidViewerUpdates;
            TreeNode oldNode = (TreeNode)this.mapElementToTreeNode.get(oldInput);
            if (oldNode != null) {
                this.removeIfUnused(oldNode);
            }
        }
        finally {
            --this.avoidViewerUpdates;
        }
    }

    private void removeIfUnused(TreeNode toRemove) {
        Object element = toRemove.getElement();
        if (toRemove.getParent() == null) {
            this.mapElementToTreeNode.remove(element);
            this.elements.doFireDiff(Collections.EMPTY_SET, Collections.singleton(element));
            toRemove.dispose();
        }
    }

    private void setViewer(Viewer viewer) {
        if (viewer != null && !(viewer instanceof TreeViewer)) {
            throw new IllegalArgumentException("This content provider can only be used with TreeViewers");
        }
        TreeViewer newTreeViewer = (TreeViewer)viewer;
        if (newTreeViewer != this.treeViewer) {
            if (this.treeViewer != null) {
                this.treeViewer.removeTreeListener(this.expandListener);
            }
            this.treeViewer = newTreeViewer;
            if (newTreeViewer != null) {
                newTreeViewer.addTreeListener(this.expandListener);
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set result = this.getNode(parentElement).getChildren();
        this.addParent(parentElement, result);
        return result.toArray();
    }

    private TreeNode getNode(Object parentElement) {
        TreeNode result = (TreeNode)this.mapElementToTreeNode.get(parentElement);
        if (result == null) {
            result = new TreeNode(parentElement, this);
            this.mapElementToTreeNode.put(parentElement, result);
            this.elements.fireSetChange(Diffs.createSetDiff(Collections.singleton(parentElement), (Set)Collections.EMPTY_SET));
        }
        return result;
    }

    public Object getParent(Object element) {
        Object result = this.getNode(element).getParent();
        if (result == null && this.rootParentProvider != null) {
            result = this.rootParentProvider.getParent(element);
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.getNode(element).shouldShowPlus();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public IObservableSet getKnownElements() {
        return this.elements;
    }

    void changeStale(int staleDelta) {
        this.staleCount += staleDelta;
        this.processPrefetches();
        this.elements.setStale(this.staleCount != 0);
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public boolean isDirty(Object element) {
        return false;
    }

    void enqueuePrefetch(TreeNode node) {
        if (this.maxPrefetches > 0 || this.maxPrefetches == -1) {
            if (this.staleCount == 0) {
                node.getChildren();
            } else {
                this.enqueuedPrefetches.add(node);
                while (this.maxPrefetches >= 0 && this.enqueuedPrefetches.size() > this.maxPrefetches) {
                    this.enqueuedPrefetches.removeFirst();
                }
            }
        }
    }

    private void processPrefetches() {
        while (this.staleCount == 0 && !this.enqueuedPrefetches.isEmpty()) {
            TreeNode next = (TreeNode)this.enqueuedPrefetches.removeLast();
            if (next.isDisposed()) continue;
            next.prefetch();
        }
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.getChildren(parentPath.getLastSegment());
    }

    public TreePath[] getParents(Object element) {
        Object nextParent;
        List parentPaths = this.computeParents(element, new HashSet());
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        Iterator iterator = parentPaths.iterator();
        while (iterator.hasNext()) {
            List nextPath = (List)iterator.next();
            LinkedList<Object> resultPath = new LinkedList<Object>();
            resultPath.addAll(nextPath);
            Object nextParent2 = resultPath.isEmpty() ? element : resultPath.getFirst();
            while (nextParent2 != null) {
                if (this.rootParentProvider != null) {
                    if ((nextParent2 = this.rootParentProvider.getParent(nextParent2)) == null) continue;
                    resultPath.addFirst(nextParent2);
                    continue;
                }
                nextParent2 = null;
            }
            result.add(new TreePath(resultPath.toArray()));
        }
        if (result.isEmpty() && this.rootParentProvider != null && (nextParent = this.rootParentProvider.getParent(element)) != null) {
            LinkedList<Object> resultPath = new LinkedList<Object>();
            while (nextParent != null) {
                resultPath.addFirst(nextParent);
                nextParent = this.rootParentProvider.getParent(nextParent);
            }
            result.add(new TreePath(resultPath.toArray()));
        }
        return result.toArray(new TreePath[result.size()]);
    }

    private List computeParents(Object node, HashSet toIgnore) {
        ArrayList<List> result = new ArrayList<List>();
        boolean containedNode = toIgnore.add(node);
        TreeNode tn = this.getNode(node);
        HashSet parents = new HashSet();
        parents.addAll(tn.getParents());
        parents.removeAll(toIgnore);
        if (parents.isEmpty()) {
            ArrayList newPath = new ArrayList();
            result.add(newPath);
        } else {
            Iterator iterator = parents.iterator();
            while (iterator.hasNext()) {
                Object parent = iterator.next();
                List parentPaths = this.computeParents(parent, toIgnore);
                Iterator iterator2 = parentPaths.iterator();
                while (iterator2.hasNext()) {
                    List parentPath = (List)iterator2.next();
                    parentPath.add(parent);
                    result.add(parentPath);
                }
            }
        }
        if (containedNode) {
            toIgnore.remove(node);
        }
        return result;
    }

    public boolean hasChildren(TreePath path) {
        return this.hasChildren(path.getLastSegment());
    }

    class KnownElementsSet
    extends AbstractObservableSet {
        protected KnownElementsSet() {
        }

        protected Set getWrappedSet() {
            return UnorderedTreeContentProvider.this.mapElementToTreeNode.keySet();
        }

        void doFireDiff(Set added, Set removed) {
            this.fireSetChange(Diffs.createSetDiff((Set)added, (Set)removed));
        }

        public void fireSetChange(SetDiff diff) {
            super.fireSetChange(diff);
        }

        void doFireStale(boolean isStale) {
            if (isStale) {
                this.fireStale();
            } else {
                this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, (Set)Collections.EMPTY_SET));
            }
        }

        public Object getElementType() {
            return new Object();
        }
    }
}

