/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.PixelConverter;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.quickdiff.QuickDiff;
import org.eclipse.ui.texteditor.quickdiff.ReferenceProviderDescriptor;

class QuickDiffConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            QuickDiffConfigurationBlock.this.fStore.setValue((String)QuickDiffConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Combo fQuickDiffProviderCombo;
    private String[][] fQuickDiffProviderListModel;
    private String[][] fQuickDiffModel;
    private ColorSelector[] fQuickDiffColorEditors;
    private Button fQuickDiffOverviewRulerCheckBox;
    private Button fEnablementCheckbox;

    public QuickDiffConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.fStore.addKeys(this.createOverlayStoreKeys(markerAnnotationPreferences));
        this.fQuickDiffModel = this.createQuickDiffModel(markerAnnotationPreferences);
        this.fQuickDiffProviderListModel = this.createQuickDiffReferenceListModel();
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "quickdiff.quickDiff"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "quickdiff.defaultProvider"));
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (!info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") && !info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") && !info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getOverviewRulerPreferenceKey()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private String[][] createQuickDiffModel(MarkerAnnotationPreferences preferences) {
        String[][] items = new String[3][];
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange")) {
                items[0] = new String[]{info.getColorPreferenceKey(), info.getOverviewRulerPreferenceKey(), TextEditorMessages.QuickDiffConfigurationBlock_changeColor};
                continue;
            }
            if (info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition")) {
                items[1] = new String[]{info.getColorPreferenceKey(), info.getOverviewRulerPreferenceKey(), TextEditorMessages.QuickDiffConfigurationBlock_additionColor};
                continue;
            }
            if (!info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            items[2] = new String[]{info.getColorPreferenceKey(), info.getOverviewRulerPreferenceKey(), TextEditorMessages.QuickDiffConfigurationBlock_deletionColor};
        }
        return items;
    }

    private String[][] createQuickDiffReferenceListModel() {
        List descriptors = new QuickDiff().getReferenceProviderDescriptors();
        ArrayList<String[]> listModelItems = new ArrayList<String[]>();
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            ReferenceProviderDescriptor descriptor = (ReferenceProviderDescriptor)it.next();
            String label = LegacyActionTools.removeMnemonics((String)descriptor.getLabel());
            listModelItems.add(new String[]{descriptor.getId(), label});
        }
        String[][] items = new String[listModelItems.size()][];
        listModelItems.toArray((T[])items);
        return items;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        String label = TextEditorMessages.QuickDiffConfigurationBlock_showForNewEditors;
        this.fEnablementCheckbox = this.addCheckBox(composite, label, "quickdiff.quickDiff", 0);
        this.fEnablementCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = QuickDiffConfigurationBlock.this.fEnablementCheckbox.getSelection();
                QuickDiffConfigurationBlock.this.fStore.setValue("spellingEnabled", enabled);
                QuickDiffConfigurationBlock.this.updateEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addFiller(composite);
        label = TextEditorMessages.QuickDiffConfigurationBlock_showInOverviewRuler;
        this.fQuickDiffOverviewRulerCheckBox = new Button(composite, 32);
        this.fQuickDiffOverviewRulerCheckBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = 0;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 10;
        this.fQuickDiffOverviewRulerCheckBox.setLayoutData((Object)gd);
        this.fQuickDiffOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < QuickDiffConfigurationBlock.this.fQuickDiffModel.length) {
                    QuickDiffConfigurationBlock.this.fStore.setValue(QuickDiffConfigurationBlock.this.fQuickDiffModel[i][1], QuickDiffConfigurationBlock.this.fQuickDiffOverviewRulerCheckBox.getSelection());
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label l = new Label(composite, 16384);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 10;
        gd.heightHint = 5;
        l.setLayoutData((Object)gd);
        Group group = new Group(composite, 0);
        group.setText(TextEditorMessages.QuickDiffConfigurationBlock_colorTitle);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 10;
        group.setLayoutData((Object)gd);
        this.fQuickDiffColorEditors = new ColorSelector[3];
        int i = 0;
        while (i < this.fQuickDiffModel.length) {
            ColorSelector editor;
            label = this.fQuickDiffModel[i][2];
            l = new Label((Composite)group, 16384);
            l.setText(label);
            this.fQuickDiffColorEditors[i] = editor = new ColorSelector((Composite)group);
            Button changeColorButton = editor.getButton();
            gd = new GridData(768);
            gd.horizontalAlignment = 1;
            changeColorButton.setLayoutData((Object)gd);
            final int index = i++;
            changeColorButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String key = QuickDiffConfigurationBlock.this.fQuickDiffModel[index][0];
                    PreferenceConverter.setValue((IPreferenceStore)QuickDiffConfigurationBlock.this.fStore, (String)key, (RGB)editor.getColorValue());
                }
            });
        }
        this.addFiller(composite);
        l = new Label(composite, 16384);
        l.setText(TextEditorMessages.QuickDiffConfigurationBlock_referenceProviderTitle);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 10;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 10;
        editorComposite.setLayoutData((Object)gd);
        this.fQuickDiffProviderCombo = new Combo(editorComposite, 12);
        gd = new GridData(770);
        this.fQuickDiffProviderCombo.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fQuickDiffProviderCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = QuickDiffConfigurationBlock.this.fQuickDiffProviderCombo.getSelectionIndex();
                QuickDiffConfigurationBlock.this.fStore.setValue("quickdiff.defaultProvider", QuickDiffConfigurationBlock.this.fQuickDiffProviderListModel[i][0]);
            }
        });
        return composite;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private void updateEnablement() {
        boolean enabled = this.fEnablementCheckbox.getSelection();
        this.fQuickDiffOverviewRulerCheckBox.setEnabled(enabled);
        this.fQuickDiffProviderCombo.setEnabled(enabled);
        int i = 0;
        while (i < this.fQuickDiffColorEditors.length) {
            this.fQuickDiffColorEditors[i].setEnabled(enabled);
            ++i;
        }
    }

    private void updateProviderList() {
        String defaultProvider = this.fStore.getString("quickdiff.defaultProvider");
        int j = 0;
        while (j < this.fQuickDiffProviderListModel.length) {
            if (defaultProvider.equals(this.fQuickDiffProviderListModel[j][0])) {
                this.fQuickDiffProviderCombo.select(j);
            }
            ++j;
        }
        this.fQuickDiffProviderCombo.redraw();
    }

    public void initialize() {
        int i = 0;
        while (i < this.fQuickDiffProviderListModel.length) {
            String label = this.fQuickDiffProviderListModel[i][1];
            this.fQuickDiffProviderCombo.add(label);
            ++i;
        }
        this.fQuickDiffProviderCombo.getDisplay().asyncExec(new Runnable(){

            public void run() {
                QuickDiffConfigurationBlock.this.updateProviderList();
            }
        });
        this.initializeFields();
    }

    private void initializeFields() {
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fStore.getBoolean(key));
        }
        this.updateQuickDiffControls();
    }

    public boolean canPerformOk() {
        return true;
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.initializeFields();
        this.updateProviderList();
    }

    private void updateQuickDiffControls() {
        boolean quickdiffOverviewRuler = false;
        int i = 0;
        while (i < this.fQuickDiffModel.length) {
            this.fQuickDiffColorEditors[i].setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)this.fQuickDiffModel[i][0]));
            quickdiffOverviewRuler |= this.fStore.getBoolean(this.fQuickDiffModel[i][1]);
            ++i;
        }
        this.fQuickDiffOverviewRulerCheckBox.setSelection(quickdiffOverviewRuler);
    }

    public void dispose() {
    }
}

