/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;

public class JsPathIndexer {
    static final boolean DEBUG;

    static {
        String string = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspsearch");
        DEBUG = string != null && string.equalsIgnoreCase("true");
    }

    public IPath[] getVisibleJspPaths(SearchPattern searchPattern, IJavaSearchScope iJavaSearchScope) {
        JSPFileVisitor jSPFileVisitor = new JSPFileVisitor(searchPattern, iJavaSearchScope);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)jSPFileVisitor, 0);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return jSPFileVisitor.getPaths();
    }

    class JSPFileVisitor
    implements IResourceProxyVisitor {
        private HashMap fPaths = new HashMap();
        SearchPattern fPattern = null;
        IJavaSearchScope fScope = null;

        public JSPFileVisitor(SearchPattern searchPattern, IJavaSearchScope iJavaSearchScope) {
            this.fPattern = searchPattern;
            this.fScope = iJavaSearchScope;
        }

        public IPath[] getPaths() {
            return this.fPaths.values().toArray(new IPath[this.fPaths.size()]);
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            if (JsSearchSupport.getInstance().isCanceled()) {
                return false;
            }
            if (iResourceProxy.getType() == 1) {
                if (Util.isJsType(iResourceProxy.getName())) {
                    IFile iFile = (IFile)iResourceProxy.requestResource();
                    IContentDescription iContentDescription = iFile.getContentDescription();
                    if (iContentDescription != null) {
                        iContentDescription.getContentType().getId();
                    }
                    if (this.fScope.encloses(iResourceProxy.requestFullPath().toString())) {
                        if (DEBUG) {
                            System.out.println("adding selected index path:" + iFile.getParent().getFullPath());
                        }
                        this.fPaths.put(iFile.getParent().getFullPath(), JsSearchSupport.getInstance().computeIndexLocation(iFile.getParent().getFullPath()));
                    }
                }
                return false;
            }
            return true;
        }
    }
}

