/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java.search;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JSDTSearchDocumentDelegate;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsPathIndexer;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.core.internal.java.search.NullSearchDocument;

public class JsSearchParticipant
extends SearchParticipant {
    private static final boolean DEBUG = JsSearchParticipant.calculateValue();

    private static boolean calculateValue() {
        String string = Platform.getDebugOption((String)"org.eclipse.jstd.jsp.core/debug/jspsearch");
        boolean bl = string != null && string.equalsIgnoreCase("true");
        return bl;
    }

    public String getDescription() {
        return "Embeded JavaScript";
    }

    public SearchDocument getDocument(IFile iFile) {
        return null;
    }

    public SearchDocument getDocument(String string) {
        SearchDocument searchDocument = JsSearchSupport.getInstance().getSearchDocument(string);
        if (searchDocument == null) {
            return new NullSearchDocument(string);
        }
        return searchDocument;
    }

    public void indexDocument(SearchDocument searchDocument, IPath iPath) {
        if (!(searchDocument instanceof JSDTSearchDocumentDelegate)) {
            return;
        }
        SearchEngine.getDefaultSearchParticipant().indexDocument(searchDocument, iPath);
    }

    public void locateMatches(SearchDocument[] searchDocumentArray, SearchPattern searchPattern, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        ArrayList<SearchDocument> arrayList = new ArrayList<SearchDocument>();
        SearchDocument searchDocument = null;
        int n = 0;
        while (n < searchDocumentArray.length) {
            if (DEBUG) {
                System.out.println("found possible matching JavaSearchDocumentDelegate: " + searchDocumentArray[n]);
            }
            if ((searchDocument = searchDocumentArray[n]) != null && searchDocument instanceof JSDTSearchDocumentDelegate && ((JSDTSearchDocumentDelegate)searchDocument).getFile().exists()) {
                arrayList.add(searchDocument);
            }
            ++n;
        }
        searchDocumentArray = arrayList.toArray(new SearchDocument[arrayList.size()]);
        SearchEngine.getDefaultSearchParticipant().locateMatches(searchDocumentArray, searchPattern, iJavaSearchScope, searchRequestor, iProgressMonitor);
    }

    public IPath[] selectIndexes(SearchPattern searchPattern, IJavaSearchScope iJavaSearchScope) {
        JsPathIndexer jsPathIndexer = new JsPathIndexer();
        return jsPathIndexer.getVisibleJspPaths(searchPattern, iJavaSearchScope);
    }
}

