/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.project;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JsWebNature
implements IProjectNature {
    private static final String[] NATURE_IDS = new String[]{"org.eclipse.wst.jsdt.core.jsNature"};
    public static final IPath VIRTUAL_BROWSER_CLASSPATH = new Path("org.eclipse.wst.jsdt.launching.baseBrowserLibrary");
    public static final String VIRTUAL_CONTAINER = "org.eclipse.wst.jsdt.launching.WebProject";
    public static final IClasspathEntry VIRTUAL_SCOPE_ENTRY = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.wst.jsdt.launching.WebProject"));
    private static final String SUPER_TYPE_NAME = "Window";
    private static final String SUPER_TYPE_LIBRARY = "org.eclipse.wst.jsdt.launching.baseBrowserLibrary";
    private Vector classPathEntries = new Vector();
    private boolean DEBUG = false;
    private IProject fCurrProject;
    private JavaProject fJavaProject;
    private IPath fOutputLocation;
    private IProgressMonitor monitor;

    public static void addJsNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!JsWebNature.hasNature(iProject)) {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length + NATURE_IDS.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            int n = 0;
            while (n < NATURE_IDS.length) {
                stringArray2[stringArray.length + n] = NATURE_IDS[n];
                ++n;
            }
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        } else if (iProgressMonitor != null) {
            iProgressMonitor.worked(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasNature(IProject iProject) {
        try {
            int n = 0;
            while (true) {
                if (n >= NATURE_IDS.length) {
                    return true;
                }
                if (!iProject.hasNature(NATURE_IDS[n])) {
                    return false;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static void removeJsNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (JsWebNature.hasNature(iProject)) {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length - NATURE_IDS.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                block7: {
                    int n3 = 0;
                    while (n3 < NATURE_IDS.length) {
                        if (stringArray[n2] != NATURE_IDS[n3]) {
                            ++n3;
                            continue;
                        }
                        break block7;
                    }
                    stringArray2[n++] = stringArray[n2];
                }
                ++n2;
            }
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        } else if (iProgressMonitor != null) {
            iProgressMonitor.worked(1);
        }
    }

    public JsWebNature() {
        this.monitor = new NullProgressMonitor();
    }

    public JsWebNature(IProject iProject, IProgressMonitor iProgressMonitor) {
        this.fCurrProject = iProject;
        if (iProgressMonitor != null) {
            this.monitor = iProgressMonitor;
        } else {
            iProgressMonitor = new NullProgressMonitor();
        }
    }

    public void configure() throws CoreException {
        LibrarySuperType librarySuperType;
        this.initOutputPath();
        this.createSourceClassPath();
        this.initJREEntry();
        this.initLocalClassPath();
        if (this.hasProjectClassPathFile() && (librarySuperType = this.getRawClassPath()) != null && ((IClasspathEntry[])librarySuperType).length > 0) {
            this.classPathEntries.removeAll(Arrays.asList(librarySuperType));
            this.classPathEntries.addAll(Arrays.asList(librarySuperType));
        }
        JsWebNature.addJsNature(this.fCurrProject, this.monitor);
        this.fJavaProject = (JavaProject)JavaCore.create((IProject)this.fCurrProject);
        this.fJavaProject.setProject(this.fCurrProject);
        try {
            if (!this.hasProjectClassPathFile()) {
                this.fJavaProject.setRawClasspath(this.classPathEntries.toArray(new IClasspathEntry[0]), this.fOutputLocation, this.monitor);
            } else {
                this.fJavaProject.setRawClasspath(this.classPathEntries.toArray(new IClasspathEntry[0]), this.monitor);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        librarySuperType = new LibrarySuperType((IPath)new Path(SUPER_TYPE_LIBRARY), (IJavaProject)this.getJavaProject(), SUPER_TYPE_NAME);
        this.getJavaProject().setCommonSuperType(librarySuperType);
        this.fCurrProject.refreshLocal(2, this.monitor);
    }

    private void createSourceClassPath() {
        if (this.hasAValidSourcePath()) {
            return;
        }
    }

    public void deconfigure() throws CoreException {
        Vector<IClasspathEntry> vector = new Vector<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = PreferenceConstants.getDefaultJRELibrary();
        IClasspathEntry[] iClasspathEntryArray2 = this.initLocalClassPath();
        vector.addAll(Arrays.asList(iClasspathEntryArray));
        vector.addAll(Arrays.asList(iClasspathEntryArray2));
        IClasspathEntry[] iClasspathEntryArray3 = this.getRawClassPath();
        Vector<IClasspathEntry> vector2 = new Vector<IClasspathEntry>();
        int n = 0;
        while (n < iClasspathEntryArray3.length) {
            if (!vector.contains(iClasspathEntryArray3[n])) {
                vector2.add(iClasspathEntryArray3[n]);
            }
            ++n;
        }
        IPath iPath = this.getJavaProject().getOutputLocation();
        this.getJavaProject().setRawClasspath(vector2.toArray(new IClasspathEntry[0]), iPath, this.monitor);
        this.getJavaProject().deconfigure();
        JsWebNature.removeJsNature(this.fCurrProject, this.monitor);
        this.fCurrProject.refreshLocal(2, this.monitor);
    }

    public JavaProject getJavaProject() {
        if (this.fJavaProject == null) {
            this.fJavaProject = (JavaProject)JavaCore.create((IProject)this.fCurrProject);
            this.fJavaProject.setProject(this.fCurrProject);
        }
        return this.fJavaProject;
    }

    public IProject getProject() {
        return this.fCurrProject;
    }

    private IClasspathEntry[] getRawClassPath() {
        JavaProject javaProject = new JavaProject();
        javaProject.setProject(this.fCurrProject);
        return javaProject.readRawClasspath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAValidSourcePath() {
        if (!this.hasProjectClassPathFile()) return false;
        try {
            IClasspathEntry[] iClasspathEntryArray = this.getRawClassPath();
            int n = 0;
            while (true) {
                if (n >= iClasspathEntryArray.length) {
                    return false;
                }
                if (iClasspathEntryArray[n].getEntryKind() == 3) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            if (!this.DEBUG) return false;
            System.out.println("Error checking sourcepath:" + exception);
        }
        return false;
    }

    private boolean hasProjectClassPathFile() {
        if (this.fCurrProject == null) {
            return false;
        }
        return this.fCurrProject.getFile(".jsdtscope").exists();
    }

    private void initJREEntry() {
        block4: {
            IClasspathEntry[] iClasspathEntryArray = PreferenceConstants.getDefaultJRELibrary();
            try {
                IClasspathEntry[] iClasspathEntryArray2 = this.getRawClassPath();
                int n = 0;
                while (n < iClasspathEntryArray2.length) {
                    if (iClasspathEntryArray2[n] == iClasspathEntryArray[0]) {
                        return;
                    }
                    ++n;
                }
                this.classPathEntries.add(iClasspathEntryArray[0]);
            }
            catch (Exception exception) {
                if (!this.DEBUG) break block4;
                System.out.println("Error checking sourcepath:" + exception);
            }
        }
    }

    private IClasspathEntry[] initLocalClassPath() {
        this.classPathEntries.add(VIRTUAL_SCOPE_ENTRY);
        IClasspathEntry iClasspathEntry = JavaCore.newContainerEntry((IPath)VIRTUAL_BROWSER_CLASSPATH);
        this.classPathEntries.add(iClasspathEntry);
        return new IClasspathEntry[]{VIRTUAL_SCOPE_ENTRY, iClasspathEntry};
    }

    private void initOutputPath() {
        if (this.fOutputLocation == null) {
            this.fOutputLocation = this.fCurrProject.getFullPath();
        }
    }

    public void setProject(IProject iProject) {
        this.fCurrProject = iProject;
    }
}

