/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.debug.model.JSLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.wst.jsdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.wst.jsdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.wst.jsdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;

public class BreakpointLocationVerifierJob
extends Job {
    private IDocument fDocument;
    private JSLineBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fTypeName;
    private IJavaElement fType;
    private boolean fBestMatch;
    private IResource fResource;
    private IEditorPart fEditorPart;
    private IEditorStatusLine fStatusLine;
    static /* synthetic */ Class class$0;

    public BreakpointLocationVerifierJob(IDocument iDocument, JSLineBreakpoint jSLineBreakpoint, int n, boolean bl, String string, IJavaElement iJavaElement, IResource iResource, IEditorPart iEditorPart) {
        super(ActionMessages.BreakpointLocationVerifierJob_breakpoint_location);
        this.fDocument = iDocument;
        this.fBreakpoint = jSLineBreakpoint;
        this.fLineNumber = n;
        this.fBestMatch = bl;
        this.fTypeName = string;
        this.fType = iJavaElement;
        this.fResource = iResource;
        this.fEditorPart = iEditorPart;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fStatusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz);
        this.setSystem(true);
    }

    public IStatus run(IProgressMonitor iProgressMonitor) {
        String string;
        String string2;
        Object object;
        Hashtable hashtable;
        ASTParser aSTParser = ASTParser.newParser((int)3);
        char[] cArray = this.fDocument.get().toCharArray();
        aSTParser.setSource(cArray);
        IJavaElement iJavaElement = JavaCore.create((IResource)this.fResource);
        IJavaProject iJavaProject = null;
        if (iJavaElement != null) {
            hashtable = JavaCore.getDefaultOptions();
            iJavaProject = iJavaElement.getJavaProject();
            object = "1.5";
            string2 = "1.5";
            if (iJavaProject != null) {
                object = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
                string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
            }
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.compliance", object);
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.source", string2);
            aSTParser.setCompilerOptions((Map)hashtable);
        }
        hashtable = (CompilationUnit)aSTParser.createAST(null);
        object = new ValidBreakpointLocationLocator((CompilationUnit)hashtable, this.fLineNumber, false, this.fBestMatch);
        hashtable.accept((ASTVisitor)object);
        if (((ValidBreakpointLocationLocator)((Object)object)).isBindingsRequired() && iJavaElement != null) {
            string2 = null;
            if (this.fType == null) {
                string = this.fResource.getName();
                if (JavaCore.isJavaLikeFileName((String)string)) {
                    string2 = string;
                }
            } else if (this.fType instanceof ICompilationUnit) {
                string2 = ((ICompilationUnit)this.fType).getElementName();
            } else if (this.fType instanceof IMember) {
                string = (IMember)this.fType;
                if (string.isBinary()) {
                    String string3 = string.getClassFile().getElementName();
                    int n = string3.indexOf(36);
                    if (n < 0) {
                        n = string3.indexOf(46);
                    }
                    string2 = String.valueOf(string3.substring(0, n)) + ".java";
                } else {
                    string2 = string.getCompilationUnit().getElementName();
                }
            }
            if (string2 != null) {
                aSTParser = ASTParser.newParser((int)3);
                aSTParser.setSource(cArray);
                aSTParser.setProject(iJavaProject);
                aSTParser.setUnitName(string2);
                aSTParser.setResolveBindings(true);
                hashtable = (CompilationUnit)aSTParser.createAST(null);
                object = new ValidBreakpointLocationLocator((CompilationUnit)hashtable, this.fLineNumber, true, this.fBestMatch);
                hashtable.accept((ASTVisitor)object);
            }
        }
        int n = ((ValidBreakpointLocationLocator)((Object)object)).getLineLocation();
        string = ((ValidBreakpointLocationLocator)((Object)object)).getFullyQualifiedTypeName();
        try {
            switch (((ValidBreakpointLocationLocator)((Object)object)).getLocationType()) {
                case 1: {
                    return this.manageLineBreakpoint(string, n);
                }
                case 2: {
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    new ToggleBreakpointAdapter().toggleMethodBreakpoints((IWorkbenchPart)this.fEditorPart, (ISelection)new TextSelection(((ValidBreakpointLocationLocator)((Object)object)).getMemberOffset(), 0));
                    break;
                }
                case 3: {
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    new ToggleBreakpointAdapter().toggleWatchpoints((IWorkbenchPart)this.fEditorPart, (ISelection)new TextSelection(((ValidBreakpointLocationLocator)((Object)object)).getMemberOffset(), 0));
                    break;
                }
                default: {
                    this.report(ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                }
            }
        }
        catch (CoreException coreException) {
            JDIDebugUIPlugin.log(coreException);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    public IStatus manageLineBreakpoint(String string, int n) {
        try {
            boolean bl;
            boolean bl2 = n != this.fLineNumber;
            JSLineBreakpoint jSLineBreakpoint = BreakpointUtils.lineBreakpointExists(this.fResource, string, n);
            boolean bl3 = bl = jSLineBreakpoint != null;
            if (this.fBreakpoint == null) {
                if (bl) {
                    if (bl2) {
                        this.report(MessageFormat.format((String)ActionMessages.BreakpointLocationVerifierJob_0, (Object[])new String[]{Integer.toString(n)}));
                        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                    }
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)jSLineBreakpoint, true);
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpointRemoved, null);
                }
                this.createNewBreakpoint(n, string);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
            }
            if (bl2) {
                if (bl) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    this.report(MessageFormat.format((String)ActionMessages.BreakpointLocationVerifierJob_0, (Object[])new String[]{Integer.toString(n)}));
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                }
                this.replaceBreakpoint(n, string);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.BreakpointLocationVerifierJob_breakpointMovedToValidPosition, null);
            }
            if (!string.equals(this.fTypeName)) {
                this.replaceBreakpoint(n, string);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.BreakpointLocationVerifierJob_breakpointSetToRightType, null);
            }
        }
        catch (CoreException coreException) {
            JDIDebugUIPlugin.log(coreException);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    private void replaceBreakpoint(int n, String string) throws CoreException {
        this.createNewBreakpoint(n, string);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
    }

    private void createNewBreakpoint(int n, String string) throws CoreException {
        HashMap hashMap = new HashMap(10);
        if (this.fType != null) {
            try {
                IRegion iRegion = this.fDocument.getLineInformation(n - 1);
                int n2 = iRegion.getOffset();
                int n3 = n2 + iRegion.getLength() - 1;
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(hashMap, this.fType, n2, n3);
            }
            catch (BadLocationException badLocationException) {
                JDIDebugUIPlugin.log(badLocationException);
            }
        }
        BreakpointUtils.createLineBreakpoint(this.fDocument, this.fEditorPart.getEditorInput(), n, -1, -1, 0, true, hashMap);
    }

    protected void report(final String string) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (BreakpointLocationVerifierJob.this.fStatusLine != null) {
                    BreakpointLocationVerifierJob.this.fStatusLine.setMessage(true, string, null);
                }
                if (string != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }
}

