/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathContainerInitialzer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public abstract class ClasspathContainerInitializer
implements IClasspathContainerInitialzer,
IClasspathContainer {
    public static final int ATTRIBUTE_NOT_SUPPORTED = 1;
    public static final int ATTRIBUTE_READ_ONLY = 2;

    public void initialize(IPath iPath, IJavaProject iJavaProject) throws CoreException {
        JavaCore.setClasspathContainer(iPath, new IJavaProject[]{iJavaProject}, new IClasspathContainer[]{this.getContainer(iPath, iJavaProject)}, null);
    }

    protected IClasspathContainer getContainer(IPath iPath, IJavaProject iJavaProject) {
        return this;
    }

    public boolean canUpdateClasspathContainer(IPath iPath, IJavaProject iJavaProject) {
        if (iJavaProject == null || iPath == null) {
            return true;
        }
        LibrarySuperType librarySuperType = iJavaProject.getCommonSuperType();
        return librarySuperType != null && librarySuperType.getRawContainerPath().equals((Object)this.getPath());
    }

    public void requestClasspathContainerUpdate(IPath iPath, IJavaProject iJavaProject, IClasspathContainer iClasspathContainer) throws CoreException {
    }

    public String getDescription(IPath iPath, IJavaProject iJavaProject) {
        return iPath.makeRelative().toString();
    }

    public IClasspathContainer getFailureContainer(final IPath iPath, IJavaProject iJavaProject) {
        final String string = this.getDescription(iPath, iJavaProject);
        return new IClasspathContainer(){

            public IClasspathEntry[] getClasspathEntries() {
                return new IClasspathEntry[0];
            }

            public String getDescription() {
                return string;
            }

            public int getKind() {
                return 0;
            }

            public IPath getPath() {
                return iPath;
            }

            public String toString() {
                return this.getDescription();
            }
        };
    }

    public Object getComparisonID(IPath iPath, IJavaProject iJavaProject) {
        if (iPath == null) {
            return null;
        }
        return iPath.segment(0);
    }

    public URI getHostPath(IPath iPath, IJavaProject iJavaProject) {
        return null;
    }

    public boolean allowAttachJsDoc() {
        return true;
    }

    public String[] containerSuperTypes() {
        return new String[0];
    }

    public IClasspathEntry[] getClasspathEntries() {
        LibraryLocation libraryLocation = this.getLibraryLocation();
        char[][] cArray = libraryLocation.getLibraryFileNames();
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[cArray.length];
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            Path path = new Path(libraryLocation.getLibraryPath(cArray[n]));
            iClasspathEntryArray[n] = JavaCore.newLibraryEntry(path.makeAbsolute(), null, null, new IAccessRule[0], new IClasspathAttribute[0], true);
            ++n;
        }
        return iClasspathEntryArray;
    }

    public String getDescription() {
        return null;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return null;
    }

    public IStatus getAccessRulesStatus(IPath iPath, IJavaProject iJavaProject) {
        if (this.canUpdateClasspathContainer(iPath, iJavaProject)) {
            return Status.OK_STATUS;
        }
        return new JavaModelStatus(2);
    }

    public IStatus getAttributeStatus(IPath iPath, IJavaProject iJavaProject, String string) {
        if (this.canUpdateClasspathContainer(iPath, iJavaProject)) {
            return Status.OK_STATUS;
        }
        return new JavaModelStatus(2);
    }

    public IStatus getSourceAttachmentStatus(IPath iPath, IJavaProject iJavaProject) {
        if (this.canUpdateClasspathContainer(iPath, iJavaProject)) {
            return Status.OK_STATUS;
        }
        return new JavaModelStatus(2);
    }
}

