/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.DefaultASTVisitor;
import org.eclipse.wst.jsdt.core.dom.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

class DefaultCommentMapper {
    Comment[] comments;
    Scanner scanner;
    int leadingPtr;
    ASTNode[] leadingNodes;
    long[] leadingIndexes;
    int trailingPtr;
    int lastTrailingPtr;
    ASTNode[] trailingNodes;
    long[] trailingIndexes;
    static final int STORAGE_INCREMENT = 16;

    DefaultCommentMapper(Comment[] commentArray) {
        this.comments = commentArray;
    }

    boolean hasSameTable(Comment[] commentArray) {
        return this.comments == commentArray;
    }

    Comment getComment(int n) {
        if (this.comments == null) {
            return null;
        }
        int n2 = this.comments.length;
        if (n2 == 0) {
            return null;
        }
        int n3 = this.getCommentIndex(0, n, 0);
        if (n3 < 0) {
            return null;
        }
        return this.comments[n3];
    }

    private int getCommentIndex(int n, int n2, int n3) {
        if (n2 == 0) {
            if (this.comments.length > 0 && this.comments[0].getStartPosition() == 0) {
                return 0;
            }
            return -1;
        }
        int n4 = n;
        int n5 = this.comments.length - 1;
        int n6 = 0;
        int n7 = -1;
        Comment comment = null;
        while (n4 <= n5) {
            n6 = n4 + (n5 - n4) / 2;
            comment = this.comments[n6];
            int n8 = comment.getStartPosition();
            if (n2 < n8) {
                n5 = n6 - 1;
                continue;
            }
            if (n2 >= n8 + comment.getLength()) {
                n4 = n6 + 1;
                continue;
            }
            n7 = n6;
            break;
        }
        if (n7 < 0 && n3 != 0) {
            comment = this.comments[n6];
            if (n2 < comment.getStartPosition()) {
                return n3 < 0 ? n6 - 1 : n6;
            }
            return n3 < 0 ? n6 : n6 + 1;
        }
        return n7;
    }

    public int getExtendedStartPosition(ASTNode aSTNode) {
        if (this.leadingPtr >= 0) {
            long l = -1L;
            int n = 0;
            while (l < 0L && n <= this.leadingPtr) {
                if (this.leadingNodes[n] == aSTNode) {
                    l = this.leadingIndexes[n];
                }
                ++n;
            }
            if (l >= 0L) {
                return this.comments[(int)(l >> 32)].getStartPosition();
            }
        }
        return aSTNode.getStartPosition();
    }

    public final int getLineNumber(int n, int[] nArray) {
        int[] nArray2;
        int n2 = (nArray2 = this.scanner.lineEnds).length;
        return Util.getLineNumber(n, nArray2, (nArray[0] > n2 ? n2 : nArray[0]) - 1, (nArray[1] > n2 ? n2 : nArray[1]) - 1);
    }

    public int getExtendedEnd(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition() + aSTNode.getLength();
        if (this.trailingPtr >= 0) {
            long l = -1L;
            int n2 = 0;
            while (l < 0L && n2 <= this.trailingPtr) {
                if (this.trailingNodes[n2] == aSTNode) {
                    l = this.trailingIndexes[n2];
                }
                ++n2;
            }
            if (l >= 0L) {
                Comment comment = this.comments[(int)l];
                n = comment.getStartPosition() + comment.getLength();
            }
        }
        return n - 1;
    }

    public int getExtendedLength(ASTNode aSTNode) {
        return this.getExtendedEnd(aSTNode) - this.getExtendedStartPosition(aSTNode) + 1;
    }

    int firstLeadingCommentIndex(ASTNode aSTNode) {
        if (this.leadingPtr >= 0) {
            int n = 0;
            while (n <= this.leadingPtr) {
                if (this.leadingNodes[n] == aSTNode) {
                    return (int)(this.leadingIndexes[n] >> 32);
                }
                ++n;
            }
        }
        return -1;
    }

    int lastTrailingCommentIndex(ASTNode aSTNode) {
        if (this.trailingPtr >= 0) {
            int n = 0;
            while (n <= this.trailingPtr) {
                if (this.trailingNodes[n] == aSTNode) {
                    return (int)this.trailingIndexes[n];
                }
                ++n;
            }
        }
        return -1;
    }

    void initialize(CompilationUnit compilationUnit, Scanner scanner) {
        this.leadingPtr = -1;
        this.trailingPtr = -1;
        this.comments = compilationUnit.optionalCommentTable;
        if (this.comments == null) {
            return;
        }
        int n = this.comments.length;
        if (n == 0) {
            return;
        }
        this.scanner = scanner;
        this.scanner.tokenizeWhiteSpace = true;
        CommentMapperVisitor commentMapperVisitor = new CommentMapperVisitor();
        compilationUnit.accept(commentMapperVisitor);
        int n2 = this.leadingPtr + 1;
        if (n2 > 0 && n2 < this.leadingIndexes.length) {
            this.leadingNodes = new ASTNode[n2];
            System.arraycopy(this.leadingNodes, 0, this.leadingNodes, 0, n2);
            this.leadingIndexes = new long[n2];
            System.arraycopy(this.leadingIndexes, 0, this.leadingIndexes, 0, n2);
        }
        if (this.trailingPtr >= 0) {
            while (this.trailingIndexes[this.trailingPtr] == -1L) {
                --this.trailingPtr;
                if (this.trailingPtr >= 0) continue;
                this.trailingIndexes = null;
                this.trailingNodes = null;
                break;
            }
            int n3 = this.trailingPtr + 1;
            if (n3 > 0 && n3 < this.trailingIndexes.length) {
                this.trailingNodes = new ASTNode[n3];
                System.arraycopy(this.trailingNodes, 0, this.trailingNodes, 0, n3);
                this.trailingIndexes = new long[n3];
                System.arraycopy(this.trailingIndexes, 0, this.trailingIndexes, 0, n3);
            }
        }
        this.scanner = null;
    }

    int storeLeadingComments(ASTNode aSTNode, int n, int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n5 = aSTNode.getStartPosition();
        int n7 = this.getLineNumber(n, nArray);
        int n8 = this.getLineNumber(n5, nArray);
        int n9 = this.getCommentIndex(0, n5, -1);
        if (n9 == -1) {
            return n5;
        }
        int n10 = -1;
        int n11 = n9;
        int n12 = n5;
        while (n9 >= 0 && n12 >= n) {
            Comment comment = this.comments[n9];
            n4 = comment.getStartPosition();
            n3 = n4 + comment.getLength() - 1;
            n2 = this.getLineNumber(n4, nArray);
            if (n3 <= n || n2 == n7 && n2 != n8) break;
            if (n3 + 1 < n12) {
                this.scanner.resetTo(n3 + 1, n12);
                try {
                    int n13 = this.scanner.getNextToken();
                    if (n13 != 1000 || this.scanner.currentPosition != n12) {
                        if (n9 != n11) break;
                        return n5;
                    }
                }
                catch (InvalidInputException invalidInputException) {
                    return n5;
                }
                char[] cArray = this.scanner.getCurrentIdentifierSource();
                int n14 = 0;
                int n15 = -1;
                while ((n15 = CharOperation.indexOf('\n', cArray, n15 + 1)) >= 0) {
                    ++n14;
                }
                if (n14 > 1) break;
            }
            n12 = n4;
            n10 = n9--;
        }
        if (n10 != -1) {
            int n16 = this.comments[n10].getStartPosition();
            if (n < n16 && n7 != n8) {
                n4 = n;
                this.scanner.resetTo(n, n16);
                try {
                    while (this.scanner.currentPosition < n16) {
                        if (this.scanner.getNextToken() == 1000) continue;
                        n4 = this.scanner.getCurrentTokenEndPosition();
                    }
                }
                catch (InvalidInputException invalidInputException) {}
                n3 = this.getLineNumber(n4, nArray);
                n2 = this.comments.length;
                while (n10 < n2 && n3 == this.getLineNumber(this.comments[n10].getStartPosition(), nArray) && n8 != n3) {
                    ++n10;
                }
            }
            if (n10 <= n11) {
                if (++this.leadingPtr == 0) {
                    this.leadingNodes = new ASTNode[16];
                    this.leadingIndexes = new long[16];
                } else if (this.leadingPtr == this.leadingNodes.length) {
                    n4 = this.leadingPtr * 3 / 2 + 16;
                    this.leadingNodes = new ASTNode[n4];
                    System.arraycopy(this.leadingNodes, 0, this.leadingNodes, 0, this.leadingPtr);
                    this.leadingIndexes = new long[n4];
                    System.arraycopy(this.leadingIndexes, 0, this.leadingIndexes, 0, this.leadingPtr);
                }
                this.leadingNodes[this.leadingPtr] = aSTNode;
                this.leadingIndexes[this.leadingPtr] = ((long)n10 << 32) + (long)n11;
                n6 = this.comments[n11].getStartPosition();
            }
        }
        return n6;
    }

    int storeTrailingComments(ASTNode aSTNode, int n, boolean bl, int[] nArray) {
        int n2;
        int n3 = aSTNode.getStartPosition() + aSTNode.getLength() - 1;
        if (n3 == n) {
            if (++this.trailingPtr == 0) {
                this.trailingNodes = new ASTNode[16];
                this.trailingIndexes = new long[16];
                this.lastTrailingPtr = -1;
            } else if (this.trailingPtr == this.trailingNodes.length) {
                int n4 = this.trailingPtr * 3 / 2 + 16;
                this.trailingNodes = new ASTNode[n4];
                System.arraycopy(this.trailingNodes, 0, this.trailingNodes, 0, this.trailingPtr);
                this.trailingIndexes = new long[n4];
                System.arraycopy(this.trailingIndexes, 0, this.trailingIndexes, 0, this.trailingPtr);
            }
            this.trailingNodes[this.trailingPtr] = aSTNode;
            this.trailingIndexes[this.trailingPtr] = -1L;
            return n3;
        }
        int n5 = n3;
        int n6 = this.getLineNumber(n3, nArray);
        int n7 = this.getCommentIndex(0, n3, 1);
        if (n7 == -1) {
            return n3;
        }
        int n8 = n7;
        int n9 = -1;
        int n10 = this.comments.length;
        int n11 = n5 + 1;
        int n12 = n3 + 1;
        int n13 = -1;
        while (n7 < n10 && n11 < n) {
            int n14;
            Comment comment = this.comments[n7];
            n11 = comment.getStartPosition();
            if (n11 >= n) break;
            if (n12 < n11) {
                this.scanner.resetTo(n12, n11);
                try {
                    n14 = this.scanner.getNextToken();
                    if (n14 != 1000 || this.scanner.currentPosition != n11) {
                        if (n7 != n8) break;
                        return n3;
                    }
                }
                catch (InvalidInputException invalidInputException) {
                    return n3;
                }
                char[] cArray = this.scanner.getCurrentIdentifierSource();
                int n15 = 0;
                n2 = -1;
                while ((n2 = CharOperation.indexOf('\n', cArray, n2 + 1)) >= 0) {
                    ++n15;
                }
                if (n15 > 1) break;
            }
            if ((n14 = this.getLineNumber(n11, nArray)) == n6) {
                n13 = n7;
            }
            n12 = n11 + comment.getLength();
            n9 = n7++;
        }
        if (n9 != -1) {
            long l;
            int n16;
            int n17;
            if (!bl && (n17 = this.getLineNumber(n, nArray)) - (n16 = this.getLineNumber(n12, nArray)) <= 1) {
                if (n13 == -1) {
                    return n3;
                }
                n9 = n13;
            }
            if (++this.trailingPtr == 0) {
                this.trailingNodes = new ASTNode[16];
                this.trailingIndexes = new long[16];
                this.lastTrailingPtr = -1;
            } else if (this.trailingPtr == this.trailingNodes.length) {
                int n18 = this.trailingPtr * 3 / 2 + 16;
                this.trailingNodes = new ASTNode[n18];
                System.arraycopy(this.trailingNodes, 0, this.trailingNodes, 0, this.trailingPtr);
                this.trailingIndexes = new long[n18];
                System.arraycopy(this.trailingIndexes, 0, this.trailingIndexes, 0, this.trailingPtr);
            }
            this.trailingNodes[this.trailingPtr] = aSTNode;
            this.trailingIndexes[this.trailingPtr] = l = ((long)n8 << 32) + (long)n9;
            n5 = this.comments[n9].getStartPosition() + this.comments[n9].getLength() - 1;
            ASTNode aSTNode2 = aSTNode;
            n2 = this.trailingPtr - 1;
            while (n2 >= 0) {
                ASTNode aSTNode3;
                long l2 = this.trailingIndexes[n2];
                if (l2 != -1L || aSTNode2 != (aSTNode3 = this.trailingNodes[n2]).getParent()) break;
                this.trailingIndexes[n2] = l;
                aSTNode2 = aSTNode3;
                --n2;
            }
            if (n2 > this.lastTrailingPtr) {
                int n19 = n2 - this.lastTrailingPtr;
                int n20 = n2 + 1;
                while (n20 <= this.trailingPtr) {
                    this.trailingNodes[n20 - n19] = this.trailingNodes[n20];
                    this.trailingIndexes[n20 - n19] = this.trailingIndexes[n20];
                    ++n20;
                }
                this.trailingPtr -= n19;
            }
            this.lastTrailingPtr = this.trailingPtr;
        }
        return n5;
    }

    class CommentMapperVisitor
    extends DefaultASTVisitor {
        ASTNode topSiblingParent = null;
        ASTNode[] siblings = new ASTNode[10];
        int[][] parentLineRange = new int[10][];
        int siblingPtr = -1;

        CommentMapperVisitor() {
        }

        protected boolean visitNode(ASTNode aSTNode) {
            int[] nArray;
            ASTNode aSTNode2;
            if (aSTNode instanceof InferredType) {
                return true;
            }
            ASTNode aSTNode3 = aSTNode.getParent();
            int n = aSTNode3.getStartPosition();
            ASTNode aSTNode4 = aSTNode2 = aSTNode3 == this.topSiblingParent ? this.siblings[this.siblingPtr] : null;
            if (aSTNode2 != null) {
                try {
                    n = DefaultCommentMapper.this.storeTrailingComments(aSTNode2, aSTNode.getStartPosition(), false, this.parentLineRange[this.siblingPtr]);
                }
                catch (Exception exception) {}
            }
            if ((aSTNode.typeAndFlags & 1) != 0) {
                return false;
            }
            if (this.siblingPtr > -1) {
                nArray = this.parentLineRange[this.siblingPtr];
            } else {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = DefaultCommentMapper.this.scanner.linePtr + 1;
            }
            int[] nArray3 = nArray;
            try {
                DefaultCommentMapper.this.storeLeadingComments(aSTNode, n, nArray3);
            }
            catch (Exception exception) {}
            if (this.topSiblingParent != aSTNode3) {
                if (this.siblings.length == ++this.siblingPtr) {
                    this.siblings = new ASTNode[this.siblingPtr * 2];
                    System.arraycopy(this.siblings, 0, this.siblings, 0, this.siblingPtr);
                    int[][] nArrayArray = new int[this.siblingPtr * 2][];
                    this.parentLineRange = nArrayArray;
                    System.arraycopy(this.parentLineRange, 0, nArrayArray, 0, this.siblingPtr);
                }
                if (this.topSiblingParent == null) {
                    this.parentLineRange[this.siblingPtr] = nArray3;
                } else {
                    int n2 = aSTNode3.getStartPosition();
                    int n3 = DefaultCommentMapper.this.getLineNumber(n2, nArray3);
                    int n4 = DefaultCommentMapper.this.getLineNumber(n2 + aSTNode3.getLength() - 1, nArray3);
                    if (this.parentLineRange[this.siblingPtr] == null) {
                        this.parentLineRange[this.siblingPtr] = new int[]{n3, n4};
                    } else {
                        int[] nArray4 = this.parentLineRange[this.siblingPtr];
                        nArray4[0] = n3;
                        nArray4[1] = n4;
                    }
                }
                this.topSiblingParent = aSTNode3;
            }
            this.siblings[this.siblingPtr] = aSTNode;
            return true;
        }

        protected void endVisitNode(ASTNode aSTNode) {
            ASTNode aSTNode2;
            ASTNode aSTNode3 = aSTNode2 = this.topSiblingParent == aSTNode ? this.siblings[this.siblingPtr] : null;
            if (aSTNode2 != null) {
                try {
                    DefaultCommentMapper.this.storeTrailingComments(aSTNode2, aSTNode.getStartPosition() + aSTNode.getLength() - 1, true, this.parentLineRange[this.siblingPtr]);
                }
                catch (Exception exception) {}
            }
            if (this.topSiblingParent != null && this.topSiblingParent == aSTNode) {
                --this.siblingPtr;
                this.topSiblingParent = aSTNode.getParent();
            }
        }

        public boolean visit(CompilationUnit compilationUnit) {
            return true;
        }
    }
}

