/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.AnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMemberValuePairBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

class MemberValuePairBinding
implements IMemberValuePairBinding {
    static final MemberValuePairBinding[] NoPair = new MemberValuePairBinding[0];
    private static final Object NoValue = new Object();
    private static final Object[] EmptyArray = new Object[0];
    private ElementValuePair internalPair;
    protected Object value = null;
    protected BindingResolver bindingResolver;

    static void appendValue(Object object, StringBuffer stringBuffer) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            stringBuffer.append('{');
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                MemberValuePairBinding.appendValue(objectArray[n], stringBuffer);
                ++n;
            }
            stringBuffer.append('}');
        } else if (object instanceof ITypeBinding) {
            stringBuffer.append(((ITypeBinding)object).getName());
            stringBuffer.append(".class");
        } else {
            stringBuffer.append(object);
        }
    }

    static Object buildDOMValue(Object object, BindingResolver bindingResolver) {
        if (object == null) {
            return null;
        }
        if (object instanceof Constant) {
            Constant constant = (Constant)object;
            switch (constant.typeID()) {
                case 5: {
                    return constant.booleanValue();
                }
                case 3: {
                    return new Byte(constant.byteValue());
                }
                case 2: {
                    return new Character(constant.charValue());
                }
                case 8: {
                    return new Double(constant.doubleValue());
                }
                case 9: {
                    return new Float(constant.floatValue());
                }
                case 10: {
                    return new Integer(constant.intValue());
                }
                case 7: {
                    return new Long(constant.longValue());
                }
                case 4: {
                    return new Short(constant.shortValue());
                }
                case 11: {
                    return constant.stringValue();
                }
            }
        } else {
            if (object instanceof TypeBinding) {
                return bindingResolver.getTypeBinding((TypeBinding)object);
            }
            if (object instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding) {
                return bindingResolver.getAnnotationInstance((org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding)object);
            }
            if (object instanceof FieldBinding) {
                return bindingResolver.getVariableBinding((FieldBinding)object);
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                Object[] objectArray2 = n == 0 ? EmptyArray : new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray2[n2] = MemberValuePairBinding.buildDOMValue(objectArray[n2], bindingResolver);
                    ++n2;
                }
                return objectArray2;
            }
        }
        return null;
    }

    MemberValuePairBinding(ElementValuePair elementValuePair, BindingResolver bindingResolver) {
        this.internalPair = elementValuePair;
        this.bindingResolver = bindingResolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        return AnnotationBinding.NoAnnotations;
    }

    public IJavaElement getJavaElement() {
        return null;
    }

    public String getKey() {
        return null;
    }

    public int getKind() {
        return 6;
    }

    public IMethodBinding getMethodBinding() {
        return this.bindingResolver.getMethodBinding(this.internalPair.getMethodBinding());
    }

    public int getModifiers() {
        return 0;
    }

    public String getName() {
        if (this.internalPair == null) {
            return null;
        }
        char[] cArray = this.internalPair.getName();
        return cArray == null ? null : new String(cArray);
    }

    public Object getValue() {
        if (this.value == null) {
            this.init();
        }
        return this.value == NoValue ? null : this.value;
    }

    private void init() {
        this.value = MemberValuePairBinding.buildDOMValue(this.internalPair.getValue(), this.bindingResolver);
        if (this.value == null) {
            this.value = NoValue;
        }
    }

    char[] internalName() {
        return this.internalPair == null ? null : this.internalPair.getName();
    }

    public boolean isDefault() {
        Object object = this.getValue();
        Object object2 = this.getMethodBinding().getDefaultValue();
        if (object instanceof IBinding) {
            if (object2 instanceof IBinding) {
                return ((IBinding)object).isEqualTo((IBinding)object2);
            }
            return false;
        }
        if (object2 == null) {
            return false;
        }
        return object2.equals(object);
    }

    public boolean isDeprecated() {
        MethodBinding methodBinding = this.internalPair.getMethodBinding();
        return methodBinding == null ? false : methodBinding.isDeprecated();
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (this == iBinding) {
            return true;
        }
        if (iBinding.getKind() != 6) {
            return false;
        }
        IMemberValuePairBinding iMemberValuePairBinding = (IMemberValuePairBinding)iBinding;
        if (!this.getMethodBinding().isEqualTo(iMemberValuePairBinding.getMethodBinding())) {
            return false;
        }
        Object object = iMemberValuePairBinding.getValue();
        Object object2 = this.getValue();
        if (object2 == null) {
            return object == null;
        }
        if (object2 instanceof IBinding) {
            if (object instanceof IBinding) {
                return ((IBinding)object2).isEqualTo((IBinding)object);
            }
            return false;
        }
        return object2.equals(object);
    }

    public boolean isRecovered() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(" = ");
        MemberValuePairBinding.appendValue(this.getValue(), stringBuffer);
        return stringBuffer.toString();
    }
}

