/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;

public class StringLiteral
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY;
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "\"\"";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.StringLiteral");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(clazz2, "escapedValue", clazz, true);
        ArrayList arrayList = new ArrayList(2);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.StringLiteral");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringLiteral.createPropertyList(clazz3, arrayList);
        StringLiteral.addProperty(ESCAPED_VALUE_PROPERTY, arrayList);
        PROPERTY_DESCRIPTORS = StringLiteral.reapPropertyList(arrayList);
    }

    public static List propertyDescriptors(int n) {
        return PROPERTY_DESCRIPTORS;
    }

    StringLiteral(AST aST) {
        super(aST);
    }

    final List internalStructuralPropertiesForType(int n) {
        return StringLiteral.propertyDescriptors(n);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor simplePropertyDescriptor, boolean bl, Object object) {
        if (simplePropertyDescriptor == ESCAPED_VALUE_PROPERTY) {
            if (bl) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)object);
            return null;
        }
        return super.internalGetSetObjectProperty(simplePropertyDescriptor, bl, object);
    }

    final int getNodeType0() {
        return 45;
    }

    ASTNode clone0(AST aST) {
        StringLiteral stringLiteral = new StringLiteral(aST);
        stringLiteral.setSourceRange(this.getStartPosition(), this.getLength());
        stringLiteral.setEscapedValue(this.getEscapedValue());
        return stringLiteral;
    }

    final boolean subtreeMatch0(ASTMatcher aSTMatcher, Object object) {
        return aSTMatcher.match(this, object);
    }

    void accept0(ASTVisitor aSTVisitor) {
        aSTVisitor.visit(this);
        aSTVisitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        Scanner scanner = this.ast.scanner;
        char[] cArray = string.toCharArray();
        scanner.setSource(cArray);
        scanner.resetTo(0, cArray.length);
        try {
            int n = scanner.getNextToken();
            switch (n) {
                case 36: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid string literal : >" + string + "<");
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException("Invalid string literal : >" + string + "<");
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = string;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    void internalSetEscapedValue(String string) {
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = string;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    public String getLiteralValue() {
        String string = this.getEscapedValue();
        int n = string.length();
        if (n < 2 || string.charAt(0) != '\"' || string.charAt(n - 1) != '\"') {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.ast.scanner;
        char[] cArray = string.toCharArray();
        scanner.setSource(cArray);
        scanner.resetTo(0, cArray.length);
        try {
            int n2 = scanner.getNextToken();
            switch (n2) {
                case 36: {
                    return scanner.getCurrentStringLiteral();
                }
            }
            throw new IllegalArgumentException();
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException();
        }
    }

    public void setLiteralValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 2);
        stringBuffer.append("\"");
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\u0000': {
                    stringBuffer.append("\\0");
                    break;
                }
                case '\u0001': {
                    stringBuffer.append("\\1");
                    break;
                }
                case '\u0002': {
                    stringBuffer.append("\\2");
                    break;
                }
                case '\u0003': {
                    stringBuffer.append("\\3");
                    break;
                }
                case '\u0004': {
                    stringBuffer.append("\\4");
                    break;
                }
                case '\u0005': {
                    stringBuffer.append("\\5");
                    break;
                }
                case '\u0006': {
                    stringBuffer.append("\\6");
                    break;
                }
                case '\u0007': {
                    stringBuffer.append("\\7");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        stringBuffer.append("\"");
        this.setEscapedValue(stringBuffer.toString());
    }

    int memSize() {
        int n = 44 + StringLiteral.stringSize(this.escapedValue);
        return n;
    }

    int treeSize() {
        return this.memSize();
    }
}

