/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.util;

import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.SortElementsOperation;

public final class CompilationUnitSorter {
    public static final String RELATIVE_ORDER = "relativeOrder";

    private CompilationUnitSorter() {
    }

    private static void checkASTLevel(int n) {
        switch (n) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static void sort(ICompilationUnit iCompilationUnit, int[] nArray, Comparator comparator, int n, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CompilationUnitSorter.sort(2, iCompilationUnit, nArray, comparator, n, iProgressMonitor);
    }

    public static void sort(int n, ICompilationUnit iCompilationUnit, int[] nArray, Comparator comparator, int n2, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iCompilationUnit == null || comparator == null) {
            throw new IllegalArgumentException();
        }
        CompilationUnitSorter.checkASTLevel(n);
        IJavaElement[] iJavaElementArray = new ICompilationUnit[]{iCompilationUnit};
        SortElementsOperation sortElementsOperation = new SortElementsOperation(n, iJavaElementArray, nArray, comparator);
        sortElementsOperation.runOperation(iProgressMonitor);
    }

    public static TextEdit sort(CompilationUnit compilationUnit, Comparator comparator, int n, TextEditGroup textEditGroup, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (compilationUnit == null || comparator == null) {
            throw new IllegalArgumentException();
        }
        SortElementsOperation sortElementsOperation = new SortElementsOperation(3, new IJavaElement[]{compilationUnit.getJavaElement()}, null, comparator);
        return sortElementsOperation.calculateEdit(compilationUnit, textEditGroup);
    }
}

