/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist.select;

import org.eclipse.wst.jsdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;

public class SelectionJavadoc
extends Javadoc {
    Expression selectedNode;

    public SelectionJavadoc(int n, int n2) {
        super(n, n2);
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        super.print(n, stringBuffer);
        if (this.selectedNode != null) {
            Expression expression;
            String string = null;
            if (this.selectedNode instanceof JavadocFieldReference) {
                expression = (JavadocFieldReference)this.selectedNode;
                string = expression.methodBinding != null ? "<SelectOnMethod:" : "<SelectOnField:";
            } else if (this.selectedNode instanceof JavadocMessageSend) {
                string = "<SelectOnMethod:";
            } else if (this.selectedNode instanceof JavadocAllocationExpression) {
                string = "<SelectOnConstructor:";
            } else if (this.selectedNode instanceof JavadocSingleNameReference) {
                string = "<SelectOnLocalVariable:";
            } else if (this.selectedNode instanceof JavadocSingleTypeReference) {
                expression = (JavadocSingleTypeReference)this.selectedNode;
                if (((JavadocSingleTypeReference)expression).packageBinding == null) {
                    string = "<SelectOnType:";
                }
            } else if (this.selectedNode instanceof JavadocQualifiedTypeReference) {
                expression = (JavadocQualifiedTypeReference)this.selectedNode;
                if (((JavadocQualifiedTypeReference)expression).packageBinding == null) {
                    string = "<SelectOnType:";
                }
            } else {
                string = "<SelectOnType:";
            }
            int n2 = stringBuffer.length() - 3;
            stringBuffer.replace(n2 - 2, n2, String.valueOf(string) + this.selectedNode + '>');
        }
        return stringBuffer;
    }

    private void internalResolve(Scope scope) {
        if (this.selectedNode != null) {
            switch (scope.kind) {
                case 3: {
                    this.selectedNode.resolveType((ClassScope)scope);
                    break;
                }
                case 2: {
                    this.selectedNode.resolveType((MethodScope)scope);
                }
            }
            Binding binding = null;
            if (this.selectedNode instanceof JavadocFieldReference) {
                JavadocFieldReference javadocFieldReference = (JavadocFieldReference)this.selectedNode;
                binding = javadocFieldReference.binding;
                if (binding == null && javadocFieldReference.methodBinding != null) {
                    binding = javadocFieldReference.methodBinding;
                }
            } else if (this.selectedNode instanceof JavadocMessageSend) {
                binding = ((JavadocMessageSend)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocAllocationExpression) {
                binding = ((JavadocAllocationExpression)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocSingleNameReference) {
                binding = ((JavadocSingleNameReference)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference javadocSingleTypeReference = (JavadocSingleTypeReference)this.selectedNode;
                if (javadocSingleTypeReference.packageBinding == null) {
                    binding = javadocSingleTypeReference.resolvedType;
                }
            } else if (this.selectedNode instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference javadocQualifiedTypeReference = (JavadocQualifiedTypeReference)this.selectedNode;
                if (javadocQualifiedTypeReference.packageBinding == null) {
                    binding = javadocQualifiedTypeReference.resolvedType;
                }
            } else {
                binding = this.selectedNode.resolvedType;
            }
            throw new SelectionNodeFound(binding);
        }
    }

    public void resolve(ClassScope classScope) {
        this.internalResolve(classScope);
    }

    public void resolve(MethodScope methodScope) {
        this.internalResolve(methodScope);
    }
}

