/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public abstract class AbstractVariableDeclaration
extends Statement
implements InvocationSite {
    public int declarationEnd;
    public int declarationSourceEnd;
    public int declarationSourceStart;
    public int hiddenVariableDepth;
    public Expression initialization;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public Javadoc javadoc;
    public InferredType inferredType;
    public char[] name;
    public TypeReference type;
    public static final int FIELD = 1;
    public static final int INITIALIZER = 2;
    public static final int ENUM_CONSTANT = 3;
    public static final int LOCAL_VARIABLE = 4;
    public static final int PARAMETER = 5;
    public static final int TYPE_PARAMETER = 6;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public abstract int getKind();

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return false;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        this.printAsExpression(n, stringBuffer);
        switch (this.getKind()) {
            case 3: {
                return stringBuffer.append(',');
            }
        }
        return stringBuffer.append(';');
    }

    public StringBuffer printAsExpression(int n, StringBuffer stringBuffer) {
        AbstractVariableDeclaration.printIndent(n, stringBuffer);
        AbstractVariableDeclaration.printModifiers(this.modifiers, stringBuffer);
        stringBuffer.append("var ");
        if (this.annotations != null) {
            AbstractVariableDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        if (this.type != null) {
            this.type.print(0, stringBuffer).append(' ');
        }
        stringBuffer.append(this.name);
        switch (this.getKind()) {
            case 3: {
                if (this.initialization == null) break;
                this.initialization.printExpression(n, stringBuffer);
                break;
            }
            default: {
                if (this.initialization == null) break;
                stringBuffer.append(" = ");
                this.initialization.printExpression(n, stringBuffer);
            }
        }
        return stringBuffer;
    }

    public void resolve(BlockScope blockScope) {
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n) {
        this.hiddenVariableDepth = n;
    }

    public void setFieldIndex(int n) {
    }

    public TypeBinding getTypeBinding() {
        if (this.type != null) {
            return this.type.resolvedType;
        }
        if (this.inferredType != null) {
            return this.inferredType.binding;
        }
        return null;
    }
}

