/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.batch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.batch.FileFinder;
import org.eclipse.wst.jsdt.internal.compiler.batch.FileSystem;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRule;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.wst.jsdt.internal.compiler.util.GenericXMLWriter;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Messages;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    public static final String bundleName = "org.eclipse.wst.jsdt.internal.compiler.batch.messages";
    public static final int DEFAULT_SIZE_CLASSPATH = 4;
    public static final String NONE = "none";
    public Compiler batchCompiler;
    public ResourceBundle bundle;
    protected FileSystem.Classpath[] checkedClasspaths;
    public Locale compilerLocale;
    public CompilerOptions compilerOptions;
    public String destinationPath;
    public String[] destinationPaths;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] encodings;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public String[] classNames;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalTasksCount;
    public int globalWarningsCount;
    private File javaHomeCache;
    private boolean javaHomeChecked = false;
    public long lineCount;
    public String log;
    public Logger logger;
    public int maxProblems;
    public boolean noWarn = false;
    public Map options;
    protected PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int repetitions;
    public boolean showProgress = false;
    public long startTime;
    public boolean systemExitWhenFinished = true;
    public long[] times;
    public int timesCounter;
    public boolean timing = false;
    public boolean verbose = false;
    private String[] expandedCommandLine;
    private PrintWriter err;
    ArrayList extraProblems;
    static /* synthetic */ Class class$0;

    public static boolean compile(String string) {
        return Main.compile(string, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static boolean compile(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        return new Main(printWriter, printWriter2, false).compile(Main.tokenize(string));
    }

    public static File[][] getLibrariesFiles(File[] fileArray) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".jar") || string2.endsWith(".zip");
            }
        };
        int n = fileArray.length;
        File[][] fileArray2 = new File[n][];
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists() && file.isDirectory()) {
                fileArray2[n2] = file.listFiles(filenameFilter);
            }
            ++n2;
        }
        return fileArray2;
    }

    public static void main(String[] stringArray) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true).compile(stringArray);
    }

    public static String[] tokenize(String string) {
        int n = 0;
        String[] stringArray = new String[10];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        String string2 = Util.EMPTY_STRING;
        boolean bl = false;
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                if (bl) {
                    int n2 = n - 1;
                    stringArray[n2] = String.valueOf(stringArray[n2]) + string2;
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (string2.equals("\"")) {
                if (!bl && bl2) {
                    if (n == stringArray.length) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[n * 2];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    }
                    stringArray[n++] = Util.EMPTY_STRING;
                }
                bl = !bl;
                bl2 = false;
                continue;
            }
            if (bl) {
                int n3 = n - 1;
                stringArray[n3] = String.valueOf(stringArray[n3]) + string2;
            } else if (string2.length() > 0 && !bl2) {
                int n4 = n - 1;
                stringArray[n4] = String.valueOf(stringArray[n4]) + string2;
            } else {
                String string3;
                if (n == stringArray.length) {
                    String[] stringArray3 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray3, 0, stringArray, 0, n);
                }
                if ((string3 = string2.trim()).length() != 0) {
                    stringArray[n++] = string3;
                }
            }
            bl2 = false;
        }
        String[] stringArray4 = stringArray;
        stringArray = new String[n];
        System.arraycopy(stringArray4, 0, stringArray, 0, n);
        return stringArray;
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this(printWriter, printWriter2, bl, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.initialize(printWriter, printWriter2, bl, map);
        this.relocalize();
    }

    public void addExtraProblems(CategorizedProblem categorizedProblem) {
        if (this.extraProblems == null) {
            this.extraProblems = new ArrayList();
        }
        this.extraProblems.add(categorizedProblem);
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, String string3, boolean bl, boolean bl2) throws InvalidInputException {
        Object object;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            String[] stringArray;
            object = new AccessRule[arrayList2.size()];
            boolean bl3 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                char c = stringArray.charAt(0);
                String string4 = stringArray.substring(1);
                if (string4.length() > 0) {
                    switch (c) {
                        case '+': {
                            object[n2++] = new AccessRule(string4.toCharArray(), 0);
                            break;
                        }
                        case '~': {
                            object[n2++] = new AccessRule(string4.toCharArray(), 0x1000118);
                            break;
                        }
                        case '-': {
                            object[n2++] = new AccessRule(string4.toCharArray(), 0x1000133);
                            break;
                        }
                        case '?': {
                            object[n2++] = new AccessRule(string4.toCharArray(), 0x1000133, true);
                            break;
                        }
                        default: {
                            bl3 = false;
                            break;
                        }
                    }
                    continue;
                }
                bl3 = false;
            }
            if (bl3) {
                stringArray = new String[]{this.bind("template.restrictedAccess.type", new String[]{"{0}", string}), this.bind("template.restrictedAccess.constructor", new String[]{"{0}", string}), this.bind("template.restrictedAccess.method", new String[]{"{0}", "{1}", string}), this.bind("template.restrictedAccess.field", new String[]{"{0}", "{1}", string})};
                accessRuleSet = new AccessRuleSet((AccessRule[])object, stringArray);
            } else {
                if (string.length() != 0) {
                    this.logger.logIncorrectClasspath(string);
                }
                return;
            }
        }
        if (NONE.equals(string3)) {
            string3 = NONE;
        }
        if (bl2 && string3 != null && (string.endsWith(".jar") || string.endsWith(".zip"))) {
            throw new InvalidInputException(this.bind("configure.unexpectedDestinationPathEntryFile", string));
        }
        object = FileSystem.getClasspath(string, string2, bl, accessRuleSet, string3);
        if (object != null) {
            arrayList.add(object);
        } else if (string.length() != 0) {
            this.logger.logIncorrectClasspath(string);
        }
    }

    public String bind(String string) {
        return this.bind(string, (String[])null);
    }

    public String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    public String bind(String string, String string2, String string3) {
        return this.bind(string, new String[]{string2, string3});
    }

    public String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + bundleName;
        }
        return MessageFormat.format(string2, stringArray);
    }

    private boolean checkVMVersion(long l) {
        int n;
        String string = System.getProperty("java.class.version");
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            return false;
        }
        try {
            n = Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        switch (n) {
            case 45: {
                return 2949123L >= l;
            }
            case 46: {
                return 0x2E0000L >= l;
            }
            case 47: {
                return 0x2F0000L >= l;
            }
            case 48: {
                return 0x300000L >= l;
            }
            case 49: {
                return 0x310000L >= l;
            }
            case 50: {
                return 0x320000L >= l;
            }
            case 51: {
                return 0x330000L >= l;
            }
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(String[] stringArray) {
        try {
            try {
                this.configure(stringArray);
                if (this.proceed) {
                    if (this.showProgress) {
                        this.logger.compiling();
                    }
                    int n = 0;
                    while (true) {
                        if (n >= this.repetitions) {
                            if (this.times != null) {
                                this.logger.logAverage(this.times, this.lineCount);
                            }
                            if (!this.showProgress) break;
                            this.logger.printNewLine();
                            break;
                        }
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.globalTasksCount = 0;
                        this.lineCount = 0L;
                        this.exportedClassFilesCounter = 0;
                        if (this.repetitions > 1) {
                            this.logger.flush();
                            this.logger.logRepetition(n, this.repetitions);
                        }
                        this.performCompilation();
                        ++n;
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (InvalidInputException invalidInputException) {
                block15: {
                    this.logger.logException(invalidInputException);
                    if (this.systemExitWhenFinished) {
                        this.logger.flush();
                        this.logger.close();
                        System.exit(-1);
                    }
                    break block15;
                    catch (RuntimeException runtimeException) {
                        this.logger.logException(runtimeException);
                        if (!this.systemExitWhenFinished) break block15;
                        this.logger.flush();
                        this.logger.close();
                        System.exit(-1);
                    }
                }
                Object var3_5 = null;
                this.logger.flush();
                this.logger.close();
                return false;
            }
            Object var3_7 = null;
            this.logger.flush();
            this.logger.close();
            if (this.globalErrorsCount != 0) return false;
            return true;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.logger.flush();
            this.logger.close();
            throw throwable;
        }
    }

    protected void handleWarningToken(String string, boolean bl, boolean bl2) throws InvalidInputException {
        if (string.equals("constructorName")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.methodWithConstructorName", bl ? "warning" : "ignore");
        } else if (string.equals("maskedCatchBlock") || string.equals("maskedCatchBlocks")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.hiddenCatchBlock", bl ? "warning" : "ignore");
        } else if (string.equals("deprecation")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
        } else if (string.equals("allDeprecation")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationInDeprecatedCode", bl ? "enabled" : "disabled");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", bl ? "enabled" : "disabled");
        } else if (string.equals("unusedLocal") || string.equals("unusedLocals")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", bl ? "warning" : "ignore");
        } else if (string.equals("unusedArgument") || string.equals("unusedArguments")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameter", bl ? "warning" : "ignore");
        } else if (string.equals("unusedImport") || string.equals("unusedImports")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedImport", bl ? "warning" : "ignore");
        } else if (string.equals("unusedPrivate")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", bl ? "warning" : "ignore");
        } else if (string.equals("unusedLabel")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLabel", bl ? "warning" : "ignore");
        } else if (string.equals("localHiding")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.localVariableHiding", bl ? "warning" : "ignore");
        } else if (string.equals("fieldHiding")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", bl ? "warning" : "ignore");
        } else if (string.equals("specialParamHiding")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.specialParameterHidingField", bl ? "enabled" : "disabled");
        } else if (string.equals("conditionAssign")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.possibleAccidentalBooleanAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("syntheticAccess") || string.equals("synthetic-access")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.syntheticAccessEmulation", bl ? "warning" : "ignore");
        } else if (string.equals("nls")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", bl ? "warning" : "ignore");
        } else if (string.equals("staticReceiver")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", bl ? "warning" : "ignore");
        } else if (string.equals("indirectStatic")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.indirectStaticAccess", bl ? "warning" : "ignore");
        } else if (string.equals("noEffectAssign")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.noEffectAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("intfNonInherited") || string.equals("interfaceNonInherited")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", bl ? "warning" : "ignore");
        } else if (string.equals("charConcat") || string.equals("noImplicitStringConversion")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.noImplicitStringConversion", bl ? "warning" : "ignore");
        } else if (string.equals("semicolon")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.emptyStatement", bl ? "warning" : "ignore");
        } else if (string.equals("serial")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingSerialVersion", bl ? "warning" : "ignore");
        } else if (string.equals("emptyBlock")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.undocumentedEmptyBlock", bl ? "warning" : "ignore");
        } else if (string.equals("uselessTypeCheck")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", bl ? "warning" : "ignore");
        } else if (string.equals("unchecked") || string.equals("unsafe")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.uncheckedTypeOperation", bl ? "warning" : "ignore");
        } else if (string.equals("raw")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", bl ? "warning" : "ignore");
        } else if (string.equals("finalBound")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.finalParameterBound", bl ? "warning" : "ignore");
        } else if (string.equals("suppress")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
        } else if (string.equals("warningToken")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unhandledWarningToken", bl ? "warning" : "ignore");
        } else if (string.equals("unnecessaryElse")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryElse", bl ? "warning" : "ignore");
        } else if (string.equals("javadoc")) {
            if (!bl2) {
                this.options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", bl ? "enabled" : "disabled");
            }
            if (bl) {
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "warning");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTags", "enabled");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", "warning");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
            }
        } else if (string.equals("allJavadoc")) {
            if (!bl2) {
                this.options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", bl ? "enabled" : "disabled");
            }
            if (bl) {
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "warning");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTags", "enabled");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", "warning");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", "warning");
            }
        } else if (string.startsWith("tasks")) {
            String string2 = Util.EMPTY_STRING;
            int n = string.indexOf(40);
            int n2 = string.indexOf(41);
            if (n >= 0 && n2 >= 0 && n < n2) {
                string2 = string.substring(n + 1, n2).trim();
                string2 = string2.replace('|', ',');
            }
            if (string2.length() == 0) {
                throw new InvalidInputException(this.bind("configure.invalidTaskTag", string));
            }
            this.options.put("org.eclipse.wst.jsdt.core.compiler.taskTags", bl ? string2 : Util.EMPTY_STRING);
        } else if (string.equals("assertIdentifier")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", bl ? "warning" : "ignore");
        } else if (string.equals("enumIdentifier")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.enumIdentifier", bl ? "warning" : "ignore");
        } else if (string.equals("finally")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.finallyBlockNotCompletingNormally", bl ? "warning" : "ignore");
        } else if (string.equals("unusedThrown")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedDeclaredThrownException", bl ? "warning" : "ignore");
        } else if (string.equals("unqualifiedField") || string.equals("unqualified-field-access")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unqualifiedFieldAccess", bl ? "warning" : "ignore");
        } else if (string.equals("typeHiding")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.typeParameterHiding", bl ? "warning" : "ignore");
        } else if (string.equals("varargsCast")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.varargsArgumentNeedCast", bl ? "warning" : "ignore");
        } else if (string.equals("null")) {
            if (bl) {
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "warning");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "warning");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.redundantNullCheck", "warning");
            } else {
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "ignore");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "ignore");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.redundantNullCheck", "ignore");
            }
        } else if (string.equals("nullDereference")) {
            if (bl) {
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "warning");
            } else {
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "ignore");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "ignore");
                this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.redundantNullCheck", "ignore");
            }
        } else if (string.equals("boxing")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.autoboxing", bl ? "warning" : "ignore");
        } else if (string.equals("over-ann")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingOverrideAnnotation", bl ? "warning" : "ignore");
        } else if (string.equals("dep-ann")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingDeprecatedAnnotation", bl ? "warning" : "ignore");
        } else if (string.equals("intfAnnotation")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.annotationSuperInterface", bl ? "warning" : "ignore");
        } else if (string.equals("enumSwitch") || string.equals("incomplete-switch")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.incompleteEnumSwitch", bl ? "warning" : "ignore");
        } else if (string.equals("hiding")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.hiddenCatchBlock", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.localVariableHiding", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.typeParameterHiding", bl ? "warning" : "ignore");
        } else if (string.equals("static-access")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.indirectStaticAccess", bl ? "warning" : "ignore");
        } else if (string.equals("unused")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameter", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedImport", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedDeclaredThrownException", bl ? "warning" : "ignore");
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLabel", bl ? "warning" : "ignore");
        } else if (string.equals("paramAssign")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.parameterAssignment", bl ? "warning" : "ignore");
        } else if (string.equals("discouraged")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.discouragedReference", bl ? "warning" : "ignore");
        } else if (string.equals("forbidden")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.forbiddenReference", bl ? "warning" : "ignore");
        } else if (string.equals("fallthrough")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", bl ? "warning" : "ignore");
        } else if (string.equals("super")) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", bl ? "warning" : "ignore");
        } else {
            throw new InvalidInputException(this.bind("configure.invalidWarning", string));
        }
    }

    protected ArrayList handleBootclasspath(ArrayList arrayList, String string) throws InvalidInputException {
        int n;
        int n2 = n = arrayList == null ? 0 : arrayList.size();
        if (n != 0) {
            String[] stringArray = new String[n];
            arrayList.toArray(stringArray);
            arrayList.clear();
            int n3 = 0;
            while (n3 < n) {
                this.processPathEntries(4, arrayList, stringArray[n3], string, false, true);
                ++n3;
            }
        } else {
            arrayList = new ArrayList<FileSystem.Classpath>(4);
            String string2 = System.getProperty("java.version");
            if (string2 != null && string2.equalsIgnoreCase("1.1.8")) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return null;
            }
            String string3 = SystemLibraryLocation.getInstance().getLibraryPath(new String(SystemLibraryLocation.SYSTEM_LIBARAY_NAME));
            if (string3 != null) {
                arrayList.add(FileSystem.getClasspath(string3, null, null));
            }
        }
        return arrayList;
    }

    protected ArrayList handleClasspath(ArrayList arrayList, String string) throws InvalidInputException {
        int n;
        int n2 = n = arrayList == null ? 0 : arrayList.size();
        if (n != 0) {
            String[] stringArray = new String[n];
            arrayList.toArray(stringArray);
            arrayList.clear();
            int n3 = 0;
            while (n3 < n) {
                this.processPathEntries(4, arrayList, stringArray[n3], string, false, true);
                ++n3;
            }
        }
        return arrayList;
    }

    protected ArrayList handleExtdirs(ArrayList arrayList) {
        return arrayList;
    }

    protected ArrayList handleEndorseddirs(ArrayList arrayList) {
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    public void configure(String[] var1_1) throws InvalidInputException {
        if (var1_1 == null || var1_1.length == 0) {
            this.printUsage();
            return;
        }
        var2_2 = new ArrayList<E>(4);
        var3_3 = null;
        var4_4 = new ArrayList<E>(4);
        var5_5 = new ArrayList<E>(4);
        var6_6 = null;
        var7_7 = null;
        var8_8 = -1;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = var1_1.length;
        var12_12 = 0;
        this.repetitions = 0;
        var13_13 = false;
        var14_14 = null;
        var15_15 = false;
        var16_16 = false;
        var17_17 = false;
        var18_18 = false;
        var19_19 = false;
        var20_20 = false;
        var21_21 = false;
        var22_22 = null;
        var23_23 = null;
        var24_24 = null;
        var25_25 = Util.EMPTY_STRING;
        var26_26 = false;
        var27_27 = 0;
        while (var27_27 < var11_11) {
            if (var1_1[var27_27].startsWith("@")) {
                var26_26 = true;
                break;
            }
            ++var27_27;
        }
        var27_28 = null;
        if (var26_26) {
            var27_28 = new String[var11_11];
            var8_8 = 0;
            var28_29 = 0;
            while (var28_29 < var11_11) {
                var29_41 = null;
                var30_50 = var1_1[var28_29].trim();
                if (var30_50.startsWith("@")) {
                    try {
                        var31_54 = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(var30_50.substring(1)), null))));
                        var32_59 = new StringBuffer();
                        while ((var33_62 = var31_54.readLine()) != null) {
                            if ((var33_62 = var33_62.trim()).startsWith("#")) continue;
                            var32_59.append(var33_62).append(" ");
                        }
                        var29_41 = Main.tokenize(var32_59.toString());
                    }
                    catch (IOException v0) {
                        throw new InvalidInputException(this.bind("configure.invalidexpansionargumentname", var30_50));
                    }
                }
                if (var29_41 != null) {
                    var31_55 = var27_28.length;
                    var32_60 = var29_41.length;
                    v1 = var27_28;
                    var27_28 = new String[var31_55 + var32_60 - 1];
                    System.arraycopy(v1, 0, var27_28, 0, var8_8);
                    System.arraycopy(var29_41, 0, var27_28, var8_8, var32_60);
                    var8_8 += var32_60;
                } else {
                    var27_28[var8_8++] = var30_50;
                }
                ++var28_29;
            }
            var8_8 = -1;
        } else {
            var27_28 = var1_1;
            var28_29 = 0;
            while (var28_29 < var11_11) {
                var27_28[var28_29] = var27_28[var28_29].trim();
                ++var28_29;
            }
        }
        var11_11 = var27_28.length;
        this.expandedCommandLine = var27_28;
        block38: while (++var8_8 < var11_11) {
            if (var22_22 != null) {
                throw new InvalidInputException(this.bind("configure.unexpectedCustomEncoding", var25_25, var22_22));
            }
            var25_25 = var27_28[var8_8];
            switch (var12_12) {
                case 0: {
                    if (var25_25.startsWith("[")) {
                        throw new InvalidInputException(this.bind("configure.unexpectedBracket", var25_25));
                    }
                    if (var25_25.endsWith("]")) {
                        var28_30 = var25_25.indexOf(91) + 1;
                        if (var28_30 <= 1) {
                            throw new InvalidInputException(this.bind("configure.unexpectedBracket", var25_25));
                        }
                        var29_43 = var25_25.length() - 1;
                        if (var28_30 >= 1) {
                            if (var28_30 < var29_43) {
                                var22_22 = var25_25.substring(var28_30, var29_43);
                                try {
                                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), var22_22);
                                }
                                catch (UnsupportedEncodingException v2) {
                                    throw new InvalidInputException(this.bind("configure.unsupportedEncoding", var22_22));
                                }
                            }
                            var25_25 = var25_25.substring(0, var28_30 - 1);
                        }
                    }
                    if (var25_25.endsWith(".js")) {
                        if (this.filenames == null) {
                            this.filenames = new String[var11_11 - var8_8];
                            this.encodings = new String[var11_11 - var8_8];
                            this.destinationPaths = new String[var11_11 - var8_8];
                        } else if (var9_9 == this.filenames.length) {
                            var28_31 = this.filenames.length;
                            this.filenames = new String[var28_31 + var11_11 - var8_8];
                            System.arraycopy(this.filenames, 0, this.filenames, 0, var28_31);
                            this.encodings = new String[var28_31 + var11_11 - var8_8];
                            System.arraycopy(this.encodings, 0, this.encodings, 0, var28_31);
                            this.destinationPaths = new String[var28_31 + var11_11 - var8_8];
                            System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, var28_31);
                        }
                        this.filenames[var9_9] = var25_25;
                        this.encodings[var9_9++] = var22_22;
                        var22_22 = null;
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-log")) {
                        if (this.log != null) {
                            throw new InvalidInputException(this.bind("configure.duplicateLog", var25_25));
                        }
                        var12_12 = 5;
                        break;
                    }
                    if (var25_25.equals("-repeat")) {
                        if (this.repetitions > 0) {
                            throw new InvalidInputException(this.bind("configure.duplicateRepeat", var25_25));
                        }
                        var12_12 = 6;
                        break;
                    }
                    if (var25_25.equals("-maxProblems")) {
                        if (this.maxProblems > 0) {
                            throw new InvalidInputException(this.bind("configure.duplicateMaxProblems", var25_25));
                        }
                        var12_12 = 11;
                        break;
                    }
                    if (var25_25.equals("-source")) {
                        var12_12 = 7;
                        break;
                    }
                    if (var25_25.equals("-encoding")) {
                        var12_12 = 8;
                        break;
                    }
                    if (var25_25.equals("-1.3")) {
                        if (var20_20) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var25_25));
                        }
                        var20_20 = true;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.3");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-1.4")) {
                        if (var20_20) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var25_25));
                        }
                        var20_20 = true;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.4");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-1.5") || var25_25.equals("-5") || var25_25.equals("-5.0")) {
                        if (var20_20) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var25_25));
                        }
                        var20_20 = true;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-1.6") || var25_25.equals("-6") || var25_25.equals("-6.0")) {
                        if (var20_20) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var25_25));
                        }
                        var20_20 = true;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.6");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-1.7") || var25_25.equals("-7") || var25_25.equals("-7.0")) {
                        if (var20_20) {
                            throw new InvalidInputException(this.bind("configure.duplicateCompliance", var25_25));
                        }
                        var20_20 = true;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.7");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-d")) {
                        if (this.destinationPath != null) {
                            var28_32 = new StringBuffer();
                            var28_32.append(var25_25);
                            if (var8_8 + 1 < var11_11) {
                                var28_32.append(' ');
                                var28_32.append(var27_28[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateOutputPath", var28_32.toString()));
                        }
                        var12_12 = 3;
                        break;
                    }
                    if (var25_25.equals("-classpath") || var25_25.equals("-cp")) {
                        var12_12 = 1;
                        break;
                    }
                    if (var25_25.equals("-bootclasspath")) {
                        if (var2_2.size() > 0) {
                            var28_33 = new StringBuffer();
                            var28_33.append(var25_25);
                            if (var8_8 + 1 < var11_11) {
                                var28_33.append(' ');
                                var28_33.append(var27_28[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateBootClasspath", var28_33.toString()));
                        }
                        var12_12 = 9;
                        break;
                    }
                    if (var25_25.equals("-sourcepath")) {
                        if (var3_3 != null) {
                            var28_34 = new StringBuffer();
                            var28_34.append(var25_25);
                            if (var8_8 + 1 < var11_11) {
                                var28_34.append(' ');
                                var28_34.append(var27_28[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateSourcepath", var28_34.toString()));
                        }
                        var12_12 = 13;
                        break;
                    }
                    if (var25_25.equals("-extdirs")) {
                        if (var6_6 != null) {
                            var28_35 = new StringBuffer();
                            var28_35.append(var25_25);
                            if (var8_8 + 1 < var11_11) {
                                var28_35.append(' ');
                                var28_35.append(var27_28[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateExtDirs", var28_35.toString()));
                        }
                        var12_12 = 12;
                        break;
                    }
                    if (var25_25.equals("-endorseddirs")) {
                        if (var7_7 != null) {
                            var28_36 = new StringBuffer();
                            var28_36.append(var25_25);
                            if (var8_8 + 1 < var11_11) {
                                var28_36.append(' ');
                                var28_36.append(var27_28[var8_8 + 1]);
                            }
                            throw new InvalidInputException(this.bind("configure.duplicateEndorsedDirs", var28_36.toString()));
                        }
                        var12_12 = 15;
                        break;
                    }
                    if (var25_25.equals("-progress")) {
                        var12_12 = 0;
                        this.showProgress = true;
                        break;
                    }
                    if (var25_25.equals("-proceedOnError")) {
                        var12_12 = 0;
                        this.proceedOnError = true;
                        break;
                    }
                    if (var25_25.equals("-time")) {
                        var12_12 = 0;
                        this.timing = true;
                        break;
                    }
                    if (var25_25.equals("-version") || var25_25.equals("-v")) {
                        this.logger.logVersion(true);
                        this.proceed = false;
                        return;
                    }
                    if (var25_25.equals("-showversion")) {
                        var15_15 = true;
                        var12_12 = 0;
                        break;
                    }
                    if ("-deprecation".equals(var25_25)) {
                        var17_17 = true;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", "warning");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-help") || var25_25.equals("-?")) {
                        var13_13 = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-help:warn") || var25_25.equals("-?:warn")) {
                        var13_13 = true;
                        var14_14 = "misc.usage.warn";
                        break;
                    }
                    if (var25_25.equals("-noExit")) {
                        this.systemExitWhenFinished = false;
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-verbose")) {
                        this.verbose = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-referenceInfo")) {
                        this.produceRefInfo = true;
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-inlineJSR")) {
                        var12_12 = 0;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                        break;
                    }
                    if (var25_25.startsWith("-g")) {
                        var12_12 = 0;
                        var28_37 = var25_25;
                        var29_44 = var25_25.length();
                        if (var29_44 == 2) {
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.localVariable", "generate");
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber", "generate");
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile", "generate");
                            break;
                        }
                        if (var29_44 > 3) {
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.localVariable", "do not generate");
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber", "do not generate");
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile", "do not generate");
                            if (var29_44 == 7 && var28_37.equals("-g:none")) continue block38;
                            var30_51 = new StringTokenizer(var28_37.substring(3, var28_37.length()), ",");
                            while (var30_51.hasMoreTokens()) {
                                var31_56 = var30_51.nextToken();
                                if (var31_56.equals("vars")) {
                                    this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.localVariable", "generate");
                                    continue;
                                }
                                if (var31_56.equals("lines")) {
                                    this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber", "generate");
                                    continue;
                                }
                                if (var31_56.equals("source")) {
                                    this.options.put("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile", "generate");
                                    continue;
                                }
                                throw new InvalidInputException(this.bind("configure.invalidDebugOption", var28_37));
                            }
                            continue block38;
                        }
                        throw new InvalidInputException(this.bind("configure.invalidDebugOption", var28_37));
                    }
                    if (var25_25.startsWith("-nowarn")) {
                        this.disableWarnings();
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.startsWith("-warn")) {
                        var12_12 = 0;
                        var28_38 = var25_25;
                        var29_45 = var25_25.length();
                        if (var29_45 == 10 && var28_38.equals("-warn:none")) {
                            this.disableWarnings();
                            break;
                        }
                        if (var29_45 <= 6) {
                            throw new InvalidInputException(this.bind("configure.invalidWarningConfiguration", var28_38));
                        }
                        switch (var28_38.charAt(6)) {
                            case '+': {
                                var30_52 = 7;
                                var31_57 = true;
                                break;
                            }
                            case '-': {
                                var30_52 = 7;
                                var31_57 = false;
                                break;
                            }
                            default: {
                                var30_52 = 6;
                                if (!var18_18) {
                                    this.disableWarnings();
                                }
                                var31_57 = true;
                            }
                        }
                        var32_61 = new StringTokenizer(var28_38.substring(var30_52, var28_38.length()), ",");
                        var33_64 = 0;
                        if (var17_17) {
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", "warning");
                        }
                        while (var32_61.hasMoreTokens()) {
                            var34_65 = var32_61.nextToken();
                            ++var33_64;
                            this.handleWarningToken(var34_65, var31_57, var19_19);
                        }
                        if (var33_64 == 0) {
                            throw new InvalidInputException(this.bind("configure.invalidWarningOption", var25_25));
                        }
                        var18_18 = true;
                        break;
                    }
                    if (var25_25.equals("-target")) {
                        var12_12 = 4;
                        break;
                    }
                    if (var25_25.equals("-preserveAllLocals")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.unusedLocal", "preserve");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-enableJavadoc")) {
                        var12_12 = 0;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "enabled");
                        var19_19 = true;
                        break;
                    }
                    if (var25_25.equals("-Xemacs")) {
                        var12_12 = 0;
                        this.logger.setEmacs();
                        break;
                    }
                    if (var25_25.startsWith("-A")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-processorpath")) {
                        var12_12 = 17;
                        break;
                    }
                    if (var25_25.equals("-processor")) {
                        var12_12 = 18;
                        break;
                    }
                    if (var25_25.equals("-proc:only")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.generateClassFiles", "disabled");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-proc:none")) {
                        var21_21 = true;
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.processAnnotations", "disabled");
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-s")) {
                        var12_12 = 19;
                        break;
                    }
                    if (var25_25.equals("-XprintProcessorInfo") || var25_25.equals("-XprintRounds")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.startsWith("-X")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.startsWith("-J")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-O")) {
                        var12_12 = 0;
                        break;
                    }
                    if (var25_25.equals("-classNames")) {
                        var12_12 = 20;
                        break;
                    }
                    ** GOTO lbl608
                }
                case 4: {
                    if (this.didSpecifyTarget) {
                        throw new InvalidInputException(this.bind("configure.duplicateTarget", var25_25));
                    }
                    this.didSpecifyTarget = true;
                    if (var25_25.equals("1.1")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (var25_25.equals("1.2")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (var25_25.equals("1.3")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (var25_25.equals("1.4")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (var25_25.equals("1.5") || var25_25.equals("5") || var25_25.equals("5.0")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (var25_25.equals("1.6") || var25_25.equals("6") || var25_25.equals("6.0")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else if (var25_25.equals("1.7") || var25_25.equals("7") || var25_25.equals("7.0")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.7");
                    } else if (var25_25.equals("jsr14")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "jsr14");
                    } else {
                        throw new InvalidInputException(this.bind("configure.targetJDK", var25_25));
                    }
                    var12_12 = 0;
                    break;
                }
                case 5: {
                    this.log = var25_25;
                    var12_12 = 0;
                    break;
                }
                case 6: {
                    try {
                        this.repetitions = Integer.parseInt(var25_25);
                        if (this.repetitions <= 0) {
                            throw new InvalidInputException(this.bind("configure.repetition", var25_25));
                        }
                    }
                    catch (NumberFormatException v3) {
                        throw new InvalidInputException(this.bind("configure.repetition", var25_25));
                    }
                    var12_12 = 0;
                    break;
                }
                case 11: {
                    try {
                        this.maxProblems = Integer.parseInt(var25_25);
                        if (this.maxProblems <= 0) {
                            throw new InvalidInputException(this.bind("configure.maxProblems", var25_25));
                        }
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.maxProblemPerUnit", var25_25);
                    }
                    catch (NumberFormatException v4) {
                        throw new InvalidInputException(this.bind("configure.maxProblems", var25_25));
                    }
                    var12_12 = 0;
                    break;
                }
                case 7: {
                    if (this.didSpecifySource) {
                        throw new InvalidInputException(this.bind("configure.duplicateSource", var25_25));
                    }
                    this.didSpecifySource = true;
                    if (var25_25.equals("1.3")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
                    } else if (var25_25.equals("1.4")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.4");
                    } else if (var25_25.equals("1.5") || var25_25.equals("5") || var25_25.equals("5.0")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
                    } else if (var25_25.equals("1.6") || var25_25.equals("6") || var25_25.equals("6.0")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.6");
                    } else if (var25_25.equals("1.7") || var25_25.equals("7") || var25_25.equals("7.0")) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.7");
                    } else {
                        throw new InvalidInputException(this.bind("configure.source", var25_25));
                    }
                    var12_12 = 0;
                    break;
                }
                case 8: {
                    if (var16_16) {
                        throw new InvalidInputException(this.bind("configure.duplicateDefaultEncoding", var25_25));
                    }
                    try {
                        new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), var25_25);
                    }
                    catch (UnsupportedEncodingException v5) {
                        throw new InvalidInputException(this.bind("configure.unsupportedEncoding", var25_25));
                    }
                    this.options.put("org.eclipse.wst.jsdt.core.encoding", var25_25);
                    var16_16 = true;
                    var12_12 = 0;
                    break;
                }
                case 3: {
                    this.setDestinationPath(var25_25.equals("none") != false ? "none" : var25_25);
                    var12_12 = 0;
                    break;
                }
                case 1: {
                    var12_12 = 0;
                    var8_8 += this.processPaths(var27_28, var8_8, var25_25, var5_5);
                    break;
                }
                case 9: {
                    var12_12 = 0;
                    var8_8 += this.processPaths(var27_28, var8_8, var25_25, var2_2);
                    break;
                }
                case 13: {
                    var12_12 = 0;
                    var28_39 = new String[1];
                    var8_8 += this.processPaths(var27_28, var8_8, var25_25, var28_39);
                    var3_3 = var28_39[0];
                    break;
                }
                case 12: {
                    if (var25_25.indexOf("[-d") != -1) {
                        throw new InvalidInputException(this.bind("configure.unexpectedDestinationPathEntry", "-extdir"));
                    }
                    var29_46 = new StringTokenizer(var25_25, File.pathSeparator, false);
                    var6_6 = new ArrayList<String>(4);
                    while (var29_46.hasMoreTokens()) {
                        var6_6.add(var29_46.nextToken());
                    }
                    var12_12 = 0;
                    break;
                }
                case 15: {
                    if (var25_25.indexOf("[-d") != -1) {
                        throw new InvalidInputException(this.bind("configure.unexpectedDestinationPathEntry", "-endorseddirs"));
                    }
                    var29_47 = new StringTokenizer(var25_25, File.pathSeparator, false);
                    var7_7 = new ArrayList<String>(4);
                    while (var29_47.hasMoreTokens()) {
                        var7_7.add(var29_47.nextToken());
                    }
                    var12_12 = 0;
                    break;
                }
                case 16: {
                    if (!var25_25.endsWith("]")) ** GOTO lbl586
                    var23_23 = var25_25.substring(0, var25_25.length() - 1);
                    ** GOTO lbl608
lbl586:
                    // 1 sources

                    throw new InvalidInputException(this.bind("configure.incorrectDestinationPathEntry", "[-d " + var25_25));
                }
                case 17: {
                    var12_12 = 0;
                    break;
                }
                case 18: {
                    var12_12 = 0;
                    break;
                }
                case 19: {
                    var12_12 = 0;
                    break;
                }
                case 20: {
                    var29_48 = new StringTokenizer(var25_25, ",");
                    if (this.classNames == null) {
                        this.classNames = new String[4];
                    }
                    while (var29_48.hasMoreTokens()) {
                        if (this.classNames.length == var10_10) {
                            this.classNames = new String[var10_10 * 2];
                            System.arraycopy(this.classNames, 0, this.classNames, 0, var10_10);
                        }
                        this.classNames[var10_10++] = var29_48.nextToken();
                    }
                    var12_12 = 0;
                    break;
                }
lbl608:
                // 3 sources

                default: {
                    if (var23_23 == null) {
                        if (File.separatorChar != '/') {
                            var25_25 = var25_25.replace('/', File.separatorChar);
                        }
                        if (var25_25.endsWith("[-d")) {
                            var24_24 = var25_25.substring(0, var25_25.length() - 3);
                            var12_12 = 16;
                            break;
                        }
                        var24_24 = var25_25;
                    }
                    if (!(var28_40 = new File(var24_24)).isDirectory()) {
                        throw new InvalidInputException(this.bind("configure.unrecognizedOption", var24_24));
                    }
                    var29_49 = FileFinder.find(var28_40, ".JS");
                    if ("none".equals(var23_23)) {
                        var23_23 = "none";
                    }
                    if (this.filenames != null) {
                        var30_53 = var29_49.length;
                        this.filenames = new String[var30_53 + var9_9];
                        System.arraycopy(this.filenames, 0, this.filenames, 0, var9_9);
                        this.encodings = new String[var30_53 + var9_9];
                        System.arraycopy(this.encodings, 0, this.encodings, 0, var9_9);
                        this.destinationPaths = new String[var30_53 + var9_9];
                        System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, var9_9);
                        System.arraycopy(var29_49, 0, this.filenames, var9_9, var30_53);
                        var31_58 = 0;
                        while (var31_58 < var30_53) {
                            this.encodings[var9_9 + var31_58] = var22_22;
                            this.destinationPaths[var9_9 + var31_58] = var23_23;
                            ++var31_58;
                        }
                        var9_9 += var30_53;
                        var22_22 = null;
                        var23_23 = null;
                        var24_24 = null;
                    } else {
                        this.filenames = var29_49;
                        var9_9 = this.filenames.length;
                        this.encodings = new String[var9_9];
                        this.destinationPaths = new String[var9_9];
                        var30_53 = 0;
                        while (var30_53 < var9_9) {
                            this.encodings[var30_53] = var22_22;
                            this.destinationPaths[var30_53] = var23_23;
                            ++var30_53;
                        }
                        var22_22 = null;
                        var23_23 = null;
                        var24_24 = null;
                    }
                    var12_12 = 0;
                }
            }
        }
        if (var13_13 || var9_9 == 0 && var10_10 == 0) {
            if (var14_14 == null) {
                this.printUsage();
            } else {
                this.printUsage(var14_14);
            }
            this.proceed = false;
            return;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        this.logger.logVersion(var15_15);
        this.validateOptions(var20_20);
        if (!var21_21 && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.wst.jsdt.core.compiler.compliance")) >= 0x320000L) {
            this.options.put("org.eclipse.wst.jsdt.core.compiler.processAnnotations", "enabled");
        }
        this.logger.logCommandLineArguments(var27_28);
        this.logger.logOptions(this.options);
        if (this.repetitions == 0) {
            this.repetitions = 1;
        }
        if (this.repetitions >= 3 && this.timing) {
            this.times = new long[this.repetitions];
            this.timesCounter = 0;
        }
        if (var9_9 != 0) {
            this.filenames = new String[var9_9];
            System.arraycopy(this.filenames, 0, this.filenames, 0, var9_9);
        }
        if (var10_10 != 0) {
            this.classNames = new String[var10_10];
            System.arraycopy(this.classNames, 0, this.classNames, 0, var10_10);
        }
        this.setPaths(var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var22_22);
    }

    protected void disableWarnings() {
        Object[] objectArray = this.options.entrySet().toArray();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Map.Entry entry = (Map.Entry)objectArray[n];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "ignore");
            }
            ++n;
        }
        this.options.put("org.eclipse.wst.jsdt.core.compiler.taskTags", Util.EMPTY_STRING);
    }

    public String extractDestinationPathFromSourceFile(CompilationResult compilationResult) {
        String string;
        File file;
        char[] cArray;
        int n;
        ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
        if (iCompilationUnit != null && (n = CharOperation.lastIndexOf(File.separatorChar, cArray = iCompilationUnit.getFileName())) != -1 && (file = new File(string = new String(cArray, 0, n))).exists() && file.isDirectory()) {
            return string;
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                int n;
                if (compilationResult.lineSeparatorPositions != null) {
                    n = compilationResult.lineSeparatorPositions.length;
                    Main.this.lineCount += (long)n;
                    this.lineDelta += n;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.logger.logProgress();
                        this.lineDelta = 0;
                    }
                }
                Main.this.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    n = Main.this.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), Main.this);
                    if (Main.this.systemExitWhenFinished && !Main.this.proceedOnError && n > 0) {
                        CompilationUnitDeclaration[] compilationUnitDeclarationArray = Main.this.batchCompiler.unitsToProcess;
                        int n2 = 0;
                        int n3 = Main.this.batchCompiler.totalUnits;
                        while (n2 < n3) {
                            CompilationResult compilationResult2;
                            CompilationUnitDeclaration compilationUnitDeclaration = compilationUnitDeclarationArray[n2];
                            if (compilationUnitDeclaration != null && (compilationResult2 = compilationUnitDeclaration.compilationResult).hasProblems() && !compilationResult2.hasBeenAccepted) {
                                Main.this.logger.logProblems(compilationResult2.getAllProblems(), compilationResult2.compilationUnit.getContents(), Main.this);
                            }
                            ++n2;
                        }
                        Main.this.logger.endLoggingSource();
                        Main.this.logger.endLoggingSources();
                        Main.this.logger.printStats();
                        Main.this.logger.flush();
                        Main.this.logger.close();
                        System.exit(-1);
                    }
                }
                Main.this.outputClassFiles(compilationResult);
                Main.this.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() throws InvalidInputException {
        int n = this.filenames.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n);
        String string = (String)this.options.get("org.eclipse.wst.jsdt.core.encoding");
        if (Util.EMPTY_STRING.equals(string)) {
            string = null;
        }
        int n2 = 0;
        while (n2 < n) {
            char[] cArray = this.filenames[n2].toCharArray();
            if (hashtableOfObject.get(cArray) != null) {
                throw new InvalidInputException(this.bind("unit.more", this.filenames[n2]));
            }
            hashtableOfObject.put(cArray, cArray);
            File file = new File(this.filenames[n2]);
            if (!file.exists()) {
                throw new InvalidInputException(this.bind("unit.missing", this.filenames[n2]));
            }
            String string2 = this.encodings[n2];
            if (string2 == null) {
                string2 = string;
            }
            compilationUnitArray[n2] = new CompilationUnit(null, this.filenames[n2], string2, this.destinationPaths[n2]);
            ++n2;
        }
        return compilationUnitArray;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            String string = System.getProperty("java.home");
            if (string != null) {
                this.javaHomeCache = new File(string);
                if (!this.javaHomeCache.exists()) {
                    this.javaHomeCache = null;
                }
            }
        }
        return this.javaHomeCache;
    }

    public FileSystem getLibraryAccess() {
        return new FileSystem(this.checkedClasspaths, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(this.compilerLocale);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this.initialize(printWriter, printWriter2, bl, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.logger = new Logger(this, printWriter, printWriter2);
        this.proceed = true;
        this.out = printWriter;
        this.err = printWriter2;
        this.systemExitWhenFinished = bl;
        this.options = new CompilerOptions().getMap();
        if (map != null) {
            this.didSpecifySource = map.get("org.eclipse.wst.jsdt.core.compiler.source") != null;
            this.didSpecifyTarget = map.get("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform") != null;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.options.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
        this.classNames = null;
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            String string = null;
            boolean bl = false;
            CompilationUnit compilationUnit = (CompilationUnit)compilationResult.compilationUnit;
            if (compilationUnit.destinationPath == null) {
                if (this.destinationPath == null) {
                    string = this.extractDestinationPathFromSourceFile(compilationResult);
                } else if (this.destinationPath != NONE) {
                    string = this.destinationPath;
                    bl = true;
                }
            } else if (compilationUnit.destinationPath != NONE) {
                string = compilationUnit.destinationPath;
                bl = true;
            }
            if (string != null) {
                int n = 0;
                int n2 = classFileArray.length;
                while (n < n2) {
                    ClassFile classFile = classFileArray[n];
                    char[] cArray = classFile.fileName();
                    int n3 = cArray.length;
                    char[] cArray2 = new char[n3 + 6];
                    System.arraycopy(cArray, 0, cArray2, 0, n3);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n3, 6);
                    CharOperation.replace(cArray2, '/', File.separatorChar);
                    String string2 = new String(cArray2);
                    try {
                        if (this.compilerOptions.verbose) {
                            this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string2}));
                        }
                        ClassFile.writeToDisk(bl, string, string2, classFile);
                        LookupEnvironment lookupEnvironment = this.batchCompiler.lookupEnvironment;
                        if (classFile.isShared) {
                            lookupEnvironment.classFilePool.release(classFile);
                        }
                        this.logger.logClassFile(bl, string, string2);
                        ++this.exportedClassFilesCounter;
                    }
                    catch (IOException iOException) {
                        this.logger.logNoClassFileCreated(string, string2, iOException);
                    }
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performCompilation() throws InvalidInputException {
        this.startTime = System.currentTimeMillis();
        FileSystem fileSystem = this.getLibraryAccess();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performMethodsFullRecovery = false;
        this.compilerOptions.performStatementsRecovery = false;
        this.batchCompiler = new Compiler((INameEnvironment)fileSystem, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out);
        if (this.compilerOptions.complianceLevel >= 0x320000L && this.compilerOptions.processAnnotations) {
            if (this.checkVMVersion(0x320000L)) {
                this.initializeAnnotationProcessorManager();
                if (this.classNames != null) {
                    this.batchCompiler.setBinaryTypes(this.processClassNames(this.batchCompiler.lookupEnvironment));
                }
            } else {
                this.logger.logIncorrectVMVersionForAnnotationProcessing();
            }
        }
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            this.batchCompiler.compile(this.getCompilationUnits());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.logger.endLoggingSources();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.logger.endLoggingSources();
            if (this.extraProblems != null) {
                this.logger.loggingExtraProblems(this);
                this.extraProblems = null;
            }
            this.logger.printStats();
            fileSystem.cleanup();
            return;
        }
    }

    private ReferenceBinding[] processClassNames(LookupEnvironment lookupEnvironment) throws InvalidInputException {
        int n = this.classNames.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string = this.classNames[n2];
            Object object2 = null;
            if (string.indexOf(46) != -1) {
                object = string.toCharArray();
                object2 = CharOperation.splitOn('.', (char[])object);
            } else {
                object2 = new char[][]{string.toCharArray()};
            }
            object = lookupEnvironment.getType((char[][])object2);
            if (object != null && ((Binding)object).isValidBinding()) {
                if (((ReferenceBinding)object).isBinaryBinding()) {
                    referenceBindingArray[n2] = object;
                }
            } else {
                throw new InvalidInputException(this.bind("configure.invalidClassName", string));
            }
            ++n2;
        }
        return referenceBindingArray;
    }

    protected void initializeAnnotationProcessorManager() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.wst.jsdt.internal.compiler.apt.dispatch.BatchAnnotationProcessorManager");
            AbstractAnnotationProcessorManager abstractAnnotationProcessorManager = (AbstractAnnotationProcessorManager)clazz.newInstance();
            abstractAnnotationProcessorManager.configure(this, this.expandedCommandLine);
            abstractAnnotationProcessorManager.setErr(this.err);
            abstractAnnotationProcessorManager.setOut(this.out);
            this.batchCompiler.annotationProcessorManager = abstractAnnotationProcessorManager;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            throw new AbortCompilation();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbortCompilation();
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            this.logger.logIncorrectVMVersionForAnnotationProcessing();
        }
    }

    public void printUsage() {
        this.printUsage("misc.usage");
    }

    private void printUsage(String string) {
        this.logger.logUsage(this.bind(string, new String[]{System.getProperty("path.separator"), this.bind("compiler.name"), this.bind("compiler.version"), this.bind("compiler.copyright")}));
        this.logger.flush();
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) throws InvalidInputException {
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(File.pathSeparator) + "[]", true);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList3.add(stringTokenizer.nextToken());
        }
        int n2 = 0;
        String string5 = null;
        int n3 = 0;
        int n4 = arrayList3.size();
        int n5 = -1;
        while (n3 < n4 && n2 != 99) {
            if ((string5 = (String)arrayList3.get(n3++)).equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: 
                    case 3: 
                    case 10: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                        arrayList2.clear();
                        break;
                    }
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        throw new InvalidInputException(this.bind("configure.incorrectDestinationPathEntry", string));
                    }
                    case 11: {
                        n3 = n5 + 1;
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("[")) {
                switch (n2) {
                    case 0: {
                        string3 = "";
                    }
                    case 1: {
                        n5 = n3 - 1;
                    }
                    case 11: {
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        break;
                    }
                    case 7: {
                        n2 = 8;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else {
                switch (n2) {
                    case 0: 
                    case 3: {
                        n2 = 1;
                        string3 = string5;
                        break;
                    }
                    case 5: {
                        if (string5.startsWith("-d ")) {
                            if (string4 != null) {
                                throw new InvalidInputException(this.bind("configure.duplicateDestinationPathEntry", string));
                            }
                            string4 = string5.substring(3).trim();
                            n2 = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (string4 != null) {
                            throw new InvalidInputException(this.bind("configure.accessRuleAfterDestinationPath", string));
                        }
                        n2 = 6;
                        arrayList2.add(string5);
                        break;
                    }
                    case 9: {
                        if (!string5.startsWith("-d ")) {
                            n2 = 99;
                            break;
                        }
                        string4 = string5.substring(3).trim();
                        n2 = 7;
                        break;
                    }
                    case 11: {
                        int n6 = n5;
                        while (n6 < n3) {
                            string3 = String.valueOf(string3) + (String)arrayList3.get(n6);
                            ++n6;
                        }
                        n2 = 1;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        n2 = 99;
                    }
                }
            }
            if (n2 != 11 || n3 != n4) continue;
            n3 = n5 + 1;
            n2 = 5;
        }
        switch (n2) {
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                break;
            }
            default: {
                if (string.length() == 0) break;
                this.logger.logIncorrectClasspath(string);
            }
        }
    }

    private int processPaths(String[] stringArray, int n, String string, ArrayList arrayList) throws InvalidInputException {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n4 < n5) {
            switch (string.charAt(n4)) {
                case '[': {
                    ++n3;
                    break;
                }
                case ']': {
                    --n3;
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            if (n3 > 1) {
                throw new InvalidInputException(this.bind("configure.unexpectedBracket", string));
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (n2 >= stringArray.length) {
                    throw new InvalidInputException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[++n2];
                int n6 = 0;
                int n7 = string2.length();
                while (n6 < n7) {
                    switch (string2.charAt(n6)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new InvalidInputException(this.bind("configure.unexpectedBracket", string2));
                            }
                            ++n3;
                            break;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                    ++n6;
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    arrayList.add(stringBuffer.toString());
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new InvalidInputException(this.bind("configure.unexpectedBracket", string2));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        arrayList.add(string);
        return n2 - n;
    }

    private int processPaths(String[] stringArray, int n, String string, String[] stringArray2) throws InvalidInputException {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n4 < n5) {
            switch (string.charAt(n4)) {
                case '[': {
                    ++n3;
                    break;
                }
                case ']': {
                    --n3;
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (++n2 >= stringArray.length) {
                    throw new InvalidInputException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[n2];
                int n6 = 0;
                int n7 = string2.length();
                while (n6 < n7) {
                    switch (string2.charAt(n6)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new InvalidInputException(this.bind("configure.unexpectedBracket", string));
                            }
                            ++n3;
                            break;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                    ++n6;
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    stringArray2[0] = stringBuffer.toString();
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new InvalidInputException(this.bind("configure.unexpectedBracket", string));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        stringArray2[0] = string;
        return n2 - n;
    }

    public void relocalize() {
        this.relocalize(Locale.getDefault());
    }

    private void relocalize(Locale locale) {
        this.compilerLocale = locale;
        try {
            this.bundle = ResourceBundleFactory.getBundle(locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
    }

    public void setLocale(Locale locale) {
        this.relocalize(locale);
    }

    protected void setDestinationPath(String string) {
        this.destinationPath = string;
    }

    protected void setPaths(ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, String string2) throws InvalidInputException {
        arrayList = this.handleBootclasspath(arrayList, string2);
        arrayList3 = this.handleClasspath(arrayList3, string2);
        if (string != null) {
            this.processPathEntries(4, arrayList2, string, string2, true, false);
        }
        arrayList4 = this.handleExtdirs(arrayList4);
        arrayList5 = this.handleEndorseddirs(arrayList5);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList3 = arrayList;
        arrayList3 = FileSystem.ClasspathNormalizer.normalize(arrayList3);
        this.checkedClasspaths = new FileSystem.Classpath[arrayList3.size()];
        arrayList3.toArray(this.checkedClasspaths);
        this.logger.logClasspath(this.checkedClasspaths);
    }

    protected void validateOptions(boolean bl) throws InvalidInputException {
        Object v;
        Object v2;
        if (bl) {
            v2 = this.options.get("org.eclipse.wst.jsdt.core.compiler.compliance");
            if ("1.3".equals(v2)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.wst.jsdt.core.compiler.source");
                    if ("1.3".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.2");
                        }
                    } else if ("1.4".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.4");
                    }
                } else {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.2");
                    }
                }
            } else if ("1.5".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.wst.jsdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                } else {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                }
            } else if ("1.6".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.wst.jsdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if (("1.5".equals(v) || "1.6".equals(v)) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                } else {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.6");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                }
            } else if ("1.7".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.wst.jsdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) || "1.6".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
                        }
                    } else if ("1.7".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                } else {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.7");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                }
            }
        } else if (this.didSpecifySource) {
            v2 = this.options.get("org.eclipse.wst.jsdt.core.compiler.source");
            if ("1.4".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.4");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            } else if ("1.7".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.7");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.7");
                }
            }
        }
        v2 = this.options.get("org.eclipse.wst.jsdt.core.compiler.source");
        v = this.options.get("org.eclipse.wst.jsdt.core.compiler.compliance");
        if (v2.equals("1.7") && CompilerOptions.versionToJdkLevel(v) < 0x330000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.wst.jsdt.core.compiler.compliance"), "1.7"));
        }
        if (v2.equals("1.6") && CompilerOptions.versionToJdkLevel(v) < 0x320000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.wst.jsdt.core.compiler.compliance"), "1.6"));
        }
        if (v2.equals("1.5") && CompilerOptions.versionToJdkLevel(v) < 0x310000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.wst.jsdt.core.compiler.compliance"), "1.5"));
        }
        if (v2.equals("1.4") && CompilerOptions.versionToJdkLevel(v) < 0x300000L) {
            throw new InvalidInputException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.wst.jsdt.core.compiler.compliance"), "1.4"));
        }
        if (this.didSpecifyTarget) {
            Object v3 = this.options.get("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform");
            if ("jsr14".equals(v3)) {
                if (CompilerOptions.versionToJdkLevel(v2) < 0x310000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForGenericSource", (String)v3, (String)v2));
                }
            } else {
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x330000L && CompilerOptions.versionToJdkLevel(v3) < 0x330000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.7"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x320000L && CompilerOptions.versionToJdkLevel(v3) < 0x320000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.6"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x310000L && CompilerOptions.versionToJdkLevel(v3) < 0x310000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.5"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x300000L && CompilerOptions.versionToJdkLevel(v3) < 0x300000L) {
                    throw new InvalidInputException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.4"));
                }
                if (CompilerOptions.versionToJdkLevel(v) < CompilerOptions.versionToJdkLevel(v3)) {
                    throw new InvalidInputException(this.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.wst.jsdt.core.compiler.compliance"), (String)v3));
                }
            }
        }
    }

    public static class Logger {
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_NAME = "name";
        private static final String COMPILER_VERSION = "version";
        public static final int EMACS = 2;
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String EXCEPTION = "exception";
        private static final String EXTRA_PROBLEM_TAG = "extra_problem";
        private static final String EXTRA_PROBLEMS = "extra_problems";
        private static final HashtableOfInt FIELD_TABLE = new HashtableOfInt();
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String OUTPUT = "output";
        private static final String PACKAGE = "package";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_CATEGORY_ID = "categoryID";
        private static final String ID = "id";
        private static final String PROBLEM_ID = "problemID";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_OPTION_KEY = "optionKey";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        public static final int XML = 1;
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.003 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_003.dtd\">";
        private PrintWriter err;
        private PrintWriter log;
        private Main main;
        private PrintWriter out;
        private HashMap parameters;
        int tagBits;

        static {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.compiler.IProblem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> clazz2 = clazz;
                Field[] fieldArray = clazz2.getFields();
                int n = 0;
                int n2 = fieldArray.length;
                while (n < n2) {
                    Field field = fieldArray[n];
                    if (field.getType().equals(Integer.TYPE)) {
                        Integer n3 = (Integer)field.get(null);
                        FIELD_TABLE.put((int)(n3 & 0xFFFFFF), field.getName());
                    }
                    ++n;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        public Logger(Main main, PrintWriter printWriter, PrintWriter printWriter2) {
            this.out = printWriter;
            this.err = printWriter2;
            this.parameters = new HashMap();
            this.main = main;
        }

        public String buildFileName(String string, String string2) {
            char c = File.separatorChar;
            String string3 = File.separator;
            string = string.replace('/', c);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(string3)) {
                stringBuffer.append(string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4).append(string3);
                string4 = stringTokenizer.nextToken();
            }
            return stringBuffer.append(string4).toString();
        }

        public void close() {
            if (this.log != null) {
                if ((this.tagBits & 1) != 0) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(this.main.bind("progress.compiling"));
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        private void endLoggingExtraProblems() {
            this.endTag(EXTRA_PROBLEMS);
        }

        public void endLoggingSource() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if ((this.tagBits & 1) != 0) {
                this.endTag("tasks");
            }
        }

        private void endTag(String string) {
            ((GenericXMLWriter)this.log).endTag(string, true, true);
        }

        private void extractContext(CategorizedProblem categorizedProblem, char[] cArray) {
            char c;
            int n;
            int n2 = categorizedProblem.getSourceStart();
            int n3 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {}
            }
            int n4 = n = cArray == null ? 0 : cArray.length;
            if (n2 > n3 || n2 < 0 && n3 < 0 || n <= 0 || n3 > n) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
                return;
            }
            int n5 = n2 >= n ? n - 1 : n2;
            while (n5 > 0) {
                c = cArray[n5 - 1];
                if (c == '\n' || c == '\r') break;
                --n5;
            }
            int n6 = n3 >= n ? n - 1 : n3;
            while (n6 + 1 < n) {
                c = cArray[n6 + 1];
                if (c == '\r' || c == '\n') break;
                ++n6;
            }
            while ((c = cArray[n5]) == ' ' || c == '\t') {
                ++n5;
            }
            while ((c = cArray[n6]) == ' ' || c == '\t') {
                --n6;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n5, n6 - n5 + 1);
            this.parameters.put("value", String.valueOf(stringBuffer));
            this.parameters.put(SOURCE_START, Integer.toString(n2 - n5));
            this.parameters.put(SOURCE_END, Integer.toString(n3 - n5));
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        private String getFieldName(int n) {
            return (String)FIELD_TABLE.get(n & 0xFFFFFF);
        }

        private String getProblemOptionKey(int n) {
            long l = ProblemReporter.getIrritant(n);
            return CompilerOptions.optionKeyFromIrritant(l);
        }

        public void logAverage(long[] lArray, long l) {
            Arrays.sort(lArray);
            int n = lArray.length;
            long l2 = 0L;
            int n2 = 1;
            int n3 = n - 1;
            while (n2 < n3) {
                l2 += lArray[n2];
                ++n2;
            }
            long l3 = l2 / (long)(n - 2);
            this.printlnOut(this.main.bind("compile.averageTime", new String[]{String.valueOf(l), String.valueOf(l3), String.valueOf((double)((int)((double)l * 10000.0 / (double)l3)) / 10.0)}));
        }

        public void logClassFile(boolean bl, String string, String string2) {
            if ((this.tagBits & 1) != 0) {
                String string3 = null;
                if (bl) {
                    string3 = this.buildFileName(string, string2);
                } else {
                    char c = File.separatorChar;
                    String string4 = File.separator;
                    string = string.replace('/', c);
                    int n = string2.lastIndexOf(c);
                    if (n == -1) {
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2 : String.valueOf(string) + string4 + string2;
                    } else {
                        int n2 = string2.length();
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2.substring(n + 1, n2) : String.valueOf(string) + string4 + string2.substring(n + 1, n2);
                    }
                }
                File file = new File(string3);
                try {
                    this.parameters.put(PATH, file.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(string, string2, iOException);
                }
            }
        }

        public void logClasspath(FileSystem.Classpath[] classpathArray) {
            int n;
            if (classpathArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = classpathArray.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                int n2 = 0;
                while (n2 < n) {
                    String string = classpathArray[n2].getPath();
                    this.parameters.put(PATH, string);
                    File file = new File(string);
                    String string2 = null;
                    if (file.isFile()) {
                        string2 = Util.isArchiveFileName(string) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (file.isDirectory()) {
                        string2 = CLASSPATH_FOLDER;
                    }
                    if (string2 != null) {
                        this.parameters.put("id", string2);
                        this.printTag(CLASSPATH, this.parameters, true, true);
                    }
                    ++n2;
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logCommandLineArguments(String[] stringArray) {
            int n;
            if (stringArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = stringArray.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                int n2 = 0;
                while (n2 < n) {
                    this.parameters.put("value", stringArray[n2]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n2;
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception exception) {
            Object object;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            String string = stringWriter.getBuffer().toString();
            if ((this.tagBits & 1) != 0) {
                object = new LineNumberReader(new StringReader(string));
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = exception.getMessage();
                if (string2 != null) {
                    stringBuffer.append(string2).append(Util.LINE_SEPARATOR);
                }
                try {
                    String string3;
                    while ((string3 = ((LineNumberReader)object).readLine()) != null && n < 4) {
                        stringBuffer.append(string3).append(Util.LINE_SEPARATOR);
                        ++n;
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {}
                string2 = stringBuffer.toString();
                this.parameters.put("message", string2);
                this.parameters.put(CLASS, exception.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            if ((object = exception.getMessage()) == null) {
                this.printlnErr(string);
            } else {
                this.printlnErr((String)object);
            }
        }

        public void logIncorrectClasspath(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectClasspath", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectClasspath", string));
        }

        public void logIncorrectEndorsedDirsEntry(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectEndorsedDirsEntry", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectEndorsedDirsEntry", string));
        }

        public void logIncorrectExtDirsEntry(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectExtDirsEntry", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectExtDirsEntry", string));
        }

        public void logIncorrectVMVersionForAnnotationProcessing() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectVMVersionforAPT"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectVMVersionforAPT"));
        }

        public void logNoClassFileCreated(String string, String string2, IOException iOException) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
        }

        public void logNoClasspath() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.noClasspath"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.noClasspath"));
        }

        public void logNumberOfClassFilesGenerated(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Integer(n));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (n == 1) {
                this.printlnOut(this.main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(this.main.bind("compile.severalClassFilesGenerated", String.valueOf(n)));
            }
        }

        public void logOptions(Map map) {
            if ((this.tagBits & 1) != 0) {
                this.printTag(OPTIONS, null, true, false);
                Set set = map.entrySet();
                Object[] objectArray = set.toArray();
                Arrays.sort(objectArray, new Comparator(this){
                    final /* synthetic */ Logger this$1;
                    {
                        this.this$1 = logger;
                    }

                    public int compare(Object object, Object object2) {
                        Map.Entry entry = (Map.Entry)object;
                        Map.Entry entry2 = (Map.Entry)object2;
                        return ((String)entry.getKey()).compareTo((String)entry2.getKey());
                    }
                });
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    Map.Entry entry = (Map.Entry)objectArray[n];
                    String string = (String)entry.getKey();
                    this.parameters.put(KEY, string);
                    this.parameters.put("value", entry.getValue());
                    this.printTag(OPTION, this.parameters, true, true);
                    ++n;
                }
                this.endTag(OPTIONS);
            }
        }

        private void logProblem(CategorizedProblem categorizedProblem, int n, int n2, char[] cArray) {
            if ((this.tagBits & 2) != 0) {
                String string = String.valueOf(new String(categorizedProblem.getOriginatingFileName())) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string);
                String string2 = this.errorReportSource(categorizedProblem, cArray, this.tagBits);
                if (string2.length() != 0) {
                    this.printlnErr(string2);
                }
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())) : this.main.bind("requestor.warning", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())));
                try {
                    String string = this.errorReportSource(categorizedProblem, cArray, 0);
                    this.printlnErr(string);
                    this.printlnErr(categorizedProblem.getMessage());
                }
                catch (Exception exception) {
                    this.printlnErr(this.main.bind("requestor.notRetrieveErrorMessage", categorizedProblem.toString()));
                }
                this.printlnErr("----------");
            }
        }

        public int logProblems(CategorizedProblem[] categorizedProblemArray, char[] cArray, Main main) {
            int n = categorizedProblemArray.length;
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n) {
                    categorizedProblem = categorizedProblemArray[n7];
                    if (categorizedProblem != null) {
                        ++main.globalProblemsCount;
                        this.logProblem(categorizedProblem, n3, main.globalProblemsCount, cArray);
                        ++n3;
                        if (categorizedProblem.isError()) {
                            ++n2;
                            ++n4;
                            ++main.globalErrorsCount;
                        } else if (categorizedProblem.getID() == 536871362) {
                            ++main.globalTasksCount;
                            ++n6;
                        } else {
                            ++main.globalWarningsCount;
                            ++n5;
                        }
                    }
                    ++n7;
                }
                if ((this.tagBits & 1) != 0) {
                    if (n4 + n5 != 0) {
                        this.startLoggingProblems(n4, n5);
                        n7 = 0;
                        while (n7 < n) {
                            categorizedProblem = categorizedProblemArray[n7];
                            if (categorizedProblem != null && categorizedProblem.getID() != 536871362) {
                                this.logXmlProblem(categorizedProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingProblems();
                    }
                    if (n6 != 0) {
                        this.startLoggingTasks(n6);
                        n7 = 0;
                        while (n7 < n) {
                            categorizedProblem = categorizedProblemArray[n7];
                            if (categorizedProblem != null && categorizedProblem.getID() == 536871362) {
                                this.logXmlTask(categorizedProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingTasks();
                    }
                }
            }
            return n2;
        }

        public void logProblemsSummary(int n, int n2, int n3, int n4) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("problems", new Integer(n));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(n2));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n3));
                this.parameters.put("tasks", new Integer(n4));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (n == 1) {
                String string = null;
                string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.oneWarning");
                this.printErr(this.main.bind("compile.oneProblem", string));
            } else {
                int n5;
                String string = null;
                String string2 = null;
                if (n2 > 0) {
                    string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.severalErrors", String.valueOf(n2));
                }
                if ((n5 = n3 + n4) > 0) {
                    string2 = n5 == 1 ? this.main.bind("compile.oneWarning") : this.main.bind("compile.severalWarnings", String.valueOf(n5));
                }
                if (string == null || string2 == null) {
                    if (string == null) {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string2));
                    } else {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string));
                    }
                } else {
                    this.printErr(this.main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(n), string, string2}));
                }
            }
            if ((this.tagBits & 2) != 0) {
                this.printlnErr();
            }
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int n, int n2) {
            this.printlnOut(this.main.bind("compile.repetition", String.valueOf(n + 1), String.valueOf(n2)));
        }

        public void logTiming(long l, long l2) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Long(l));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.put("value", new Long(l2));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (l2 != 0L) {
                this.printlnOut(this.main.bind("compile.instantTime", new String[]{String.valueOf(l2), String.valueOf(l), String.valueOf((double)((int)((double)l2 * 10000.0 / (double)l)) / 10.0)}));
            } else {
                this.printlnOut(this.main.bind("compile.totalTime", String.valueOf(l)));
            }
        }

        public void logUsage(String string) {
            this.printlnOut(string);
        }

        public void logVersion(boolean bl) {
            if (this.log != null && (this.tagBits & 1) == 0) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.log.println("# " + string);
                if (bl) {
                    this.out.println(string);
                    this.out.flush();
                }
            } else if (bl) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.out.println(string);
                this.out.flush();
            }
        }

        public void logWrongJDK() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlProblem(CategorizedProblem categorizedProblem, char[] cArray) {
            int n = categorizedProblem.getSourceStart();
            int n2 = categorizedProblem.getSourceEnd();
            int n3 = categorizedProblem.getID();
            this.parameters.put("id", this.getFieldName(n3));
            this.parameters.put(PROBLEM_ID, new Integer(n3));
            boolean bl = categorizedProblem.isError();
            int n4 = bl ? 1 : 0;
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n2));
            String string = this.getProblemOptionKey(n3);
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            int n5 = ProblemReporter.getProblemCategory(n4, n3);
            this.parameters.put(PROBLEM_CATEGORY_ID, new Integer(n5));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            String[] stringArray = categorizedProblem.getArguments();
            int n6 = stringArray.length;
            if (n6 != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                int n7 = 0;
                while (n7 < n6) {
                    this.parameters.put("value", stringArray[n7]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n7;
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(CategorizedProblem categorizedProblem, char[] cArray) {
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(categorizedProblem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(categorizedProblem.getSourceEnd()));
            String string = this.getProblemOptionKey(categorizedProblem.getID());
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.endTag(TASK);
        }

        private void printErr(String string) {
            this.err.print(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.print(string);
            }
        }

        private void printlnErr() {
            this.err.println();
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println();
            }
        }

        private void printlnErr(String string) {
            this.err.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        private void printlnOut(String string) {
            this.out.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printStats() {
            boolean bl = this.main.timing;
            if ((this.tagBits & 1) != 0) {
                this.printTag(STATS, null, true, false);
            }
            if (bl) {
                long l = System.currentTimeMillis() - this.main.startTime;
                this.logTiming(l, this.main.lineCount);
                if (this.main.times != null) {
                    this.main.times[this.main.timesCounter++] = l;
                }
            }
            if (this.main.globalProblemsCount > 0) {
                this.logProblemsSummary(this.main.globalProblemsCount, this.main.globalErrorsCount, this.main.globalWarningsCount, this.main.globalTasksCount);
            }
            if (this.main.exportedClassFilesCounter != 0 && (this.main.showProgress || bl || this.main.verbose)) {
                this.logNumberOfClassFilesGenerated(this.main.exportedClassFilesCounter);
            }
            if ((this.tagBits & 1) != 0) {
                this.endTag(STATS);
            }
        }

        private void printTag(String string, HashMap hashMap, boolean bl, boolean bl2) {
            ((GenericXMLWriter)this.log).printTag(string, this.parameters, true, bl, bl2);
            this.parameters.clear();
        }

        public void setEmacs() {
            this.tagBits |= 2;
        }

        public void setLog(String string) throws InvalidInputException {
            block6: {
                Date date = new Date();
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
                try {
                    int n = string.lastIndexOf(46);
                    if (n != -1) {
                        if (string.substring(n).toLowerCase().equals(".xml")) {
                            this.log = new GenericXMLWriter((OutputStream)new FileOutputStream(string, false), Util.LINE_SEPARATOR, true);
                            this.tagBits |= 1;
                            try {
                                this.log.println("<!-- " + new String(dateFormat.format(date).getBytes(), "UTF-8") + " -->");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                unsupportedEncodingException.printStackTrace();
                            }
                            this.log.println(XML_DTD_DECLARATION);
                            this.parameters.put(COMPILER_NAME, this.main.bind("compiler.name"));
                            this.parameters.put(COMPILER_VERSION, this.main.bind("compiler.version"));
                            this.parameters.put(COMPILER_COPYRIGHT, this.main.bind("compiler.copyright"));
                            this.printTag(COMPILER, this.parameters, true, false);
                            break block6;
                        }
                        this.log = new PrintWriter(new FileOutputStream(string, false));
                        this.log.println("# " + dateFormat.format(date));
                        break block6;
                    }
                    this.log = string.equals("con") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(string, false));
                    this.log.println("# " + dateFormat.format(date));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new InvalidInputException(this.main.bind("configure.cannotOpenLog", string));
                }
            }
        }

        private void startLoggingProblems(int n, int n2) {
            this.parameters.put("problems", new Integer(n + n2));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(n));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n2));
            this.printTag("problems", this.parameters, true, false);
        }

        private void startLoggingExtraProblems(int n) {
            this.parameters.put("problems", new Integer(n));
            this.printTag(EXTRA_PROBLEMS, this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if ((this.tagBits & 1) != 0) {
                ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
                if (iCompilationUnit != null) {
                    char[][] cArray;
                    char[] cArray2 = iCompilationUnit.getFileName();
                    File file = new File(new String(cArray2));
                    if (cArray2 != null) {
                        this.parameters.put(PATH, file.getAbsolutePath());
                    }
                    if ((cArray = compilationResult.packageName) != null) {
                        this.parameters.put(PACKAGE, new String(CharOperation.concatWith(cArray, File.separatorChar)));
                    }
                    CompilationUnit compilationUnit = (CompilationUnit)iCompilationUnit;
                    String string = compilationUnit.destinationPath;
                    if (string == null) {
                        string = this.main.destinationPath;
                    }
                    if (string != null && string != Main.NONE) {
                        if (File.separatorChar == '/') {
                            this.parameters.put(OUTPUT, string);
                        } else {
                            this.parameters.put(OUTPUT, string.replace('/', File.separatorChar));
                        }
                    }
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("tasks", new Integer(n));
                this.printTag("tasks", this.parameters, true, false);
            }
        }

        public void loggingExtraProblems(Main main) {
            ArrayList arrayList = main.extraProblems;
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n) {
                    categorizedProblem = (CategorizedProblem)arrayList.get(n6);
                    if (categorizedProblem != null) {
                        ++main.globalProblemsCount;
                        this.logExtraProblem(categorizedProblem, n3, main.globalProblemsCount);
                        ++n3;
                        if (categorizedProblem.isError()) {
                            ++n2;
                            ++n4;
                            ++main.globalErrorsCount;
                        } else if (categorizedProblem.isWarning()) {
                            ++main.globalWarningsCount;
                            ++n5;
                        }
                    }
                    ++n6;
                }
                if ((this.tagBits & 1) != 0 && n4 + n5 != 0) {
                    this.startLoggingExtraProblems(n);
                    n6 = 0;
                    while (n6 < n) {
                        categorizedProblem = (CategorizedProblem)arrayList.get(n6);
                        if (categorizedProblem != null && categorizedProblem.getID() != 536871362) {
                            this.logXmlExtraProblem(categorizedProblem, n3, main.globalProblemsCount);
                        }
                        ++n6;
                    }
                    this.endLoggingExtraProblems();
                }
            }
        }

        private void logXmlExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            int n3 = categorizedProblem.getSourceStart();
            int n4 = categorizedProblem.getSourceEnd();
            boolean bl = categorizedProblem.isError();
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n3));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n4));
            this.printTag(EXTRA_PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, null);
            this.endTag(EXTRA_PROBLEM_TAG);
        }

        private void logExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            String string;
            char[] cArray = categorizedProblem.getOriginatingFileName();
            String string2 = string = cArray == null ? this.main.bind("requestor.noFileNameSpecified") : new String(cArray);
            if ((this.tagBits & 2) != 0) {
                String string3 = String.valueOf(string) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string3);
                String string4 = this.errorReportSource(categorizedProblem, null, this.tagBits);
                this.printlnErr(string4);
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(string)) : this.main.bind("requestor.warning", Integer.toString(n2), new String(string)));
                String string5 = this.errorReportSource(categorizedProblem, null, 0);
                this.printlnErr(string5);
                this.printlnErr(categorizedProblem.getMessage());
                this.printlnErr("----------");
            }
        }

        private String errorReportSource(CategorizedProblem categorizedProblem, char[] cArray, int n) {
            char c;
            int n2;
            int n3 = categorizedProblem.getSourceStart();
            int n4 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {}
            }
            int n5 = n2 = cArray == null ? 0 : cArray.length;
            if (n3 > n4 || n3 < 0 && n4 < 0 || n2 == 0) {
                return Messages.problem_noSourceInformation;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if ((n & 2) == 0) {
                stringBuffer.append(' ').append(Messages.bind(Messages.problem_atLine, String.valueOf(categorizedProblem.getSourceLineNumber())));
                stringBuffer.append(Util.LINE_SEPARATOR);
            }
            stringBuffer.append('\t');
            int n6 = n3 >= n2 ? n2 - 1 : n3;
            while (n6 > 0) {
                c = cArray[n6 - 1];
                if (c == '\n' || c == '\r') break;
                --n6;
            }
            int n7 = n4 >= n2 ? n2 - 1 : n4;
            while (n7 + 1 < n2) {
                c = cArray[n7 + 1];
                if (c == '\r' || c == '\n') break;
                ++n7;
            }
            while ((c = cArray[n6]) == ' ' || c == '\t') {
                ++n6;
            }
            stringBuffer.append(cArray, n6, n7 - n6 + 1);
            stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
            int n8 = n6;
            while (n8 < n3) {
                stringBuffer.append(cArray[n8] == '\t' ? (char)'\t' : ' ');
                ++n8;
            }
            n8 = n3;
            while (n8 <= (n4 >= n2 ? n2 - 1 : n4)) {
                stringBuffer.append('^');
                ++n8;
            }
            return stringBuffer.toString();
        }
    }

    public static class ResourceBundleFactory {
        private static HashMap Cache = new HashMap();

        public static synchronized ResourceBundle getBundle(Locale locale) {
            ResourceBundle resourceBundle = (ResourceBundle)Cache.get(locale);
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(Main.bundleName, locale);
                Cache.put(locale, resourceBundle);
            }
            return resourceBundle;
        }
    }
}

