/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class BasicCompilationUnit
implements ICompilationUnit {
    protected char[] contents;
    protected char[] fileName;
    protected char[][] packageName;
    protected char[] mainTypeName;
    protected String encoding;
    protected LibrarySuperType superType;

    public BasicCompilationUnit(char[] cArray, char[][] cArray2, String string) {
        this.contents = cArray;
        this.fileName = string.toCharArray();
        this.packageName = cArray2;
    }

    public BasicCompilationUnit(char[] cArray, char[][] cArray2, String string, String string2) {
        this(cArray, cArray2, string);
        this.encoding = string2;
    }

    public BasicCompilationUnit(char[] cArray, char[][] cArray2, String string, IJavaElement iJavaElement) {
        this(cArray, cArray2, string);
        if (iJavaElement instanceof ICompilationUnit) {
            this.superType = ((ICompilationUnit)((Object)iJavaElement)).getCommonSuperType();
        }
        this.initEncoding(iJavaElement);
    }

    public BasicCompilationUnit(char[] cArray, char[][] cArray2, String string, IJavaElement iJavaElement, String string2) {
        this(cArray, cArray2, string);
        this.initEncoding(iJavaElement);
        if (string2 != null) {
            this.mainTypeName = string2.toCharArray();
        }
    }

    private void initEncoding(IJavaElement iJavaElement) {
        if (iJavaElement != null) {
            try {
                IJavaProject iJavaProject = iJavaElement.getJavaProject();
                switch (iJavaElement.getElementType()) {
                    case 5: {
                        IFile iFile = (IFile)iJavaElement.getResource();
                        if (iFile != null) {
                            this.encoding = iFile.getCharset();
                            break;
                        }
                    }
                    default: {
                        IProject iProject = (IProject)iJavaProject.getResource();
                        if (iProject != null) {
                            this.encoding = iProject.getDefaultCharset();
                        }
                        break;
                    }
                }
            }
            catch (CoreException coreException) {
                this.encoding = null;
            }
        } else {
            this.encoding = null;
        }
    }

    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent(new File(new String(this.fileName)), this.encoding);
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR;
        }
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public char[] getMainTypeName() {
        if (this.mainTypeName == null) {
            int n;
            int n2;
            int n3 = CharOperation.lastIndexOf('/', this.fileName) + 1;
            if (n3 == 0 || n3 < CharOperation.lastIndexOf('\\', this.fileName)) {
                n3 = CharOperation.lastIndexOf('\\', this.fileName) + 1;
            }
            if ((n2 = CharOperation.indexOf('|', this.fileName) + 1) > n3) {
                n3 = n2;
            }
            if (!((n = CharOperation.lastIndexOf('$', this.fileName)) != -1 && Util.isClassFileName(this.fileName) || (n = CharOperation.lastIndexOf('.', this.fileName)) != -1)) {
                n = this.fileName.length;
            }
            this.mainTypeName = CharOperation.subarray(this.fileName, n3, n);
        }
        return this.mainTypeName;
    }

    public char[][] getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "CompilationUnit: " + new String(this.fileName);
    }

    public LibrarySuperType getCommonSuperType() {
        return this.superType;
    }
}

