/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.util.IClassFileReader;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.BufferManager;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.util.Disassembler;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ClassFileWorkingCopy
extends CompilationUnit {
    public IClassFile classFile;

    public ClassFileWorkingCopy(IClassFile iClassFile, WorkingCopyOwner workingCopyOwner) {
        super((PackageFragment)iClassFile.getParent(), ((BinaryType)((ClassFile)iClassFile).getType()).getSourceFileName(null), workingCopyOwner);
        this.classFile = iClassFile;
    }

    public void commitWorkingCopy(boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    public IBuffer getBuffer() throws JavaModelException {
        if (this.isWorkingCopy()) {
            return super.getBuffer();
        }
        return this.classFile.getBuffer();
    }

    public char[] getContents() {
        try {
            IBuffer iBuffer = this.getBuffer();
            if (iBuffer == null) {
                return CharOperation.NO_CHAR;
            }
            char[] cArray = iBuffer.getCharacters();
            if (cArray == null) {
                return CharOperation.NO_CHAR;
            }
            return cArray;
        }
        catch (JavaModelException javaModelException) {
            return CharOperation.NO_CHAR;
        }
    }

    public IPath getPath() {
        return this.classFile.getPath();
    }

    public IJavaElement getPrimaryElement(boolean bl) {
        if (bl && this.isPrimary()) {
            return this;
        }
        return new ClassFileWorkingCopy(this.classFile, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IResource getResource() {
        return this.classFile.getResource();
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor, Object object) throws JavaModelException {
        Object object2;
        IBuffer iBuffer = this.owner.createBuffer(this);
        if (iBuffer == null) {
            return null;
        }
        if (iBuffer.getCharacters() == null) {
            object2 = this.classFile.getBuffer();
            if (object2 != null) {
                iBuffer.setContents(object2.getCharacters());
            } else {
                IClassFileReader iClassFileReader = ToolFactory.createDefaultClassFileReader(this.classFile, 65535);
                Disassembler disassembler = new Disassembler();
                String string = disassembler.disassemble(iClassFileReader, Util.getLineSeparator("", this.getJavaProject()), 16);
                iBuffer.setContents(string);
            }
        }
        object2 = this.getBufferManager();
        ((BufferManager)object2).addBuffer(iBuffer);
        iBuffer.addBufferChangedListener(this);
        return iBuffer;
    }

    protected void toStringName(StringBuffer stringBuffer) {
        stringBuffer.append(this.classFile.getElementName());
    }
}

