/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRule;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.core.ClasspathAccessRule;
import org.eclipse.wst.jsdt.internal.core.ClasspathAttribute;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.XMLWriter;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClasspathEntry
implements IClasspathEntry {
    public static final String TAG_CLASSPATH = "classpath";
    public static final String TAG_CLASSPATHENTRY = "classpathentry";
    public static final String TAG_OUTPUT = "output";
    public static final String TAG_KIND = "kind";
    public static final String TAG_PATH = "path";
    public static final String TAG_SOURCEPATH = "sourcepath";
    public static final String TAG_ROOTPATH = "rootpath";
    public static final String TAG_EXPORTED = "exported";
    public static final String TAG_INCLUDING = "including";
    public static final String TAG_EXCLUDING = "excluding";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_ATTRIBUTE_NAME = "name";
    public static final String TAG_ATTRIBUTE_VALUE = "value";
    public static final String TAG_COMBINE_ACCESS_RULES = "combineaccessrules";
    public static final String TAG_ACCESS_RULES = "accessrules";
    public static final String TAG_ACCESS_RULE = "accessrule";
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_ACCESSIBLE = "accessible";
    public static final String TAG_NON_ACCESSIBLE = "nonaccessible";
    public static final String TAG_DISCOURAGED = "discouraged";
    public static final String TAG_IGNORE_IF_BETTER = "ignoreifbetter";
    public int entryKind;
    public int contentKind;
    public IPath path;
    private IPath[] inclusionPatterns;
    private char[][] fullInclusionPatternChars;
    private IPath[] exclusionPatterns;
    private char[][] fullExclusionPatternChars;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    private boolean combineAccessRules;
    private String rootID;
    private AccessRuleSet accessRuleSet;
    public static final IPath[] INCLUDE_ALL = new IPath[0];
    public static final IPath[] EXCLUDE_NONE = new IPath[0];
    public static final IClasspathAttribute[] NO_EXTRA_ATTRIBUTES = new IClasspathAttribute[0];
    public static final IAccessRule[] NO_ACCESS_RULES = new IAccessRule[0];
    public IPath sourceAttachmentPath;
    public IPath sourceAttachmentRootPath;
    public IPath specificOutputLocation;
    public static final int K_OUTPUT = 10;
    public boolean isExported;
    IClasspathAttribute[] extraAttributes;

    public ClasspathEntry(int n, int n2, IPath iPath, IPath[] iPathArray, IPath[] iPathArray2, IPath iPath2, IPath iPath3, IPath iPath4, boolean bl, IAccessRule[] iAccessRuleArray, boolean bl2, IClasspathAttribute[] iClasspathAttributeArray) {
        int n3;
        this.contentKind = n;
        this.entryKind = n2;
        this.path = iPath;
        this.inclusionPatterns = iPathArray;
        this.exclusionPatterns = iPathArray2;
        if (iAccessRuleArray != null && (n3 = iAccessRuleArray.length) > 0) {
            AccessRule[] accessRuleArray = new AccessRule[n3];
            System.arraycopy(iAccessRuleArray, 0, accessRuleArray, 0, n3);
            this.accessRuleSet = new AccessRuleSet(accessRuleArray, this.getMessageTemplates());
        }
        this.combineAccessRules = bl2;
        this.extraAttributes = iClasspathAttributeArray;
        if (iPathArray != INCLUDE_ALL && iPathArray.length > 0) {
            this.fullInclusionPatternChars = UNINIT_PATTERNS;
        }
        if (iPathArray2.length > 0) {
            this.fullExclusionPatternChars = UNINIT_PATTERNS;
        }
        this.sourceAttachmentPath = iPath2;
        this.sourceAttachmentRootPath = iPath3;
        this.specificOutputLocation = iPath4;
        this.isExported = bl;
    }

    public boolean combineAccessRules() {
        return this.combineAccessRules;
    }

    public ClasspathEntry combineWith(ClasspathEntry classpathEntry) {
        if (classpathEntry == null) {
            return this;
        }
        if (classpathEntry.isExported() || classpathEntry.getAccessRuleSet() != null) {
            boolean bl = this.entryKind == 3 || classpathEntry.combineAccessRules();
            return new ClasspathEntry(this.getContentKind(), this.getEntryKind(), this.getPath(), this.inclusionPatterns, this.exclusionPatterns, this.getSourceAttachmentPath(), this.getSourceAttachmentRootPath(), this.getOutputLocation(), classpathEntry.isExported() || this.isExported, this.combine(classpathEntry.getAccessRules(), this.getAccessRules(), bl), this.combineAccessRules, this.extraAttributes);
        }
        return this;
    }

    private IAccessRule[] combine(IAccessRule[] iAccessRuleArray, IAccessRule[] iAccessRuleArray2, boolean bl) {
        if (!bl) {
            return iAccessRuleArray2;
        }
        if (iAccessRuleArray2 == null || iAccessRuleArray2.length == 0) {
            return iAccessRuleArray;
        }
        int n = iAccessRuleArray.length;
        int n2 = iAccessRuleArray2.length;
        int n3 = n + n2;
        IAccessRule[] iAccessRuleArray3 = new IAccessRule[n3];
        System.arraycopy(iAccessRuleArray, 0, iAccessRuleArray3, 0, n);
        System.arraycopy(iAccessRuleArray2, 0, iAccessRuleArray3, n, n2);
        return iAccessRuleArray3;
    }

    static IClasspathAttribute[] decodeExtraAttributes(NodeList nodeList) {
        if (nodeList == null) {
            return NO_EXTRA_ATTRIBUTES;
        }
        int n = nodeList.getLength();
        if (n == 0) {
            return NO_EXTRA_ATTRIBUTES;
        }
        IClasspathAttribute[] iClasspathAttributeArray = new IClasspathAttribute[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string;
            Element element;
            String string2;
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1 && (string2 = (element = (Element)node).getAttribute(TAG_ATTRIBUTE_NAME)) != null && (string = element.getAttribute(TAG_ATTRIBUTE_VALUE)) != null) {
                iClasspathAttributeArray[n2++] = new ClasspathAttribute(string2, string);
            }
            ++n3;
        }
        if (n2 != n) {
            IClasspathAttribute[] iClasspathAttributeArray2 = iClasspathAttributeArray;
            iClasspathAttributeArray = new IClasspathAttribute[n2];
            System.arraycopy(iClasspathAttributeArray2, 0, iClasspathAttributeArray, 0, n2);
        }
        return iClasspathAttributeArray;
    }

    static IAccessRule[] decodeAccessRules(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        IAccessRule[] iAccessRuleArray = new IAccessRule[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            block7: {
                int n4;
                Element element;
                String string;
                block9: {
                    String string2;
                    block10: {
                        block8: {
                            Node node = nodeList.item(n3);
                            if (node.getNodeType() != 1 || (string = (element = (Element)node).getAttribute(TAG_PATTERN)) == null) break block7;
                            string2 = element.getAttribute(TAG_KIND);
                            if (!TAG_ACCESSIBLE.equals(string2)) break block8;
                            n4 = 0;
                            break block9;
                        }
                        if (!TAG_NON_ACCESSIBLE.equals(string2)) break block10;
                        n4 = 1;
                        break block9;
                    }
                    if (!TAG_DISCOURAGED.equals(string2)) break block7;
                    n4 = 2;
                }
                boolean bl = "true".equals(element.getAttribute(TAG_IGNORE_IF_BETTER));
                iAccessRuleArray[n2++] = new ClasspathAccessRule((IPath)new Path(string), bl ? n4 | 0x100 : n4);
            }
            ++n3;
        }
        if (n2 != n) {
            IAccessRule[] iAccessRuleArray2 = iAccessRuleArray;
            iAccessRuleArray = new IAccessRule[n2];
            System.arraycopy(iAccessRuleArray2, 0, iAccessRuleArray, 0, n2);
        }
        return iAccessRuleArray;
    }

    private static IPath[] decodePatterns(NamedNodeMap namedNodeMap, String string) {
        char[][] cArray;
        int n;
        String string2 = ClasspathEntry.removeAttribute(string, namedNodeMap);
        if (!string2.equals("") && (n = (cArray = CharOperation.splitOn('|', string2.toCharArray())).length) > 0) {
            IPath[] iPathArray = new IPath[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                char[] cArray2 = cArray[n3];
                if (cArray2.length != 0) {
                    iPathArray[n2++] = new Path(new String(cArray2));
                }
                ++n3;
            }
            if (n2 < n) {
                IPath[] iPathArray2 = iPathArray;
                iPathArray = new IPath[n2];
                System.arraycopy(iPathArray2, 0, iPathArray, 0, n2);
            }
            return iPathArray;
        }
        return null;
    }

    private static void decodeUnknownNode(Node node, StringBuffer stringBuffer, IJavaProject iJavaProject) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
            XMLWriter xMLWriter = new XMLWriter((Writer)outputStreamWriter, iJavaProject, false);
            ClasspathEntry.decodeUnknownNode(node, xMLWriter, true);
            xMLWriter.flush();
            xMLWriter.close();
            stringBuffer.append(byteArrayOutputStream.toString("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static void decodeUnknownNode(Node node, XMLWriter xMLWriter, boolean bl) {
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                int n;
                int n2;
                HashMap<String, String> hashMap = null;
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null && (n2 = namedNodeMap.getLength()) > 0) {
                    hashMap = new HashMap<String, String>();
                    n = 0;
                    while (n < n2) {
                        object = namedNodeMap.item(n);
                        hashMap.put(object.getNodeName(), object.getNodeValue());
                        ++n;
                    }
                }
                NodeList nodeList = node.getChildNodes();
                n = nodeList.getLength();
                object = node.getNodeName();
                xMLWriter.printTag((String)object, hashMap, false, false, n == 0);
                if (n <= 0) break;
                int n3 = 0;
                while (n3 < n) {
                    ClasspathEntry.decodeUnknownNode(nodeList.item(n3), xMLWriter, false);
                    ++n3;
                }
                xMLWriter.endTag((String)object, false, bl);
                break;
            }
            case 3: {
                String string = ((Text)node).getData();
                xMLWriter.printString(string, false, false);
            }
        }
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullExclusionPatternChars == UNINIT_PATTERNS) {
            int n = this.exclusionPatterns.length;
            this.fullExclusionPatternChars = new char[n][];
            IPath iPath = this.path.removeTrailingSeparator();
            int n2 = 0;
            while (n2 < n) {
                this.fullExclusionPatternChars[n2] = iPath.append(this.exclusionPatterns[n2]).toString().toCharArray();
                ++n2;
            }
        }
        return this.fullExclusionPatternChars;
    }

    public char[][] fullInclusionPatternChars() {
        if (this.fullInclusionPatternChars == UNINIT_PATTERNS) {
            int n = this.inclusionPatterns.length;
            this.fullInclusionPatternChars = new char[n][];
            IPath iPath = this.path.removeTrailingSeparator();
            int n2 = 0;
            while (n2 < n) {
                this.fullInclusionPatternChars[n2] = iPath.append(this.inclusionPatterns[n2]).toString().toCharArray();
                ++n2;
            }
        }
        return this.fullInclusionPatternChars;
    }

    public void elementEncode(XMLWriter xMLWriter, IPath iPath, boolean bl, boolean bl2, Map map) {
        Object object;
        int n;
        UnknownXmlElements unknownXmlElements;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        hashMap.put(TAG_KIND, ClasspathEntry.kindToString(this.entryKind));
        IPath iPath2 = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && iPath2.isAbsolute() && iPath != null && iPath.isPrefixOf(iPath2)) {
            if (iPath2.segment(0).equals(iPath.segment(0))) {
                iPath2 = iPath2.removeFirstSegments(1);
                iPath2 = iPath2.makeRelative();
            } else {
                iPath2 = iPath2.makeAbsolute();
            }
        }
        hashMap.put(TAG_PATH, String.valueOf(iPath2));
        if (this.sourceAttachmentPath != null) {
            iPath2 = this.sourceAttachmentPath;
            if (this.entryKind != 4 && iPath != null && iPath.isPrefixOf(iPath2) && iPath2.segment(0).equals(iPath.segment(0))) {
                iPath2 = iPath2.removeFirstSegments(1);
                iPath2 = iPath2.makeRelative();
            }
            hashMap.put(TAG_SOURCEPATH, String.valueOf(iPath2));
        }
        if (this.sourceAttachmentRootPath != null) {
            hashMap.put(TAG_ROOTPATH, String.valueOf(this.sourceAttachmentRootPath));
        }
        if (this.isExported) {
            hashMap.put(TAG_EXPORTED, "true");
        }
        ClasspathEntry.encodePatterns(this.inclusionPatterns, TAG_INCLUDING, hashMap);
        ClasspathEntry.encodePatterns(this.exclusionPatterns, TAG_EXCLUDING, hashMap);
        if (this.entryKind == 2 && !this.combineAccessRules) {
            hashMap.put(TAG_COMBINE_ACCESS_RULES, "false");
        }
        UnknownXmlElements unknownXmlElements2 = unknownXmlElements = map == null ? null : (UnknownXmlElements)map.get(this.path);
        if (unknownXmlElements != null) {
            String[] stringArray = unknownXmlElements.attributes;
            if (unknownXmlElements.attributes != null) {
                int n2 = 0;
                n = stringArray.length;
                while (n2 < n) {
                    object = stringArray[n2];
                    String string = stringArray[n2 + 1];
                    hashMap.put(object, string);
                    n2 += 2;
                }
            }
        }
        if (this.specificOutputLocation != null) {
            IPath iPath3 = this.specificOutputLocation.removeFirstSegments(1);
            iPath3 = iPath3.makeRelative();
            hashMap.put(TAG_OUTPUT, String.valueOf(iPath3));
        }
        boolean bl3 = this.extraAttributes.length != 0;
        n = this.getAccessRuleSet() != null ? 1 : 0;
        object = unknownXmlElements != null ? unknownXmlElements.children : null;
        boolean bl4 = object != null;
        xMLWriter.printTag(TAG_CLASSPATHENTRY, hashMap, bl, bl2, !bl3 && n == 0 && !bl4);
        if (bl3) {
            this.encodeExtraAttributes(xMLWriter, bl, bl2);
        }
        if (n != 0) {
            this.encodeAccessRules(xMLWriter, bl, bl2);
        }
        if (bl4) {
            this.encodeUnknownChildren(xMLWriter, bl, bl2, (ArrayList)object);
        }
        if (bl3 || n != 0 || bl4) {
            xMLWriter.endTag(TAG_CLASSPATHENTRY, bl, true);
        }
    }

    void encodeExtraAttributes(XMLWriter xMLWriter, boolean bl, boolean bl2) {
        xMLWriter.startTag(TAG_ATTRIBUTES, bl);
        int n = 0;
        while (n < this.extraAttributes.length) {
            IClasspathAttribute iClasspathAttribute = this.extraAttributes[n];
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(TAG_ATTRIBUTE_NAME, iClasspathAttribute.getName());
            hashMap.put(TAG_ATTRIBUTE_VALUE, iClasspathAttribute.getValue());
            xMLWriter.printTag(TAG_ATTRIBUTE, hashMap, bl, bl2, true);
            ++n;
        }
        xMLWriter.endTag(TAG_ATTRIBUTES, bl, true);
    }

    void encodeAccessRules(XMLWriter xMLWriter, boolean bl, boolean bl2) {
        xMLWriter.startTag(TAG_ACCESS_RULES, bl);
        AccessRule[] accessRuleArray = this.getAccessRuleSet().getAccessRules();
        int n = 0;
        int n2 = accessRuleArray.length;
        while (n < n2) {
            this.encodeAccessRule(accessRuleArray[n], xMLWriter, bl, bl2);
            ++n;
        }
        xMLWriter.endTag(TAG_ACCESS_RULES, bl, true);
    }

    private void encodeAccessRule(AccessRule accessRule, XMLWriter xMLWriter, boolean bl, boolean bl2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TAG_PATTERN, new String(accessRule.pattern));
        switch (accessRule.getProblemId()) {
            case 0x1000133: {
                hashMap.put(TAG_KIND, TAG_NON_ACCESSIBLE);
                break;
            }
            case 0x1000118: {
                hashMap.put(TAG_KIND, TAG_DISCOURAGED);
                break;
            }
            default: {
                hashMap.put(TAG_KIND, TAG_ACCESSIBLE);
            }
        }
        if (accessRule.ignoreIfBetter()) {
            hashMap.put(TAG_IGNORE_IF_BETTER, "true");
        }
        xMLWriter.printTag(TAG_ACCESS_RULE, hashMap, bl, bl2, true);
    }

    private void encodeUnknownChildren(XMLWriter xMLWriter, boolean bl, boolean bl2, ArrayList arrayList) {
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            String string = (String)arrayList.get(n);
            xMLWriter.printString(string, bl, false);
            ++n;
        }
    }

    public static IClasspathEntry elementDecode(Element element, IJavaProject iJavaProject, Map map) {
        NodeList nodeList;
        IAccessRule[] iAccessRuleArray;
        IPath[] iPathArray;
        Path path;
        IPath iPath = iJavaProject.getProject().getFullPath();
        NamedNodeMap namedNodeMap = element.getAttributes();
        NodeList nodeList2 = element.getChildNodes();
        boolean[] blArray = new boolean[nodeList2.getLength()];
        String string = ClasspathEntry.removeAttribute(TAG_KIND, namedNodeMap);
        String string2 = ClasspathEntry.removeAttribute(TAG_PATH, namedNodeMap);
        Path path2 = new Path(string2);
        int n = ClasspathEntry.kindFromString(string);
        if (n != 4 && n != 5 && !path2.isAbsolute()) {
            path2 = iPath.append((IPath)path2);
        }
        Path path3 = path = element.hasAttribute(TAG_SOURCEPATH) ? new Path(ClasspathEntry.removeAttribute(TAG_SOURCEPATH, namedNodeMap)) : null;
        if (n != 4 && path != null && !path.isAbsolute()) {
            path = iPath.append((IPath)path);
        }
        Path path4 = element.hasAttribute(TAG_ROOTPATH) ? new Path(ClasspathEntry.removeAttribute(TAG_ROOTPATH, namedNodeMap)) : null;
        boolean bl = ClasspathEntry.removeAttribute(TAG_EXPORTED, namedNodeMap).equals("true");
        IPath[] iPathArray2 = ClasspathEntry.decodePatterns(namedNodeMap, TAG_INCLUDING);
        if (iPathArray2 == null) {
            iPathArray2 = INCLUDE_ALL;
        }
        if ((iPathArray = ClasspathEntry.decodePatterns(namedNodeMap, TAG_EXCLUDING)) == null) {
            iPathArray = EXCLUDE_NONE;
        }
        if ((iAccessRuleArray = ClasspathEntry.decodeAccessRules(nodeList = ClasspathEntry.getChildAttributes(TAG_ACCESS_RULES, nodeList2, blArray))) == null) {
            iAccessRuleArray = ClasspathEntry.getAccessRules(iPathArray2, iPathArray);
        }
        boolean bl2 = !ClasspathEntry.removeAttribute(TAG_COMBINE_ACCESS_RULES, namedNodeMap).equals("false");
        nodeList = ClasspathEntry.getChildAttributes(TAG_ATTRIBUTES, nodeList2, blArray);
        IClasspathAttribute[] iClasspathAttributeArray = ClasspathEntry.decodeExtraAttributes(nodeList);
        IPath iPath2 = element.hasAttribute(TAG_OUTPUT) ? iPath.append(ClasspathEntry.removeAttribute(TAG_OUTPUT, namedNodeMap)) : null;
        String[] stringArray = null;
        ArrayList<String> arrayList = null;
        if (map != null) {
            int n2;
            int n3 = namedNodeMap.getLength();
            if (n3 != 0) {
                stringArray = new String[n3 * 2];
                n2 = 0;
                while (n2 < n3) {
                    Node node = namedNodeMap.item(n2);
                    stringArray[n2 * 2] = node.getNodeName();
                    stringArray[n2 * 2 + 1] = node.getNodeValue();
                    ++n2;
                }
            }
            n2 = 0;
            int n4 = blArray.length;
            while (n2 < n4) {
                Node node;
                if (!blArray[n2] && (node = nodeList2.item(n2)).getNodeType() == 1) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    ClasspathEntry.decodeUnknownNode(node, stringBuffer, iJavaProject);
                    arrayList.add(stringBuffer.toString());
                }
                ++n2;
            }
        }
        IClasspathEntry iClasspathEntry = null;
        switch (n) {
            case 2: {
                iClasspathEntry = new ClasspathEntry(1, 2, (IPath)path2, INCLUDE_ALL, EXCLUDE_NONE, null, null, null, bl, iAccessRuleArray, bl2, iClasspathAttributeArray);
                break;
            }
            case 1: {
                iClasspathEntry = JavaCore.newLibraryEntry((IPath)path2, (IPath)path, (IPath)path4, iAccessRuleArray, iClasspathAttributeArray, bl);
                break;
            }
            case 3: {
                String string3 = path2.segment(0);
                if (string3 != null && string3.equals(iJavaProject.getElementName())) {
                    iClasspathEntry = JavaCore.newSourceEntry((IPath)path2, iPathArray2, iPathArray, iPath2, iClasspathAttributeArray);
                    break;
                }
                if (path2.segmentCount() == 1) {
                    iClasspathEntry = JavaCore.newProjectEntry((IPath)path2, iAccessRuleArray, bl2, iClasspathAttributeArray, bl);
                    break;
                }
                iClasspathEntry = JavaCore.newSourceEntry((IPath)path2, iPathArray2, iPathArray, iPath2, iClasspathAttributeArray);
                break;
            }
            case 4: {
                iClasspathEntry = JavaCore.newVariableEntry((IPath)path2, (IPath)path, (IPath)path4, iAccessRuleArray, iClasspathAttributeArray, bl);
                break;
            }
            case 5: {
                iClasspathEntry = JavaCore.newContainerEntry((IPath)path2, iAccessRuleArray, iClasspathAttributeArray, bl);
                break;
            }
            case 10: {
                if (!path2.isAbsolute()) {
                    return null;
                }
                iClasspathEntry = new ClasspathEntry(10, 1, (IPath)path2, INCLUDE_ALL, EXCLUDE_NONE, null, null, null, false, null, false, NO_EXTRA_ATTRIBUTES);
                break;
            }
            default: {
                throw new AssertionFailedException(Messages.bind(Messages.classpath_unknownKind, string));
            }
        }
        if (stringArray != null || arrayList != null) {
            UnknownXmlElements unknownXmlElements = new UnknownXmlElements();
            unknownXmlElements.attributes = stringArray;
            unknownXmlElements.children = arrayList;
            map.put(path2, unknownXmlElements);
        }
        return iClasspathEntry;
    }

    public static NodeList getChildAttributes(String string, NodeList nodeList, boolean[] blArray) {
        int n = 0;
        int n2 = blArray.length;
        while (n < n2) {
            Node node = nodeList.item(n);
            if (string.equals(node.getNodeName())) {
                blArray[n] = true;
                return node.getChildNodes();
            }
            ++n;
        }
        return null;
    }

    private static String removeAttribute(String string, NamedNodeMap namedNodeMap) {
        Node node = ClasspathEntry.removeNode(string, namedNodeMap);
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    private static Node removeNode(String string, NamedNodeMap namedNodeMap) {
        try {
            return namedNodeMap.removeNamedItem(string);
        }
        catch (DOMException dOMException) {
            if (dOMException.code != 8) {
                throw dOMException;
            }
            return null;
        }
    }

    private static void encodePatterns(IPath[] iPathArray, String string, Map map) {
        if (iPathArray != null && iPathArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(10);
            int n = 0;
            int n2 = iPathArray.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append('|');
                }
                stringBuffer.append(iPathArray[n]);
                ++n;
            }
            map.put(string, String.valueOf(stringBuffer));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ClasspathEntry) {
            ClasspathEntry classpathEntry = (ClasspathEntry)object;
            if (this.contentKind != classpathEntry.getContentKind()) {
                return false;
            }
            if (this.entryKind != classpathEntry.getEntryKind()) {
                return false;
            }
            if (this.isExported != classpathEntry.isExported()) {
                return false;
            }
            if (!this.path.equals((Object)classpathEntry.getPath())) {
                return false;
            }
            IPath iPath = classpathEntry.getSourceAttachmentPath();
            if (this.sourceAttachmentPath == null ? iPath != null : !this.sourceAttachmentPath.equals((Object)iPath)) {
                return false;
            }
            iPath = classpathEntry.getSourceAttachmentRootPath();
            if (this.sourceAttachmentRootPath == null ? iPath != null : !this.sourceAttachmentRootPath.equals((Object)iPath)) {
                return false;
            }
            if (!ClasspathEntry.equalPatterns(this.inclusionPatterns, classpathEntry.getInclusionPatterns())) {
                return false;
            }
            if (!ClasspathEntry.equalPatterns(this.exclusionPatterns, classpathEntry.getExclusionPatterns())) {
                return false;
            }
            AccessRuleSet accessRuleSet = classpathEntry.getAccessRuleSet();
            if (this.getAccessRuleSet() != null ? !this.getAccessRuleSet().equals(accessRuleSet) : accessRuleSet != null) {
                return false;
            }
            if (this.combineAccessRules != classpathEntry.combineAccessRules()) {
                return false;
            }
            iPath = classpathEntry.getOutputLocation();
            if (this.specificOutputLocation == null ? iPath != null : !this.specificOutputLocation.equals((Object)iPath)) {
                return false;
            }
            return ClasspathEntry.equalAttributes(this.extraAttributes, classpathEntry.getExtraAttributes());
        }
        return false;
    }

    private static boolean equalAttributes(IClasspathAttribute[] iClasspathAttributeArray, IClasspathAttribute[] iClasspathAttributeArray2) {
        if (iClasspathAttributeArray != iClasspathAttributeArray2) {
            if (iClasspathAttributeArray == null) {
                return false;
            }
            int n = iClasspathAttributeArray.length;
            if (iClasspathAttributeArray2 == null || iClasspathAttributeArray2.length != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!iClasspathAttributeArray[n2].equals(iClasspathAttributeArray2[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean equalPatterns(IPath[] iPathArray, IPath[] iPathArray2) {
        if (iPathArray != iPathArray2) {
            if (iPathArray == null) {
                return false;
            }
            int n = iPathArray.length;
            if (iPathArray2 == null || iPathArray2.length != n) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!iPathArray[n2].toString().equals(iPathArray2[n2].toString())) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public IAccessRule[] getAccessRules() {
        if (this.accessRuleSet == null) {
            return NO_ACCESS_RULES;
        }
        AccessRule[] accessRuleArray = this.accessRuleSet.getAccessRules();
        int n = accessRuleArray.length;
        if (n == 0) {
            return NO_ACCESS_RULES;
        }
        IAccessRule[] iAccessRuleArray = new IAccessRule[n];
        System.arraycopy(accessRuleArray, 0, iAccessRuleArray, 0, n);
        return iAccessRuleArray;
    }

    public AccessRuleSet getAccessRuleSet() {
        return this.accessRuleSet;
    }

    public int getContentKind() {
        return this.contentKind;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IClasspathAttribute[] getExtraAttributes() {
        return this.extraAttributes;
    }

    private String[] getMessageTemplates() {
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        String[] stringArray = new String[4];
        if (this.entryKind == 2 || this.entryKind == 3) {
            stringArray[0] = javaModelManager.intern(Messages.bind(Messages.restrictedAccess_project, new String[]{"{0}", this.getPath().segment(0)}));
            stringArray[1] = javaModelManager.intern(Messages.bind(Messages.restrictedAccess_constructor_project, new String[]{"{0}", this.getPath().segment(0)}));
            stringArray[2] = javaModelManager.intern(Messages.bind(Messages.restrictedAccess_method_project, new String[]{"{0}", "{1}", this.getPath().segment(0)}));
            stringArray[3] = javaModelManager.intern(Messages.bind(Messages.restrictedAccess_field_project, new String[]{"{0}", "{1}", this.getPath().segment(0)}));
        } else {
            IPath iPath = this.getPath();
            Object object = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), iPath, false);
            String string = object instanceof File ? iPath.toOSString() : iPath.makeRelative().toString();
            stringArray[0] = javaModelManager.intern(Messages.bind(Messages.restrictedAccess_library, new String[]{"{0}", string}));
            stringArray[1] = javaModelManager.intern(Messages.bind(Messages.restrictedAccess_constructor_library, new String[]{"{0}", string}));
            stringArray[2] = javaModelManager.intern(Messages.bind(Messages.restrictedAccess_method_library, new String[]{"{0}", "{1}", string}));
            stringArray[3] = javaModelManager.intern(Messages.bind(Messages.restrictedAccess_field_library, new String[]{"{0}", "{1}", string}));
        }
        return stringArray;
    }

    public IPath[] getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public IPath getOutputLocation() {
        return this.specificOutputLocation;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isExported() {
        return this.isExported;
    }

    public boolean isOptional() {
        int n = 0;
        int n2 = this.extraAttributes.length;
        while (n < n2) {
            IClasspathAttribute iClasspathAttribute = this.extraAttributes[n];
            if ("optional".equals(iClasspathAttribute.getName()) && "true".equals(iClasspathAttribute.getValue())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static int kindFromString(String string) {
        if (string.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (string.equalsIgnoreCase("var")) {
            return 4;
        }
        if (string.equalsIgnoreCase("con")) {
            return 5;
        }
        if (string.equalsIgnoreCase("src")) {
            return 3;
        }
        if (string.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (string.equalsIgnoreCase(TAG_OUTPUT)) {
            return 10;
        }
        return -1;
    }

    static String kindToString(int n) {
        switch (n) {
            case 2: {
                return "src";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
            case 10: {
                return TAG_OUTPUT;
            }
        }
        return "unknown";
    }

    public static IAccessRule[] getAccessRules(IPath[] iPathArray, IPath[] iPathArray2) {
        int n;
        int n2 = iPathArray == null ? 0 : iPathArray.length;
        int n3 = n2 + (n = iPathArray2 == null ? 0 : iPathArray2.length);
        if (n3 == 0) {
            return null;
        }
        IAccessRule[] iAccessRuleArray = new IAccessRule[n3];
        int n4 = 0;
        while (n4 < n2) {
            iAccessRuleArray[n4] = JavaCore.newAccessRule(iPathArray[n4], 0);
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            iAccessRuleArray[n2 + n4] = JavaCore.newAccessRule(iPathArray2[n4], 1);
            ++n4;
        }
        return iAccessRuleArray;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getPath()));
        stringBuffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                stringBuffer.append("CPE_LIBRARY");
                break;
            }
            case 2: {
                stringBuffer.append("CPE_PROJECT");
                break;
            }
            case 3: {
                stringBuffer.append("CPE_SOURCE");
                break;
            }
            case 4: {
                stringBuffer.append("CPE_VARIABLE");
                break;
            }
            case 5: {
                stringBuffer.append("CPE_CONTAINER");
            }
        }
        stringBuffer.append("][");
        switch (this.getContentKind()) {
            case 2: {
                stringBuffer.append("K_BINARY");
                break;
            }
            case 1: {
                stringBuffer.append("K_SOURCE");
                break;
            }
            case 10: {
                stringBuffer.append("K_OUTPUT");
            }
        }
        stringBuffer.append(']');
        if (this.getSourceAttachmentPath() != null) {
            stringBuffer.append("[sourcePath:");
            stringBuffer.append(this.getSourceAttachmentPath());
            stringBuffer.append(']');
        }
        if (this.getSourceAttachmentRootPath() != null) {
            stringBuffer.append("[rootPath:");
            stringBuffer.append(this.getSourceAttachmentRootPath());
            stringBuffer.append(']');
        }
        stringBuffer.append("[isExported:");
        stringBuffer.append(this.isExported);
        stringBuffer.append(']');
        IPath[] iPathArray = this.inclusionPatterns;
        int n2 = iPathArray == null ? 0 : iPathArray.length;
        if (n2 > 0) {
            stringBuffer.append("[including:");
            n = 0;
            while (n < n2) {
                stringBuffer.append(iPathArray[n]);
                if (n != n2 - 1) {
                    stringBuffer.append('|');
                }
                ++n;
            }
            stringBuffer.append(']');
        }
        if ((n2 = (iPathArray = this.exclusionPatterns) == null ? 0 : iPathArray.length) > 0) {
            stringBuffer.append("[excluding:");
            n = 0;
            while (n < n2) {
                stringBuffer.append(iPathArray[n]);
                if (n != n2 - 1) {
                    stringBuffer.append('|');
                }
                ++n;
            }
            stringBuffer.append(']');
        }
        if (this.accessRuleSet != null) {
            stringBuffer.append('[');
            stringBuffer.append(this.accessRuleSet.toString(false));
            stringBuffer.append(']');
        }
        if (this.entryKind == 2) {
            stringBuffer.append("[combine access rules:");
            stringBuffer.append(this.combineAccessRules);
            stringBuffer.append(']');
        }
        if (this.getOutputLocation() != null) {
            stringBuffer.append("[output:");
            stringBuffer.append(this.getOutputLocation());
            stringBuffer.append(']');
        }
        if ((n2 = this.extraAttributes == null ? 0 : this.extraAttributes.length) > 0) {
            stringBuffer.append("[attributes:");
            n = 0;
            while (n < n2) {
                stringBuffer.append(this.extraAttributes[n]);
                if (n != n2 - 1) {
                    stringBuffer.append(',');
                }
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 4: {
                    this.rootID = "[VAR]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    public IClasspathEntry getResolvedEntry() {
        return JavaCore.getResolvedClasspathEntry(this);
    }

    public static IJavaModelStatus validateClasspath(IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray, IPath iPath) {
        Object object;
        Object object2;
        String string;
        boolean bl;
        int n;
        Object object3;
        IClasspathEntry iClasspathEntry;
        IClasspathEntry[] iClasspathEntryArray2;
        IProject iProject = iJavaProject.getProject();
        IPath iPath2 = iProject.getFullPath();
        String string2 = iJavaProject.getElementName();
        boolean bl2 = false;
        boolean bl3 = false;
        if (iClasspathEntryArray == null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        try {
            iClasspathEntryArray2 = ((JavaProject)iJavaProject).resolveClasspath(iClasspathEntryArray);
        }
        catch (JavaModelException javaModelException) {
            return javaModelException.getJavaModelStatus();
        }
        int n2 = iClasspathEntryArray2.length;
        int n3 = 1;
        IPath[] iPathArray = new IPath[n2 + 1];
        boolean[] blArray = new boolean[n2 + 1];
        iPathArray[0] = iPath;
        IClasspathEntry iClasspathEntry2 = null;
        int n4 = 0;
        boolean bl4 = "disabled".equals(iJavaProject.getOption("org.eclipse.wst.jsdt.core.classpath.exclusionPatterns", true));
        boolean bl5 = "disabled".equals(iJavaProject.getOption("org.eclipse.wst.jsdt.core.classpath.multipleOutputLocations", true));
        int n5 = 0;
        while (n5 < n2) {
            iClasspathEntry = iClasspathEntryArray2[n5];
            if (bl4 && (iClasspathEntry.getInclusionPatterns() != null && iClasspathEntry.getInclusionPatterns().length > 0 || iClasspathEntry.getExclusionPatterns() != null && iClasspathEntry.getExclusionPatterns().length > 0)) {
                return new JavaModelStatus(1002, (IJavaElement)iJavaProject, iClasspathEntry.getPath());
            }
            switch (iClasspathEntry.getEntryKind()) {
                case 3: {
                    ++n4;
                    object3 = iClasspathEntry.getOutputLocation();
                    if (object3 == null) break;
                    if (bl5) {
                        return new JavaModelStatus(1003, (IJavaElement)iJavaProject, iClasspathEntry.getPath());
                    }
                    if (object3.isAbsolute()) {
                        if (!iJavaProject.getPath().isPrefixOf((IPath)object3)) {
                            return new JavaModelStatus(971, (IJavaElement)iJavaProject, object3.toString());
                        }
                    } else {
                        return new JavaModelStatus(972, (IPath)object3);
                    }
                    if (Util.indexOfMatchingPath((IPath)object3, iPathArray, n3) != -1) break;
                    iPathArray[n3++] = object3;
                }
            }
            ++n5;
        }
        n5 = 1;
        while (n5 < n3) {
            iClasspathEntry = iPathArray[n5];
            int n6 = Util.indexOfEnclosingPath((IPath)iClasspathEntry, iPathArray, n3);
            if (n6 != -1 && n6 != n5) {
                if (n6 == 0) {
                    if (iClasspathEntry2 == null) {
                        iClasspathEntry2 = iClasspathEntry;
                    }
                } else {
                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestOutputInOutput, new String[]{iClasspathEntry.makeRelative().toString(), iPathArray[n6].makeRelative().toString()}));
                }
            }
            ++n5;
        }
        if (n4 <= n3 - 1) {
            blArray[0] = true;
        } else if (iClasspathEntry2 != null) {
            return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestOutputInOutput, new String[]{iClasspathEntry2.makeRelative().toString(), iPathArray[0].makeRelative().toString()}));
        }
        n5 = 0;
        while (n5 < n2) {
            iClasspathEntry = iClasspathEntryArray2[n5];
            object3 = iClasspathEntry.getPath();
            switch (iClasspathEntry.getEntryKind()) {
                case 3: {
                    bl2 = true;
                    int n7 = Util.indexOfMatchingPath((IPath)object3, iPathArray, n3);
                    if (n7 == -1) break;
                    blArray[n7] = true;
                    break;
                }
                case 1: {
                    bl3 |= !org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(object3.lastSegment());
                    int n7 = Util.indexOfMatchingPath((IPath)object3, iPathArray, n3);
                    if (n7 == -1) break;
                    blArray[n7] = true;
                }
            }
            ++n5;
        }
        if (!bl2 && !bl3) {
            n5 = 0;
            while (n5 < n3) {
                blArray[n5] = true;
                ++n5;
            }
        }
        HashSet<IPath> hashSet = new HashSet<IPath>(n2);
        int n8 = 0;
        while (n8 < n2) {
            object3 = iClasspathEntryArray2[n8];
            if (object3 != null) {
                IPath iPath3 = object3.getPath();
                n = object3.getEntryKind();
                bl = string2.equals(iPath3.segment(0));
                String string3 = string = bl ? iPath3.removeFirstSegments(1).toString() : iPath3.makeRelative().toString();
                if (!hashSet.add(iPath3)) {
                    return new JavaModelStatus(977, Messages.bind(Messages.classpath_duplicateEntryPath, new String[]{string, string2}));
                }
                if (iPath3.equals((Object)iPath2)) {
                    if (n == 2) {
                        return new JavaModelStatus(979, Messages.bind(Messages.classpath_cannotReferToItself, iPath3.makeRelative().toString()));
                    }
                } else {
                    IPath iPath4;
                    int n9;
                    Object object4;
                    if (n == 3 || n == 1 && !org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(iPath3.lastSegment())) {
                        int n10 = 0;
                        while (n10 < iClasspathEntryArray2.length) {
                            object4 = iClasspathEntryArray2[n10];
                            if (object4 != null) {
                                n9 = object4.getEntryKind();
                                iPath4 = object4.getPath();
                                if (object3 != object4 && (n9 == 3 || n9 == 1 && !org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(iPath4.lastSegment())) && iPath4.isPrefixOf(iPath3) && !iPath4.equals((Object)iPath3)) {
                                    char[][] cArray = ((ClasspathEntry)object4).fullInclusionPatternChars();
                                    object2 = cArray;
                                    char[][] cArray2 = ((ClasspathEntry)object4).fullExclusionPatternChars();
                                    if (!Util.isExcluded(iPath3.append("*"), cArray, cArray2, false)) {
                                        String string4 = iPath3.removeFirstSegments(iPath4.segmentCount()).segment(0);
                                        if (Util.isExcluded(iPath3, (char[][])object2, cArray2, false)) {
                                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_mustEndWithSlash, new String[]{string4, iPath3.makeRelative().toString()}));
                                        }
                                        if (n9 == 3) {
                                            string4 = String.valueOf(string4) + '/';
                                            if (!bl4) {
                                                return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestEntryInEntry, new String[]{iPath3.makeRelative().toString(), object4.getPath().makeRelative().toString(), string4}));
                                            }
                                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestEntryInEntryNoExclusion, new String[]{iPath3.makeRelative().toString(), object4.getPath().makeRelative().toString(), string4}));
                                        }
                                        return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestEntryInLibrary, new String[]{iPath3.makeRelative().toString(), object4.getPath().makeRelative().toString()}));
                                    }
                                }
                            }
                            ++n10;
                        }
                    }
                    object = ((ClasspathEntry)object3).fullInclusionPatternChars();
                    object4 = ((ClasspathEntry)object3).fullExclusionPatternChars();
                    n9 = 0;
                    while (n9 < n3) {
                        iPath4 = iPathArray[n9];
                        if (!(iPath3.equals((Object)iPath4) || !iPath3.isPrefixOf(iPath4) || n == 3 && Util.isExcluded(iPath4, (char[][])object, (char[][])object4, true))) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotNestOutputInEntry, new String[]{iPath4.makeRelative().toString(), iPath3.makeRelative().toString()}));
                        }
                        ++n9;
                    }
                }
            }
            ++n8;
        }
        n8 = 0;
        while (n8 < n2) {
            object3 = iClasspathEntryArray2[n8];
            if (object3 != null) {
                IPath iPath5 = object3.getPath();
                n = object3.getEntryKind();
                bl = string2.equals(iPath5.segment(0));
                String string5 = string = bl ? iPath5.removeFirstSegments(1).toString() : iPath5.makeRelative().toString();
                if (n == 3 && (object = object3.getOutputLocation()) != null) {
                    int n11 = 0;
                    while (n11 < n2) {
                        IClasspathEntry iClasspathEntry3 = iClasspathEntryArray2[n11];
                        if (iClasspathEntry3 != object3) {
                            boolean bl6 = string2.equals(iClasspathEntry3.getPath().segment(0));
                            object2 = bl6 ? iClasspathEntry3.getPath().removeFirstSegments(1).toString() : iClasspathEntry3.getPath().makeRelative().toString();
                            switch (iClasspathEntry3.getEntryKind()) {
                                case 3: {
                                    if (!iClasspathEntry3.getPath().equals(object)) break;
                                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotUseDistinctSourceFolderAsOutput, new String[]{string, object2, string2}));
                                }
                                case 1: {
                                    if (!iClasspathEntry3.getPath().equals(object)) break;
                                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_cannotUseLibraryAsOutput, new String[]{string, object2, string2}));
                                }
                            }
                        }
                        ++n11;
                    }
                }
            }
            ++n8;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    /*
     * Unable to fully structure code
     */
    public static IJavaModelStatus validateClasspathEntry(IJavaProject var0, IClasspathEntry var1_1, boolean var2_2, boolean var3_3) {
        var4_4 = ResourcesPlugin.getWorkspace().getRoot();
        var5_5 = var1_1.getPath();
        var6_6 = var0.getElementName();
        var7_7 = var6_6.equals(var5_5.segment(0));
        var8_8 = var7_7 != false ? var5_5.removeFirstSegments(1).makeRelative().toString() : var5_5.toString();
        block3 : switch (var1_1.getEntryKind()) {
            case 5: {
                if (var5_5 != null && var5_5.segmentCount() >= 1) {
                    try {
                        var9_9 = JavaModelManager.getJavaModelManager().getClasspathContainer(var5_5, var0);
                        if (var9_9 == null) {
                            return new JavaModelStatus(963, (IJavaElement)var0, var5_5);
                        }
                        if (var9_9 == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                            var10_13 = var1_1.getExtraAttributes();
                            if (var10_13 != null) {
                                var11_17 = var10_13.length;
                                var12_26 = new HashSet<String>(var11_17);
                                var13_28 = 0;
                                while (var13_28 < var11_17) {
                                    var14_33 = var10_13[var13_28].getName();
                                    if (!var12_26.add(var14_33)) {
                                        return new JavaModelStatus(977, Messages.bind(Messages.classpath_duplicateEntryExtraAttribute, new String[]{var14_33, var8_8, var6_6}));
                                    }
                                    ++var13_28;
                                }
                            }
                            return JavaModelStatus.VERIFIED_OK;
                        }
                        var10_14 = var9_9.getClasspathEntries();
                        if (var10_14 == null) break;
                        var11_18 = 0;
                        var12_27 = var10_14.length;
                        while (var11_18 < var12_27) {
                            var13_29 = var10_14[var11_18];
                            v0 = var14_34 = var13_29 == null ? 0 : var13_29.getEntryKind();
                            if (var13_29 == null || var14_34 == 3 || var14_34 == 4 || var14_34 == 5) {
                                var15_35 = var9_9.getDescription();
                                if (var15_35 == null) {
                                    var15_35 = var5_5.makeRelative().toString();
                                }
                                return new JavaModelStatus(962, (IJavaElement)var0, var5_5);
                            }
                            if (var3_3 && !(var15_35 = ClasspathEntry.validateClasspathEntry(var0, var13_29, var2_2, var3_3)).isOK()) {
                                return var15_35;
                            }
                            ++var11_18;
                        }
                        break;
                    }
                    catch (JavaModelException var9_10) {
                        return new JavaModelStatus(var9_10);
                    }
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalContainerPath, new String[]{var8_8, var6_6}));
            }
            case 4: {
                if (var5_5 != null && var5_5.segmentCount() >= 1) {
                    try {
                        var1_1 = JavaCore.getResolvedClasspathEntry(var1_1);
                    }
                    catch (AssertionFailedException var9_11) {
                        return new JavaModelStatus(979, var9_11.getMessage());
                    }
                    if (var1_1 == null) {
                        return new JavaModelStatus(965, (IJavaElement)var0, var5_5);
                    }
                    var9_12 = ClasspathEntry.validateClasspathEntry(var0, var1_1, var2_2, var3_3);
                    if (!var9_12.isOK()) {
                        return var9_12;
                    }
                    var10_15 = var5_5.segment(0);
                    var11_19 = JavaCore.getClasspathVariableDeprecationMessage(var10_15);
                    if (var11_19 != null) {
                        return new JavaModelStatus(2, 1010, var0, var5_5, var11_19);
                    }
                    return var9_12;
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalVariablePath, new String[]{var8_8, var6_6}));
            }
            case 1: {
                if (var5_5 != null && var5_5.isAbsolute() && !var5_5.isEmpty()) {
                    var9_9 = var1_1.getSourceAttachmentPath();
                    var10_14 = JavaModel.getTarget((IContainer)var4_4, var5_5, true);
                    if (var10_14 != null && !"ignore".equals(var0.getOption("org.eclipse.wst.jsdt.core.incompatibleJDKLevel", true))) {
                        var11_20 = CompilerOptions.versionToJdkLevel(var0.getOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", true));
                        var13_30 = Util.getJdkLevel(var10_14);
                        if (var13_30 != 0L && var13_30 > var11_20) {
                            return new JavaModelStatus(1004, var0, var5_5, CompilerOptions.versionFromJdkLevel(var13_30));
                        }
                    }
                    if (var10_14 instanceof IResource) {
                        var11_21 = (IResource)var10_14;
                        switch (var11_21.getType()) {
                            case 1: {
                                if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(var11_21.getName()) || org.eclipse.wst.jsdt.internal.compiler.util.Util.isJavaFileName(var11_21.getName())) {
                                    if (!var2_2 || var9_9 == null || var9_9.isEmpty() || JavaModel.getTarget((IContainer)var4_4, (IPath)var9_9, true) != null) break block3;
                                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundSourceAttachment, new String[]{var9_9.toString(), var5_5.toString(), var6_6}));
                                }
                                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalLibraryArchive, new String[]{var8_8, var6_6}));
                            }
                            case 2: {
                                if (!var2_2 || var9_9 == null || var9_9.isEmpty() || JavaModel.getTarget((IContainer)var4_4, (IPath)var9_9, true) != null) break block3;
                                return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundSourceAttachment, new String[]{var9_9.toString(), var5_5.toString(), var6_6}));
                            }
                        }
                        break;
                    }
                    if (var10_14 instanceof File) {
                        var11_22 = JavaModel.getFile(var10_14);
                        if (var11_22 == null) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalExternalFolder, new String[]{var5_5.toOSString(), var6_6}));
                        }
                        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(var11_22.getName()) && !org.eclipse.wst.jsdt.internal.compiler.util.Util.isJavaFileName(var11_22.getName())) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalLibraryArchive, new String[]{var5_5.toOSString(), var6_6}));
                        }
                        if (!var2_2 || var9_9 == null || var9_9.isEmpty() || JavaModel.getTarget((IContainer)var4_4, (IPath)var9_9, true) != null) break;
                        return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundSourceAttachment, new String[]{var9_9.toString(), var5_5.toOSString(), var6_6}));
                    }
                    v1 = var11_23 = var5_5.getDevice() != null || var4_4.getProject(var5_5.segment(0)).exists() == false;
                    if (var11_23) {
                        return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundLibrary, new String[]{var5_5.toOSString(), var6_6}));
                    }
                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundLibrary, new String[]{var8_8, var6_6}));
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalLibraryPath, new String[]{var8_8, var6_6}));
            }
            case 2: {
                if (var5_5 != null && var5_5.isAbsolute() && var5_5.segmentCount() == 1) {
                    var9_9 = var4_4.getProject(var5_5.segment(0));
                    var10_14 = JavaCore.create((IProject)var9_9);
                    try {
                        if (!var9_9.exists() || !var9_9.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundProject, new String[]{var5_5.segment(0), var6_6}));
                        }
                        if (!var9_9.isOpen()) {
                            return new JavaModelStatus(964, Messages.bind(Messages.classpath_closedProject, new String[]{var5_5.segment(0)}));
                        }
                        if ("ignore".equals(var0.getOption("org.eclipse.wst.jsdt.core.incompatibleJDKLevel", true))) ** break;
                        var11_24 = CompilerOptions.versionToJdkLevel(var0.getOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", true));
                        var13_31 = CompilerOptions.versionToJdkLevel(var10_14.getOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", true));
                        if (var13_31 <= var11_24) ** break;
                        return new JavaModelStatus(1004, var0, var5_5, CompilerOptions.versionFromJdkLevel(var13_31));
                        break;
                    }
                    catch (CoreException v2) {
                        return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundProject, new String[]{var5_5.segment(0), var6_6}));
                    }
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalProjectPath, new String[]{var5_5.toString(), var6_6}));
            }
            case 3: {
                if ((var1_1.getInclusionPatterns() != null && var1_1.getInclusionPatterns().length > 0 || var1_1.getExclusionPatterns() != null && var1_1.getExclusionPatterns().length > 0) && "disabled".equals(var0.getOption("org.eclipse.wst.jsdt.core.classpath.exclusionPatterns", true))) {
                    return new JavaModelStatus(1002, (IJavaElement)var0, var5_5);
                }
                if (var1_1.getOutputLocation() != null && "disabled".equals(var0.getOption("org.eclipse.wst.jsdt.core.classpath.multipleOutputLocations", true))) {
                    return new JavaModelStatus(1003, (IJavaElement)var0, var5_5);
                }
                if (var5_5 != null && var5_5.isAbsolute() && !var5_5.isEmpty()) {
                    var9_9 = var0.getProject().getFullPath();
                    if (var9_9.isPrefixOf(var5_5) && JavaModel.getTarget((IContainer)var4_4, var5_5, true) != null) break;
                    return new JavaModelStatus(964, Messages.bind(Messages.classpath_unboundSourceFolder, new String[]{var8_8, var6_6}));
                }
                return new JavaModelStatus(964, Messages.bind(Messages.classpath_illegalSourceFolderPath, new String[]{var8_8, var6_6}));
            }
        }
        var9_9 = var1_1.getExtraAttributes();
        if (var9_9 != null) {
            var10_16 = ((IClasspathAttribute[])var9_9).length;
            var11_25 = new HashSet<String>(var10_16);
            var12_27 = 0;
            while (var12_27 < var10_16) {
                var13_32 = var9_9[var12_27].getName();
                if (!var11_25.add(var13_32)) {
                    return new JavaModelStatus(977, Messages.bind(Messages.classpath_duplicateEntryExtraAttribute, new String[]{var13_32, var8_8, var6_6}));
                }
                ++var12_27;
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    static class UnknownXmlElements {
        String[] attributes;
        ArrayList children;

        UnknownXmlElements() {
        }
    }
}

