/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.wst.jsdt.internal.core.ImportContainer;
import org.eclipse.wst.jsdt.internal.core.ImportDeclaration;
import org.eclipse.wst.jsdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.wst.jsdt.internal.core.Initializer;
import org.eclipse.wst.jsdt.internal.core.InitializerElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.MemberElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageDeclaration;
import org.eclipse.wst.jsdt.internal.core.SourceAnnotationMethodInfo;
import org.eclipse.wst.jsdt.internal.core.SourceConstructorInfo;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceFieldElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceMethodElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethodInfo;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.SourceRefElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.TypeParameter;
import org.eclipse.wst.jsdt.internal.core.TypeParameterElementInfo;
import org.eclipse.wst.jsdt.internal.core.util.ReferenceInfoAdapter;

public class CompilationUnitStructureRequestor
extends ReferenceInfoAdapter
implements ISourceElementRequestor {
    protected IJavaElement unit;
    protected CompilationUnitElementInfo unitInfo;
    protected JavaElementInfo importContainerInfo = null;
    protected Map newElements;
    protected Stack infoStack;
    protected HashMap children;
    protected Stack handleStack;
    protected int referenceCount = 0;
    protected boolean hasSyntaxErrors = false;
    protected Parser parser;
    protected static byte[] NO_BYTES = new byte[0];
    protected HashtableOfObject fieldRefCache;
    protected HashtableOfObject messageRefCache;
    protected HashtableOfObject typeRefCache;
    protected HashtableOfObject unknownRefCache;

    protected CompilationUnitStructureRequestor(IJavaElement iJavaElement, CompilationUnitElementInfo compilationUnitElementInfo, Map map) {
        this.unit = iJavaElement;
        this.unitInfo = compilationUnitElementInfo;
        this.newElements = map;
    }

    public void acceptImport(int n, int n2, char[][] cArray, boolean bl, int n3) {
        Object object;
        JavaElement javaElement = (JavaElement)this.handleStack.peek();
        if (javaElement.getElementType() != 5) {
            Assert.isTrue((boolean)false);
        }
        ICompilationUnit iCompilationUnit = (ICompilationUnit)((Object)javaElement);
        ImportContainer importContainer = (ImportContainer)iCompilationUnit.getImportContainer();
        if (this.importContainerInfo == null) {
            this.importContainerInfo = new JavaElementInfo();
            object = (JavaElementInfo)this.infoStack.peek();
            this.addToChildren((JavaElementInfo)object, importContainer);
            this.newElements.put(importContainer, this.importContainerInfo);
        }
        object = JavaModelManager.getJavaModelManager().intern(new String(CharOperation.concatWith(cArray, '.')));
        ImportDeclaration importDeclaration = new ImportDeclaration(importContainer, (String)object, bl);
        this.resolveDuplicates(importDeclaration);
        ImportDeclarationElementInfo importDeclarationElementInfo = new ImportDeclarationElementInfo();
        importDeclarationElementInfo.setSourceRangeStart(n);
        importDeclarationElementInfo.setSourceRangeEnd(n2);
        importDeclarationElementInfo.setFlags(n3);
        this.addToChildren(this.importContainerInfo, importDeclaration);
        this.newElements.put(importDeclaration, importDeclarationElementInfo);
    }

    public void acceptLineSeparatorPositions(int[] nArray) {
    }

    public void acceptPackage(int n, int n2, char[] cArray) {
        JavaElementInfo javaElementInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement javaElement = (JavaElement)this.handleStack.peek();
        PackageDeclaration packageDeclaration = null;
        if (javaElement.getElementType() == 5) {
            packageDeclaration = new PackageDeclaration((CompilationUnit)javaElement, new String(cArray));
        } else if (javaElement.getElementType() == 6) {
            packageDeclaration = new PackageDeclaration((ClassFile)javaElement, new String(cArray));
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(packageDeclaration);
        SourceRefElementInfo sourceRefElementInfo = new SourceRefElementInfo();
        sourceRefElementInfo.setSourceRangeStart(n);
        sourceRefElementInfo.setSourceRangeEnd(n2);
        this.addToChildren(javaElementInfo, packageDeclaration);
        this.newElements.put(packageDeclaration, sourceRefElementInfo);
    }

    public void acceptProblem(CategorizedProblem categorizedProblem) {
        if ((categorizedProblem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    private void addToChildren(JavaElementInfo javaElementInfo, JavaElement javaElement) {
        ArrayList<JavaElement> arrayList = (ArrayList<JavaElement>)this.children.get(javaElementInfo);
        if (arrayList == null) {
            arrayList = new ArrayList<JavaElement>();
            this.children.put(javaElementInfo, arrayList);
        }
        arrayList.add(javaElement);
    }

    static String[] convertTypeNamesToSigs(char[][] cArray) {
        if (cArray == null) {
            return CharOperation.NO_STRINGS;
        }
        int n = cArray.length;
        if (n == 0) {
            return CharOperation.NO_STRINGS;
        }
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = javaModelManager.intern(Signature.createTypeSignature(cArray[n2], false));
            ++n2;
        }
        return stringArray;
    }

    public void enterCompilationUnit() {
        this.infoStack = new Stack();
        this.children = new HashMap();
        this.handleStack = new Stack();
        this.infoStack.push(this.unitInfo);
        this.handleStack.push(this.unit);
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        Object object;
        Object object2;
        JavaElementInfo javaElementInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement javaElement = (JavaElement)this.handleStack.peek();
        SourceField sourceField = null;
        if (javaElement.getElementType() == 7 || javaElement.getElementType() == 5 || javaElement.getElementType() == 6 || javaElement.getElementType() == 9) {
            object2 = JavaModelManager.getJavaModelManager().intern(new String(fieldInfo.name));
            sourceField = new SourceField(javaElement, (String)object2);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(sourceField);
        object2 = new SourceFieldElementInfo();
        ((MemberElementInfo)object2).setNameSourceStart(fieldInfo.nameSourceStart);
        ((MemberElementInfo)object2).setNameSourceEnd(fieldInfo.nameSourceEnd);
        ((SourceRefElementInfo)object2).setSourceRangeStart(fieldInfo.declarationStart);
        ((MemberElementInfo)object2).setFlags(fieldInfo.modifiers);
        if (fieldInfo.type != null) {
            object = JavaModelManager.getJavaModelManager().intern(fieldInfo.type);
            ((SourceFieldElementInfo)object2).setTypeName((char[])object);
        }
        this.unitInfo.addAnnotationPositions(sourceField, fieldInfo.annotationPositions);
        this.addToChildren(javaElementInfo, sourceField);
        if (javaElementInfo instanceof CompilationUnitElementInfo) {
            object = (CompilationUnitElementInfo)javaElementInfo;
            ((CompilationUnitElementInfo)object).addCategories(sourceField, fieldInfo.categories);
        }
        this.newElements.put(sourceField, object2);
        this.infoStack.push(object2);
        this.handleStack.push(sourceField);
    }

    public void enterInitializer(int n, int n2) {
        JavaElementInfo javaElementInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement javaElement = (JavaElement)this.handleStack.peek();
        Initializer initializer = null;
        if (javaElement.getElementType() == 7) {
            initializer = new Initializer(javaElement, 1);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(initializer);
        InitializerElementInfo initializerElementInfo = new InitializerElementInfo();
        initializerElementInfo.setSourceRangeStart(n);
        initializerElementInfo.setFlags(n2);
        this.addToChildren(javaElementInfo, initializer);
        this.newElements.put(initializer, initializerElementInfo);
        this.infoStack.push(initializerElementInfo);
        this.handleStack.push(initializer);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        Object object;
        JavaElementInfo javaElementInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement javaElement = (JavaElement)this.handleStack.peek();
        SourceMethod sourceMethod = null;
        if (methodInfo.parameterTypes == null) {
            methodInfo.parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (methodInfo.parameterNames == null) {
            methodInfo.parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        if (methodInfo.exceptionTypes == null) {
            methodInfo.exceptionTypes = CharOperation.NO_CHAR_CHAR;
        }
        String[] stringArray = CompilationUnitStructureRequestor.convertTypeNamesToSigs(methodInfo.parameterTypes);
        if (javaElement.getElementType() == 7 || javaElement.getElementType() == 5 || javaElement.getElementType() == 6 || javaElement.getElementType() == 9) {
            object = methodInfo.name != null ? methodInfo.name : CharOperation.NO_CHAR;
            String string = JavaModelManager.getJavaModelManager().intern(new String((char[])object));
            sourceMethod = new SourceMethod(javaElement, string, stringArray);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(sourceMethod);
        object = methodInfo.isConstructor ? (Object)new SourceConstructorInfo() : (methodInfo.isAnnotation ? (Object)new SourceAnnotationMethodInfo() : (Object)new SourceMethodInfo());
        ((SourceRefElementInfo)object).setSourceRangeStart(methodInfo.declarationStart);
        int n = methodInfo.modifiers;
        ((MemberElementInfo)object).setNameSourceStart(methodInfo.nameSourceStart);
        ((MemberElementInfo)object).setNameSourceEnd(methodInfo.nameSourceEnd);
        ((MemberElementInfo)object).setFlags(n);
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        char[][] cArray = methodInfo.parameterNames;
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            cArray[n2] = javaModelManager.intern(cArray[n2]);
            ++n2;
        }
        ((SourceMethodElementInfo)object).setArgumentNames(cArray);
        char[] cArray2 = methodInfo.returnType == null ? null : javaModelManager.intern(methodInfo.returnType);
        ((SourceMethodElementInfo)object).setReturnType(cArray2);
        char[][] cArray3 = methodInfo.exceptionTypes;
        ((SourceMethodElementInfo)object).setExceptionTypeNames(cArray3);
        int n4 = 0;
        int n5 = cArray3.length;
        while (n4 < n5) {
            cArray3[n4] = javaModelManager.intern(cArray3[n4]);
            ++n4;
        }
        this.unitInfo.addAnnotationPositions(sourceMethod, methodInfo.annotationPositions);
        this.addToChildren(javaElementInfo, sourceMethod);
        if (javaElementInfo instanceof CompilationUnitElementInfo) {
            CompilationUnitElementInfo compilationUnitElementInfo = (CompilationUnitElementInfo)javaElementInfo;
            compilationUnitElementInfo.addCategories(sourceMethod, methodInfo.categories);
        }
        this.newElements.put(sourceMethod, object);
        this.infoStack.push(object);
        this.handleStack.push(sourceMethod);
        if (methodInfo.typeParameters != null) {
            int n6 = 0;
            n5 = methodInfo.typeParameters.length;
            while (n6 < n5) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = methodInfo.typeParameters[n6];
                this.enterTypeParameter(typeParameterInfo);
                this.exitMember(typeParameterInfo.declarationEnd);
                ++n6;
            }
        }
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        JavaElementInfo javaElementInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement javaElement = (JavaElement)this.handleStack.peek();
        String string = new String(typeInfo.name);
        SourceType sourceType = new SourceType(javaElement, string);
        this.resolveDuplicates(sourceType);
        SourceTypeElementInfo sourceTypeElementInfo = new SourceTypeElementInfo(javaElement instanceof ClassFile, typeInfo.anonymousMember);
        sourceTypeElementInfo.setHandle(sourceType);
        sourceTypeElementInfo.setSourceRangeStart(typeInfo.declarationStart);
        sourceTypeElementInfo.setFlags(typeInfo.modifiers);
        sourceTypeElementInfo.setNameSourceStart(typeInfo.nameSourceStart);
        sourceTypeElementInfo.setNameSourceEnd(typeInfo.nameSourceEnd);
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        char[] cArray = typeInfo.superclass;
        sourceTypeElementInfo.setSuperclassName(cArray == null ? null : javaModelManager.intern(cArray));
        char[][] cArray2 = typeInfo.superinterfaces;
        int n = 0;
        int n2 = cArray2 == null ? 0 : cArray2.length;
        while (n < n2) {
            cArray2[n] = javaModelManager.intern(cArray2[n]);
            ++n;
        }
        sourceTypeElementInfo.setSuperInterfaceNames(cArray2);
        sourceTypeElementInfo.addCategories(sourceType, typeInfo.categories);
        if (javaElement.getElementType() == 7) {
            ((SourceTypeElementInfo)javaElementInfo).addCategories(sourceType, typeInfo.categories);
        }
        this.addToChildren(javaElementInfo, sourceType);
        this.unitInfo.addAnnotationPositions(sourceType, typeInfo.annotationPositions);
        this.newElements.put(sourceType, sourceTypeElementInfo);
        this.infoStack.push(sourceTypeElementInfo);
        this.handleStack.push(sourceType);
        if (typeInfo.typeParameters != null) {
            n = 0;
            n2 = typeInfo.typeParameters.length;
            while (n < n2) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[n];
                this.enterTypeParameter(typeParameterInfo);
                this.exitMember(typeParameterInfo.declarationEnd);
                ++n;
            }
        }
    }

    protected void enterTypeParameter(ISourceElementRequestor.TypeParameterInfo typeParameterInfo) {
        JavaElementInfo javaElementInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement javaElement = (JavaElement)this.handleStack.peek();
        String string = new String(typeParameterInfo.name);
        TypeParameter typeParameter = new TypeParameter(javaElement, string);
        this.resolveDuplicates(typeParameter);
        TypeParameterElementInfo typeParameterElementInfo = new TypeParameterElementInfo();
        typeParameterElementInfo.setSourceRangeStart(typeParameterInfo.declarationStart);
        typeParameterElementInfo.nameStart = typeParameterInfo.nameSourceStart;
        typeParameterElementInfo.nameEnd = typeParameterInfo.nameSourceEnd;
        typeParameterElementInfo.bounds = typeParameterInfo.bounds;
        if (javaElementInfo instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)javaElementInfo;
            ITypeParameter[] iTypeParameterArray = sourceTypeElementInfo.typeParameters;
            int n = iTypeParameterArray.length;
            ITypeParameter[] iTypeParameterArray2 = iTypeParameterArray;
            iTypeParameterArray = new ITypeParameter[n + 1];
            System.arraycopy(iTypeParameterArray2, 0, iTypeParameterArray, 0, n);
            iTypeParameterArray[n] = typeParameter;
            sourceTypeElementInfo.typeParameters = iTypeParameterArray;
        } else {
            SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)javaElementInfo;
            ITypeParameter[] iTypeParameterArray = sourceMethodElementInfo.typeParameters;
            int n = iTypeParameterArray.length;
            ITypeParameter[] iTypeParameterArray3 = iTypeParameterArray;
            iTypeParameterArray = new ITypeParameter[n + 1];
            System.arraycopy(iTypeParameterArray3, 0, iTypeParameterArray, 0, n);
            iTypeParameterArray[n] = typeParameter;
            sourceMethodElementInfo.typeParameters = iTypeParameterArray;
        }
        this.unitInfo.addAnnotationPositions(typeParameter, typeParameterInfo.annotationPositions);
        this.newElements.put(typeParameter, typeParameterElementInfo);
        this.infoStack.push(typeParameterElementInfo);
        this.handleStack.push(typeParameter);
    }

    public void exitCompilationUnit(int n) {
        if (this.importContainerInfo != null) {
            this.setChildren(this.importContainerInfo);
        }
        this.setChildren(this.unitInfo);
        this.unitInfo.setSourceLength(n + 1);
        this.unitInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitConstructor(int n) {
        this.exitMember(n);
    }

    public void exitField(int n, int n2, int n3) {
        int n4;
        Object e;
        int n5;
        SourceFieldElementInfo sourceFieldElementInfo = (SourceFieldElementInfo)this.infoStack.pop();
        sourceFieldElementInfo.setSourceRangeEnd(n3);
        this.setChildren(sourceFieldElementInfo);
        if (n != -1 && (Flags.isStatic(n5 = sourceFieldElementInfo.flags) && Flags.isFinal(n5) || (e = this.infoStack.peek()) instanceof SourceTypeElementInfo && Flags.isInterface(((SourceTypeElementInfo)e).flags)) && (n4 = n2 - n) > 0) {
            char[] cArray = new char[n4];
            System.arraycopy(this.parser.scanner.source, n, cArray, 0, n4);
            sourceFieldElementInfo.initializationSource = cArray;
        }
        this.handleStack.pop();
    }

    public void exitInitializer(int n) {
        this.exitMember(n);
    }

    protected void exitMember(int n) {
        SourceRefElementInfo sourceRefElementInfo = (SourceRefElementInfo)this.infoStack.pop();
        sourceRefElementInfo.setSourceRangeEnd(n);
        this.setChildren(sourceRefElementInfo);
        this.handleStack.pop();
    }

    public void exitMethod(int n, int n2, int n3) {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.infoStack.pop();
        sourceMethodElementInfo.setSourceRangeEnd(n);
        this.setChildren(sourceMethodElementInfo);
        if (sourceMethodElementInfo.isAnnotationMethod()) {
            SourceAnnotationMethodInfo sourceAnnotationMethodInfo = (SourceAnnotationMethodInfo)sourceMethodElementInfo;
            sourceAnnotationMethodInfo.defaultValueStart = n2;
            sourceAnnotationMethodInfo.defaultValueEnd = n3;
        }
        this.handleStack.pop();
    }

    public void exitType(int n) {
        this.exitMember(n);
    }

    protected void resolveDuplicates(SourceRefElement sourceRefElement) {
        while (this.newElements.containsKey(sourceRefElement)) {
            ++sourceRefElement.occurrenceCount;
        }
    }

    private void setChildren(JavaElementInfo javaElementInfo) {
        ArrayList arrayList = (ArrayList)this.children.get(javaElementInfo);
        if (arrayList != null) {
            int n = arrayList.size();
            IJavaElement[] iJavaElementArray = new IJavaElement[n];
            arrayList.toArray(iJavaElementArray);
            javaElementInfo.children = iJavaElementArray;
        }
    }
}

