/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.CreateElementInCUOperation;
import org.eclipse.wst.jsdt.internal.core.CreateFieldOperation;
import org.eclipse.wst.jsdt.internal.core.CreateImportOperation;
import org.eclipse.wst.jsdt.internal.core.CreateInitializerOperation;
import org.eclipse.wst.jsdt.internal.core.CreateMethodOperation;
import org.eclipse.wst.jsdt.internal.core.CreatePackageDeclarationOperation;
import org.eclipse.wst.jsdt.internal.core.CreateTypeOperation;
import org.eclipse.wst.jsdt.internal.core.DeleteElementsOperation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MultiOperation;
import org.eclipse.wst.jsdt.internal.core.RenameResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CopyElementsOperation
extends MultiOperation
implements SuffixConstants {
    private Map sources = new HashMap();

    public CopyElementsOperation(IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2, boolean bl) {
        super(iJavaElementArray, iJavaElementArray2, bl);
    }

    public CopyElementsOperation(IJavaElement[] iJavaElementArray, IJavaElement iJavaElement, boolean bl) {
        this(iJavaElementArray, new IJavaElement[]{iJavaElement}, bl);
    }

    protected String getMainTaskName() {
        return Messages.operation_copyElementProgress;
    }

    protected JavaModelOperation getNestedOperation(IJavaElement iJavaElement) {
        try {
            IJavaElement iJavaElement2 = this.getDestinationParent(iJavaElement);
            switch (iJavaElement.getElementType()) {
                case 11: {
                    return new CreatePackageDeclarationOperation(iJavaElement.getElementName(), (ICompilationUnit)iJavaElement2);
                }
                case 13: {
                    IImportDeclaration iImportDeclaration = (IImportDeclaration)iJavaElement;
                    return new CreateImportOperation(iJavaElement.getElementName(), (ICompilationUnit)iJavaElement2, iImportDeclaration.getFlags());
                }
                case 7: {
                    if (this.isRenamingMainType(iJavaElement, iJavaElement2)) {
                        IPath iPath = iJavaElement.getPath();
                        String string = iPath.getFileExtension();
                        return new RenameResourceElementsOperation(new IJavaElement[]{iJavaElement2}, new IJavaElement[]{iJavaElement2.getParent()}, new String[]{String.valueOf(this.getNewNameFor(iJavaElement)) + '.' + string}, this.force);
                    }
                    String string = this.getSourceFor(iJavaElement);
                    String string2 = Util.getLineSeparator(string, iJavaElement.getJavaProject());
                    return new CreateTypeOperation(iJavaElement2, String.valueOf(string) + string2, this.force);
                }
                case 9: {
                    String string = this.getSourceFor(iJavaElement);
                    String string3 = Util.getLineSeparator(string, iJavaElement.getJavaProject());
                    return new CreateMethodOperation((IType)iJavaElement2, String.valueOf(string) + string3, this.force);
                }
                case 8: {
                    String string = this.getSourceFor(iJavaElement);
                    String string4 = Util.getLineSeparator(string, iJavaElement.getJavaProject());
                    return new CreateFieldOperation((IType)iJavaElement2, String.valueOf(string) + string4, this.force);
                }
                case 10: {
                    String string = this.getSourceFor(iJavaElement);
                    String string5 = Util.getLineSeparator(string, iJavaElement.getJavaProject());
                    return new CreateInitializerOperation((IType)iJavaElement2, String.valueOf(string) + string5);
                }
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private String getSourceFor(IJavaElement iJavaElement) throws JavaModelException {
        String string = (String)this.sources.get(iJavaElement);
        if (string == null && iJavaElement instanceof IMember) {
            string = ((IMember)iJavaElement).getSource();
            this.sources.put(iJavaElement, string);
        }
        return string;
    }

    protected boolean isRenamingMainType(IJavaElement iJavaElement, IJavaElement iJavaElement2) throws JavaModelException {
        if ((this.isRename() || this.getNewNameFor(iJavaElement) != null) && iJavaElement2.getElementType() == 5) {
            String string = iJavaElement2.getElementName();
            string = Util.getNameWithoutJavaLikeExtension(string);
            return iJavaElement.getElementName().equals(string) && iJavaElement.getParent().equals(iJavaElement2);
        }
        return false;
    }

    protected void processElement(IJavaElement iJavaElement) throws JavaModelException {
        Object object;
        IJavaElement iJavaElement2;
        JavaModelOperation javaModelOperation = this.getNestedOperation(iJavaElement);
        boolean bl = javaModelOperation instanceof CreateElementInCUOperation;
        if (javaModelOperation == null) {
            return;
        }
        if (bl) {
            iJavaElement2 = (IJavaElement)this.insertBeforeElements.get(iJavaElement);
            if (iJavaElement2 != null) {
                ((CreateElementInCUOperation)javaModelOperation).setRelativePosition(iJavaElement2, 3);
            } else if (this.isRename() && (object = this.resolveRenameAnchor(iJavaElement)) != null) {
                ((CreateElementInCUOperation)javaModelOperation).setRelativePosition((IJavaElement)object, 2);
            }
            object = this.getNewNameFor(iJavaElement);
            if (object != null) {
                ((CreateElementInCUOperation)javaModelOperation).setAlteredName((String)object);
            }
        }
        this.executeNestedOperation(javaModelOperation, 1);
        iJavaElement2 = (JavaElement)this.getDestinationParent(iJavaElement);
        object = ((JavaElement)iJavaElement2).getCompilationUnit();
        if (!object.isWorkingCopy()) {
            object.close();
        }
        if (bl && this.isMove() && !this.isRenamingMainType(iJavaElement, iJavaElement2)) {
            DeleteElementsOperation deleteElementsOperation = new DeleteElementsOperation(new IJavaElement[]{iJavaElement}, this.force);
            this.executeNestedOperation(deleteElementsOperation, 1);
        }
    }

    private IJavaElement resolveRenameAnchor(IJavaElement iJavaElement) throws JavaModelException {
        IParent iParent = (IParent)((Object)iJavaElement.getParent());
        IJavaElement[] iJavaElementArray = iParent.getChildren();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement2 = iJavaElementArray[n];
            if (iJavaElement2.equals(iJavaElement)) {
                return iJavaElement2;
            }
            ++n;
        }
        return null;
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus iJavaModelStatus = super.verify();
        if (!iJavaModelStatus.isOK()) {
            return iJavaModelStatus;
        }
        if (this.renamingsList != null && this.renamingsList.length != this.elementsToProcess.length) {
            return new JavaModelStatus(980);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void verify(IJavaElement iJavaElement) throws JavaModelException {
        if (iJavaElement == null || !iJavaElement.exists()) {
            this.error(969, iJavaElement);
        }
        if (iJavaElement.getElementType() < 7) {
            this.error(967, iJavaElement);
        }
        if (iJavaElement.isReadOnly()) {
            this.error(976, iJavaElement);
        }
        IJavaElement iJavaElement2 = this.getDestinationParent(iJavaElement);
        this.verifyDestination(iJavaElement, iJavaElement2);
        this.verifySibling(iJavaElement, iJavaElement2);
        if (this.renamingsList != null) {
            this.verifyRenaming(iJavaElement);
        }
    }
}

