/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class CreateElementInCUOperation
extends JavaModelOperation {
    protected CompilationUnit cuAST;
    protected static final int INSERT_LAST = 1;
    protected static final int INSERT_AFTER = 2;
    protected static final int INSERT_BEFORE = 3;
    protected int insertionPolicy = 1;
    protected IJavaElement anchorElement = null;
    protected boolean creationOccurred = true;

    public CreateElementInCUOperation(IJavaElement iJavaElement) {
        super(null, new IJavaElement[]{iJavaElement});
        this.initializeDefaultPosition();
    }

    protected void apply(ASTRewrite aSTRewrite, IDocument iDocument, Map map) throws JavaModelException {
        TextEdit textEdit = aSTRewrite.rewriteAST(iDocument, map);
        try {
            textEdit.apply(iDocument);
        }
        catch (BadLocationException badLocationException) {
            throw new JavaModelException(badLocationException, 984);
        }
    }

    protected void checkCanceled() {
        if (!this.isNested) {
            super.checkCanceled();
        }
    }

    public void createAfter(IJavaElement iJavaElement) {
        this.setRelativePosition(iJavaElement, 2);
    }

    public void createBefore(IJavaElement iJavaElement) {
        this.setRelativePosition(iJavaElement, 3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        try {
            this.beginTask(this.getMainTaskName(), this.getMainAmountOfWork());
            JavaElementDelta javaElementDelta = this.newJavaElementDelta();
            ICompilationUnit iCompilationUnit = this.getCompilationUnit();
            this.generateNewCompilationUnitAST(iCompilationUnit);
            if (this.creationOccurred) {
                iCompilationUnit.save(null, false);
                boolean bl = iCompilationUnit.isWorkingCopy();
                if (!bl) {
                    CreateElementInCUOperation.setAttribute("hasModifiedResource", "true");
                }
                this.worked(1);
                this.resultElements = this.generateResultHandles();
                if (!bl && !Util.isExcluded(iCompilationUnit) && iCompilationUnit.getParent().exists()) {
                    int n = 0;
                    while (n < this.resultElements.length) {
                        javaElementDelta.added(this.resultElements[n]);
                        ++n;
                    }
                    this.addDelta(javaElementDelta);
                }
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.done();
            throw throwable;
        }
        this.done();
    }

    protected abstract StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode var1);

    protected abstract ASTNode generateElementAST(ASTRewrite var1, IDocument var2, ICompilationUnit var3) throws JavaModelException;

    protected void generateNewCompilationUnitAST(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IDocument iDocument;
        this.cuAST = this.parse(iCompilationUnit);
        AST aST = this.cuAST.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create(aST);
        ASTNode aSTNode = this.generateElementAST(aSTRewrite, iDocument = this.getDocument(iCompilationUnit), iCompilationUnit);
        if (aSTNode != null) {
            ASTNode aSTNode2 = ((JavaElement)this.getParentElement()).findNode(this.cuAST);
            if (aSTNode2 == null) {
                aSTNode2 = this.cuAST;
            }
            this.insertASTNode(aSTRewrite, aSTNode2, aSTNode);
            this.apply(aSTRewrite, iDocument, iCompilationUnit.getJavaProject().getOptions(true));
        }
        this.worked(1);
    }

    protected abstract IJavaElement generateResultHandle();

    protected IJavaElement[] generateResultHandles() {
        return new IJavaElement[]{this.generateResultHandle()};
    }

    protected ICompilationUnit getCompilationUnit() {
        return this.getCompilationUnitFor(this.getParentElement());
    }

    protected int getMainAmountOfWork() {
        return 2;
    }

    public abstract String getMainTaskName();

    protected ISchedulingRule getSchedulingRule() {
        IResource iResource = this.getCompilationUnit().getResource();
        IWorkspace iWorkspace = iResource.getWorkspace();
        return iWorkspace.getRuleFactory().modifyRule(iResource);
    }

    protected void initializeDefaultPosition() {
    }

    protected void insertASTNode(ASTRewrite aSTRewrite, ASTNode aSTNode, ASTNode aSTNode2) throws JavaModelException {
        StructuralPropertyDescriptor structuralPropertyDescriptor = this.getChildPropertyDescriptor(aSTNode);
        if (structuralPropertyDescriptor instanceof ChildListPropertyDescriptor) {
            ChildListPropertyDescriptor childListPropertyDescriptor = (ChildListPropertyDescriptor)structuralPropertyDescriptor;
            ListRewrite listRewrite = aSTRewrite.getListRewrite(aSTNode, childListPropertyDescriptor);
            switch (this.insertionPolicy) {
                case 3: {
                    ASTNode aSTNode3 = ((JavaElement)this.anchorElement).findNode(this.cuAST);
                    if (childListPropertyDescriptor.getElementType().isAssignableFrom(aSTNode3.getClass())) {
                        listRewrite.insertBefore(aSTNode2, aSTNode3, null);
                        break;
                    }
                    listRewrite.insertLast(aSTNode2, null);
                    break;
                }
                case 2: {
                    ASTNode aSTNode4 = ((JavaElement)this.anchorElement).findNode(this.cuAST);
                    if (childListPropertyDescriptor.getElementType().isAssignableFrom(aSTNode4.getClass())) {
                        listRewrite.insertAfter(aSTNode2, aSTNode4, null);
                        break;
                    }
                    listRewrite.insertLast(aSTNode2, null);
                    break;
                }
                case 1: {
                    listRewrite.insertLast(aSTNode2, null);
                }
            }
        } else {
            aSTRewrite.set(aSTNode, structuralPropertyDescriptor, aSTNode2, null);
        }
    }

    protected CompilationUnit parse(ICompilationUnit iCompilationUnit) throws JavaModelException {
        iCompilationUnit.makeConsistent(this.progressMonitor);
        ASTParser aSTParser = ASTParser.newParser(3);
        aSTParser.setSource(iCompilationUnit);
        return (CompilationUnit)aSTParser.createAST(this.progressMonitor);
    }

    protected void setAlteredName(String string) {
    }

    protected void setRelativePosition(IJavaElement iJavaElement, int n) throws IllegalArgumentException {
        if (iJavaElement == null) {
            this.anchorElement = null;
            this.insertionPolicy = 1;
        } else {
            this.anchorElement = iJavaElement;
            this.insertionPolicy = n;
        }
    }

    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        if (this.anchorElement != null) {
            IJavaElement iJavaElement = this.anchorElement.getParent();
            if (iJavaElement.getElementType() == 12) {
                iJavaElement = iJavaElement.getParent();
            }
            if (!iJavaElement.equals(this.getParentElement())) {
                return new JavaModelStatus(993, this.anchorElement);
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

