/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public class DeletePackageFragmentRootOperation
extends JavaModelOperation {
    int updateResourceFlags;
    int updateModelFlags;

    public DeletePackageFragmentRootOperation(IPackageFragmentRoot iPackageFragmentRoot, int n, int n2) {
        super(iPackageFragmentRoot);
        this.updateResourceFlags = n;
        this.updateModelFlags = n2;
    }

    protected void executeOperation() throws JavaModelException {
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)this.getElementToProcess();
        IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
        DeltaProcessor deltaProcessor = JavaModelManager.getJavaModelManager().getDeltaProcessor();
        if (deltaProcessor.oldRoots == null) {
            deltaProcessor.oldRoots = new HashMap();
        }
        if ((this.updateModelFlags & 2) != 0) {
            this.updateProjectClasspath(iClasspathEntry.getPath(), iPackageFragmentRoot.getJavaProject(), deltaProcessor.oldRoots);
        }
        if ((this.updateModelFlags & 4) != 0) {
            this.updateReferringProjectClasspaths(iClasspathEntry.getPath(), iPackageFragmentRoot.getJavaProject(), deltaProcessor.oldRoots);
        }
        if (!iPackageFragmentRoot.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.deleteResource(iPackageFragmentRoot, iClasspathEntry);
        }
    }

    protected void deleteResource(IPackageFragmentRoot iPackageFragmentRoot, IClasspathEntry iClasspathEntry) throws JavaModelException {
        char[][] cArray = ((ClasspathEntry)iClasspathEntry).fullExclusionPatternChars();
        IResource iResource = iPackageFragmentRoot.getResource();
        if (iClasspathEntry.getEntryKind() != 3 || cArray == null) {
            try {
                iResource.delete(this.updateResourceFlags, this.progressMonitor);
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }
        final IPath[] iPathArray = this.getNestedFolders(iPackageFragmentRoot);
        IResourceProxyVisitor iResourceProxyVisitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                if (iResourceProxy.getType() == 2) {
                    IPath iPath = iResourceProxy.requestFullPath();
                    if (DeletePackageFragmentRootOperation.this.prefixesOneOf(iPath, iPathArray)) {
                        return !DeletePackageFragmentRootOperation.this.equalsOneOf(iPath, iPathArray);
                    }
                    iResourceProxy.requestResource().delete(DeletePackageFragmentRootOperation.this.updateResourceFlags, DeletePackageFragmentRootOperation.this.progressMonitor);
                    return false;
                }
                iResourceProxy.requestResource().delete(DeletePackageFragmentRootOperation.this.updateResourceFlags, DeletePackageFragmentRootOperation.this.progressMonitor);
                return false;
            }
        };
        try {
            iResource.accept(iResourceProxyVisitor, 0);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
        DeletePackageFragmentRootOperation.setAttribute("hasModifiedResource", "true");
    }

    protected void updateReferringProjectClasspaths(IPath iPath, IJavaProject iJavaProject, Map map) throws JavaModelException {
        IJavaModel iJavaModel = this.getJavaModel();
        IJavaProject[] iJavaProjectArray = iJavaModel.getJavaProjects();
        int n = 0;
        int n2 = iJavaProjectArray.length;
        while (n < n2) {
            IJavaProject iJavaProject2 = iJavaProjectArray[n];
            if (!iJavaProject2.equals(iJavaProject)) {
                this.updateProjectClasspath(iPath, iJavaProject2, map);
            }
            ++n;
        }
    }

    protected void updateProjectClasspath(IPath iPath, IJavaProject iJavaProject, Map map) throws JavaModelException {
        map.put(iJavaProject, iJavaProject.getPackageFragmentRoots());
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        IClasspathEntry[] iClasspathEntryArray2 = null;
        int n = iClasspathEntryArray.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n3];
            if (iPath.equals((Object)iClasspathEntry.getPath())) {
                if (iClasspathEntryArray2 == null) {
                    iClasspathEntryArray2 = new IClasspathEntry[n - 1];
                    System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, n3);
                    n2 = n3;
                }
            } else if (iClasspathEntryArray2 != null) {
                iClasspathEntryArray2[n2++] = iClasspathEntry;
            }
            ++n3;
        }
        if (iClasspathEntryArray2 != null) {
            if (n2 < iClasspathEntryArray2.length) {
                IClasspathEntry[] iClasspathEntryArray3 = iClasspathEntryArray2;
                iClasspathEntryArray2 = new IClasspathEntry[n2];
                System.arraycopy(iClasspathEntryArray3, 0, iClasspathEntryArray2, 0, n2);
            }
            iJavaProject.setRawClasspath(iClasspathEntryArray2, this.progressMonitor);
        }
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus iJavaModelStatus = super.verify();
        if (!iJavaModelStatus.isOK()) {
            return iJavaModelStatus;
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)this.getElementToProcess();
        if (iPackageFragmentRoot == null || !iPackageFragmentRoot.exists()) {
            return new JavaModelStatus(969, iPackageFragmentRoot);
        }
        IResource iResource = iPackageFragmentRoot.getResource();
        if (iResource instanceof IFolder && iResource.isLinked()) {
            return new JavaModelStatus(995, iPackageFragmentRoot);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

