/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Openable;

public class ModelUpdater {
    HashSet projectsToUpdate = new HashSet();

    protected void addToParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            try {
                JavaElementInfo javaElementInfo = (JavaElementInfo)openable2.getElementInfo();
                javaElementInfo.addChild(openable);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected static void close(Openable openable) {
        try {
            openable.close();
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void elementAdded(Openable openable) {
        int n = openable.getElementType();
        if (n == 2) {
            this.addToParentInfo(openable);
            this.projectsToUpdate.add(openable);
        } else {
            this.addToParentInfo(openable);
            ModelUpdater.close(openable);
        }
        switch (n) {
            case 3: {
                this.projectsToUpdate.add(openable.getJavaProject());
                break;
            }
            case 4: {
                JavaProject javaProject = (JavaProject)openable.getJavaProject();
                javaProject.resetCaches();
            }
        }
    }

    protected void elementChanged(Openable openable) {
        ModelUpdater.close(openable);
    }

    protected void elementRemoved(Openable openable) {
        if (openable.isOpen()) {
            ModelUpdater.close(openable);
        }
        this.removeFromParentInfo(openable);
        int n = openable.getElementType();
        switch (n) {
            case 1: {
                JavaModelManager.getJavaModelManager().getIndexManager().reset();
                break;
            }
            case 2: {
                JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
                JavaProject javaProject = (JavaProject)openable;
                javaModelManager.removePerProjectInfo(javaProject);
                javaModelManager.containerRemove(javaProject);
                break;
            }
            case 3: {
                this.projectsToUpdate.add(openable.getJavaProject());
                break;
            }
            case 4: {
                JavaProject javaProject = (JavaProject)openable.getJavaProject();
                javaProject.resetCaches();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processJavaDelta(IJavaElementDelta iJavaElementDelta) {
        try {
            this.traverseDelta(iJavaElementDelta, null, null);
            Iterator iterator = this.projectsToUpdate.iterator();
            while (iterator.hasNext()) {
                JavaProject javaProject = (JavaProject)iterator.next();
                javaProject.updatePackageFragmentRoots();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.projectsToUpdate = new HashSet();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.projectsToUpdate = new HashSet();
            return;
        }
    }

    protected void removeFromParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            try {
                JavaElementInfo javaElementInfo = (JavaElementInfo)openable2.getElementInfo();
                javaElementInfo.removeChild(openable);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void traverseDelta(IJavaElementDelta iJavaElementDelta, IPackageFragmentRoot iPackageFragmentRoot, IJavaProject iJavaProject) {
        IJavaElementDelta[] iJavaElementDeltaArray;
        boolean bl = true;
        Openable openable = (Openable)iJavaElementDelta.getElement();
        switch (openable.getElementType()) {
            case 2: {
                iJavaProject = (IJavaProject)((Object)openable);
                break;
            }
            case 3: {
                iPackageFragmentRoot = (IPackageFragmentRoot)((Object)openable);
                break;
            }
            case 5: {
                iJavaElementDeltaArray = (IJavaElementDelta[])openable;
                if (iJavaElementDeltaArray.isWorkingCopy() && !iJavaElementDeltaArray.isPrimary()) {
                    return;
                }
            }
            case 6: {
                bl = false;
            }
        }
        switch (iJavaElementDelta.getKind()) {
            case 1: {
                this.elementAdded(openable);
                break;
            }
            case 2: {
                this.elementRemoved(openable);
                break;
            }
            case 4: {
                if ((iJavaElementDelta.getFlags() & 1) == 0) break;
                this.elementChanged(openable);
            }
        }
        if (bl) {
            iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
            int n = 0;
            while (n < iJavaElementDeltaArray.length) {
                IJavaElementDelta iJavaElementDelta2 = iJavaElementDeltaArray[n];
                this.traverseDelta(iJavaElementDelta2, iPackageFragmentRoot, iJavaProject);
                ++n;
            }
        }
    }
}

