/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.NamedMember;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceMethodElementInfo;
import org.eclipse.wst.jsdt.internal.core.TypeParameter;
import org.eclipse.wst.jsdt.internal.core.TypeParameterElementInfo;

public class SourceMethod
extends NamedMember
implements IMethod {
    protected String[] parameterTypes;

    protected SourceMethod(JavaElement javaElement, String string, String[] stringArray) {
        super(javaElement, string);
        this.parameterTypes = stringArray == null ? CharOperation.NO_STRINGS : stringArray;
    }

    protected void closing(Object object) throws JavaModelException {
        super.closing(object);
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)object;
        ITypeParameter[] iTypeParameterArray = sourceMethodElementInfo.typeParameters;
        int n = 0;
        int n2 = iTypeParameterArray.length;
        while (n < n2) {
            ((TypeParameter)iTypeParameterArray[n]).close();
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SourceMethod)) {
            return false;
        }
        return super.equals(object);
    }

    public int getElementType() {
        return 9;
    }

    public String[] getExceptionTypes() throws JavaModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        char[][] cArray = sourceMethodElementInfo.getExceptionTypeNames();
        return CompilationUnitStructureRequestor.convertTypeNamesToSigs(cArray);
    }

    protected void getHandleMemento(StringBuffer stringBuffer) {
        ((JavaElement)this.getParent()).getHandleMemento(stringBuffer);
        char c = this.getHandleMementoDelimiter();
        stringBuffer.append(c);
        this.escapeMementoName(stringBuffer, this.getElementName());
        if (this.occurrenceCount > 1) {
            stringBuffer.append('!');
            stringBuffer.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    public String[] getParameterNames() throws JavaModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        char[][] cArray = sourceMethodElementInfo.getArgumentNames();
        return CharOperation.toStrings(cArray);
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ITypeParameter getTypeParameter(String string) {
        return new TypeParameter(this, string);
    }

    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        return sourceMethodElementInfo.typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        ITypeParameter[] iTypeParameterArray = this.getTypeParameters();
        int n = iTypeParameterArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            TypeParameter typeParameter = (TypeParameter)iTypeParameterArray[n2];
            TypeParameterElementInfo typeParameterElementInfo = (TypeParameterElementInfo)typeParameter.getElementInfo();
            char[][] cArray = typeParameterElementInfo.bounds;
            if (cArray == null) {
                stringArray[n2] = Signature.createTypeParameterSignature(typeParameter.getElementName(), CharOperation.NO_STRINGS);
            } else {
                int n3 = cArray.length;
                char[][] cArrayArray = new char[n3][];
                int n4 = 0;
                while (n4 < n3) {
                    cArrayArray[n4] = Signature.createCharArrayTypeSignature(cArray[n4], false);
                    ++n4;
                }
                stringArray[n2] = new String(Signature.createTypeParameterSignature(typeParameter.getElementName().toCharArray(), cArrayArray));
            }
            ++n2;
        }
        return stringArray;
    }

    public IJavaElement getPrimaryElement(boolean bl) {
        IJavaElement iJavaElement;
        if (bl && ((CompilationUnit)(iJavaElement = (CompilationUnit)this.getAncestor(5))).isPrimary()) {
            return this;
        }
        iJavaElement = this.parent.getPrimaryElement(false);
        if (iJavaElement instanceof IType) {
            return ((IType)iJavaElement).getMethod(this.name, this.parameterTypes);
        }
        return ((ICompilationUnit)iJavaElement).getMethod(this.name, this.parameterTypes);
    }

    public String[] getRawParameterNames() throws JavaModelException {
        return this.getParameterNames();
    }

    public String getReturnType() throws JavaModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createTypeSignature(sourceMethodElementInfo.getReturnTypeName(), false);
    }

    public String getSignature() throws JavaModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createMethodSignature(this.parameterTypes, Signature.createTypeSignature(sourceMethodElementInfo.getReturnTypeName(), false));
    }

    public int hashCode() {
        int n = super.hashCode();
        return n;
    }

    public boolean isConstructor() throws JavaModelException {
        if (!this.getElementName().equals(this.parent.getElementName())) {
            return false;
        }
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        return sourceMethodElementInfo.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isResolved() {
        return false;
    }

    public boolean isSimilar(IMethod iMethod) {
        return SourceMethod.areSimilarMethods(this.getElementName(), this.getParameterTypes(), iMethod.getElementName(), iMethod.getParameterTypes(), null);
    }

    public String readableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.readableName());
        stringBuffer.append('(');
        if (this.parameterTypes != null && (n = this.parameterTypes.length) > 0) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(Signature.toString(this.parameterTypes[n2]));
                if (n2 < n - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public JavaElement resolved(Binding binding) {
        ResolvedSourceMethod resolvedSourceMethod = new ResolvedSourceMethod(this.parent, this.name, this.parameterTypes, new String(binding.computeUniqueKey()));
        resolvedSourceMethod.occurrenceCount = this.occurrenceCount;
        return resolvedSourceMethod;
    }

    protected void toStringInfo(int n, StringBuffer stringBuffer, Object object, boolean bl) {
        stringBuffer.append(this.tabString(n));
        if (object == null) {
            this.toStringName(stringBuffer);
            stringBuffer.append(" (not open)");
        } else if (object == NO_INFO) {
            this.toStringName(stringBuffer);
        } else {
            SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)object;
            int n2 = sourceMethodElementInfo.getModifiers();
            if (Flags.isStatic(n2)) {
                stringBuffer.append("static ");
            }
            if (!sourceMethodElementInfo.isConstructor()) {
                stringBuffer.append("function ");
            }
            this.toStringName(stringBuffer, n2);
        }
    }

    protected void toStringName(StringBuffer stringBuffer) {
        this.toStringName(stringBuffer, 0);
    }

    protected void toStringName(StringBuffer stringBuffer, int n) {
        int n2;
        stringBuffer.append(this.getElementName());
        stringBuffer.append('(');
        String[] stringArray = this.getParameterTypes();
        if (stringArray != null && (n2 = stringArray.length) > 0) {
            boolean bl = Flags.isVarargs(n);
            int n3 = 0;
            while (n3 < n2) {
                try {
                    if (n3 < n2 - 1) {
                        stringBuffer.append("p" + n3);
                        stringBuffer.append(", ");
                    } else if (bl) {
                        String string = stringArray[n3].substring(1);
                        stringBuffer.append(Signature.toString(string));
                        stringBuffer.append(" ...");
                    } else {
                        stringBuffer.append("p" + n3);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    stringBuffer.append("*** invalid signature: ");
                    stringBuffer.append(stringArray[n3]);
                }
                ++n3;
            }
        }
        stringBuffer.append(')');
        if (this.occurrenceCount > 1) {
            stringBuffer.append("#");
            stringBuffer.append(this.occurrenceCount);
        }
    }

    public IMethod getMethod(String string, String[] stringArray) {
        return new SourceMethod(this, string, stringArray);
    }
}

